/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TProgress.h"

TProgress::TProgress()
{
	mainProgress = new QProgressBar(this);
	slaveProgress = new QProgressBar(this);
	mainLabel = new QLabel(tr("Main progress"));
	slaveLabel = new QLabel(tr("File in progress: "));
	slaveLabelText = new QLabel(this);
	
	// layers
	QHBoxLayout *labels_layout = new QHBoxLayout;
	labels_layout->addWidget(slaveLabel);
	labels_layout->addWidget(slaveLabelText);
	
	QVBoxLayout *main_v_layout = new QVBoxLayout;
	main_v_layout->addWidget(mainLabel);
	main_v_layout->addWidget(mainProgress);
	main_v_layout->addLayout(labels_layout);
	main_v_layout->addWidget(slaveProgress);
	
	QHBoxLayout *main_layout = new QHBoxLayout;
	main_layout->addLayout(main_v_layout);
	
	this->setLayout(main_layout);
	
	this->setModal(true);
}

void TProgress::setRangeTop(int start, int end)
{
	this->mainProgress->setRange(start, end);
}

void TProgress::setRangeBottom(int start, int end)
{
	this->slaveProgress->setRange(start, end);
}

void TProgress::setLabel(QString label)
{
	this->setWindowTitle(label);
}

void TProgress::setValueTop(int value)
{
	mainProgress->setValue(value);
}

void TProgress::setValueBottom(int value)
{
	slaveProgress->setValue(value);
}

void TProgress::setCurrentFile(QString current_file)
{
	this->slaveLabelText->setText(current_file);
}
