#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "v3dmp.h"

#include "splash.h"
#include "vmapixmaps.h"
#include "vma.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif


#include "images/icon_vma_20x20.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_folder_opened_20x20.xpm"
#include "images/icon_file_20x20.xpm"
#include "images/icon_file_v3d_20x20.xpm"
#include "images/icon_add_20x20.xpm"
#include "images/icon_apperance_20x20.xpm"
#include "images/icon_backup_20x20.xpm"
#include "images/icon_browse_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_copy_20x20.xpm"
#include "images/icon_cull_20x20.xpm"
#include "images/icon_cut_20x20.xpm"
#include "images/icon_devices_20x20.xpm"
#include "images/icon_error_32x32.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_fonts_20x20.xpm"
#include "images/icon_grid_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_info_32x32.xpm"
#include "images/icon_maximize_20x20.xpm"
#include "images/icon_menu_map_20x20.xpm"
#include "images/icon_model_20x20.xpm"
#include "images/icon_model_hidden_20x20.xpm"
#include "images/icon_model_other_20x20.xpm"
#include "images/icon_move_rate_20x20.xpm"
#include "images/icon_precision_20x20.xpm"
#include "images/icon_mp_color_20x20.xpm"
#include "images/icon_mp_comment_20x20.xpm"
#include "images/icon_mp_heightfield_load_20x20.xpm"
#include "images/icon_mp_line_20x20.xpm"
#include "images/icon_mp_lineloop_20x20.xpm"
#include "images/icon_mp_linestrip_20x20.xpm"
#include "images/icon_mp_point_20x20.xpm"
#include "images/icon_mp_polygon_20x20.xpm"
#include "images/icon_mp_quad_20x20.xpm"
#include "images/icon_mp_quadstrip_20x20.xpm"
#include "images/icon_mp_rotate_20x20.xpm"
#include "images/icon_mp_texture_orient_20x20.xpm"
#include "images/icon_mp_texture_select_20x20.xpm"
#include "images/icon_mp_texture_off_20x20.xpm"
#include "images/icon_mp_translate_20x20.xpm"
#include "images/icon_mp_triangle_20x20.xpm"
#include "images/icon_mp_trianglefan_20x20.xpm"
#include "images/icon_mp_trianglestrip_20x20.xpm"
#include "images/icon_new_20x20.xpm"
#include "images/icon_ok_20x20.xpm"
#include "images/icon_open_20x20.xpm"
#include "images/icon_paste_20x20.xpm"
#include "images/icon_plugin_20x20.xpm"
#include "images/icon_plugin_enabled_20x20.xpm"
#include "images/icon_plugin_disabled_20x20.xpm"
#include "images/icon_power_off_20x20.xpm"
#include "images/icon_power_on_20x20.xpm"
#include "images/icon_properties_20x20.xpm"
#include "images/icon_question_32x32.xpm"
#include "images/icon_redo_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_remove_20x20.xpm"
#include "images/icon_render_20x20.xpm"
#include "images/icon_restore_20x20.xpm"
#include "images/icon_revert_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_save_as_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_texture_20x20.xpm"
#include "images/icon_translations_20x20.xpm"
#include "images/icon_undo_20x20.xpm"
#include "images/icon_viewable_dim_20x20.xpm"
#include "images/icon_warning_32x32.xpm"
#include "images/icon_zoom_in_20x20.xpm"
#include "images/icon_zoom_onetoone_20x20.xpm"
#include "images/icon_zoom_out_20x20.xpm"
#include "images/icon_zoom_tofit_20x20.xpm"



vma_pixmaps_list_struct vma_pixmaps_list;

GtkPixmap *VMAPixmapsListGetPtr(
	vma_pixmaps_list_struct *list,
	gint n
);
gint VMAPixmapsListGetValues(
	vma_pixmaps_list_struct *list,
	gint n,
	GdkPixmap **pixmap_gdk_rtn,
	GdkBitmap **mask_rtn,
	GtkPixmap **pixmap_rtn
);
gint VMAPixmapsListGetMPCode(
	vma_pixmaps_list_struct *list, gint ptype
);
gint VMAPixmapsListLoad(
	gpointer core, vma_pixmaps_list_struct *list,
	splash_win_struct *splash_win
);
void VMAPixmapsListUnload(gpointer core, vma_pixmaps_list_struct *list);


/*
 *	Returns the pointer to the allocated pixmap in the
 *	given vma_pixmaps_list_struct list or NULL on error.
 */
GtkPixmap *VMAPixmapsListGetPtr(
	vma_pixmaps_list_struct *list, gint n
)
{
	if(list == NULL)
	    return(NULL);

	if((list->pixmap == NULL) ||
	   (n < 0) ||
	   (n >= list->total_pixmaps)
	)
	    return(NULL);
	else
	    return(list->pixmap[n]);
}

/*
 *      Returns the pointers to the requested values, if any
 *	returns are NULL then that value will not be returned.
 *
 *	Returns non-zero on error.
 */
gint VMAPixmapsListGetValues(
	vma_pixmaps_list_struct *list, 
	gint n,
	GdkPixmap **pixmap_gdk_rtn,
	GdkBitmap **mask_rtn,
	GtkPixmap **pixmap_rtn
)
{
	if(pixmap_gdk_rtn != NULL)
	    (*pixmap_gdk_rtn) = NULL;
	if(mask_rtn != NULL)
	    (*mask_rtn) = NULL;
	if(pixmap_rtn != NULL)
	    (*pixmap_rtn) = NULL;

	if(list == NULL)
	    return(-1);

	if((list->pixmap == NULL) ||
	   (n < 0) ||
	   (n >= list->total_pixmaps)
	)
	    return(-1);

	if(pixmap_gdk_rtn != NULL)
	    (*pixmap_gdk_rtn) = list->pixmap_gdk[n];
	if(mask_rtn != NULL)
	    (*mask_rtn) = list->mask[n];
	if(pixmap_rtn != NULL)
	    (*pixmap_rtn) = list->pixmap[n];
 
	return(0);
}

/*
 *	Returns the vma pixmap list index number that best matches
 *	the v3d model primitive type ptype.
 */
gint VMAPixmapsListGetMPCode(vma_pixmaps_list_struct *list, int ptype)
{
	gint i = VMA_PIXMAP_MP_COMMENT_20x20;


	switch(ptype)
	{
	  case V3DMP_TYPE_COMMENT:
	    i = VMA_PIXMAP_MP_COMMENT_20x20;
	    break;

	  case V3DMP_TYPE_TRANSLATE:
	  case V3DMP_TYPE_UNTRANSLATE:
	    i = VMA_PIXMAP_MP_TRANSLATE_20x20;
	    break;

	  case V3DMP_TYPE_ROTATE:
	  case V3DMP_TYPE_UNROTATE:
	    i = VMA_PIXMAP_MP_ROTATE_20x20;
	    break;

	  case V3DMP_TYPE_POINT:
	    i = VMA_PIXMAP_MP_POINT_20x20;
	    break;

	  case V3DMP_TYPE_LINE:
	    i = VMA_PIXMAP_MP_LINE_20x20;
	    break;

	  case V3DMP_TYPE_LINE_STRIP:
	    i = VMA_PIXMAP_MP_LINESTRIP_20x20;
	    break;

	  case V3DMP_TYPE_LINE_LOOP:
	    i = VMA_PIXMAP_MP_LINELOOP_20x20;
	    break;

	  case V3DMP_TYPE_TRIANGLE:
	    i = VMA_PIXMAP_MP_TRIANGLE_20x20;
	    break;

	  case V3DMP_TYPE_TRIANGLE_STRIP:
	    i = VMA_PIXMAP_MP_TRIANGLESTRIP_20x20;
	    break;

	  case V3DMP_TYPE_TRIANGLE_FAN:
	    i = VMA_PIXMAP_MP_TRIANGLEFAN_20x20;
	    break;

	  case V3DMP_TYPE_QUAD:
	    i = VMA_PIXMAP_MP_QUAD_20x20;
	    break;

	  case V3DMP_TYPE_QUAD_STRIP:
	    i = VMA_PIXMAP_MP_QUADSTRIP_20x20;
	    break;

	  case V3DMP_TYPE_POLYGON:
	    i = VMA_PIXMAP_MP_POLYGON_20x20;
	    break;

	  case V3DMP_TYPE_COLOR:
	    i = VMA_PIXMAP_MP_COLOR_20x20;
	    break;

	  case V3DMP_TYPE_TEXTURE_SELECT:
	    i = VMA_PIXMAP_MP_TEXTURE_SELECT_20x20;
	    break;

	  case V3DMP_TYPE_TEXTURE_ORIENT_XY:
	  case V3DMP_TYPE_TEXTURE_ORIENT_YZ:
	  case V3DMP_TYPE_TEXTURE_ORIENT_XZ:
	    i = VMA_PIXMAP_MP_TEXTURE_ORIENT_20x20;
	    break;

	  case V3DMP_TYPE_TEXTURE_OFF:
	    i = VMA_PIXMAP_MP_TEXTURE_OFF_20x20;
	    break;

	  case V3DMP_TYPE_HEIGHTFIELD_LOAD:
	    i = VMA_PIXMAP_MP_HEIGHTFIELD_LOAD_20x20;
	    break;
	}

	return(i);
}


/*
 *	Loads a pixmap from data and allocates it to the list.
 *
 *	Returns non-zero on error.
 */
gint VMAPixmapsListLoadFromData(
	gpointer core, vma_pixmaps_list_struct *list,
	gint n,
	u_int8_t **data
)
{
	GtkWidget *w;
	GdkPixmap *pixmap_gdk;
	GdkBitmap *mask;
	    

	if((core == NULL) || (list == NULL) || (data == NULL))
	    return(-1);

	/* Sanitize total. */
	if(list->total_pixmaps < 0)
	    list->total_pixmaps = 0;

	/* Append? */
	if(n < 0)
	{
	    gint j;

	    n = list->total_pixmaps;
	    list->total_pixmaps++;

	    list->pixmap = (GtkPixmap **)g_realloc(
		list->pixmap,
		list->total_pixmaps * sizeof(GtkPixmap *)
	    );
	    list->pixmap_gdk = (GdkPixmap **)g_realloc(
		list->pixmap_gdk,
		list->total_pixmaps * sizeof(GdkPixmap *)
	    );
	    list->mask = (GdkBitmap **)g_realloc(
		list->mask,
		list->total_pixmaps * sizeof(GdkBitmap *)
	    );
	    if((list->pixmap == NULL) ||
	       (list->pixmap_gdk == NULL) ||
	       (list->mask == NULL)
	    )
	    {
		list->total_pixmaps = 0;
		return(-1);
	    }

	    /* Set new pointer NULL. */
	    j = n;
	    list->pixmap[j] = NULL;
	    list->pixmap_gdk[j] = NULL;
	    list->mask[j] = NULL;
	}
	/* Allocate more? */
	else if(n >= list->total_pixmaps)
	{
	    gint j;
	    gint prev_total = list->total_pixmaps;

	    /* Set new total and allocate more pointers. */
	    list->total_pixmaps = n + 1;
	    list->pixmap = (GtkPixmap **)g_realloc(
		list->pixmap,
		list->total_pixmaps * sizeof(GtkPixmap *)
	    );
	    list->pixmap_gdk = (GdkPixmap **)g_realloc(   
		list->pixmap_gdk,
		list->total_pixmaps * sizeof(GdkPixmap *)
	    );
	    list->mask = (GdkBitmap **)g_realloc(
		list->mask,
		list->total_pixmaps * sizeof(GdkBitmap *)
	    );
	    if((list->pixmap == NULL) ||
	       (list->pixmap_gdk == NULL) ||
	       (list->mask == NULL)
	    )
	    {
		list->total_pixmaps = 0;
		return(-1);
	    }

	    /* Set new pointers NULL. */
	    for(j = prev_total; j < list->total_pixmaps; j++)
	    {
		list->pixmap[j] = NULL;
		list->pixmap_gdk[j] = NULL;
		list->mask[j] = NULL;
	    }
	}
	else
	{
	    /* Replace. */
	    gint j = n;

	    w = (GtkWidget *)list->pixmap[j];
	    pixmap_gdk = list->pixmap_gdk[j];
	    mask = list->mask[j];

	    /* Unref old stuff. */
	    if(pixmap_gdk != NULL)
		gdk_pixmap_unref(pixmap_gdk);
	    if(mask != NULL)
		gdk_bitmap_unref(mask);
	    if(w != NULL)
		gtk_widget_destroy(w);

	    list->pixmap[j] = NULL;
	    list->pixmap_gdk[j] = NULL;
	    list->mask[j] = NULL;
	}

	/* n is now set to be the newly allocated position. */
	if((n >= 0) && (n < list->total_pixmaps))
	{
	    GdkWindow *window = (GdkWindow *)GDK_ROOT_PARENT();
	    GtkStyle *style = gtk_widget_get_default_style();
	    gint width, height;


	    if((window == NULL) || (style == NULL))
		return(-1);

	    pixmap_gdk = gdk_pixmap_create_from_xpm_d(  
		window,
		&mask,
		&style->bg[GTK_STATE_NORMAL],
		(gchar **)data
	    );
	    w = gtk_pixmap_new(pixmap_gdk, mask);

	    /* Get size of newly loaded pixmap. */
	    gdk_window_get_size((GdkWindow *)pixmap_gdk, &width, &height);

	    list->pixmap[n] = GTK_PIXMAP(w);
	    list->pixmap_gdk[n] = pixmap_gdk;
	    list->mask[n] = mask;
	}

	return(0);
}

/*
 *	Procedure to load all pixmaps into the specified
 *	vma_pixmaps_list_struct list, returns the number of
 *	pixmaps loaded or -1 on error.
 */
gint VMAPixmapsListLoad(
	gpointer core, vma_pixmaps_list_struct *list,
	splash_win_struct *splash_win
)
{
	vma_core_struct *core_ptr = (vma_core_struct *)core;
	gint status, pixmap_index;
	u_int8_t **pixmap_data;


	if((core_ptr == NULL) || (list == NULL))
	    return(-1);

#define DO_LOAD_PIXMAP	\
{ \
 status = VMAPixmapsListLoadFromData( \
  core_ptr, list, \
  pixmap_index, pixmap_data \
 ); \
 SplashUpdate( \
  core_ptr->splash_win, \
  0, (gdouble)pixmap_index / (gdouble)VMA_PIXMAP_HIGHEST, \
  "Loading graphics...", \
  TRUE \
 ); \
}

	pixmap_index = VMA_PIXMAP_VMA_20x20;
	pixmap_data = (u_int8_t **)icon_vma_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_FOLDER_OPENED_20x20;
	pixmap_data = (u_int8_t **)icon_folder_opened_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_FOLDER_CLOSED_20x20;
	pixmap_data = (u_int8_t **)icon_folder_closed_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_FILE_20x20;
	pixmap_data = (u_int8_t **)icon_file_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_FILE_V3D_20x20;
	pixmap_data = (u_int8_t **)icon_file_v3d_20x20_xpm;
	DO_LOAD_PIXMAP


	pixmap_index = VMA_PIXMAP_ADD_20x20;
	pixmap_data = (u_int8_t **)icon_add_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_APPERANCE_20x20;
	pixmap_data = (u_int8_t **)icon_apperance_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_BACKUP_20x20;
	pixmap_data = (u_int8_t **)icon_backup_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_BROWSE_20x20;
	pixmap_data = (u_int8_t **)icon_browse_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_CANCEL_20x20;
	pixmap_data = (u_int8_t **)icon_cancel_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_CLOSE_20x20;
	pixmap_data = (u_int8_t **)icon_close_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_COPY_20x20;
	pixmap_data = (u_int8_t **)icon_copy_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_CULL_20x20;
	pixmap_data = (u_int8_t **)icon_cull_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_CUT_20x20;
	pixmap_data = (u_int8_t **)icon_cut_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_DEVICES_20x20;
	pixmap_data = (u_int8_t **)icon_devices_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_ERROR_32x32;
	pixmap_data = (u_int8_t **)icon_error_32x32_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_EXIT_20x20;
	pixmap_data = (u_int8_t **)icon_exit_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_FONTS_20x20;
	pixmap_data = (u_int8_t **)icon_fonts_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_GRID_20x20;
	pixmap_data = (u_int8_t **)icon_grid_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_HELP_20x20;
	pixmap_data = (u_int8_t **)icon_help_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_INFO_32x32;
	pixmap_data = (u_int8_t **)icon_info_32x32_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MAXIMIZE_20x20;
	pixmap_data = (u_int8_t **)icon_maximize_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MENU_MAP_20x20;
	pixmap_data = (u_int8_t **)icon_menu_map_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MODEL_20x20;
	pixmap_data = (u_int8_t **)icon_model_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MODEL_HIDDEN_20x20;
	pixmap_data = (u_int8_t **)icon_model_hidden_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MODEL_OTHER_20x20;
	pixmap_data = (u_int8_t **)icon_model_other_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MOVE_RATE_20x20;
	pixmap_data = (u_int8_t **)icon_move_rate_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PRECISION_20x20;
	pixmap_data = (u_int8_t **)icon_precision_20x20_xpm;
	DO_LOAD_PIXMAP


	pixmap_index = VMA_PIXMAP_MP_COLOR_20x20;
	pixmap_data = (u_int8_t **)icon_mp_color_20x20_xpm;
	DO_LOAD_PIXMAP   

	pixmap_index = VMA_PIXMAP_MP_COMMENT_20x20;
	pixmap_data = (u_int8_t **)icon_mp_comment_20x20_xpm;
	DO_LOAD_PIXMAP   

	pixmap_index = VMA_PIXMAP_MP_HEIGHTFIELD_LOAD_20x20;
	pixmap_data = (u_int8_t **)icon_mp_heightfield_load_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_LINE_20x20;
	pixmap_data = (u_int8_t **)icon_mp_line_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_LINELOOP_20x20;
	pixmap_data = (u_int8_t **)icon_mp_lineloop_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_LINESTRIP_20x20;
	pixmap_data = (u_int8_t **)icon_mp_linestrip_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_POINT_20x20;
	pixmap_data = (u_int8_t **)icon_mp_point_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_POLYGON_20x20;
	pixmap_data = (u_int8_t **)icon_mp_polygon_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_QUAD_20x20;
	pixmap_data = (u_int8_t **)icon_mp_quad_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_QUADSTRIP_20x20;
	pixmap_data = (u_int8_t **)icon_mp_quadstrip_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_ROTATE_20x20;
	pixmap_data = (u_int8_t **)icon_mp_rotate_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TEXTURE_ORIENT_20x20;
	pixmap_data = (u_int8_t **)icon_mp_texture_orient_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TEXTURE_SELECT_20x20;
	pixmap_data = (u_int8_t **)icon_mp_texture_select_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TEXTURE_OFF_20x20;
	pixmap_data = (u_int8_t **)icon_mp_texture_off_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TRANSLATE_20x20;
	pixmap_data = (u_int8_t **)icon_mp_translate_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TRIANGLE_20x20;
	pixmap_data = (u_int8_t **)icon_mp_triangle_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TRIANGLEFAN_20x20;
	pixmap_data = (u_int8_t **)icon_mp_trianglefan_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_MP_TRIANGLESTRIP_20x20;
	pixmap_data = (u_int8_t **)icon_mp_trianglestrip_20x20_xpm;
	DO_LOAD_PIXMAP


	pixmap_index = VMA_PIXMAP_NEW_20x20;
	pixmap_data = (u_int8_t **)icon_new_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_OK_20x20;
	pixmap_data = (u_int8_t **)icon_ok_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_OPEN_20x20;
	pixmap_data = (u_int8_t **)icon_open_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PASTE_20x20;
	pixmap_data = (u_int8_t **)icon_paste_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PLUGIN_20x20; 
	pixmap_data = (u_int8_t **)icon_plugin_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PLUGIN_ENABLED_20x20; 
	pixmap_data = (u_int8_t **)icon_plugin_enabled_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PLUGIN_DISABLED_20x20;
	pixmap_data = (u_int8_t **)icon_plugin_disabled_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_POWER_OFF_20x20;
	pixmap_data = (u_int8_t **)icon_power_off_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_POWER_ON_20x20;
	pixmap_data = (u_int8_t **)icon_power_on_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_PROPERTIES_20x20;
	pixmap_data = (u_int8_t **)icon_properties_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_QUESTION_32x32;
	pixmap_data = (u_int8_t **)icon_question_32x32_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_REDO_20x20;
	pixmap_data = (u_int8_t **)icon_redo_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_RELOAD_20x20;
	pixmap_data = (u_int8_t **)icon_reload_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_REMOVE_20x20;
	pixmap_data = (u_int8_t **)icon_remove_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_RENDER_20x20;
	pixmap_data = (u_int8_t **)icon_render_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_RESTORE_20x20;
	pixmap_data = (u_int8_t **)icon_restore_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_REVERT_20x20;
	pixmap_data = (u_int8_t **)icon_revert_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_SAVE_20x20;
	pixmap_data = (u_int8_t **)icon_save_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_SAVE_AS_20x20;
	pixmap_data = (u_int8_t **)icon_save_as_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_SELECT_20x20;
	pixmap_data = (u_int8_t **)icon_select_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_TEXTURE_20x20;
	pixmap_data = (u_int8_t **)icon_texture_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_TRALSNATIONS_20x20;
	pixmap_data = (u_int8_t **)icon_translations_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_UNDO_20x20;
	pixmap_data = (u_int8_t **)icon_undo_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_VIEWABLE_DIM_20x20;
	pixmap_data = (u_int8_t **)icon_viewable_dim_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_WARNING_32x32;
	pixmap_data = (u_int8_t **)icon_warning_32x32_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_ZOOM_IN_20x20;
	pixmap_data = (u_int8_t **)icon_zoom_in_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_ZOOM_ONETOONE_20x20;
	pixmap_data = (u_int8_t **)icon_zoom_onetoone_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_ZOOM_OUT_20x20;
	pixmap_data = (u_int8_t **)icon_zoom_out_20x20_xpm;
	DO_LOAD_PIXMAP

	pixmap_index = VMA_PIXMAP_ZOOM_TOFIT_20x20;
	pixmap_data = (u_int8_t **)icon_zoom_tofit_20x20_xpm;
	DO_LOAD_PIXMAP


#undef DO_LOAD_PIXMAP

	return(0);
}

/*
 *	Procedure to unload all pixmaps allocated in the
 *	vma_pixmaps_list_struct list.
 */
void VMAPixmapsListUnload(gpointer core, vma_pixmaps_list_struct *list)
{
	gint i;
	GtkWidget *w;
	GdkPixmap *pixmap_gdk;
	GdkBitmap *mask;


	if((core == NULL) || (list == NULL))
	    return;

	for(i = 0; i < list->total_pixmaps; i++)
	{
	    w = (GtkWidget *)list->pixmap[i];
	    pixmap_gdk = list->pixmap_gdk[i];
	    mask = list->mask[i];

	    list->pixmap[i] = NULL;
	    list->pixmap_gdk[i] = NULL;
	    list->mask[i] = NULL;


	    if(pixmap_gdk != NULL)
		gdk_pixmap_unref(pixmap_gdk);
	    if(mask != NULL)
		gdk_bitmap_unref(mask);
	    if(w != NULL)
		gtk_widget_destroy(w);
	}
	g_free(list->pixmap);
	list->pixmap = NULL;
	list->total_pixmaps = 0;

	/* Clear the rest of the pixmaps list structure. */
	memset(list, 0x00, sizeof(vma_pixmaps_list_struct));
}
