/*
			     Print Outputting
 */

#ifndef PRINT_H
#define PRINT_H

#include <sys/types.h>


/*
 *	Visual codes:
 */
#define PrintBlackAndWhite	0
#define PrintGreyScale		1
#define PrintColor		2

/*
 *	Orientation codes:
 */
#define PrintPortrait		0
#define PrintLandScape		1

/*
 *	Print destinations:
 */
#define PrintToPrinter		0
#define PrintToFile		1

/*
 *	Pixel formats:
 */
#define PrintFormatGamma	0	/* GreyScale, 1 byte per pixel. */
#define PrintFormatRGB		1	/* 3 bytes per pixel. */
#define PrintFormatRGBA		2	/* 4 bytes per pixel. */


/*
 *	Default print command.
 *
 *	%f is replaced with the name of the tempory file to print.
 *	%p is replaced with a printer ID name (not needed).
 *	%o is replaced by various other options as needed.
 */
#define PrintDefaultPrintCommand	"lpr %f"


/*
 *	Print parameters structure:
 */
typedef struct {

	u_int64_t flags;	/* Any of PrintFlag*. */

	int destination;	/* PrintToPrinter or PrintToFile. */
	int coppies;		/* Number of coppies to print. */
	int orientation;	/* PrintPortrait or PrintLandScape. */
	int visual;		/* PrintBlackAndWhite, PrintGreyScale,
				 * or PrintColor.
				 */
	double ppi_x, ppi_y;	/* Pixels per inch. */
	int	paper_width,	/* Size of paper in units of pixels. */
		paper_height;
	int x, y;		/* Offset from upper left corner in
				 * units of pixels.
				 */
	int width, height;	/* Size of print output in units
				 * of pixels, always relative to
				 * PrintPortrait regardless what 
				 * orientation is set to.
				 */

} print_parms_struct;


/*
 *	Print job structure:
 */
typedef struct {

	pid_t pid;		/* Process ID of print client. */
	char *command;		/* Complete command string. */
	char *file;		/* Post script file name. */
	char *title;		/* Document title. */
	char *creator;		/* Name of whatever program made this. */

	int coppies;		/* Total coppies. */
	int coppies_printed;	/* Coppies printed so far. */

	int remove_file_when_done;	/* Removes post script file when
					 * done printing.
					 */
	void *client_data;

} print_job_struct;



extern int PrintWritePSImage(
	FILE *fp,
	print_parms_struct *parms,
	int format,	/* PrintFormatRGBA, PrintFormatRGB, or
			 * PrintFormatGamma.
			 */
	int width,	/* In pixels. */
	int height,
	const void *buf
);
extern print_job_struct *PrintJobNew(
	const char *command,
	const char *file,		/* Path to postscript file. */
	int coppies,
	int remove_file_when_done
);
extern int PrintJobManage(print_job_struct *pj);
extern void PrintJobDelete(print_job_struct *pj);


#endif	/* PRINTERW_H */
