/*
                      Vertex Low-Level Backup Routines
 */

#ifndef BACKUP_H
#define BACKUP_H

#include <sys/types.h>


/*
 *	Backup error codes:
 */
#define VMA_BACKUP_SUCCESS		0
#define VMA_BACKUP_ERROR		1	/* General error. */


/*
 *	Shift order codes:
 */
#define VMA_BACKUP_ORDER_LH		0	/* min index is newest. */
#define VMA_BACKUP_ORDER_HL		1	/* max index is newest. */


extern int VMABackupFile(
        const char *orig_path,          /* Full path to original file name. */
        int min, int max,               /* Min and max indexes. */
        int shift_order,                /* One of VMA_BACKUP_ORDER_*. */
        int can_remove_overflow
);

#endif	/* BACKUP_H */
