/*
                         Image Viewer Crop Dialog
 */

#ifndef IMGVIEWCROP_H
#define IMGVIEWCROP_H

#include <gtk/gtk.h>
#include "imgview.h"

typedef struct {

	gboolean map_state;
	GtkAccelGroup *accelgrp;
	GtkWidget *toplevel;
	GtkWidget *label;
	GtkWidget *crop_btn, *cancel_btn;
	gpointer imgview;		/* Pointer back to image viewer. */

	/* Crop geometry. */
	gint x, y, width, height;

} imgview_crop_dialog_struct;

extern imgview_crop_dialog_struct *ImgViewCropDialogNew(
	imgview_struct *iv
);
extern void ImgViewCropDialogMapValues(
        imgview_crop_dialog_struct *cd,
        gint x0, gint x1,
        gint y0, gint y1
);
extern void ImgViewCropDialogMap(imgview_crop_dialog_struct *cd);
extern void ImgViewCropDialogUnmap(imgview_crop_dialog_struct *cd);
extern void ImgViewCropDialogDelete(imgview_crop_dialog_struct *cd);

#endif	/* IMGVIEWCROP_H */
