/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.layout.Page;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.Font;

public class PDFDocument {
    protected static final String pdfVersion = "1.3";
    protected int position = 0;
    protected Vector location = new Vector();
    protected int objectcount = 0;
    protected Vector objects = new Vector();
    protected int xref;
    protected PDFRoot root;
    protected PDFInfo info;
    protected PDFResources resources;
    protected IDReferences idReferences;
    protected ColorSpace colorspace = new ColorSpace(ColorSpace.DEVICE_RGB);
    protected int patternCount = 0;
    protected int shadingCount = 0;
    protected int xObjectCount = 0;
    protected Vector xObjects = new Vector();
    protected Hashtable xObjectsMap = new Hashtable();

    public PDFDocument() {
        this.root = this.makeRoot();
        this.info = this.makeInfo();
        this.resources = this.makeResources();
    }

    public int addImage(FopImage fopImage) {
        String string = fopImage.getURL();
        PDFXObject pDFXObject = (PDFXObject)this.xObjectsMap.get(string);
        if (pDFXObject != null) {
            return pDFXObject.getXNumber();
        }
        pDFXObject = new PDFXObject(++this.objectcount, ++this.xObjectCount, fopImage);
        this.objects.addElement(pDFXObject);
        this.xObjects.addElement(pDFXObject);
        this.xObjectsMap.put(string, pDFXObject);
        return this.xObjectCount;
    }

    public PDFPattern createGradient(boolean bl, ColorSpace colorSpace, Vector vector, Vector vector2, Vector vector3) {
        PDFShading pDFShading;
        Object object;
        double d = 1.0;
        Vector<PDFFunction> vector4 = new Vector<PDFFunction>();
        int n = vector.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            object = (PDFColor)vector.elementAt(n2);
            PDFColor pDFColor = (PDFColor)vector.elementAt(n2 + 1);
            if (this.colorspace.getColorSpace() != ((PDFPathPaint)object).getColorSpace()) {
                ((PDFColor)object).setColorSpace(this.colorspace.getColorSpace());
            }
            if (this.colorspace.getColorSpace() != pDFColor.getColorSpace()) {
                pDFColor.setColorSpace(this.colorspace.getColorSpace());
            }
            Vector vector5 = ((PDFColor)object).getVector();
            Vector vector6 = pDFColor.getVector();
            PDFFunction pDFFunction = this.makeFunction(2, null, null, vector5, vector6, d);
            vector4.addElement(pDFFunction);
            ++n2;
        }
        PDFFunction pDFFunction = this.makeFunction(3, null, null, vector4, vector2, null);
        if (bl) {
            if (vector3.size() == 6) {
                pDFShading = this.makeShading(3, this.colorspace, null, null, false, vector3, null, pDFFunction, null);
            } else {
                object = new Vector();
                ((Vector)object).addElement(vector3.elementAt(0));
                ((Vector)object).addElement(vector3.elementAt(1));
                ((Vector)object).addElement(vector3.elementAt(2));
                ((Vector)object).addElement(vector3.elementAt(0));
                ((Vector)object).addElement(vector3.elementAt(1));
                ((Vector)object).addElement(new Double(0.0));
                pDFShading = this.makeShading(3, this.colorspace, null, null, false, (Vector)object, null, pDFFunction, null);
            }
        } else {
            pDFShading = this.makeShading(2, this.colorspace, null, null, false, vector3, null, pDFFunction, null);
        }
        PDFPattern pDFPattern = this.makePattern(2, pDFShading, null, null, null);
        return pDFPattern;
    }

    public int getColorSpace() {
        return this.colorspace.getColorSpace();
    }

    private String getGoToReference(String string) {
        String string2;
        if (this.idReferences.doesIDExist(string)) {
            if (this.idReferences.doesGoToReferenceExist(string)) {
                string2 = this.idReferences.getInternalLinkGoToReference(string);
            } else {
                string2 = this.idReferences.createInternalLinkGoTo(string, ++this.objectcount);
                this.objects.addElement(this.idReferences.getPDFGoTo(string));
            }
        } else {
            this.idReferences.createNewId(string);
            this.idReferences.addToIdValidationList(string);
            string2 = this.idReferences.createInternalLinkGoTo(string, ++this.objectcount);
            this.objects.addElement(this.idReferences.getPDFGoTo(string));
        }
        return string2;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList pDFAnnotList = new PDFAnnotList(++this.objectcount);
        this.objects.addElement(pDFAnnotList);
        return pDFAnnotList;
    }

    public PDFArray makeArray(int[] nArray) {
        PDFArray pDFArray = new PDFArray(++this.objectcount, nArray);
        this.objects.addElement(pDFArray);
        return pDFArray;
    }

    public PDFEncoding makeEncoding(String string) {
        PDFEncoding pDFEncoding = new PDFEncoding(++this.objectcount, string);
        this.objects.addElement(pDFEncoding);
        return pDFEncoding;
    }

    public PDFFont makeFont(String string, String string2, String string3, FontMetric fontMetric, FontDescriptor fontDescriptor) {
        if (fontDescriptor == null) {
            PDFFont pDFFont = new PDFFont(++this.objectcount, string, 1, string2, string3);
            this.objects.addElement(pDFFont);
            return pDFFont;
        }
        byte by = 1;
        if (fontMetric instanceof Font) {
            by = ((Font)fontMetric).getSubType();
        }
        PDFFontNonBase14 pDFFontNonBase14 = (PDFFontNonBase14)PDFFont.createFont(++this.objectcount, string, by, string2, string3);
        this.objects.addElement(pDFFontNonBase14);
        PDFFontDescriptor pDFFontDescriptor = this.makeFontDescriptor(fontDescriptor);
        pDFFontNonBase14.setDescriptor(pDFFontDescriptor);
        pDFFontNonBase14.setWidthMetrics(fontMetric.getFirstChar(), fontMetric.getLastChar(), this.makeArray(fontMetric.getWidths(1)));
        return pDFFontNonBase14;
    }

    public PDFFontDescriptor makeFontDescriptor(FontDescriptor fontDescriptor) {
        PDFFontDescriptor pDFFontDescriptor = new PDFFontDescriptor(++this.objectcount, fontDescriptor.fontName(), fontDescriptor.getAscender(), fontDescriptor.getDescender(), fontDescriptor.getCapHeight(), fontDescriptor.getFlags(), new PDFRectangle(fontDescriptor.getFontBBox()), fontDescriptor.getStemV(), fontDescriptor.getItalicAngle());
        Vector vector = Configuration.getListValue("embed-fonts", 0);
        if (vector != null && vector.contains(fontDescriptor.fontName()) && fontDescriptor.isEmbeddable()) {
            PDFStream pDFStream = fontDescriptor.getFontFile(this.objectcount + 1);
            if (pDFStream != null) {
                ++this.objectcount;
                pDFFontDescriptor.setFontFile(fontDescriptor.getSubType(), pDFStream);
                this.objects.addElement(pDFFontDescriptor);
                this.objects.addElement(pDFStream);
            }
        } else {
            this.objects.addElement(pDFFontDescriptor);
        }
        return pDFFontDescriptor;
    }

    public PDFFunction makeFunction(int n, int n2, Vector vector, Vector vector2, StringBuffer stringBuffer) {
        PDFFunction pDFFunction = new PDFFunction(++this.objectcount, n2, vector, vector2, stringBuffer);
        this.objects.addElement(pDFFunction);
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, Vector vector, Vector vector2, Vector vector3, int n2, int n3, Vector vector4, Vector vector5, StringBuffer stringBuffer, Vector vector6) {
        PDFFunction pDFFunction = new PDFFunction(++this.objectcount, n, vector, vector2, vector3, n2, n3, vector4, vector5, stringBuffer, vector6);
        this.objects.addElement(pDFFunction);
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, Vector vector, Vector vector2, Vector vector3, Vector vector4, double d) {
        PDFFunction pDFFunction = new PDFFunction(++this.objectcount, n, vector, vector2, vector3, vector4, d);
        this.objects.addElement(pDFFunction);
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5) {
        PDFFunction pDFFunction = new PDFFunction(++this.objectcount, n, vector, vector2, vector3, vector4, vector5);
        this.objects.addElement(pDFFunction);
        return pDFFunction;
    }

    protected PDFInfo makeInfo() {
        PDFInfo pDFInfo = new PDFInfo(++this.objectcount);
        this.objects.addElement(pDFInfo);
        return pDFInfo;
    }

    public PDFLink makeLink(Rectangle rectangle, String string, int n) {
        PDFLink pDFLink = new PDFLink(++this.objectcount, rectangle);
        this.objects.addElement(pDFLink);
        if (n == 1) {
            if (string.endsWith(".pdf")) {
                PDFFileSpec pDFFileSpec = new PDFFileSpec(++this.objectcount, string);
                this.objects.addElement(pDFFileSpec);
                PDFGoToRemote pDFGoToRemote = new PDFGoToRemote(++this.objectcount, pDFFileSpec);
                this.objects.addElement(pDFGoToRemote);
                pDFLink.setAction(pDFGoToRemote);
            } else {
                PDFUri pDFUri = new PDFUri(string);
                pDFLink.setAction(pDFUri);
            }
        } else {
            String string2 = this.getGoToReference(string);
            PDFInternalLink pDFInternalLink = new PDFInternalLink(string2);
            pDFLink.setAction(pDFInternalLink);
        }
        return pDFLink;
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, String string2) {
        String string3 = this.getGoToReference(string2);
        PDFOutline pDFOutline2 = new PDFOutline(++this.objectcount, string, string3);
        if (pDFOutline != null) {
            pDFOutline.addOutline(pDFOutline2);
        }
        this.objects.addElement(pDFOutline2);
        return pDFOutline2;
    }

    public PDFOutline makeOutlineRoot() {
        PDFOutline pDFOutline = new PDFOutline(++this.objectcount, null, null);
        this.objects.addElement(pDFOutline);
        this.root.setRootOutline(pDFOutline);
        return pDFOutline;
    }

    public PDFPage makePage(PDFResources pDFResources, PDFStream pDFStream, int n, int n2, Page page) {
        PDFPage pDFPage = new PDFPage(++this.objectcount, pDFResources, pDFStream, n, n2);
        Enumeration enumeration = page.getIDList().elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            this.idReferences.setInternalGoToPageReference(string, pDFPage.referencePDF());
        }
        this.objects.addElement(pDFPage);
        this.root.addPage(pDFPage);
        return pDFPage;
    }

    public PDFPattern makePattern(int n, PDFResources pDFResources, int n2, int n3, Vector vector, double d, double d2, Vector vector2, Vector vector3, StringBuffer stringBuffer) {
        String string = new String("Pa" + ++this.patternCount);
        PDFPattern pDFPattern = new PDFPattern(++this.objectcount, string, pDFResources, 1, n2, n3, vector, d, d2, vector2, vector3, stringBuffer);
        this.resources.addPattern(pDFPattern);
        this.objects.addElement(pDFPattern);
        return pDFPattern;
    }

    public PDFPattern makePattern(int n, PDFShading pDFShading, Vector vector, StringBuffer stringBuffer, Vector vector2) {
        String string = new String("Pa" + ++this.patternCount);
        PDFPattern pDFPattern = new PDFPattern(++this.objectcount, string, 2, pDFShading, vector, stringBuffer, vector2);
        this.resources.addPattern(pDFPattern);
        this.objects.addElement(pDFPattern);
        return pDFPattern;
    }

    private PDFResources makeResources() {
        PDFResources pDFResources = new PDFResources(++this.objectcount);
        this.objects.addElement(pDFResources);
        return pDFResources;
    }

    protected PDFRoot makeRoot() {
        PDFRoot pDFRoot = new PDFRoot(++this.objectcount);
        this.objects.addElement(pDFRoot);
        PDFPages pDFPages = new PDFPages(++this.objectcount);
        this.objects.addElement(pDFPages);
        pDFRoot.setRootPages(pDFPages);
        return pDFRoot;
    }

    public PDFShading makeShading(int n, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, int n2, int n3, int n4, Vector vector3, PDFFunction pDFFunction) {
        String string = new String("Sh" + ++this.shadingCount);
        PDFShading pDFShading = new PDFShading(++this.objectcount, string, n, colorSpace, vector, vector2, bl, n2, n3, n4, vector3, pDFFunction);
        this.resources.addShading(pDFShading);
        this.objects.addElement(pDFShading);
        return pDFShading;
    }

    public PDFShading makeShading(int n, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, int n2, int n3, Vector vector3, int n4, PDFFunction pDFFunction) {
        String string = new String("Sh" + ++this.shadingCount);
        PDFShading pDFShading = new PDFShading(++this.objectcount, string, n, colorSpace, vector, vector2, bl, n2, n3, vector3, n4, pDFFunction);
        this.resources.addShading(pDFShading);
        this.objects.addElement(pDFShading);
        return pDFShading;
    }

    public PDFShading makeShading(int n, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, Vector vector3, Vector vector4, PDFFunction pDFFunction) {
        String string = new String("Sh" + ++this.shadingCount);
        PDFShading pDFShading = new PDFShading(++this.objectcount, string, n, colorSpace, vector, vector2, bl, vector3, vector4, pDFFunction);
        this.objects.addElement(pDFShading);
        this.resources.addShading(pDFShading);
        return pDFShading;
    }

    public PDFShading makeShading(int n, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, Vector vector3, Vector vector4, PDFFunction pDFFunction, Vector vector5) {
        String string = new String("Sh" + ++this.shadingCount);
        PDFShading pDFShading = new PDFShading(++this.objectcount, string, n, colorSpace, vector, vector2, bl, vector3, vector4, pDFFunction, vector5);
        this.resources.addShading(pDFShading);
        this.objects.addElement(pDFShading);
        return pDFShading;
    }

    public PDFStream makeStream() {
        PDFStream pDFStream = new PDFStream(++this.objectcount);
        pDFStream.addDefaultFilters();
        this.objects.addElement(pDFStream);
        return pDFStream;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.position += this.outputHeader(outputStream);
        this.resources.setXObjects(this.xObjects);
        int n = 1;
        while (n <= this.objectcount) {
            this.location.addElement(new Integer(this.position));
            PDFObject pDFObject = (PDFObject)this.objects.elementAt(n - 1);
            this.position += pDFObject.output(outputStream);
            ++n;
        }
        this.position += this.outputXref(outputStream);
        this.outputTrailer(outputStream);
        outputStream.flush();
    }

    protected int outputHeader(OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = "%PDF-1.3\n".getBytes();
        outputStream.write(byArray);
        n += byArray.length;
        byte[] byArray2 = new byte[]{37, -86, -85, -84, -83, 10};
        outputStream.write(byArray2);
        return n += byArray2.length;
    }

    protected void outputTrailer(OutputStream outputStream) throws IOException {
        String string = "trailer\n<<\n/Size " + (this.objectcount + 1) + "\n/Root " + this.root.number + " " + this.root.generation + " R\n/Info " + this.info.number + " " + this.info.generation + " R\n>>\nstartxref\n" + this.xref + "\n%%EOF\n";
        outputStream.write(string.getBytes());
    }

    private int outputXref(OutputStream outputStream) throws IOException {
        Object object;
        this.xref = this.position;
        StringBuffer stringBuffer = new StringBuffer("xref\n0 " + (this.objectcount + 1) + "\n0000000000 65535 f \n");
        int n = 1;
        while (n < this.objectcount + 1) {
            object = "0000000000";
            String string = this.location.elementAt(n - 1).toString();
            String string2 = String.valueOf(((String)object).substring(string.length())) + string;
            stringBuffer = stringBuffer.append(String.valueOf(string2) + " 00000 n \n");
            ++n;
        }
        object = stringBuffer.toString().getBytes();
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    public void setColorSpace(int n) {
        this.colorspace.setColorSpace(n);
    }

    public void setIDReferences(IDReferences iDReferences) {
        this.idReferences = iDReferences;
    }

    public void setProducer(String string) {
        this.info.setProducer(string);
    }
}

