/*
 * i18n.c: 'EnigmaNG' skin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 *
 * Translations submitted by:
 *  - English:    Andreas Mair <andreas _@_ vdr-developer.org>
 *  - Deutsch:    Andreas Mair <andreas _@_ vdr-developer.org>
 *  - Italiano:   Gringo <vdr-italian _@_ tiscali.it>
 *  - Nederlands: Johan Schuring <dorpsgek @vdr-portal.de>
 *  - Franais:   Patrice Staudt <pat @vdr-portal.de>
 *  - Finnish:    Rolf Ahrenberg <rofafor @vdr-portal.de>
 *  - Polski:     ???
 *  - Espaol:    bittor from open7x0.org <bittor7x0 _at_ gmail.com>
 *  - Svenska:    ???
 *  - Russian:    SergArb @vdr-portal.de / neptunvasja @vdr-portal.de
 *  - Eesti:      ???
 *  - Dansk:      ???
 *  - Czech:      ???
 *  - Trke:     n/a
 *
 */

#include "common.h"
#include "i18n.h"

#if VDRVERSNUM < 10507
const tI18nPhrase Phrases[] = {
// START I18N - automatically generated by po2i18n.pl
  { "  Blink pause (ms)",
    "  Blink-Pause (ms)",
    "",
    "  Pausa lampeggiante (ms)",
    "  Blinkpauze (ms)",
    "",
    "  Pause de clignotement (ms)",
    "",
    "  Vilkutuksen tauko (ms)",
    "",
    "  Pausa del parpadeo (ms)",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Identify channel by",
    "  Kanal-Identifikation durch",
    "",
    "  Identifica canale per",
    "  Identificeer kanaal door",
    "",
    "  Identifier chane par",
    "",
    "  Tunnista kanava",
    "  Rozpoznaj kana po",
    "  Identificar el canal por",
    "",
    "  Identifiera kanal med",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "    ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "  Kanali tuvastamise meetod",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Image format",
    "  Bildformat",
    "",
    "  Formato immagine",
    "  Beeldformaat",
    "",
    "  Format d'image",
    "",
    "  Kuvaformaatti",
    "",
    "  Formato de imagen",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Image height",
    "  Bildhhe",
    "",
    "  Altezza immagine",
    "  Beeldhoogte",
    "",
    "  Hauteur",
    "",
    "  Kuvien korkeus",
    "",
    "  Altura de imagen",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Image width",
    "  Bildbreite",
    "",
    "  Larghezza immagine",
    "  Beeldbreedte",
    "",
    "  Largeur",
    "",
    "  Kuvien leveys",
    "",
    "  Anchura de imagen",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Resize images",
    "  Bildberechnung benutzt",
    "",
    "  Ridimensiona immagini",
    "  Aanpassen beeldgrootte",
    "",
    "  Redimensionne les images",
    "",
    "  Muokkaa kuvien kokoa",
    "",
    "  Redimensionar imgenes",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scoll behaviour",
    "  Scroll-Verhalten",
    "",
    "  Modalit scorrimento",
    "  Scroll gedrag",
    "",
    "  Comportement de dfilement",
    "",
    "  Vieritystapa",
    "",
    "  Comportamiento del scroll",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll OSD title",
    "  OSD Titel scrollen",
    "",
    "  Scorri titolo OSD",
    "  OSD titel scrollen",
    "",
    "  Dfilement dans le titre du OSD",
    "",
    "  Vierit valikon otsikkoa",
    "",
    "  Ttulo OSD del scroll",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll active list items",
    "  Aktive Listenzeile scrollen",
    "",
    "  Scorri elenco valori attivi",
    "  Lijst aktieve punten scrollen",
    "",
    "  Barre de dfilement dans la liste active",
    "",
    "  Vierit aktiivista valintaa",
    "",
    "  Scroll para la lista activa",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll delay (ms)",
    "  Scroll-Verzgerung (ms)",
    "",
    "  Ritardo scorrimento (ms)",
    "  Scrollvertraging (ms)",
    "",
    "  Dlai de dfilement (ms)",
    "",
    "  Vierityksen viive (ms)",
    "",
    "  Retardo del scroll (ms)",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll info area",
    "  Infobereich scrollen",
    "",
    "  Scorri info area",
    "  Infobereik scrollen",
    "",
    "  Barre de dfilement dans la surface info",
    "",
    "  Vierit infoaluetta",
    "",
    "  Scroll para el rea info",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll other items",
    "  Andere Bereiche scrollen",
    "",
    "  Scorri altri valori",
    "  Andere punten scrollen",
    "",
    "  Barre de dfilement dans d'autres parties",
    "",
    "  Vierit muita alueita",
    "",
    "  Scroll para otros datos",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Scroll pause (ms)",
    "  Scroll-Pause (ms)",
    "",
    "  Pausa scorrimento (ms)",
    "  Scrollpause (ms)",
    "",
    "  Pause de dfilement (ms)",
    "",
    "  Vierityksen tauko (ms)",
    "",
    "  Pausa del scroll (ms)",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show WSS mode symbols",
    "  Symbol fr WSS Modus",
    "",
    "  Mostra simboli mod. WSS",
    "WSS modus symbolen tonen",
    "",
    " Afficher mode symboles WSS",
    "",
    "  Nyt WSS-symbolit",
    "",
    "  Mostrar smbolos modo WSS",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show flags",
    "  Fahnen anzeigen",
    "",
    "  Mostra segni",
    "  Vlaggen tonen",
    "",
    "  Afficher drapeau",
    "",
    "  Nyt liput",
    "",
    "  Mostrar banderas",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show mail icon",
    "  Zeige Mail-Icon",
    "",
    "  Mostra icona email",
    "  Mail-ikoon tonen",
    "",
    "  Afficher l'icne courriel",
    "",
    "  Nyt shkpostikuvake",
    "",
    "  Mostrar icono correo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "    . ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show symbols in audio",
    "  Symbole bei Audio",
    "",
    "  Mostra simboli audio",
    "  Symbolen bij audio tonen",
    "",
    "  dans audio",
    "",
    "  Nyt symbolit nivalikossa",
    "",
    "  Mostrar smbolos en audio",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show symbols in menu",
    "  Symbole im Men",
    "",
    "  Mostra simboli menu",
    "  Symbolen in menu tonen",
    "",
    "  dans le menu",
    "",
    "  Nyt symbolit valikossa",
    "",
    "  Mostrar smbolos en men",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "     ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show symbols in messages",
    "  Symbole bei den Meldungen",
    "",
    "  Mostra simboli messaggi",
    "  Symbolen bij berichten tonen",
    "",
    "  dans les messages",
    "",
    "  Nyt symbolit viesteiss",
    "",
    "  Mostrar smbolos en mensajes",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "  Show symbols in replay",
    "  Symbole bei der Wiedergabe",
    "",
    "  Mostra simboli esecuzione",
    "  Symbolen bij weergave tonen",
    "",
    "  dans lecture",
    "",
    "  Nyt symbolit toistettaessa",
    "",
    "  Mostrar smbolos en reproduccin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "*** Invalid Channel ***",
    "*** Ungltiger Kanal ***",
    "",
    "*** Canale non valido ***",
    "*** Ongeldig Kanaal ***",
    "",
    "*** Chane non valable ***",
    "",
    "*** Virheellinen kanava ***",
    "",
    "*** Canal no vlido ***",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "***   ***",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Animated Text",
    "Bewegter Text",
    "",
    "Testo animato",
    "Geanimeerde tekst",
    "",
    "Texte dfilant",
    "",
    "Tekstien elvinti",
    "",
    "Texto animado",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Auxiliary information",
    "Zusatzinformation",
    "",
    "Informazione ausiliare",
    "Hulp informatie",
    "",
    "Information auxiliare",
    "",
    "Listiedot",
    "Informacje pomocnicze",
    "Informacin adicional",
    "",
    "Extrainformation",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    ". ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Lisainfo",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Button$Flush cache",
    "Cache leeren",
    "",
    "Pulisci cache",
    "Cache legen",
    "",
    "Supprimer cache",
    "",
    "Tyhjenn",
    "Oprnij cache",
    "Limpiar cach",
    "",
    "Tm cachen",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Thjenda",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Button$Set",
    "ndern",
    "",
    "Imposta",
    "Veranderen",
    "",
    "Changer",
    "",
    "Aseta",
    "",
    "Cambiar",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Channel logo cache size",
    "Gre des Logo-Caches",
    "",
    "Dim. cache logo canale",
    "Kanaallogo cache",
    "",
    "Taille du cache des logos",
    "",
    "Vlimuistin koko kanavalogoille",
    "Rozmiar cache dla logo kanau",
    "Tamao de cach para los logos",
    "",
    "Cachestorlek fr logotyper",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  o ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Kanalilogo vahemlu suurus",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Channel:",
    "Kanal:",
    "",
    "Canale:",
    "Kanaal:",
    "",
    "Chane:",
    "",
    "Kanava:",
    "",
    "Canal:",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Channelinfo: language",
    "Kanalinfo: Sprache",
    "",
    "Info canale: lingua",
    "Kanaalinfo: taal",
    "",
    "Chane info: langue",
    "",
    "Kanavatieto: kieli",
    "",
    "Info canal: idioma",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Channelinfo: subtitle",
    "Kanalinfo: Untertitel",
    "",
    "Info canale: sottotitolo",
    "Kanaalinfo: ondertitel",
    "",
    "Chane info: sous-titres",
    "",
    "Kanavatieto: ohjelman kuvaus",
    "",
    "Info canal: subttulo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Channelinfo: title",
    "Kanalinfo: Titel",
    "",
    "Info canale: titolo",
    "Kanaalinfo: titel",
    "",
    "Chane info: titre ",
    "",
    "Kanavatieto: ohjelman nimi",
    "",
    "Info canal: ttulo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Date",
    "Datum",
    "",
    "Data",
    "Datum",
    "",
    "Date",
    "",
    "Pivys",
    "",
    "Fecha",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Default Fixed Size Font",
    "Std. Schrift mit fester Breite",
    "",
    "Car. dim. fissa pred.",
    "Standaardwaarde font",
    "",
    "Largeur fixe standard",
    "",
    "tasavlinen kirjasintyyppi",
    "",
    "Fuente tamao fijo defecto",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Default OSD Font",
    "Std. OSD Font",
    "",
    "Car. OSD pred.",
    "Standaard OSDfont",
    "",
    "OSD standard",
    "",
    "oletuskirjasintyyppi",
    "",
    "Fuente OSD defecto",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Default Small Font",
    "Std. kleine Schrift",
    "",
    "Car. piccolo pred.",
    "Standaard klein font",
    "",
    "Petite police standard",
    "",
    "pieni kirjasintyyppi",
    "",
    "Fuente pequea defecto",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Details: date",
    "Details: Datumszeile",
    "",
    "Dettagli: data",
    "Details: datum",
    "",
    "Dtails: date",
    "",
    "Listiedot: pivmr",
    "",
    "Detalles: fecha",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Details: subtitle",
    "Details: Untertitel",
    "",
    "Dettagli: sottotitolo",
    "Details: ondertitel",
    "",
    "Dtails: Sous-titre",
    "",
    "Listiedot: ohjelman kuvaus",
    "",
    "Detalles: subttulo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Details: text",
    "Details: Text",
    "",
    "Dettagli: testo",
    "Details: tekst",
    "",
    "Dtails: Texte",
    "",
    "Listiedot: leipteksti",
    "",
    "Detalles: texto",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Details: title",
    "Details: Titel",
    "",
    "Dettagli: titolo",
    "Details: titel",
    "",
    "Dtails: Titre",
    "",
    "Listiedot: ohjelman nimi",
    "",
    "Detalles: ttulo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Dynamic OSD size",
    "Dynamische OSD-Gre",
    "",
    "Dimensione OSD dinamica",
    "Dynamische OSD grootte",
    "",
    "Taille dynamique de OSD",
    "",
    "Mukauta kuvaruutunytn kokoa",
    "",
    "Tamao OSD dinmico",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "EPGSearch",
    "EPGSearch",
    "",
    "EPGSearch",
    "EPGsearch",
    "",
    "Recherche EPG",
    "",
    "EPGSearch",
    "",
    "EPGSearch",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Enable",
    "Verwenden",
    "",
    "Abilita",
    "Toelaten",
    "",
    "Permettre",
    "",
    "Kyt elvinti",
    "",
    "Activar",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "EnigmaNG",
    "EnigmaNG",
    "",
    "EnigmaNG",
    "EnigmaNG",
    "",
    "EnigmaNG",
    "",
    "EnigmaNG",
    "EnigmaNG",
    "EnigmaNG",
    "",
    "EnigmaNG",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "EnigmaNG",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "EnigmaNG",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "EnigmaNG skin",
    "EnigmaNG Oberflche",
    "",
    "Interfaccia EnigmaNG",
    "EnigmaNG skin",
    "",
    "Skin EnigmaNG",
    "",
    "EnigmaNG-ulkoasu",
    "Skin EnigmaNG",
    "Piel EnigmaNG",
    "",
    "EnigmaNG-temat",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "EnigmaNG ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "EnigmaNG kest",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Fixed Font",
    "Schrift mit fester Breite",
    "",
    "Carattere fisso",
    "Vaste waarde font",
    "",
    "Police avec une largeur fixe",
    "",
    "Tasavlinen kirjasintyyppi",
    "",
    "Fuente Fija",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Flushing channel logo cache...",
    "Logo-Cache wird geleert...",
    "",
    "Pulizia cache logo canale...",
    "Kanaallogo cache legen...",
    "",
    "Suppression du cache...",
    "",
    "Tyhjennetn vlimuistia...",
    "Oprniam cache logo kanau...",
    "Limpiando la cach...",
    "",
    "Tmmer cachen...",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ...",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Kanalilogo vahemlu thjendamine...",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Fonts",
    "Fonts",
    "",
    "Caratteri",
    "Fonts",
    "",
    "Les polices",
    "",
    "Kirjasintyypit",
    "",
    "Fuentes",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Free last line",
    "freie letzte Zeile",
    "",
    "Ultima riga libera",
    "Vrije laatste lijn",
    "",
    "Dernire ligne libre",
    "",
    "alimmalla vapaalla rivill",
    "",
    "ltima lnea libre",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Friday",
    "Freitag",
    "Petek",
    "Venerd",
    "Vrijdag",
    "Sexta",
    "Vendredi",
    "Fredag",
    "Perjantai",
    "Pitek",
    "Viernes",
    "",
    "Fredag",
    "Vineri",
    "Pntek",
    "Divendres",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Petak",
#endif
#if VDRVERSNUM >= 10313
    "Reede",
#endif
#if VDRVERSNUM >= 10316
    "Fredag",
#endif
#if VDRVERSNUM >= 10342
    "Ptek",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Full title width",
    "Volle Titelbreite",
    "",
    "Lunghezza titolo completo",
    "Volle titelbreedte",
    "",
    "Largeur totale pour le titre",
    "",
    "Levit otsikkopalkki",
    "",
    "Ancho completo para ttulo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "General",
    "Allgemein",
    "",
    "Generale",
    "Algemeen",
    "",
    "Gnralit",
    "",
    "Yleiset",
    "",
    "General",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Help buttons",
    "Hilfe Tasten",
    "",
    "Tasti aiuto",
    "Help knoppen",
    "",
    "Button aide",
    "",
    "vrinppinrivill",
    "",
    "Botones de ayuda",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Help keys",
    "Farb-Tasten",
    "",
    "Tasti aiuto",
    "Help toetsen",
    "",
    "Touche couleur",
    "",
    "Vrinppimet",
    "",
    "Botones de ayuda",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Info area: timers text",
    "Infobereich: Timer Text",
    "",
    "Info area: testo timer",
    "Infobereik: Timertekst",
    "",
    "Barre d'information: Text programmation",
    "",
    "Infoalue: ajastimen leipteksti",
    "",
    "rea info: texto programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Info area: timers title",
    "Infobereich: Timer Titel",
    "",
    "Info area: titoli timer",
    "Infobereik: Timertitel",
    "",
    "Barre d'information: Titre Progammation",
    "",
    "Infoalue: ajastimen otsikko",
    "",
    "rea info: ttulo programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Info area: warning text",
    "Infobereich: Warnung Text",
    "",
    "Info area: testo avviso",
    "Infobereik: waarschuwing tekst",
    "",
    "Barre d'information: texte d'avertissement",
    "",
    "Infoalue: varoituksen leipteksti",
    "",
    "rea info: texto aviso",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Info area: warning title",
    "Infobereich: Warnung Titel",
    "",
    "Info area: titolo avviso",
    "Infobereik: waarschuwing titel",
    "",
    "Barre d'information: avertissement titre",
    "",
    "Infoalue: varoituksen otsikko",
    "",
    "rea info: ttulo aviso",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Languages",
    "Sprachen",
    "",
    "Lingue",
    "Talen",
    "",
    "Langues",
    "",
    "Kielet",
    "Jzyki",
    "Idiomas",
    "",
    "Sprk",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Keeled",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Last line",
    "Letzter Zeile",
    "",
    "Ultima riga",
    "Laatste lijn",
    "",
    "Dernire ligne",
    "",
    "alimmalla rivill",
    "",
    "ltima lnea",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "List items",
    "Listen",
    "",
    "Elenco valori",
    "Lijsten",
    "",
    "Liste",
    "",
    "Listat",
    "",
    "Listado",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Logos & Symbols",
    "Logos & Symbole",
    "",
    "Loghi e simboli",
    "Logo's & Symbolen",
    "",
    "Logos et symboles",
    "",
    "Logot ja symbolit",
    "",
    "Logos y smbolos",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " & ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Messages",
    "Meldungen",
    "",
    "Messaggi",
    "Meldingen",
    "",
    "Message",
    "",
    "Viestit",
    "",
    "Mensajes",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Monday",
    "Montag",
    "ponedeljek",
    "Luned",
    "maandag",
    "Segunda",
    "Lundi",
    "Manday",
    "Maanantai",
    "poniedziaek",
    "Lunes",
    "",
    "Mndag",
    "Luni",
    "Htf",
    "Dilluns",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Ponedjeljak",
#endif
#if VDRVERSNUM >= 10313
    "Esmaspev",
#endif
#if VDRVERSNUM >= 10316
    "Mandag",
#endif
#if VDRVERSNUM >= 10342
    "Pondl",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Mute",
    "Stumm",
    "",
    "Muto",
    "Geluid uit",
    "Muet",
    "Silence",
    "",
    "Mykistetty",
    "",
    "Silenciar",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    ".",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Name",
    "Name",
    "",
    "Nome",
    "Naam",
    "",
    "Nom",
    "",
    "Nimi",
    "",
    "Nombre",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "No TTF support!",
    "TTF nicht untersttzt!",
    "",
    "Nessun supporto TTF!",
    "TTF niet ondersteund!",
    "",
    "Les polices TrueType ne sont pas supportes!",
    "",
    "Ei TrueType-kirjasintyyppi tukea!",
    "",
    "Sin soporte TTF!",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "No TrueType fonts installed!",
    "Keine TrueType Schriften installiert!",
    "",
    "Nessun carattere TrueType installato!",
    "Geen TrueType fonten geinstalleerd!",
    "",
    "Il n'y a pas de police TrueType d'install!",
    "",
    "TrueType-kirjasintyyppej ei lydy!",
    "",
    "Ninguna fuente TrueType instalada!",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "No timer check",
    "Ohne berwachung",
    "",
    "Nessuna verifica timer",
    "Geen controle",
    "",
    "Sans surveillance",
    "",
    "Ei valvontaa",
    "",
    "No comprobar programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Number of Reruns",
    "Anzahl Wiederholungen",
    "",
    "Numero di repliche",
    "aantal herhalingen",
    "",
    "Nombre de rptitions",
    "",
    "Uusintojen lukumr",
    "",
    "Nmero de repeticiones",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "OSD title",
    "OSD Titel",
    "",
    "Titolo OSD",
    "OSD titel",
    "",
    "Titre OSD",
    "",
    "Valikon otsikko",
    "",
    "Ttulo OSD",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "RERUNS OF THIS SHOW",
    "WIEDERHOLUNGEN",
    "",
    "REPLICHE DI QUESTO SPETTACOLO",
    "HERHALINGEN",
    "",
    "REPETITION",
    "",
    "TOISTUVAT TAPAHTUMAT",
    "",
    "REPETICIONES",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "¾",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Replay: times",
    "Wiedergabe: Zeiten",
    "",
    "Riproduzione: volte",
    "Weergave: tijden",
    "",
    "Rejouer : priodes",
    "",
    "Toisto: kellonajat",
    "",
    "Reproducir: veces",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Saturday",
    "Samstag",
    "Sobota",
    "Sabato",
    "Zaterdag",
    "Sbado",
    "Samedi",
    "Lrdag",
    "Lauantai",
    "Sobota",
    "Sbado",
    "",
    "Lrdag",
    "Smbt",
    "Szombat",
    "Dissabte",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Subota",
#endif
#if VDRVERSNUM >= 10313
    "Laupev",
#endif
#if VDRVERSNUM >= 10316
    "Lrdag",
#endif
#if VDRVERSNUM >= 10342
    "Sobota",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Search pattern:",
    "Suchmuster:",
    "",
    "Modello di ricerca:",
    "Zoekpatroon:",
    "",
    "Modle de recherche",
    "",
    "Hakutapa:",
    "",
    "Buscar patrn:",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show VPS",
    "VPS anzeigen",
    "",
    "Mostra VPS",
    "VPS tonen",
    "",
    "Afficher le VPS",
    "",
    "Nyt VPS-tieto",
    "",
    "Mostrar VPS",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " VPS",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show auxiliary information",
    "Zusatzinfo anzeigen",
    "",
    "Mostra info ausiliare",
    "Toon hulp informatie",
    "",
    "Afficher informations auxiliaires",
    "",
    "Nyt listiedot",
    "Pokazuj informacje pomocnicze",
    "Mostrar informacin adicional",
    "",
    "Visa extrainformation",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " . ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Lisainfo nitamine",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show channel logos",
    "Kanal-Logos anzeigen",
    "",
    "Mostra loghi canali",
    "Toon kanaallogo's",
    "",
    "Afficher logos des chanes",
    "",
    "Nyt kanavalogot",
    "Pokazuj logo kanau",
    "Mostrar logos de los canales",
    "",
    "Visa kanallogotyper",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Kanalilogo nitamine",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show event/recording images",
    "Bilder in EPG/Aufnahmendetails",
    "",
    "Mostra immagini evento/reg.",
    "Voorstelling/opname figuren tonen",
    "",
    "Images dans les EPG et dtails d'enregistrements",
    "",
    "Nyt kuvat listietovalikossa",
    "",
    "Mostrar imgenes grabacin/suceso",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  EPG",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show info area in main menu",
    "Infobereich im Hauptmen",
    "",
    "Mostra area info nel menu",
    "Info in hoofdmenu",
    "",
    "Surface d'infos dans le menu principal",
    "",
    "Nyt infoalue pvalikossa",
    "",
    "Mostrar info en men principal",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " .   . ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show marker in lists",
    "Symbol vor Listeneintrgen",
    "",
    "Mostra indicatore elenchi",
    "Markering in lijsten tonen",
    "",
    "Marque devant les listes",
    "",
    "Nyt valintasymboli",
    "",
    "Mostrar marcador en listas",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show messages in menu on",
    "Meldungen im Men ber",
    "",
    "Mostra messaggi nel menu",
    "Toon berichten in menu aan",
    "",
    "Afficher les messages dans le menu",
    "",
    "Nyt viestit valikossa",
    "",
    "Mostrar mensajes en el men",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show progressbar",
    "Fortschrittbalken anzeigen",
    "",
    "Mostra barra avanzamento",
    "Progressiebalk tonen",
    "",
    "Afficher barre de progression",
    "",
    "Nyt aikajana",
    "Pokazuj pasek postpu",
    "Mostrar barra de progreso",
    "",
    "Visa framsteg",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Edenemisriba nitamine",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show recording's size",
    "Aufnahmengre anzeigen",
    "",
    "Mostra dimensione reg.",
    "Opnamegrootte tonen",
    "",
    "Afficher la taille des enregistrements",
    "",
    "Nyt tallenteen koko",
    "",
    "Mostrar tamao de grabacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show remaining/elapsed time",
    "Zeige abgel./restl. Zeit",
    "",
    "Mostra tempo rimasto/trascorso",
    "Toon resterend/gedane tijd",
    "",
    "Afficher le temps coul/restant",
    "",
    "Nyt tapahtuman aika",
    "",
    "Mostrar tiempo restante/transcurrido",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ./. ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show status symbols",
    "Statussymbole anzeigen",
    "",
    "Mostra simboli stato",
    "Status symbolen tonen",
    "",
    "Afficher symbole de status",
    "",
    "Nyt symbolit",
    "Pokazuj symbole",
    "Mostrar smbolos de estado",
    "",
    "Visa symboler",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Smbolite nitamine",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show symbols",
    "Symbole anzeigen",
    "",
    "Mostra simboli",
    "Symbolen tonen",
    "",
    "Afficher symbole",
    "",
    "Nyt symbolit",
    "Pokazuj symbole",
    "Mostrar smbolos",
    "",
    "Visa symboler",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "Smbolite nitamine",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show symbols in lists",
    "Symbole in Listen",
    "",
    "Mostra simboli elenchi",
    "Symbolen in lijsten tonen",
    "",
    "Symboles dans les listes",
    "",
    "Nyt tapahtumien symbolit",
    "",
    "Mostrar smbolos en listas",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Show timer conflicts",
    "Timerkonflikte anzeigen",
    "",
    "Mostra conflitti timer",
    "Timerconflict tonen",
    "",
    "Afficher les conflits de programmation",
    "",
    "Nyt pllekkiset ajastimet",
    "",
    "Mostrar conflictos de programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Size",
    "Gre",
    "",
    "Dim.",
    "Grootte",
    "",
    "Taille",
    "",
    "Koko",
    "",
    "Tamao",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Sunday",
    "Sonntag",
    "Nedelja",
    "Domenica",
    "Zondag",
    "Domingo",
    "Dimanche",
    "Sndag",
    "Sunnuntai",
    "Niedziela",
    "Domingo",
    "",
    "Sndag",
    "Duminic",
    "Vasrnap",
    "Diumenge",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Nedjelja",
#endif
#if VDRVERSNUM >= 10313
    "Phapev",
#endif
#if VDRVERSNUM >= 10316
    "Sndag",
#endif
#if VDRVERSNUM >= 10342
    "Nedle",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "TIMERS",
    "TIMER",
    "",
    "TIMER",
    "TIMER",
    "",
    "PROGRAMMATION",
    "",
    "AJASTIMET",
    "",
    "PROGRAMACIONES",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "°",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Thursday",
    "Donnerstag",
    "etrtek",
    "Gioved",
    "Donderdag",
    "Quinta",
    "Jeudi",
    "Torsdag",
    "Torstai",
    "Czwartek",
    "Jueves",
    "",
    "Torsdag",
    "Joi",
    "Cstrtk",
    "Dijous",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "etvrtak",
#endif
#if VDRVERSNUM >= 10313
    "Neljapev",
#endif
#if VDRVERSNUM >= 10316
    "Torsdag",
#endif
#if VDRVERSNUM >= 10342
    "tvrtek",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Timer check",
    "berwachung",
    "",
    "Verifica timer",
    "Monitoren",
    "",
    "Observation de la programmation",
    "",
    "Ajastimien valvonta",
    "",
    "Comprobar programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Timer conflict",
    "Timerkonflikt",
    "",
    "Conflitto timer",
    "Timerconflict",
    "",
    "Conflit de programmation",
    "",
    "Pllekkinen ajastin",
    "",
    "Conflicto de programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Timer conflicts",
    "Timerkonflikte",
    "",
    "Conflitti timer",
    "Timerconflicten",
    "",
    "Conflits de programmation",
    "",
    "Pllekkisi ajastimia",
    "",
    "Conflictos de programacin",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "TrueType Font",
    "TrueType Schrift",
    "",
    "Car. TrueType",
    "TrueType Font",
    "",
    "TrueType",
    "",
    "TrueType-kirjasin",
    "",
    "Fuente TrueType",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Try 8bpp single area",
    "Einen 8bpp Bereich versuchen",
    "",
    "Prova area singola a 8bpp",
    "Op 8bpp bereik testen",
    "",
    "Essayer une surface  8bpp",
    "",
    "Suosi yht 8bpp kuva-aluetta",
    "",
    "Probar un rea de 8bpp",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Tuesday",
    "Dienstag",
    "Torek",
    "Marted",
    "Dinsdag",
    "Tera",
    "Mardi",
    "Tirsday",
    "Tiistai",
    "Wtorek",
    "Martes",
    "",
    "Tisdag",
    "Mari",
    "Kedd",
    "Dimarts",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Utorak",
#endif
#if VDRVERSNUM >= 10313
    "Teisipev",
#endif
#if VDRVERSNUM >= 10316
    "Tirsdag",
#endif
#if VDRVERSNUM >= 10342
    "ter",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Use Subtitle for reruns",
    "Verw. Untertitel fr Wdh.",
    "",
    "Utilizza sottotitolo per repliche",
    "Gebr. ondertitlel voor herh.",
    "",
    "Utilise sous-titres pour les rptitions",
    "",
    "Kyt lyhytt kuvausta uusinnoille",
    "",
    "Usar subttulo para repeticiones",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    ".   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Volume",
    "Lautstrke",
    "",
    "Volume",
    "Volume",
    "",
    "Volume",
    "",
    "nenvoimakkuus",
    "",
    "Volumen",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "WARNING",
    "WARNUNG",
    "",
    "ATTENZIONE",
    "WAARSCHUWING",
    "",
    "ATTENTION",
    "",
    "VAROITUS",
    "",
    "AVISO",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "ÿ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Wednesday",
    "Mittwoch",
    "sreda",
    "mercoled",
    "woensdag",
    "Quarta",
    "Mercredi",
    "Onsday",
    "Keskiviikko",
    "roda",
    "Mircoles",
    "",
    "Onsdag",
    "Miercuri",
    "Szerda",
    "Dimecres",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "Srijeda",
#endif
#if VDRVERSNUM >= 10313
    "Kolmapev",
#endif
#if VDRVERSNUM >= 10316
    "Onsdag",
#endif
#if VDRVERSNUM >= 10342
    "Steda",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "Width",
    "Weite",
    "",
    "Ampiezza",
    "Breedte",
    "",
    "Largeur",
    "",
    "Leveys",
    "",
    "Anchura",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "always",
    "immer",
    "",
    "sempre",
    "Altijd",
    "",
    "toujours",
    "",
    "aina",
    "",
    "siempre",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "data",
    "ID",
    "",
    "dati",
    "data",
    "",
    "Donne",
    "",
    "tiedoista",
    "parametry",
    "datos",
    "",
    "data",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "andmed",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "elapsed",
    "abgelaufene",
    "",
    "trascorso",
    "gedane",
    "",
    "coul",
    "",
    "kulunut",
    "",
    "transcurrido",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "en_US",
    "de_DE",
    "sl_SI",
    "it_IT",
    "nl_NL",
    "pt_PT",
    "fr_FR",
    "no_NO",
    "fi_FI",
    "pl_PL",
    "es_ES",
    "el_GR",
    "sv_SE",
    "ro_RO",
    "hu_HU",
    "ca_AD",
#if VDRVERSNUM >= 10302
    "ru_RU",
#endif
#if VDRVERSNUM >= 10307
    "hr_HR",
#endif
#if VDRVERSNUM >= 10313
    "et_EE",
#endif
#if VDRVERSNUM >= 10316
    "da_DK",
#endif
#if VDRVERSNUM >= 10342
    "cs_CZ",
#endif
#if VDRVERSNUM >= 10502
    "tr_TR",
#endif
  },
  { "if exists",
    "wenn vorhanden",
    "",
    "se esiste",
    "wanneer aanwezig",
    "",
    "si existant",
    "",
    "jos olemassa",
    "",
    "si existe",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "left and right",
    "links und rechts",
    "",
    "sinistra e destra",
    "links en rechts",
    "",
    "gauche et droite",
    "",
    "edestakaisin",
    "",
    "izquierda y derecha",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "min",
    "min",
    "",
    "min",
    "min",
    "",
    "min",
    "",
    "min",
    "min",
    "min",
    "",
    "min",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "min",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "name",
    "Name",
    "",
    "nome",
    "naam",
    "",
    "Nom",
    "",
    "nimest",
    "nazwa",
    "nombre",
    "",
    "namn",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "nimi",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "never",
    "nie",
    "",
    "mai",
    "nooit",
    "",
    "jamais",
    "",
    "ei koskaan",
    "",
    "nunca",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "only if new mail present",
    "nur bei neuer Mail",
    "",
    "solo se presenti nuove email",
    "alleen bij nieuwe mail",
    "",
    "juste lors d'un courriel",
    "",
    "jos uutta postia",
    "",
    "slo si hay nuevo correo",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "   ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "percent",
    "Prozent",
    "",
    "percentuale",
    "procent",
    "",
    "Pourcentage",
    "",
    "prosentti",
    "",
    "porcentaje",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "pixel algo",
    "Pixel-Algorithmus",
    "",
    "algoritmo pixel",
    "pixelalgoritme",
    "",
    "Algorithme pixel",
    "",
    "nytteistys",
    "",
    "Algoritmo pxel",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "ratio algo",
    "Ratio-Algorithmus",
    "",
    "algoritmo medio",
    "algoritmeratio",
    "",
    "Algorithme ratio",
    "",
    "skaalaus",
    "",
    "Algoritmo ratio",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "remaining",
    "restliche",
    "",
    "rimasto",
    "resterend",
    "",
    "restant",
    "",
    "jljell oleva",
    "",
    "restante",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "to the left",
    "nach links",
    "",
    "verso la sinistra",
    "naar links",
    "",
    "vers la gauche",
    "",
    "vasemmalle",
    "",
    "a la izquierda",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "use size.vdr only",
    "nur size.vdr verwenden",
    "",
    "usa solo size.vdr",
    "alleen size.vdr gebruiken",
    "",
    "utiliser seulement size.vdr",
    "",
    "vain jos size.vdr",
    "",
    "slo usar size.vdr",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "  size.vdr",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
  { "zoom image",
    "Zoomen",
    "",
    "ingrandisci immagine",
    "zoomen",
    "",
    "Agrandir image",
    "",
    "zoomaus",
    "",
    "Aumentar imagen",
    "",
    "",
    "",
    "",
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
#if VDRVERSNUM >= 10307
    "",
#endif
#if VDRVERSNUM >= 10313
    "",
#endif
#if VDRVERSNUM >= 10316
    "",
#endif
#if VDRVERSNUM >= 10342
    "",
#endif
#if VDRVERSNUM >= 10502
    "",
#endif
  },
// END I18N - automatically generated by po2i18n.pl
  { NULL }
  };
#endif
