/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_prj_man_h
#define _vdkb_prj_man_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb_prj.h>
#include <vdk/panelbar.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_objinspect.h>
/////////////////////////////////
// visual design part of 
// project manager code is in:
//
// - vdkb_createform.cc
// - vdkb_design.cc
/////////////////////////////////

typedef VDKList<VDKBGuiForm> GFL;
typedef VDKListIterator<VDKBGuiForm> GuiFormListIterator;
/*
this list manages all gui child forms
 */
// code in vdkb_create_form.cc
class GuiFormList : public GFL
{

 public:
  GuiFormList() {}
  ~GuiFormList() {}
  // find child address looking at child name
  VDKBGuiForm* search(VDKString& name);
  void Iconize(); // iconize all gui childs
  void Restore(); // restore them
  void Destroy(); // let them to be closed
  void Close(); // close all childs
};
////////////////////////////////////////////////////

typedef VDKList<VDKBProject> ProjectList;
typedef VDKListIterator<VDKBProject> ProjectListIterator;

////////////////////////////////////////////////////////
// stores active design form
struct GUIActiveChild
{
  VDKBGuiForm *child; // active child address
  VDKString name; // pathfilename extracted from path/file.frm
};
/*
 */

class VDKBCustomTree: public VDKCustomTree
{


 public:
  VDKBCustomTree(VDKForm* owner,
		 int columns = 1,
		 char **titles = NULL,
		 GtkSelectionMode mode = GTK_SELECTION_SINGLE,
		 int tree_column = 0):
    VDKCustomTree(owner,columns,titles,mode,tree_column) {}
  virtual ~VDKBCustomTree() {}
  // substitutes ancestor Find()
  // returns a list of node that contains <key>
  // returned list should be freed by user.
  VDKTreeNodeList* Select(char* key);

};

/////////////////////////////////////////////////////////
class VDKBProjectManager: public VDKForm
{
  VDKBCustomTree *tree;
  VDKPanelbar    *bar;
  VDKToolbar    *toolbar;
  VDKBProject   *project;
  VDKTreeNode   root;
  void LoadTree();
  void RemoveUnit();
  void AddUnitNode(VDKBUnit* unit);
  bool Unique(VDKBUnit*);
  GuiFormList formlist;
  // always updated active child infos
  bool AskSaveForm(char* name);
 public:

  bool ForceToClose;
  bool Changed;
  GUIActiveChild ActiveChild;
  VDKBObjectInspector* objInspector;
  //
  VDKBProjectManager(VDKForm* owner);
  ~VDKBProjectManager();
  void Setup();
  void AddNewProject(char*,int,bool updatelru = true);
  void AddUnit();
  void OnShow(VDKForm*);
  void OpenProject(char* filename = NULL, bool updatelru = true);
  bool Save();
  bool CanClose();
  void ActivateEditor(VDKTreeNode, 
		      bool editable = true, 
		      bool hilite = true);
  void ActivateEditor(char* text, 
		      bool editable = true,
		      bool hilite = true);
  VDKBProject* Project() { return project; }
  VDKBGuiForm* CreateForm(char* name);
  GuiFormList* FormList() { return &formlist; } 
  void WriteGuiFiles(bool ask = true);
  void LoadLastSession(void);
  bool SaveLastSession();
  // received from active gui childs (VDKBGuiForm)
  void ChildResized(VDKBGuiForm* sender, VDKPoint& newsize);
  void ActivateChild(VDKBGuiForm* sender, bool active);
  // replacing on sources
  void ReplaceAllMatches(char* match, 
			 char* replace, 
			 char* textname,
			 int offset = 0, // see vdkb_design.cc
			 bool all = true); // if false replace only first match
  void DefineResponseMethod( char* textname, char* method);
  void DefineFormEventHandler( char* textname, char* handler);
  VDKBCustomTree * Tree() { return tree; }
  bool IsFormChanged(char* name);
  // in vdkb_design.cc
  void OnChildClosing(VDKForm* child);
  // signals
  bool OnSelectRow(VDKObject* obj);
  bool HandleToolbar(VDKObject* obj);
  
  // events
  bool OnReleaseButton(VDKObject* obj, GdkEvent*);
  DECLARE_SIGNAL_MAP(VDKBProjectManager);
  DECLARE_EVENT_LIST(VDKBProjectManager);
  DECLARE_SIGNAL_LIST(VDKBProjectManager);
};
#endif
