/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * February 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "edcompo.h"
#include "testvdk.h"
#include <cstring>
static char buff[512];
extern char* togglech_xpm[] ;
extern char* mini_ofolder_xpm[];
static char* get_extension(char* s);
static char* ToggledSource(const char* file);
///////////////////////////////////////////////////
DEFINE_SIGNAL_LIST(EditorComponent,VDKBox);
DEFINE_SIGNAL_MAP(EditorComponent,VDKBox) 
  ON_SIGNAL(tbar,clicked_signal,OnToolbarClicked)
END_SIGNAL_MAP
///////////////////////////////////////////////////
/*
  response methods
*/
bool
EditorComponent::OnToolbarClicked(VDKObject* sender)
{
  TestvdkForm* ownerform = NULL;
  VDKToolbar* bar = dynamic_cast<VDKToolbar*>(sender);
  int ndx;
  if(bar)
    {
      int btn = bar->ButtonPressed;
      switch(btn)
	{
	case 0: // open test related source
	  if ( (ownerform = dynamic_cast<TestvdkForm*>(Owner())) )
	    ownerform->OnopenMenuActivate(NULL);
	  break;
	case 1: // toggle source<->header
	  ndx = nbook->ActivePage;
	  if( (ndx >= 0) && (ndx < nbook->Pages.size()) )
	    {
	      char* toggledname = ToggledSource(nbook->Pages[ndx]->TabLabel->Caption);
	      if(toggledname)
		{
		  AddPage(toggledname);
		  delete [] toggledname;
		}
	    }
	  break;
	}
    }
  return true;
}

/*
  constructor
*/
EditorComponent::EditorComponent(VDKForm* owner):  VDKBox(owner)
{
  // load tokens for editor word completion
  sprintf(buff,"tokens.db");
  tokenlist = VDKEditor::LoadTokens(buff);
}
/*
  setup interface
 */
void    
EditorComponent::Setup() 
{
  tbar = new VDKToolbar(Owner());
  tbar->AddButton(mini_ofolder_xpm,"Select a test, then open related source"); 
  tbar->AddButton(togglech_xpm,"toggle source <-> header"); 
  tbar->Relief = GTK_RELIEF_NONE;

  nbook = new VDKNotebook(Owner());
  nbook->Scrollable = true;
  Add(tbar,l_justify,false,false,5);
  Add(new VDKSeparator(Owner()),l_justify,false,false,2);
  Add(nbook,5);
}

/*
  add a new page to notebook,
  if a page containing <filename>
  already exists, activate it.
 */
static char file_selection[256] = {'\0'};
void 
EditorComponent::AddPage(const char* filename, const char* member)
{
  if(filename)
    {
      // check if an editor oage on that file is already opened
      int ndx = HasPage(filename);
      // makes a new editor page
      if(ndx < 0)
	{
	  std::strcpy(file_selection, filename);
	  VDKEditor *editor = new VDKEditor(Owner());
	  // editor->Font = new VDKFont(Owner(),"courier Medium 12");
	  // install token list for word completion
	  if(tokenlist)
	    editor->SetTokens(tokenlist);
	  // NOTE:
	  // due to a not yet discovered bug isn't possible
	  // connect here vdkeditor with a realize signal
	  // using dynamic tables (aka SignalConnect())
	  // so we use a lower level gtk+ way.
	  gtk_signal_connect(GTK_OBJECT(editor->WrappedWidget()),"realize",
			     GTK_SIGNAL_FUNC(EditorComponent::OnVDKEditorRealize), 
			     (gpointer) editor); // pass himself here
	  // add a page to notebook
	  nbook->AddPage(editor,filename);
	  // activate this (last) page
	  nbook->ActivePage = (nbook->Pages.size()-1);
	}
      else
	// activates page containing <filename>
	nbook->ActivePage = (ndx);
      if(member)
	ScrollTo(member);
    }
} 
/*
  search into notebook page list
  to see it owns  an editor with <filename>
  Returns ordinal position or -1 if not found.
 */
int EditorComponent::HasPage(const char* filename)
{
  PageListIterator li(nbook->Pages);
  int ndx = 0;
  for(;li;li++,ndx++)
    {
      const char* fn = li.current()->TabLabel->Caption;
      if(!std::strcmp(fn,filename))
	return ndx;
    }
  return -1;
}

/*
  makes a text widget to load a source file into.
  - we can't trap "realize" signal in a safe way using
    dynamics tables on this widget.
  - a possible work around is to use a lower call to 
    gtk_signal_connect() and connect with a static function
    that uses a static buffer on which file selection is stored
    (inelegant but works).
 */
static char* defaultFont = "courier 11";
static char* defaultFontBold = "courier bold 11";
static char* defaultFontItalic = "courier oblique 11";

void
EditorComponent::OnVDKEditorRealize(GtkWidget* , gpointer gp)
{

  VDKEditor* text = reinterpret_cast<VDKEditor*>(gp);
  g_return_if_fail(text != NULL);
  text->Font = new VDKFont(text->Owner(),defaultFont);
  text->NormalBackground = clIvory;
  // text->Foreground = clNavyBlue;
  gtk_source_view_set_auto_indent(GTK_SOURCE_VIEW(text->WrappedWidget()),true);

  // makes some nice colors and fonts
  VDKColor* firebrick = new VDKColor(text,"firebrick");
  VDKColor *navyblue = new VDKColor(text,"navy blue");
  VDKFont* bold = new VDKFont(text,defaultFontBold);
  VDKFont* italic = new VDKFont(text,defaultFontItalic);
  VDKColor* forest_green = new VDKColor(text,"forest green");
  VDKColor* blue = new VDKColor(text,"blue");
  // install syntax and patterns table
  text->InstallSyntaxTable (
			    firebrick,bold, // keywords 
			    firebrick,NULL, // gtk+ names
			    forest_green,NULL, // macros
			    forest_green,bold, // preprocessor directives
			    blue,NULL, // constants
			    navyblue,italic ); // remarks
  if(text && *file_selection)
      text->LoadFromFile(file_selection);

}
/*
  scrolls to member into notebook
  active page
 */
void 
EditorComponent::ScrollTo(const char* member)
{
  int ndx = nbook->ActivePage;
  if(ndx < 0)
    return;
  // downcasts from tabpage child to editor
  VDKEditor* editor = dynamic_cast<VDKEditor*>(nbook->Pages[ndx]->Child());
  if(editor)
    {
      GtkTextBuffer* buffer = GTK_TEXT_BUFFER(editor->Buffer());
      GtkTextIter start;
      GtkTextIter match_start;
      GtkTextIter match_end;
      bool found = false;
      int start_offset = 0;
      // int end_offset = 0;
      int found_start_offset = -1;
      int found_end_offset = -1;
      // goes to the last match of <member>
      do
	{
	  gtk_text_buffer_get_iter_at_offset (buffer,& start, start_offset);
	  found = gtk_text_iter_forward_search (&start,member,GTK_TEXT_SEARCH_TEXT_ONLY,&match_start,&match_end,NULL);
	  if(found)
	    {
	      found_start_offset = gtk_text_iter_get_offset(&match_start);
	      found_end_offset = gtk_text_iter_get_offset(&match_end);
	      start_offset = found_end_offset;
	    }
	  } while(found);
      
	  if(found_start_offset >= 0)
	    {
	      editor->Scroll(start_offset);
	      editor->SelectText(found_start_offset,found_end_offset);
	    }
    }
}
/*
  support functions
 */

// get file extension
char* get_extension(char* s)
{
  int t = std::strlen(s)-1;
  char* p = &s[t];
  for(; (s != p) && (*p != '.') && (*p != '/'); p--) ;
  return ( s!= p)  && (*p != '/') ? p : static_cast<char*>(0);
}

/*
 answers a toggled .cc <-> .h filename
 user should delete answered buffer
*/
char* ToggledSource(const char* file)
{
  char* localbuff = new char[std::strlen(file)+1];
  char* answer = NULL;
  std::strcpy(localbuff,file);
  char* ext = get_extension(localbuff);
  if(ext)
    {
      *ext = '\0';
      ext++;
    }
  else {
    delete [] localbuff;
    return NULL;
  }
  sprintf(buff,"%s.%s",localbuff,!std::strcmp(ext,"cc") ? "h" : "cc");
  delete [] localbuff;
  answer = new char[std::strlen(buff)+1];
  std::strcpy(answer,buff);
  return answer;
}
