/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkfileicondlg.h>
#include <vdk/boxes.h>
/*
 */
void
VDKFileIconDialog::ok_or_cancel_clicked(GtkWidget *widget, gpointer data)
{
  g_return_if_fail(widget != NULL);
  g_return_if_fail(data != NULL);
  VDKFileIconDialog* dlg = reinterpret_cast<VDKFileIconDialog*>(data);
  dlg->Close();
}

/*
 */
VDKFileIconDialog::VDKFileIconDialog(VDKForm* owner,
	VDKString* selection,
	char* title = ""):
    VDKForm(owner,title),
    selection(selection)
{
  // can't destroy to avoid to call destroy handler
    gtk_widget_unrealize(window);
    widget = sigwid = window = gtk_icon_file_selection_new(NULL);
    if(title)
	gtk_window_set_title(GTK_WINDOW(window),title);
    // connect default signals
    SignalsConnect();
    Setup();
}
/*
 */
VDKFileIconDialog::~VDKFileIconDialog()
{
}
/*
 */
void
VDKFileIconDialog::Setup(void)
{
   gtk_signal_connect (GTK_OBJECT (GTK_ICON_FILESEL(window)->ok_button),
                     "clicked",
	   GTK_SIGNAL_FUNC (VDKFileIconDialog::ok_or_cancel_clicked),
			this);
   gtk_signal_connect (GTK_OBJECT (GTK_ICON_FILESEL(window)->cancel_button),
                     "clicked",
	   GTK_SIGNAL_FUNC (VDKFileIconDialog::ok_or_cancel_clicked),
			this);
}
/*
 */
bool
VDKFileIconDialog::CanClose()
{
    gchar *path;
    gchar *file;
    GtkIconFileSel *fsel = GTK_ICON_FILESEL(widget);
    path = gtk_file_list_get_path(GTK_FILE_LIST(fsel->file_list));
    file = gtk_file_list_get_filename(GTK_FILE_LIST(fsel->file_list));
    if(path && file)
	{
	    *selection = path;
	    *selection += file;
	}
    return true;
}
