/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6
 * Revision 2
 * June 1999
 * ===========================
 * VDKColorBrowser 
 * ===========================
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */                
                
#include <vdk/vdkcolorbrowser.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
static char buff[256];
////////////////////////////////////////////////////////////
//
// as in vdktypes.h
//
////////////////////////////////////////////////////////////
#define MAX_COLORS 123
static 
VDKDefaultColors  vdk_colors[] =  
{
{"clAquamarine", 127, 255, 212},
{"clAliceBlue",240, 248, 255},
{"clAntiqueWhite",250, 235, 215},
{"clAirBlue",89, 186, 231},
{"clBeige",245, 245, 220},
{"clBlack",0, 0, 0},
{"clBlanchedAlmond",255, 235, 205},
{"clBlue",0, 0, 255},
{"clBlueViolet",138, 43, 226},
{"clBrown",165, 42, 42},
{"clBurkyWood",222, 184, 135},
{"clCadetBlue", 95, 158, 160},
{"clChartreuse",127, 255, 0},
{"clChocolate",210, 105, 30},
{"clCoral",255, 127, 80},
{"clCyan", 0, 255, 255},
{"clCornflowerBlue",100, 149, 237},
{"clDarkKhaki",89, 183, 107},
{"clDarkGoldenrod",184, 134, 11},
{"clDarkGreen", 0, 100, 0},
{"clDarkOliveGreen", 85, 107, 47},
{"clDarkOrange",255, 140, 0},
{"clDarkOrchid",153, 50, 204},
{"clDarkSalmon",233, 150, 122},
{"clDarkSeaGreen", 143, 188, 143},
{"clDarkSlateBlue", 72, 61, 139},
{"clDarkSlateGray",47, 79, 79},
{"clDarkTurquoise", 0, 206, 209},
{"clDarkViolet",148, 0, 211},
{"clDeepPink",255, 20, 147},
{"clDeepSkyBlue",0, 191, 255},
{"clDimGrey",105, 105, 105},
{"clDodgerBlue",30, 114, 255},
{"clFireBrick",178, 34, 34},
{"clFloralWhite",255, 250, 240},
{"clForestGreen",34, 139, 34},
{"clGhostWhite",248, 248, 255},
{"clGold",255, 215, 0},
{"clGoldenrod",218, 165, 32},
{"clGreen", 0, 255, 0},
{"clGreenYellow", 173, 255, 47},
{"clGrey",190, 190, 190},
{"clIndianRed",205, 92, 92},
{"clIvory",255, 255, 223},
{"clHotPink",255, 105, 180},
{"clLavenderBlush",255, 240, 245},
{"clLawnGreen", 124, 252, 0},
{"clLemonChiffon",255, 250, 205},
{"clLightBlue", 173, 216, 230},
{"clLightCoral",240, 128, 128},
{"clLightCyan", 224, 255, 255},
{"clLightGoldenrod",238, 221, 130},
{"clLightGoldenrodYellow",250, 250, 210},
{"clLightGrey",211, 211, 211},
{"clLightPink",255, 182, 193},
{"clLightSalmon",255, 160, 122},
{"clLightSeaGreen", 32, 178, 170},
{"clLightSlateBlue", 132, 112, 255},
{"clLightSlateGrey",119, 136, 153},
{"clLightSkyBlue",135, 206, 250},
{"clLightSteelBlue",176, 196, 222},
{"clLightYellow",255, 255, 224},
{"clLimeGreen", 50, 205, 50},
{"clKhaki",40, 230, 140},
{"clMagenta",255, 0, 255},
{"clMaroon",146, 89, 28},
{"clMediumAquamarine",102, 205, 170},
{"clMediumBlue", 0, 0, 205},
{"clMediumOrchid",186, 85, 211},
{"clMediumPurple",147, 112, 219},
{"clMediumSeaGreen", 60, 179, 113},
{"clMediumSlateBLue", 123, 104, 238},
{"clMediumSpringGreen", 0, 250, 154},
{"clMediumVioletRed",99, 21, 133},
{"clMidnightBlue",25, 25, 112}, 
{"clMintCream",245, 255, 250},
{"clMintyRose",255, 228, 225},
{"clNavajoWhite",255, 222, 173},
{"clNavyBlue", 0, 0, 128},
{"clOldLace",253, 245, 230},
{"clOliveDrab",107, 142, 35},
{"clOrange",255, 165, 0},
{"clOrangeRed",255, 69, 0},
{"clOrchid",218, 112, 214},
{"clPaleGoldenrod",238, 232, 170},
{"clPaleGreen", 152, 251, 152},
{"clPaleTurquoise", 175, 238, 238},
{"clPaleVioletRed",219, 112, 147},
{"clPapayaWhip",255, 239, 213},
{"clPeachPuff",255, 218, 185},
{"clPeru",205, 133, 63},
{"clPink",255, 192, 203},
{"clPurple",210, 105, 30},
{"clPlum",221, 160, 221},
{"clPowderBlue",176, 224, 230},
{"clRed",255, 0, 0},
{"clRosyBrown",188, 143, 143},
{"clRoyalBlue", 65, 105, 225},
{"clSaddleBrown",139, 69, 19},
{"clSalmon",250, 128, 114},
{"clSandyBrown",244, 164, 96},
{"clSeaGreen", 46, 139, 87},
{"clSiena",160, 82, 45},
{"clSlateBlue", 106, 90, 205},
{"clSlateGrey",112, 128, 144},
{"clSnow",255, 250, 250},
{"clSnow1",255, 250, 250},
{"clSnow2",238, 233, 233},
{"clSnow3",205, 201, 201},
{"clSnow4",139, 137, 137},
{"clSpringGreen", 0, 255, 127},
{"clSteelblue", 70, 130, 180},
{"clSkyBlue", 135, 206, 235},
{"clTan",210, 180, 140},
{"clTomato",255, 99, 71},
{"clTurquoise", 64, 224, 208},
{"clTwistle",216, 191, 216},
{"clViolet",238, 130, 238},
{"clVioletRed",208, 32, 144},
{"clWheat",245, 222, 179},
{"clWhite",255, 255, 255 },
{"clWhiteSmoke",245, 245, 245},
{"clYellow",255, 255, 0},
{"clYellowGreen",154, 205, 50},
{(char*) 0,-1,-1,-1}
};


DEFINE_SIGNAL_MAP(VDKColorBrowser,VDKForm)
  ON_SIGNAL(ok,clicked_signal,OkClicked),
  ON_SIGNAL(cancel,clicked_signal,CancelClicked),
  ON_SIGNAL(loadvdk,clicked_signal,LoadVdkClicked),
  ON_SIGNAL(loadrgb,clicked_signal,LoadRgbClicked),
  ON_SIGNAL(grid,grid_select_cell,OnSelectCell)
END_SIGNAL_MAP

bool
VDKColorBrowser::OkClicked(VDKObject*)
{
VDKGridCell* cell = grid->ActiveCell;
if(cell && parms)
  {
    // means rgb database in rgb.txt was loaded
    if(colors.size() > 0)
      {
	parms->rgb = VDKRgb(colors[cell->Row()].red,
			    colors[cell->Row()].green,
			    colors[cell->Row()].blue);
	strcpy(parms->colorname,
	       (char*)colors[cell->Row()].name);
      }
    else
      {
	parms->rgb = VDKRgb(vdk_colors[cell->Row()].red,
			    vdk_colors[cell->Row()].green,
			    vdk_colors[cell->Row()].blue);
	strcpy(parms->colorname,vdk_colors[cell->Row()].colorname+2);
	fflush(stdout);
      }
  }
Close();
return true;
}
/*
 */
bool
VDKColorBrowser::OnSelectCell(VDKObject*)
{
  VDKGridCell* prevcell = grid->PreviousActiveCell;
  VDKGridCell* cell = grid->ActiveCell;
  if(prevcell)
    prevcell->SetBorder(0,0,0);
  if(cell)
    cell->SetBorder(GTK_SHEET_LEFT_BORDER| 
		    GTK_SHEET_RIGHT_BORDER| 
		    GTK_SHEET_TOP_BORDER | 
		    GTK_SHEET_BOTTOM_BORDER,
		    1,0);
return true;
}

bool
VDKColorBrowser::CancelClicked(VDKObject*)
{
Close();
return true;
}

bool
VDKColorBrowser::LoadVdkClicked(VDKObject*)
{
LoadVDKGrid();
return true;
}

bool
VDKColorBrowser::LoadRgbClicked(VDKObject*)
{
LoadRGB();
return true;
}
/*
 */
void 
VDKColorBrowser::OnShow(VDKForm*)
{
LoadVDKGrid();
}
/*
load grid from defaults
 */
void
VDKColorBrowser::LoadVDKGrid()
{
  int t = 0;
  GtkWidget* p;
  gtk_sheet_freeze(GTK_SHEET(grid->Widget()));
  // flush colors list
  colors.flush();
  if(grid->MaxRows > 0)
    grid->Flush();
  for(t=0; vdk_colors[t].colorname;t++);
  grid->AddBlankRows(t-1);
  for(t=0; vdk_colors[t].colorname;t++)
    {
      VDKRgb rgb(vdk_colors[t].red,
		 vdk_colors[t].green,
		 vdk_colors[t].blue); 
      /*
	=======================================
	Mario: at 06.27.1999
	=======================================
	for some obscure reason this call avoid
	a corrupted pointer. I suspect is a gift
	of new egcs-2.91.66 19990314 
	(egcs-1.1.2 release)...
	=======================================
      */
      p = grid->Widget();

      grid->Cell(t,0)->SetBackground(rgb);
      grid->Cell(t,1)->Text = vdk_colors[t].colorname;
      sprintf(buff,"%3d",vdk_colors[t].red);
      grid->Cell(t,2)->Text = buff; 
            sprintf(buff,"%3d",vdk_colors[t].green);
      grid->Cell(t,3)->Text = buff; 
      sprintf(buff,"%3d",vdk_colors[t].blue);
      grid->Cell(t,4)->Text = buff; 
    }
  gtk_sheet_thaw(GTK_SHEET(grid->Widget()));
  statbar->Push("VDK default colors");
}

void
VDKColorBrowser::LoadRGB()
{
  int t = 0;
  colors.flush();
  if(!ReadRGB())
    {
      sprintf(buff,"%s neither %s found",RGBTEXT1,RGBTEXT2);
      Application()->MessageBox("VDK color browser",buff,MB_OK);
      return;
    }
  gtk_sheet_freeze(GTK_SHEET(grid->Widget()));
  if(grid->MaxRows > 0)
    grid->Flush();
  grid->AddBlankRows(colors.size()-1);
  RGBColorListIterator li(colors);
  for(;li;li++,t++)
    {
      RGBColor color = li.current();
      VDKRgb rgb(color.red,
		 color.green,
		 color.blue);
      /*
      GdkRectangle area;
      gtk_sheet_get_cell_info (GTK_SHEET(grid->Widget()),
                         t,
                         0,
                         &area);
      VDKCanvas* canvas = new VDKCanvas(this,
					(area.width*4)/5,
					(area.height*4)/5);
      canvas->NormalBackground = rgb;
      grid->Cell(t,0)->Attach(canvas,0.5,0.5);
      canvas->Clear();
      gtk_widget_draw(canvas->Widget(),NULL);
      */
      grid->Cell(t,0)->SetBackground(rgb);
      grid->Cell(t,1)->Text = (char*) color.name;
      sprintf(buff,"%3d",color.red);
      grid->Cell(t,2)->Text = buff; 
            sprintf(buff,"%3d",color.green);
      grid->Cell(t,3)->Text = buff; 
      sprintf(buff,"%3d",color.blue);
      grid->Cell(t,4)->Text = buff; 
    }
  gtk_sheet_thaw(GTK_SHEET(grid->Widget()));
}

void 
VDKColorBrowser::Setup()
{
  int t;
  sprintf(buff,"%s",
	  parms && parms->title ? parms->title :
	  "VDK color browser");
  Title = VDKString(buff);
  // count how many rows
  scrolled = new VDKScrolled(this);
  for(t=0; vdk_colors[t].colorname;t++)  ;
  grid = new VDKGrid(this,0,MAX_COL);
  scrolled->AddWithoutViewport(grid,l_justify,false,false,false);
  Add(scrolled);
  VDKFrame* frame = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  sprintf(buff,"%s",
	  parms && parms->ok ? parms->ok :
	  "Ok");
  ok = new VDKCustomButton(this,buff);
  frame->Add(ok);
  sprintf(buff,"%s",
	  parms && parms->cancel ? parms->cancel :
	  "Cancel");
  cancel = new VDKCustomButton(this,buff);
  frame->Add(cancel);
  sprintf(buff,"%s",
	  parms && parms->loadvdk ? parms->loadvdk :
	  "VDK default colors");
  loadvdk = new VDKCustomButton(this,buff);
  frame->Add(loadvdk);
  sprintf(buff,"%s",
	  parms && parms->loadrgb ? parms->loadrgb :
	  "Load rgb.txt");
  loadrgb = new VDKCustomButton(this,buff);
  frame->Add(loadrgb);
  bool enabled = ((access(RGBTEXT1,F_OK) == 0) || 
		  (access(RGBTEXT2,F_OK) == 0));
  loadrgb->Enabled = enabled;
  Add(frame,l_justify,false,false,3);
  statbar = new VDKStatusbar(this);
  Add(statbar,l_justify,false,false,false);
  InitGrid();
  // LoadVDKGrid();
}

/*
 */ 
const int FIXED_WIDTH = 150;
void 
VDKColorBrowser::InitGrid()
{
  int i;
  char *titles[] =
  {
    "Color","Name","R","G","B" 
  };
  int width = 0;
  for(i = 0; i < MAX_COL; i++)
    {
      grid->Column(i)->Title = titles[i];
      grid->Column(i)->Width = i == 1 ? FIXED_WIDTH : 50;
      width += grid->Column(i)->Width;
    }
  grid->Usize = VDKPoint(width,300);
  grid->RowTitleVisible = false;
 
}

bool
VDKColorBrowser::ReadRGB()
{
int red,green,blue;
char colorname[64];
FILE* fp = NULL;
if(!access(RGBTEXT1,F_OK))
  {
    fp = fopen(RGBTEXT1,"r");
    statbar->Push(RGBTEXT1);
  }
else if(!access(RGBTEXT2,F_OK))
  {
    fp = fopen(RGBTEXT2,"r");
    statbar->Push(RGBTEXT2);
  }
if(!fp)
  return false;
// jump first line
fgets(buff,sizeof(buff),fp);
colors.flush();
while(fgets(buff,sizeof(buff),fp))
  {
    char* p;
    buff[strlen(buff)-1] = '\0';
    sscanf(buff,"%d %d %d",&red,&green,&blue);
    // find first alpha
    for(p = buff; *p && (!isalpha(*p)); p++);
    if(*p)
      strcpy(colorname,p);
    else
      strcpy(colorname,"black");
    RGBColor color(colorname,red,green,blue);
    colors.add(color);
  }
fclose(fp);
return true;
}





