/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1999, Salmaso Raffaele
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/label_togglebutton.h"
#include "vdk/vdkfont.h"

VDKLabelToggleButton::VDKLabelToggleButton(VDKForm* owner,
                               char* label,
                               char* tip) :
    VDKToggleButton(owner,tip),
    Caption ("Caption", this, label, &VDKLabelToggleButton::SetCaption, &VDKLabelToggleButton::GetCaption),
    CaptionWrap ("CaptionWrap", this, true, &VDKLabelToggleButton::SetCaptionWrap, &VDKLabelToggleButton::GetCaptionWrap)
{
    lbl  = gtk_label_new(label);
    gtk_label_set_justify (GTK_LABEL(lbl),GTK_JUSTIFY_CENTER);
    gtk_misc_set_alignment (GTK_MISC(lbl), .5, .5);
    gtk_widget_show(lbl);
    gtk_container_add(GTK_CONTAINER(widget),lbl);
}
/*
VDKLabelToggleButton::~VDKLabelToggleButton()
{
}

void 
VDKLabelToggleButton::SetForeground(VDKRgb color, GtkStateType state)
{
    _setForeground_(lbl,color.red,color.green,color.blue, state);
} 

void 
VDKLabelToggleButton::SetFont(VDKFont* font)
{
    _setFont_(lbl,font);
}

void VDKLabelToggleButton::SetCaption(char* str)
{
    gtk_label_set_text (GTK_LABEL(lbl),str);
}

char* VDKLabelToggleButton::GetCaption () {
    return GTK_LABEL (lbl)->label;
}

void VDKLabelToggleButton::SetCaptionWrap (bool flag) {

    gtk_label_set_line_wrap (GTK_LABEL (lbl), flag);
}

bool VDKLabelToggleButton::GetCaptionWrap () {
    return GTK_LABEL (lbl)->wrap;
}
*/
