/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/label.h"

VDKLabel::VDKLabel(VDKForm* owner, char* label, GtkJustification jtype):
  VDKObject(owner),
  Justify("Justify",this,jtype,&VDKLabel::SetJustify),
  Caption ("Caption", this, label, &VDKLabel::SetCaption, 
	   &VDKLabel::GetCaption),
  CaptionWrap ("CaptionWrap", this, false, &VDKLabel::SetCaptionWrap, 
	       &VDKLabel::GetCaptionWrap)
{
double x = 0.0,y = .5;
widget = gtk_label_new(label);
gtk_label_set_justify (GTK_LABEL(widget),jtype);
switch(jtype)
  {
  case GTK_JUSTIFY_LEFT:
    x = 0;
    break;
  case GTK_JUSTIFY_RIGHT:
    x = 1;
    break;
  case GTK_JUSTIFY_CENTER:
    x = .5;
    break;
  case GTK_JUSTIFY_FILL:
    break;
  }
gtk_misc_set_alignment (GTK_MISC(widget), x, y);
ConnectDefaultSignals();
}
/*
 */
void VDKLabel::SetJustify(GtkJustification jtype)
{
  double x = 0.0,y = .5;
  gtk_label_set_justify (GTK_LABEL(widget),jtype);
  switch(jtype)
    {
    case GTK_JUSTIFY_LEFT:
      x = 0;
      break;
    case GTK_JUSTIFY_RIGHT:
      x = 1;
      break;
    case GTK_JUSTIFY_CENTER:
      x = .5;
      break;
    case GTK_JUSTIFY_FILL:
      break;
    }
  gtk_misc_set_alignment (GTK_MISC(widget), x, y);
}
/*
 */
VDKLabel::~VDKLabel()
{
}

void VDKLabel::SetCaption(char* str)
{
      gtk_label_set_text (GTK_LABEL(widget),str);
}

char* VDKLabel::GetCaption () {
    return GTK_LABEL (widget)->label;
}

void VDKLabel::SetCaptionWrap (bool flag) {
    gtk_label_set_line_wrap (GTK_LABEL (widget), flag);
}

bool VDKLabel::GetCaptionWrap () {
    return GTK_LABEL (widget)->wrap;
}
