/* -*- c++ -*- */
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _sigc_addon_h_
#define _sigc_addon_h_
#ifdef USE_SIGCPLUSPLUS
#include <sigc++/signal_system.h>

#ifdef SIGC_CXX_NAMESPACES // currently code depends on this!
using namespace std;
using namespace SigC;
#endif

/*!
  \class VDKSignal0
  \brief makes a signal of type: Signal2<Ret, VDKObject*, P1>

   This template basically makes a signal of type:
             Signal2<Ret, VDKObject*, P1>
    what also accepts slots of type:
             Slot1<Ret,P1>
    for VDKSignal1<Ret, P1>.
    Attention: To emit a signal like this you have to call
    'emit(VDKObject* ob, P1)' , that means 'emit(P1)' is not available.
    This must be as we must handle all subscribed signal_receivers equal.
    This nameing convention also applies on the other classes, so
    VDKSignal0<Ret> wraps Signal0<Ret> and Signal1<Ret, VDKObject*>.
 
    For the moment you can not connect two VDKSignal#'s dircetly, as
    VDKSignal#.slot() is not availbale.
*/
template<class Ret>
class VDKSignal0 : public SigC::Signal1<Ret, VDKObject*>,
		   public SigC::Signal0<Ret>
{
private:
/*     Ret emit(){}; // Don't use!!! */
/*     Ret operator()(){} // also */
public:
     Connection connect(const Slot0<Ret> &sl)
     {return Signal0<Ret>::connect(sl);}
     Connection connect(const Slot1<Ret, VDKObject*> &sl)
     {return Signal1<Ret,VDKObject*>::connect(sl);}

     Ret emit(VDKObject* obj)
     {Signal0<Ret>::emit();
     return Signal1<Ret,VDKObject*>::emit(obj);}

     Ret operator()(VDKObject* obj)
     {Signal0<Ret>::emit();
     return Signal1<Ret,VDKObject*>::emit(obj);}

     bool empty() const
     {return (Signal1<Ret, VDKObject*>::empty() &&
	      Signal0<Ret>::empty());}
};

template<class Ret, class P1>
class 
VDKSignal1 : public SigC::Signal2<Ret, VDKObject*, P1>,
	     public SigC::Signal1<Ret, P1>
{
private:
     Ret emit(P1){}; // Don't use!!!
     Ret operator()(P1){} // also 
public:
     Connection connect(const Slot1<Ret, P1> &sl)
     {return Signal1<Ret,P1>::connect(sl);}
     Connection connect(const Slot2<Ret, VDKObject*, P1> &sl)
     {return Signal2<Ret,VDKObject*,P1>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1)
     {Signal1<Ret,P1>::emit(par1);
     return Signal2<Ret,VDKObject*,P1>::emit(obj, par1);}

     Ret operator()(VDKObject* obj, P1 par1)
     {Signal1<Ret,P1>::emit(par1);
     return Signal2<Ret,VDKObject*,P1>::emit(obj, par1);}

     bool empty() const
     {return (Signal2<Ret, VDKObject*, P1>::empty() &&
	      Signal1<Ret,P1>::empty());}
};

template<class Ret, class P1, class P2>
class 
VDKSignal2 : public SigC::Signal3<Ret, VDKObject*, P1, P2>,
	     public SigC::Signal2<Ret, P1, P2>
{
private:
     Ret emit(P1, P2){}; // Don't use!!!
     Ret operator()(P1, P2){} // also
public:
     Connection connect(const Slot2<Ret, P1, P2> &sl)
     {return Signal2<Ret, P1, P2>::connect(sl);}
     Connection connect(const Slot3<Ret, VDKObject*, P1, P2> &sl)
     {return Signal3<Ret,VDKObject*,P1, P2>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1, P2 par2)
     {Signal2<Ret, P1, P2>::emit(par1,par2);
     return Signal3<Ret,VDKObject*,P1,P2>::emit(obj, par1, par2);}

     Ret operator()(VDKObject* obj, P1 par1, P2 par2)
     {Signal2<Ret, P1, P2>::emit(par1, par2);
     return Signal3<Ret,VDKObject*,P1, P2>::emit(obj, par1, par2);}

     bool empty() const
     {return (Signal3<Ret, VDKObject*, P1, P2>::empty() &&
	      Signal2<Ret, P1, P2>::empty());}
};

template<class Ret, class P1, class P2, class P3>
class 
VDKSignal3 : public SigC::Signal4<Ret, VDKObject*, P1, P2, P3>,
	     public SigC::Signal3<Ret, P1, P2, P3>
{
private:
     Ret emit(P1, P2, P3){}; // Don't use!!!
     Ret operator()(P1, P2, P3){} // also
public:
     Connection connect(const Slot3<Ret, P1, P2, P3> &sl)
     {return Signal3<Ret, P1, P2, P3>::connect(sl);}
     Connection connect(const Slot4<Ret, VDKObject*, P1, P2, P3> &sl)
     {return Signal4<Ret,VDKObject*,P1, P2, P3>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1, P2 par2, P3 par3)
     {Signal3<Ret, P1, P2, P3>::emit(par1,par2.par3);
     return Signal4<Ret,VDKObject*,P1,P2,P3>::emit(obj,par1,par2,par3);}

     Ret operator()(VDKObject* obj, P1 par1, P2 par2, P3 par3)
     {Signal3<Ret, P1, P2, P3>::emit(par1, par2, par3);
     return Signal4<Ret,VDKObject*,P1, P2, P3>::emit(obj,par1,par2,par3);}

     bool empty() const
     {return (Signal4<Ret, VDKObject*, P1, P2, P3>::empty() &&
	      Signal3<Ret, P1, P2, P3>::empty());
     }
};

/* not needed at the moment
template<class Ret>
class VDKSmartSignal0 : public SigC::Signal0<Ret>,
                        public SigC::Signal1<Ret, VDKObject*>
{
public:
     Signal1<void, bool> OnConnect;
     Connection connect(const Slot0<Ret> &sl);
     Connection connect(const Slot1<Ret, VDKObject*> &sl);
     Ret operator()(VDKObject*);
     Ret emit(VDKObject*);
};

template<class Ret, class P1>
class VDKSmartSignal1 : public SigC::Signal1<Ret, P1>,
                        public SigC::Signal2<Ret, VDKObject*, P1>
{
public:
     Signal1<void, bool> OnConnect;
     Connection connect(const Slot1<Ret,P1>& sl);
     Connection connect(const Slot2<Ret, VDKObject*, P1>& sl);
     Ret operator()(VDKObject*, P1);
     Ret emit(VDKObject*, P1);
};

// Implementation for Smart-Signals is to big to be inlined
// move this to a better place so that it is compiled only once
template<class Ret>
Connection
VDKSmartSignal0<Ret>::connect(const Slot0<Ret> &sl)
{
     bool not_connected=empty();
     Connection c=Signal0<Ret>::connect(sl);
     if(not_connected)
	  OnConnect(true);
     return c;
}

template<class Ret>
Connection
VDKSmartSignal0<Ret>::connect(const Slot1<Ret, VDKObject*> &sl)
{
     bool not_connected=empty();
     Connection c=Signal1<Ret, VDKObject*>::connect(sl);
     if(not_connected)
	  OnConnect(true);
     return c;
}

template<class Ret>
Ret
VDKSmartSignal0<Ret>::operator()(VDKObject* obj)
{
     Signal0<Ret>::emit();
     return Signal1<Ret,VDKObject*>::emit(obj);
}

template<class Ret>
Ret
VDKSmartSignal0<Ret>::emit(VDKObject* obj)
{
     Signal0<Ret>::emit();
     return Signal1<Ret, VDKObject*>::emit(obj);
}

template<class Ret, class P1>
Connection
VDKSmartSignal1<Ret, P1>::connect(const Slot2<Ret, VDKObject*, P1> &sl)
{
     bool not_connected=emtpy();
     Connection c=Signal2<Ret, VDKObject*, P1>::connect(sl);
     if(not_connected)
	  OnConnect(true);
     return c;
}

template<class Ret, class P1>
Connection
VDKSmartSignal1<Ret, P1>::connect(const Slot1<Ret, P1> &sl)
{
     bool not_connected=empty();
     Connection c=Signal1<Ret,P1>::connect(sl);
     if(not_connected)
	  OnConnect(true);
     return c;
}

template<class Ret, class P1>
Ret
VDKSmartSignal1<Ret,P1>::operator()(VDKObject* o, P1 p1)
{
     Signal1<Ret,P1>::emit(p1);
     return Signal2<Ret, VDKObject*, P1>::emit(p1);
}

template<class Ret, class P1>
Ret
VDKSmartSignal1<Ret,P1>::emit(VDKObject* o, P1 p1)
{
     Signal1<Ret,P1>::emit(p1);
     return Signal2<Ret, VDKObject*, P1>::emit(p1);
}
*/
#endif /* USE_SIGCPLUSPLUS */
#endif /* !_sigc_addon_h_ */
