/***************************************************************************
                          dchubprofile.cpp  -  description
                             -------------------
    begin                : Fre Sep 20 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qinputdialog.h>
#include <qregexp.h>
#include <qmessagebox.h>

#include <dcconfig.h>

#include <dclib/core/cstringlist.h>

#include "dchubprofile.h"

/** */
DCHubProfile::DCHubProfile(QWidget *parent, const char *name ) : DCDialogHubProfile(parent,name)
{
	InitDocument();
}

/** */
DCHubProfile::~DCHubProfile()
{
}

/** */
void DCHubProfile::InitDocument()
{
	CStringList list;
	DCConfigHubProfile * pConfigHubProfile = 0;

	ComboBox_PROFILE->clear();

 	g_pConfig->GetHubProfileList( &list );

	while ( list.Next((CObject*&)pConfigHubProfile) )
	{
		if ( pConfigHubProfile->m_sName != "" )
		{
			ComboBox_PROFILE->insertItem(pConfigHubProfile->m_sName.Data());
		}
	}

	connect( PushButton_OK, SIGNAL(clicked()), this, SLOT(slotClickedOK()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
	connect( ComboBox_PROFILE, SIGNAL(activated( const QString & )), this, SLOT(slotProfileActiveted( const QString & )) );

	slotProfileActiveted("");
}

/** */
void DCHubProfile::SaveProfile( QString profilename )
{
	DCConfigHubProfile pConfigHubProfile;

	if ( profilename != "" )
	{
		pConfigHubProfile.m_sName        = profilename.ascii();
		pConfigHubProfile.m_sNick        = LineEdit_NICK->text().replace( QRegExp(" "), "\xa0").ascii();
		pConfigHubProfile.m_sPassword    = LineEdit_PASSWORD->text().ascii();
		pConfigHubProfile.m_bAutoConnect = CheckBox_AUTOCONNECT->isChecked();
		pConfigHubProfile.m_bTag         = CheckBox_DESCRIPTIONTAG->isChecked();
		pConfigHubProfile.m_sComment     = LineEdit_PROF_DESCRIPTION->text().ascii();
		pConfigHubProfile.m_bComment     = CheckBox_DESCRIPTION->isChecked();
		pConfigHubProfile.m_sEMail       = LineEdit_EMAIL->text().ascii();
		pConfigHubProfile.m_bEMail       = CheckBox_EMAIL->isChecked();
		pConfigHubProfile.m_bSSL         = CheckBox_SSL->isChecked();
		
		g_pConfig->AddHubProfile( &pConfigHubProfile );
	}

	g_pConfig->SaveHubProfile();
}

/** */
void DCHubProfile::slotClickedOK()
{
	SaveProfile(ComboBox_PROFILE->currentText());

	accept();
}

/** */
void DCHubProfile::slotProfileActiveted( const QString & /*s*/ )
{
	DCConfigHubProfile pConfigHubProfile;

	// save old profile
	if ( m_sOldName != "" )
	{
		// check for changes
		if ( g_pConfig->GetHubProfile( m_sOldName.ascii(), &pConfigHubProfile ) == TRUE )
		{
			if ( (pConfigHubProfile.m_sNick != LineEdit_NICK->text().replace( QRegExp(" "), "\xa0").ascii()) ||
			     (pConfigHubProfile.m_sPassword != LineEdit_PASSWORD->text().ascii()) ||
			     (pConfigHubProfile.m_bAutoConnect != CheckBox_AUTOCONNECT->isChecked()) ||
			     (pConfigHubProfile.m_bTag != CheckBox_DESCRIPTIONTAG->isChecked()) ||
			     (pConfigHubProfile.m_sEMail != LineEdit_EMAIL->text().ascii()) ||
			     (pConfigHubProfile.m_sComment != LineEdit_PROF_DESCRIPTION->text().ascii()) ||
			     (pConfigHubProfile.m_bComment != CheckBox_DESCRIPTION->isChecked()) ||
			     (pConfigHubProfile.m_bEMail != CheckBox_EMAIL->isChecked()) ||
			     (pConfigHubProfile.m_bSSL   != CheckBox_SSL->isChecked()) )
			{
				// ask user to save changes
				switch( QMessageBox::warning( this, tr("Save profile"),
	        			tr("Do you want to save your changes?"),
	        			tr("Save"),
        				tr("Cancel"), 0, 0, 1 ) )
				{
			    		case 1: // The user clicked the Quit or pressed Escape
        					break;
					default:
						SaveProfile(m_sOldName);
						break;
				}
			}
		}
	}

	// set new profile name
	m_sOldName = ComboBox_PROFILE->currentText();

	// reset values
	LineEdit_NICK->setText("");
	LineEdit_PASSWORD->setText("");
	CheckBox_AUTOCONNECT->setChecked(FALSE);
	CheckBox_DESCRIPTIONTAG->setChecked(FALSE);
	LineEdit_EMAIL->setText("");
	LineEdit_PROF_DESCRIPTION->setText("");
	
	if ( m_sOldName != "" )
	{
		if ( g_pConfig->GetHubProfile( m_sOldName.ascii(), &pConfigHubProfile ) == TRUE )
		{
			LineEdit_NICK->setText( pConfigHubProfile.m_sNick.Data() );
			LineEdit_PASSWORD->setText( pConfigHubProfile.m_sPassword.Data() );
			CheckBox_AUTOCONNECT->setChecked( pConfigHubProfile.m_bAutoConnect );
			CheckBox_DESCRIPTIONTAG->setChecked( pConfigHubProfile.m_bTag );
			LineEdit_EMAIL->setText( pConfigHubProfile.m_sEMail.Data() );
			CheckBox_EMAIL->setChecked( pConfigHubProfile.m_bEMail );
			LineEdit_PROF_DESCRIPTION->setText( pConfigHubProfile.m_sComment.Data() );
			CheckBox_DESCRIPTION->setChecked( pConfigHubProfile.m_bComment );
			CheckBox_SSL->setChecked(pConfigHubProfile.m_bSSL);
		}
	}
}
