/* vtgprojectmanager.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgprojectmanager.vala, do not modify */

/*
 *  vtgprojectmanager.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vbf.h>
#include <gtk/gtk.h>
#include <afrodite.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_MANAGER_UI (vtg_project_manager_ui_get_type ())
#define VTG_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUi))
#define VTG_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))
#define VTG_IS_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_IS_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_PROJECT_MANAGER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))

typedef struct _VtgProjectManagerUi VtgProjectManagerUi;
typedef struct _VtgProjectManagerUiClass VtgProjectManagerUiClass;

#define VTG_TYPE_PROJECT_BUILDER (vtg_project_builder_get_type ())
#define VTG_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilder))
#define VTG_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))
#define VTG_IS_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_BUILDER))
#define VTG_IS_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_BUILDER))
#define VTG_PROJECT_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))

typedef struct _VtgProjectBuilder VtgProjectBuilder;
typedef struct _VtgProjectBuilderClass VtgProjectBuilderClass;

#define VTG_TYPE_BUILD_LOG_VIEW (vtg_build_log_view_get_type ())
#define VTG_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogView))
#define VTG_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))
#define VTG_IS_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_IS_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_BUILD_LOG_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))

typedef struct _VtgBuildLogView VtgBuildLogView;
typedef struct _VtgBuildLogViewClass VtgBuildLogViewClass;

#define VTG_VCS_BACKENDS_TYPE_VCS_BASE (vtg_vcs_backends_vcs_base_get_type ())
#define VTG_VCS_BACKENDS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBase))
#define VTG_VCS_BACKENDS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))
#define VTG_VCS_BACKENDS_IS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_IS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_VCS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))

typedef struct _VtgVcsBackendsVcsBase VtgVcsBackendsVcsBase;
typedef struct _VtgVcsBackendsVcsBaseClass VtgVcsBackendsVcsBaseClass;

#define VTG_VCS_BACKENDS_TYPE_GIT (vtg_vcs_backends_git_get_type ())
#define VTG_VCS_BACKENDS_GIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGit))
#define VTG_VCS_BACKENDS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))
#define VTG_VCS_BACKENDS_IS_GIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_IS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_GIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))

typedef struct _VtgVcsBackendsGit VtgVcsBackendsGit;
typedef struct _VtgVcsBackendsGitClass VtgVcsBackendsGitClass;

#define VTG_VCS_BACKENDS_TYPE_BZR (vtg_vcs_backends_bzr_get_type ())
#define VTG_VCS_BACKENDS_BZR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzr))
#define VTG_VCS_BACKENDS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))
#define VTG_VCS_BACKENDS_IS_BZR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_IS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_BZR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))

typedef struct _VtgVcsBackendsBzr VtgVcsBackendsBzr;
typedef struct _VtgVcsBackendsBzrClass VtgVcsBackendsBzrClass;

#define VTG_VCS_BACKENDS_TYPE_SVN (vtg_vcs_backends_svn_get_type ())
#define VTG_VCS_BACKENDS_SVN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvn))
#define VTG_VCS_BACKENDS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))
#define VTG_VCS_BACKENDS_IS_SVN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_IS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_SVN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))

typedef struct _VtgVcsBackendsSvn VtgVcsBackendsSvn;
typedef struct _VtgVcsBackendsSvnClass VtgVcsBackendsSvnClass;

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};

struct _VtgProjectManagerPrivate {
	VbfProject* _project;
	GtkTreeStore* _model;
	gboolean _enable_completion;
	gboolean in_update;
	ValaHashMap* _completions;
	gint parser_thread_count;
	gboolean _sc_building;
	gboolean _automanaged;
	guint _idle_id;
};

typedef enum  {
	VTG_PROJECT_MANAGER_ERROR_NO_BACKEND
} VtgProjectManagerError;
#define VTG_PROJECT_MANAGER_ERROR vtg_project_manager_error_quark ()

static gpointer vtg_project_manager_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
extern GdkPixbuf* vtg_utils_icon_project;
extern GdkPixbuf* vtg_utils_icon_folder_packages;
extern GdkPixbuf* vtg_utils_icon_package;
static GType vtg_project_manager_type_id = 0;

GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
#define VTG_PROJECT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerPrivate))
enum  {
	VTG_PROJECT_MANAGER_DUMMY_PROPERTY,
	VTG_PROJECT_MANAGER_MODEL,
	VTG_PROJECT_MANAGER_PROJECT,
	VTG_PROJECT_MANAGER_AUTOMANAGED,
	VTG_PROJECT_MANAGER_ENABLE_COMPLETION,
	VTG_PROJECT_MANAGER_COMPLETIONS
};
static void vtg_project_manager_cleanup_completions (VtgProjectManager* self);
VtgProjectManager* vtg_project_manager_new (gboolean enable_completion);
VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const gchar* uri);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const gchar* filename);
VbfSource* vtg_project_manager_get_source_file_from_uri (VtgProjectManager* self, const gchar* uri);
VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const gchar* filename);
gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const gchar* uri);
gchar* vtg_project_manager_source_uri_for_name (VtgProjectManager* self, const gchar* name);
void vtg_project_manager_create_default_project (VtgProjectManager* self);
static void vtg_project_manager_on_project_updated (VtgProjectManager* self, VbfProject* sender);
static void _vtg_project_manager_on_project_updated_vbf_project_updated (VbfProject* _sender, gpointer self);
gboolean vtg_project_manager_open (VtgProjectManager* self, const gchar* project_filename, GError** error);
static void vtg_project_manager_parse_project (VtgProjectManager* self);
static void vtg_project_manager_setup_completions (VtgProjectManager* self);
static void vtg_project_manager_build_tree_model (VtgProjectManager* self);
static void vtg_project_manager_vcs_test (VtgProjectManager* self, const gchar* filename);
GQuark vtg_project_manager_error_quark (void);
static gboolean vtg_project_manager_target_has_vala_source (VtgProjectManager* self, VbfTarget* target);
static void vtg_project_manager_on_completion_engine_begin_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender);
static void _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static void vtg_project_manager_on_completion_engine_end_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender);
static void _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static void vtg_project_manager_on_completion_engine_file_parsed (VtgProjectManager* self, AfroditeCompletionEngine* sender, const gchar* filename, AfroditeParseResult* parse_result);
static void _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, const gchar* filename, AfroditeParseResult* parse_result, gpointer self);
void vtg_utils_trace (const gchar* format, ...);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
ValaList* vtg_plugin_get_instances (VtgPlugin* self);
void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine);
void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine);
static gboolean vtg_project_manager_on_idle (VtgProjectManager* self);
static gboolean _vtg_project_manager_on_idle_gsource_func (gpointer self);
GType vtg_project_manager_ui_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_ui_register_type (GTypeModule * module);
VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self);
GType vtg_project_builder_get_type (void) G_GNUC_CONST;
GType vtg_project_builder_register_type (GTypeModule * module);
VtgProjectBuilder* vtg_project_manager_ui_get_project_builder (VtgProjectManagerUi* self);
GType vtg_build_log_view_get_type (void) G_GNUC_CONST;
GType vtg_build_log_view_register_type (GTypeModule * module);
VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self);
void vtg_build_log_view_clear_messages_for_source (VtgBuildLogView* self, const gchar* filename);
void vtg_build_log_view_update_parse_result (VtgBuildLogView* self, const gchar* filename, AfroditeParseResult* parse_result);
VtgVcsBackendsGit* vtg_vcs_backends_git_new (void);
VtgVcsBackendsGit* vtg_vcs_backends_git_construct (GType object_type);
GType vtg_vcs_backends_vcs_base_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_register_type (GTypeModule * module);
GType vtg_vcs_backends_git_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_git_register_type (GTypeModule * module);
gboolean vtg_vcs_backends_vcs_base_test (VtgVcsBackendsVcsBase* self, const gchar* path);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_new (void);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_construct (GType object_type);
GType vtg_vcs_backends_bzr_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_bzr_register_type (GTypeModule * module);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_new (void);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_construct (GType object_type);
GType vtg_vcs_backends_svn_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_svn_register_type (GTypeModule * module);
void vtg_project_manager_close (VtgProjectManager* self);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
GdkPixbuf* vtg_utils_get_small_icon_for_target_type (VbfTargetTypes type);
static gint vtg_project_manager_sort_model (VtgProjectManager* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_project_manager_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
gint vtg_path_utils_compare_vala_filenames (const gchar* filea, const gchar* fileb);
GtkTreeModel* vtg_project_manager_get_model (VtgProjectManager* self);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
gboolean vtg_project_manager_get_automanaged (VtgProjectManager* self);
void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value);
gboolean vtg_project_manager_get_enable_completion (VtgProjectManager* self);
void vtg_project_manager_set_enable_completion (VtgProjectManager* self, gboolean value);
ValaHashMap* vtg_project_manager_get_completions (VtgProjectManager* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void vtg_project_manager_finalize (GObject* obj);
static void _vala_vtg_project_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vtg_project_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion) {
	VtgProjectManager * self = NULL;
	self = (VtgProjectManager*) g_object_new (object_type, NULL);
	self->priv->_enable_completion = enable_completion;
	return self;
}


VtgProjectManager* vtg_project_manager_new (gboolean enable_completion) {
	return vtg_project_manager_construct (VTG_TYPE_PROJECT_MANAGER, enable_completion);
}


AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const gchar* uri) {
	AfroditeCompletionEngine* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (uri != NULL) {
		_tmp0_ = self->priv->_completions != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _group_list;
			gint _tmp2_;
			gint _group_size;
			gint _group_index;
			_tmp1_ = vbf_project_get_groups (self->priv->_project);
			_group_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp2_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp3_;
				{
					ValaList* _tmp4_ = NULL;
					ValaList* _target_list;
					gint _tmp5_;
					gint _target_size;
					gint _target_index;
					_tmp4_ = vbf_group_get_targets (group);
					_target_list = _tmp4_;
					_tmp5_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp5_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp6_ = NULL;
						VbfTarget* target;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp6_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp6_;
						{
							ValaList* _tmp7_ = NULL;
							ValaList* _source_list;
							gint _tmp8_;
							gint _source_size;
							gint _source_index;
							_tmp7_ = vbf_target_get_sources (target);
							_source_list = _tmp7_;
							_tmp8_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp8_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp9_ = NULL;
								VbfSource* source;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp9_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp9_;
								if (g_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
									AfroditeCompletionEngine* _tmp10_ = NULL;
									_tmp10_ = vtg_project_manager_get_completion_for_target (self, target);
									result = _tmp10_;
									_g_object_unref0 (source);
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
	}
	result = NULL;
	return result;
}


AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target) {
	AfroditeCompletionEngine* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	if (self->priv->_completions != NULL) {
		{
			ValaSet* _tmp0_ = NULL;
			ValaSet* _tmp1_;
			ValaIterator* _tmp2_ = NULL;
			ValaIterator* _tmp3_;
			ValaIterator* _key_it;
			_tmp0_ = vala_map_get_keys ((ValaMap*) self->priv->_completions);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_vala_iterable_unref0 (_tmp1_);
			_key_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				VbfTarget* key;
				_tmp4_ = vala_iterator_next (_key_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = vala_iterator_get (_key_it);
				key = (VbfTarget*) _tmp5_;
				if (g_strcmp0 (key->id, target->id) == 0) {
					gpointer _tmp6_ = NULL;
					_tmp6_ = vala_map_get ((ValaMap*) self->priv->_completions, key);
					result = (AfroditeCompletionEngine*) _tmp6_;
					_g_object_unref0 (key);
					_vala_iterator_unref0 (_key_it);
					return result;
				}
				_g_object_unref0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
	}
	result = NULL;
	return result;
}


gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const gchar* filename) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (filename != NULL) {
		{
			ValaList* _tmp0_ = NULL;
			ValaList* _group_list;
			gint _tmp1_;
			gint _group_size;
			gint _group_index;
			_tmp0_ = vbf_project_get_groups (self->priv->_project);
			_group_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp1_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp2_;
				{
					ValaList* _tmp3_ = NULL;
					ValaList* _target_list;
					gint _tmp4_;
					gint _target_size;
					gint _target_index;
					_tmp3_ = vbf_group_get_targets (group);
					_target_list = _tmp3_;
					_tmp4_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp4_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp5_ = NULL;
						VbfTarget* target;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp5_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp5_;
						{
							ValaList* _tmp6_ = NULL;
							ValaList* _source_list;
							gint _tmp7_;
							gint _source_size;
							gint _source_index;
							_tmp6_ = vbf_target_get_sources (target);
							_source_list = _tmp6_;
							_tmp7_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp7_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp8_ = NULL;
								VbfSource* source;
								gchar* _tmp9_ = NULL;
								gchar* _tmp10_;
								gchar* _tmp11_;
								gboolean _tmp12_;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp8_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp8_;
								_tmp9_ = g_filename_from_uri (((VbfFile*) source)->uri, NULL, &_inner_error_);
								_tmp10_ = _tmp9_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == G_CONVERT_ERROR) {
										goto __catch37_g_convert_error;
									}
									_g_object_unref0 (source);
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_tmp11_ = _tmp10_;
								_tmp12_ = g_strcmp0 (_tmp11_, filename) == 0;
								_g_free0 (_tmp11_);
								if (_tmp12_) {
									result = TRUE;
									_g_object_unref0 (source);
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									return result;
								}
								goto __finally37;
								__catch37_g_convert_error:
								{
									GError * err;
									err = _inner_error_;
									_inner_error_ = NULL;
									g_warning ("vtgprojectmanager.vala:138: error converting uri %s to filename: %s", ((VbfFile*) source)->uri, err->message);
									_g_error_free0 (err);
								}
								__finally37:
								if (_inner_error_ != NULL) {
									_g_object_unref0 (source);
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						{
							ValaList* _tmp13_ = NULL;
							ValaList* _file_list;
							gint _tmp14_;
							gint _file_size;
							gint _file_index;
							_tmp13_ = vbf_target_get_files (target);
							_file_list = _tmp13_;
							_tmp14_ = vala_collection_get_size ((ValaCollection*) _file_list);
							_file_size = _tmp14_;
							_file_index = -1;
							while (TRUE) {
								gpointer _tmp15_ = NULL;
								VbfFile* file;
								gchar* _tmp16_ = NULL;
								gchar* _tmp17_;
								gchar* _tmp18_;
								gboolean _tmp19_;
								_file_index = _file_index + 1;
								if (!(_file_index < _file_size)) {
									break;
								}
								_tmp15_ = vala_list_get (_file_list, _file_index);
								file = (VbfFile*) _tmp15_;
								_tmp16_ = g_filename_from_uri (file->uri, NULL, &_inner_error_);
								_tmp17_ = _tmp16_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == G_CONVERT_ERROR) {
										goto __catch38_g_convert_error;
									}
									_g_object_unref0 (file);
									_vala_iterable_unref0 (_file_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_tmp18_ = _tmp17_;
								_tmp19_ = g_strcmp0 (_tmp18_, filename) == 0;
								_g_free0 (_tmp18_);
								if (_tmp19_) {
									result = TRUE;
									_g_object_unref0 (file);
									_vala_iterable_unref0 (_file_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									return result;
								}
								goto __finally38;
								__catch38_g_convert_error:
								{
									GError * err;
									err = _inner_error_;
									_inner_error_ = NULL;
									g_warning ("vtgprojectmanager.vala:147: error converting uri %s to filename: %s", file->uri, err->message);
									_g_error_free0 (err);
								}
								__finally38:
								if (_inner_error_ != NULL) {
									_g_object_unref0 (file);
									_vala_iterable_unref0 (_file_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_g_object_unref0 (file);
							}
							_vala_iterable_unref0 (_file_list);
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
	}
	result = FALSE;
	return result;
}


VbfSource* vtg_project_manager_get_source_file_from_uri (VtgProjectManager* self, const gchar* uri) {
	VbfSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (uri != NULL) {
		{
			ValaList* _tmp0_ = NULL;
			ValaList* _group_list;
			gint _tmp1_;
			gint _group_size;
			gint _group_index;
			_tmp0_ = vbf_project_get_groups (self->priv->_project);
			_group_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp1_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp2_;
				{
					ValaList* _tmp3_ = NULL;
					ValaList* _target_list;
					gint _tmp4_;
					gint _target_size;
					gint _target_index;
					_tmp3_ = vbf_group_get_targets (group);
					_target_list = _tmp3_;
					_tmp4_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp4_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp5_ = NULL;
						VbfTarget* target;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp5_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp5_;
						{
							ValaList* _tmp6_ = NULL;
							ValaList* _source_list;
							gint _tmp7_;
							gint _source_size;
							gint _source_index;
							_tmp6_ = vbf_target_get_sources (target);
							_source_list = _tmp6_;
							_tmp7_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp7_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp8_ = NULL;
								VbfSource* source;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp8_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp8_;
								if (g_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
									result = source;
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
	}
	result = NULL;
	return result;
}


VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const gchar* filename) {
	VbfSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (filename != NULL) {
		{
			ValaList* _tmp0_ = NULL;
			ValaList* _group_list;
			gint _tmp1_;
			gint _group_size;
			gint _group_index;
			_tmp0_ = vbf_project_get_groups (self->priv->_project);
			_group_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp1_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp2_;
				{
					ValaList* _tmp3_ = NULL;
					ValaList* _target_list;
					gint _tmp4_;
					gint _target_size;
					gint _target_index;
					_tmp3_ = vbf_group_get_targets (group);
					_target_list = _tmp3_;
					_tmp4_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp4_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp5_ = NULL;
						VbfTarget* target;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp5_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp5_;
						{
							ValaList* _tmp6_ = NULL;
							ValaList* _source_list;
							gint _tmp7_;
							gint _source_size;
							gint _source_index;
							_tmp6_ = vbf_target_get_sources (target);
							_source_list = _tmp6_;
							_tmp7_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp7_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp8_ = NULL;
								VbfSource* source;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp8_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp8_;
								if (g_strcmp0 (((VbfFile*) source)->filename, filename) == 0) {
									result = source;
									_vala_iterable_unref0 (_source_list);
									_g_object_unref0 (target);
									_vala_iterable_unref0 (_target_list);
									_g_object_unref0 (group);
									_vala_iterable_unref0 (_group_list);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
	}
	result = NULL;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const gchar* uri) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (uri != NULL) {
		{
			ValaList* _tmp0_;
			ValaList* _source_list;
			gint _tmp1_;
			gint _source_size;
			gint _source_index;
			_tmp0_ = _vala_iterable_ref0 (self->all_vala_sources);
			_source_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
			_source_size = _tmp1_;
			_source_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VbfSource* source;
				_source_index = _source_index + 1;
				if (!(_source_index < _source_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_source_list, _source_index);
				source = (VbfSource*) _tmp2_;
				if (g_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
					result = TRUE;
					_g_object_unref0 (source);
					_vala_iterable_unref0 (_source_list);
					return result;
				}
				_g_object_unref0 (source);
			}
			_vala_iterable_unref0 (_source_list);
		}
	}
	result = FALSE;
	return result;
}


gchar* vtg_project_manager_source_uri_for_name (VtgProjectManager* self, const gchar* name) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (name != NULL) {
		gchar** _tmp0_;
		gchar** _tmp1_ = NULL;
		gchar** name_parts;
		gint name_parts_length1;
		gint _name_parts_size_;
		_tmp1_ = _tmp0_ = g_strsplit (name, "/", 0);
		name_parts = _tmp1_;
		name_parts_length1 = _vala_array_length (_tmp0_);
		_name_parts_size_ = _vala_array_length (_tmp0_);
		{
			ValaList* _tmp2_ = NULL;
			ValaList* _group_list;
			gint _tmp3_;
			gint _group_size;
			gint _group_index;
			_tmp2_ = vbf_project_get_groups (self->priv->_project);
			_group_list = _tmp2_;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp3_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp4_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp4_;
				{
					ValaList* _tmp5_ = NULL;
					ValaList* _target_list;
					gint _tmp6_;
					gint _target_size;
					gint _target_index;
					_tmp5_ = vbf_group_get_targets (group);
					_target_list = _tmp5_;
					_tmp6_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp6_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp7_ = NULL;
						VbfTarget* target;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp7_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp7_;
						{
							ValaList* _tmp8_ = NULL;
							ValaList* _source_list;
							gint _tmp9_;
							gint _source_size;
							gint _source_index;
							_tmp8_ = vbf_target_get_sources (target);
							_source_list = _tmp8_;
							_tmp9_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp9_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp10_ = NULL;
								VbfSource* source;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp10_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp10_;
								if (name_parts_length1 == 1) {
									if (g_strcmp0 (((VbfFile*) source)->name, name) == 0) {
										gchar* _tmp11_;
										_tmp11_ = g_strdup (((VbfFile*) source)->uri);
										result = _tmp11_;
										_g_object_unref0 (source);
										_vala_iterable_unref0 (_source_list);
										_g_object_unref0 (target);
										_vala_iterable_unref0 (_target_list);
										_g_object_unref0 (group);
										_vala_iterable_unref0 (_group_list);
										name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
										return result;
									}
								} else {
									if (((VbfFile*) source)->uri != NULL) {
										gchar** _tmp12_;
										gchar** _tmp13_ = NULL;
										gchar** src_parts;
										gint src_parts_length1;
										gint _src_parts_size_;
										_tmp13_ = _tmp12_ = g_strsplit (((VbfFile*) source)->uri, "/", 0);
										src_parts = _tmp13_;
										src_parts_length1 = _vala_array_length (_tmp12_);
										_src_parts_size_ = _vala_array_length (_tmp12_);
										if (name_parts_length1 <= src_parts_length1) {
											gboolean equals;
											equals = TRUE;
											{
												gint idx;
												idx = 0;
												{
													gboolean _tmp14_;
													_tmp14_ = TRUE;
													while (TRUE) {
														if (!_tmp14_) {
															idx++;
														}
														_tmp14_ = FALSE;
														if (!(idx < name_parts_length1)) {
															break;
														}
														if (g_strcmp0 (src_parts[src_parts_length1 - idx], name_parts[name_parts_length1 - idx]) != 0) {
															equals = FALSE;
															break;
														}
													}
												}
											}
											if (equals) {
												gchar* _tmp15_;
												_tmp15_ = g_strdup (((VbfFile*) source)->uri);
												result = _tmp15_;
												src_parts = (_vala_array_free (src_parts, src_parts_length1, (GDestroyNotify) g_free), NULL);
												_g_object_unref0 (source);
												_vala_iterable_unref0 (_source_list);
												_g_object_unref0 (target);
												_vala_iterable_unref0 (_target_list);
												_g_object_unref0 (group);
												_vala_iterable_unref0 (_group_list);
												name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
												return result;
											}
										}
										src_parts = (_vala_array_free (src_parts, src_parts_length1, (GDestroyNotify) g_free), NULL);
									}
								}
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
		name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	return result;
}


static void _vtg_project_manager_on_project_updated_vbf_project_updated (VbfProject* _sender, gpointer self) {
	vtg_project_manager_on_project_updated (self, _sender);
}


void vtg_project_manager_create_default_project (VtgProjectManager* self) {
	VbfProject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	VbfGroup* _tmp3_ = NULL;
	VbfGroup* group;
	const gchar* _tmp4_ = NULL;
	VbfTarget* _tmp5_ = NULL;
	VbfTarget* target;
	g_return_if_fail (self != NULL);
	_tmp0_ = vbf_project_new ("vtg-default-project");
	_g_object_unref0 (self->priv->_project);
	self->priv->_project = _tmp0_;
	_tmp1_ = _ ("default project");
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_project->name);
	self->priv->_project->name = _tmp2_;
	_tmp3_ = vbf_group_new (self->priv->_project, "Sources");
	group = _tmp3_;
	_tmp4_ = _ ("Default");
	_tmp5_ = vbf_target_new (group, VBF_TARGET_TYPES_PROGRAM, "Default", _tmp4_);
	target = _tmp5_;
	vbf_group_add_target (group, target);
	vbf_project_add_group (self->priv->_project, group);
	g_signal_connect_object (self->priv->_project, "updated", (GCallback) _vtg_project_manager_on_project_updated_vbf_project_updated, self, 0);
	self->is_default = TRUE;
	_g_object_unref0 (target);
	_g_object_unref0 (group);
}


gboolean vtg_project_manager_open (VtgProjectManager* self, const gchar* project_filename, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	VbfIProjectBackend* backend = NULL;
	VbfIProjectBackend* _tmp3_ = NULL;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_filename != NULL, FALSE);
	_tmp0_ = g_file_test (project_filename, (G_FILE_TEST_IS_DIR | G_FILE_TEST_IS_REGULAR) | G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("Can't load project, file not found");
		_tmp2_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp4_ = vbf_probe (project_filename, &_tmp3_);
	_g_object_unref0 (backend);
	backend = _tmp3_;
	if (_tmp4_) {
		VbfProject* _tmp5_ = NULL;
		_tmp5_ = vbf_iproject_backend_open (backend, project_filename);
		_g_object_unref0 (self->priv->_project);
		self->priv->_project = _tmp5_;
		if (self->priv->_project == NULL) {
			result = FALSE;
			_g_object_unref0 (backend);
			return result;
		}
		vtg_project_manager_parse_project (self);
		vtg_project_manager_setup_completions (self);
		vtg_project_manager_build_tree_model (self);
		vtg_project_manager_vcs_test (self, project_filename);
		g_signal_connect_object (self->priv->_project, "updated", (GCallback) _vtg_project_manager_on_project_updated_vbf_project_updated, self, 0);
		result = TRUE;
		_g_object_unref0 (backend);
		return result;
	} else {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("Can't load project, no suitable backend found");
		_tmp7_ = g_error_new_literal (VTG_PROJECT_MANAGER_ERROR, VTG_PROJECT_MANAGER_ERROR_NO_BACKEND, _tmp6_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (backend);
		return FALSE;
	}
	_g_object_unref0 (backend);
}


static gboolean vtg_project_manager_target_has_vala_source (VtgProjectManager* self, VbfTarget* target) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _source_list;
		gint _tmp1_;
		gint _source_size;
		gint _source_index;
		_tmp0_ = vbf_target_get_sources (target);
		_source_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp1_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfSource* source;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_list, _source_index);
			source = (VbfSource*) _tmp2_;
			if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
				result = TRUE;
				_g_object_unref0 (source);
				_vala_iterable_unref0 (_source_list);
				return result;
			}
			_g_object_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
	result = FALSE;
	return result;
}


static void _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	vtg_project_manager_on_completion_engine_begin_parse (self, sender);
}


static void _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	vtg_project_manager_on_completion_engine_end_parse (self, sender);
}


static void _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, const gchar* filename, AfroditeParseResult* parse_result, gpointer self) {
	vtg_project_manager_on_completion_engine_file_parsed (self, sender, filename, parse_result);
}


static void vtg_project_manager_setup_completions (VtgProjectManager* self) {
	ValaHashMap* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->_enable_completion) {
		return;
	}
	_tmp0_ = vala_hash_map_new (VBF_TYPE_TARGET, (GBoxedCopyFunc) g_object_ref, g_object_unref, AFRODITE_TYPE_COMPLETION_ENGINE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_vala_map_unref0 (self->priv->_completions);
	self->priv->_completions = _tmp0_;
	{
		ValaList* _tmp1_ = NULL;
		ValaList* _group_list;
		gint _tmp2_;
		gint _group_size;
		gint _group_index;
		_tmp1_ = vbf_project_get_groups (self->priv->_project);
		_group_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _group_list);
		_group_size = _tmp2_;
		_group_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			VbfGroup* group;
			_group_index = _group_index + 1;
			if (!(_group_index < _group_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_group_list, _group_index);
			group = (VbfGroup*) _tmp3_;
			{
				ValaList* _tmp4_ = NULL;
				ValaList* _target_list;
				gint _tmp5_;
				gint _target_size;
				gint _target_index;
				_tmp4_ = vbf_group_get_targets (group);
				_target_list = _tmp4_;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _target_list);
				_target_size = _tmp5_;
				_target_index = -1;
				while (TRUE) {
					gpointer _tmp6_ = NULL;
					VbfTarget* target;
					gboolean _tmp7_;
					AfroditeCompletionEngine* _tmp8_ = NULL;
					AfroditeCompletionEngine* completion;
					ValaList* _tmp12_ = NULL;
					ValaList* vapis;
					ValaList* _tmp13_ = NULL;
					ValaList* group_vapis;
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gchar** _tmp17_ = NULL;
					gchar** vapi_dirs;
					gint vapi_dirs_length1;
					gint _vapi_dirs_size_;
					gint index;
					_target_index = _target_index + 1;
					if (!(_target_index < _target_size)) {
						break;
					}
					_tmp6_ = vala_list_get (_target_list, _target_index);
					target = (VbfTarget*) _tmp6_;
					_tmp7_ = vtg_project_manager_target_has_vala_source (self, target);
					if (!_tmp7_) {
						_g_object_unref0 (target);
						continue;
					}
					_tmp8_ = afrodite_completion_engine_new (target->name);
					completion = _tmp8_;
					g_signal_connect_object (completion, "begin-parsing", (GCallback) _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing, self, 0);
					g_signal_connect_object (completion, "end-parsing", (GCallback) _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing, self, 0);
					g_signal_connect_object (completion, "file-parsed", (GCallback) _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed, self, 0);
					vala_map_set ((ValaMap*) self->priv->_completions, target, completion);
					{
						ValaList* _tmp9_ = NULL;
						ValaList* _path_list;
						gint _tmp10_;
						gint _path_size;
						gint _path_index;
						_tmp9_ = vbf_target_get_include_dirs (target);
						_path_list = _tmp9_;
						_tmp10_ = vala_collection_get_size ((ValaCollection*) _path_list);
						_path_size = _tmp10_;
						_path_index = -1;
						while (TRUE) {
							gpointer _tmp11_ = NULL;
							gchar* path;
							_path_index = _path_index + 1;
							if (!(_path_index < _path_size)) {
								break;
							}
							_tmp11_ = vala_list_get (_path_list, _path_index);
							path = (gchar*) _tmp11_;
							afrodite_completion_engine_add_vapi_dir (completion, path);
							_g_free0 (path);
						}
						_vala_iterable_unref0 (_path_list);
					}
					_tmp12_ = vbf_target_get_include_dirs (target);
					vapis = _tmp12_;
					_tmp13_ = vbf_group_get_include_dirs (group);
					group_vapis = _tmp13_;
					_tmp14_ = vala_collection_get_size ((ValaCollection*) vapis);
					_tmp15_ = vala_collection_get_size ((ValaCollection*) group_vapis);
					_tmp17_ = g_new0 (gchar*, (_tmp16_ = _tmp14_ + _tmp15_) + 1);
					vapi_dirs = _tmp17_;
					vapi_dirs_length1 = _tmp16_;
					_vapi_dirs_size_ = _tmp16_;
					index = 0;
					{
						ValaList* _tmp18_;
						ValaList* _item_list;
						gint _tmp19_;
						gint _item_size;
						gint _item_index;
						_tmp18_ = _vala_iterable_ref0 (vapis);
						_item_list = _tmp18_;
						_tmp19_ = vala_collection_get_size ((ValaCollection*) _item_list);
						_item_size = _tmp19_;
						_item_index = -1;
						while (TRUE) {
							gpointer _tmp20_ = NULL;
							gchar* item;
							gint _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							_item_index = _item_index + 1;
							if (!(_item_index < _item_size)) {
								break;
							}
							_tmp20_ = vala_list_get (_item_list, _item_index);
							item = (gchar*) _tmp20_;
							_tmp21_ = index;
							index = _tmp21_ + 1;
							_tmp22_ = g_strdup (item);
							_tmp23_ = _tmp22_;
							_g_free0 (vapi_dirs[_tmp21_]);
							vapi_dirs[_tmp21_] = _tmp23_;
							_g_free0 (item);
						}
						_vala_iterable_unref0 (_item_list);
					}
					{
						ValaList* _tmp24_;
						ValaList* _item_list;
						gint _tmp25_;
						gint _item_size;
						gint _item_index;
						_tmp24_ = _vala_iterable_ref0 (group_vapis);
						_item_list = _tmp24_;
						_tmp25_ = vala_collection_get_size ((ValaCollection*) _item_list);
						_item_size = _tmp25_;
						_item_index = -1;
						while (TRUE) {
							gpointer _tmp26_ = NULL;
							gchar* item;
							gint _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							_item_index = _item_index + 1;
							if (!(_item_index < _item_size)) {
								break;
							}
							_tmp26_ = vala_list_get (_item_list, _item_index);
							item = (gchar*) _tmp26_;
							_tmp27_ = index;
							index = _tmp27_ + 1;
							_tmp28_ = g_strdup (item);
							_tmp29_ = _tmp28_;
							_g_free0 (vapi_dirs[_tmp27_]);
							vapi_dirs[_tmp27_] = _tmp29_;
							_g_free0 (item);
						}
						_vala_iterable_unref0 (_item_list);
					}
					{
						ValaList* _tmp30_ = NULL;
						ValaList* _package_list;
						gint _tmp31_;
						gint _package_size;
						gint _package_index;
						_tmp30_ = vbf_group_get_packages (group);
						_package_list = _tmp30_;
						_tmp31_ = vala_collection_get_size ((ValaCollection*) _package_list);
						_package_size = _tmp31_;
						_package_index = -1;
						while (TRUE) {
							gpointer _tmp32_ = NULL;
							VbfPackage* package;
							ValaList* _tmp33_ = NULL;
							ValaList* paths;
							_package_index = _package_index + 1;
							if (!(_package_index < _package_size)) {
								break;
							}
							_tmp32_ = vala_list_get (_package_list, _package_index);
							package = (VbfPackage*) _tmp32_;
							vtg_utils_trace ("vtgprojectmanager.vala:322: setup_completions: group %s, referenced pa" \
"ckage: %s", group->id, package->id);
							_tmp33_ = afrodite_utils_get_package_paths (package->id, NULL, vapi_dirs, vapi_dirs_length1);
							paths = _tmp33_;
							if (paths != NULL) {
								afrodite_completion_engine_queue_sourcefiles (completion, paths, NULL, TRUE, FALSE);
							} else {
								vtg_utils_trace ("vtgprojectmanager.vala:329: setup_completions: group %s, no vapi found" \
" for: %s", group->id, package->id);
							}
							_vala_iterable_unref0 (paths);
							_g_object_unref0 (package);
						}
						_vala_iterable_unref0 (_package_list);
					}
					{
						ValaList* _tmp34_ = NULL;
						ValaList* _package_list;
						gint _tmp35_;
						gint _package_size;
						gint _package_index;
						_tmp34_ = vbf_target_get_packages (target);
						_package_list = _tmp34_;
						_tmp35_ = vala_collection_get_size ((ValaCollection*) _package_list);
						_package_size = _tmp35_;
						_package_index = -1;
						while (TRUE) {
							gpointer _tmp36_ = NULL;
							VbfPackage* package;
							ValaList* _tmp37_ = NULL;
							ValaList* paths;
							_package_index = _package_index + 1;
							if (!(_package_index < _package_size)) {
								break;
							}
							_tmp36_ = vala_list_get (_package_list, _package_index);
							package = (VbfPackage*) _tmp36_;
							vtg_utils_trace ("vtgprojectmanager.vala:334: setup_completions: target %s, referenced p" \
"ackage: %s", target->id, package->id);
							_tmp37_ = afrodite_utils_get_package_paths (package->id, NULL, vapi_dirs, vapi_dirs_length1);
							paths = _tmp37_;
							if (paths != NULL) {
								afrodite_completion_engine_queue_sourcefiles (completion, paths, NULL, TRUE, FALSE);
							} else {
								vtg_utils_trace ("vtgprojectmanager.vala:341: setup_completions: target %s, no vapi foun" \
"d for: %s", target->id, package->id);
							}
							_vala_iterable_unref0 (paths);
							_g_object_unref0 (package);
						}
						_vala_iterable_unref0 (_package_list);
					}
					{
						ValaList* _tmp38_ = NULL;
						ValaList* _source_list;
						gint _tmp39_;
						gint _source_size;
						gint _source_index;
						_tmp38_ = vbf_target_get_sources (target);
						_source_list = _tmp38_;
						_tmp39_ = vala_collection_get_size ((ValaCollection*) _source_list);
						_source_size = _tmp39_;
						_source_index = -1;
						while (TRUE) {
							gpointer _tmp40_ = NULL;
							VbfSource* source;
							_source_index = _source_index + 1;
							if (!(_source_index < _source_size)) {
								break;
							}
							_tmp40_ = vala_list_get (_source_list, _source_index);
							source = (VbfSource*) _tmp40_;
							if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
								gboolean _tmp41_;
								vtg_utils_trace ("vtgprojectmanager.vala:348: setup_completions: source %s", ((VbfFile*) source)->filename);
								_tmp41_ = g_file_test (((VbfFile*) source)->filename, (G_FILE_TEST_EXISTS | G_FILE_TEST_IS_SYMLINK) | G_FILE_TEST_IS_REGULAR);
								if (_tmp41_) {
									afrodite_completion_engine_queue_sourcefile (completion, ((VbfFile*) source)->filename, NULL, FALSE, FALSE);
								}
							}
							_g_object_unref0 (source);
						}
						_vala_iterable_unref0 (_source_list);
					}
					{
						ValaList* _tmp42_ = NULL;
						ValaList* _tmp43_;
						ValaList* _instance_list;
						gint _tmp44_;
						gint _instance_size;
						gint _instance_index;
						_tmp42_ = vtg_plugin_get_instances (vtg_plugin_main_instance);
						_tmp43_ = _vala_iterable_ref0 (_tmp42_);
						_instance_list = _tmp43_;
						_tmp44_ = vala_collection_get_size ((ValaCollection*) _instance_list);
						_instance_size = _tmp44_;
						_instance_index = -1;
						while (TRUE) {
							gpointer _tmp45_ = NULL;
							VtgPluginInstance* instance;
							_instance_index = _instance_index + 1;
							if (!(_instance_index < _instance_size)) {
								break;
							}
							_tmp45_ = vala_list_get (_instance_list, _instance_index);
							instance = (VtgPluginInstance*) _tmp45_;
							vtg_plugin_instance_bind_completion_engine_with_target (instance, target, completion);
							_g_object_unref0 (instance);
						}
						_vala_iterable_unref0 (_instance_list);
					}
					vapi_dirs = (_vala_array_free (vapi_dirs, vapi_dirs_length1, (GDestroyNotify) g_free), NULL);
					_vala_iterable_unref0 (group_vapis);
					_vala_iterable_unref0 (vapis);
					_g_object_unref0 (completion);
					_g_object_unref0 (target);
				}
				_vala_iterable_unref0 (_target_list);
			}
			_g_object_unref0 (group);
		}
		_vala_iterable_unref0 (_group_list);
	}
}


static void vtg_project_manager_cleanup_completions (VtgProjectManager* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_completions != NULL) {
		{
			ValaCollection* _tmp0_ = NULL;
			ValaCollection* _tmp1_;
			ValaIterator* _tmp2_ = NULL;
			ValaIterator* _tmp3_;
			ValaIterator* _completion_it;
			_tmp0_ = vala_map_get_values ((ValaMap*) self->priv->_completions);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_vala_iterable_unref0 (_tmp1_);
			_completion_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				AfroditeCompletionEngine* completion;
				guint _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				_tmp4_ = vala_iterator_next (_completion_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = vala_iterator_get (_completion_it);
				completion = (AfroditeCompletionEngine*) _tmp5_;
				g_signal_parse_name ("begin-parsing", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp6_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing, self);
				g_signal_parse_name ("end-parsing", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp7_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing, self);
				g_signal_parse_name ("file-parsed", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed, self);
				{
					ValaList* _tmp9_ = NULL;
					ValaList* _tmp10_;
					ValaList* _instance_list;
					gint _tmp11_;
					gint _instance_size;
					gint _instance_index;
					_tmp9_ = vtg_plugin_get_instances (vtg_plugin_main_instance);
					_tmp10_ = _vala_iterable_ref0 (_tmp9_);
					_instance_list = _tmp10_;
					_tmp11_ = vala_collection_get_size ((ValaCollection*) _instance_list);
					_instance_size = _tmp11_;
					_instance_index = -1;
					while (TRUE) {
						gpointer _tmp12_ = NULL;
						VtgPluginInstance* instance;
						_instance_index = _instance_index + 1;
						if (!(_instance_index < _instance_size)) {
							break;
						}
						_tmp12_ = vala_list_get (_instance_list, _instance_index);
						instance = (VtgPluginInstance*) _tmp12_;
						vtg_plugin_instance_unbind_completion_engine (instance, completion);
						_g_object_unref0 (instance);
					}
					_vala_iterable_unref0 (_instance_list);
				}
				_g_object_unref0 (completion);
			}
			_vala_iterator_unref0 (_completion_it);
		}
		vala_map_clear ((ValaMap*) self->priv->_completions);
		_vala_map_unref0 (self->priv->_completions);
		self->priv->_completions = NULL;
	}
}


static gboolean _vtg_project_manager_on_idle_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_project_manager_on_idle (self);
	return result;
}


static void vtg_project_manager_on_completion_engine_begin_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "completion-begin-parsing", self, sender);
	_tmp0_ = g_atomic_int_exchange_and_add (&self->priv->parser_thread_count, 1);
	if (_tmp0_ == 0) {
		if (self->priv->_idle_id == 0) {
			guint _tmp1_;
			_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_project_manager_on_idle_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->_idle_id = _tmp1_;
		}
	}
}


static void vtg_project_manager_on_completion_engine_end_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "completion-end-parsing", self, sender);
	_tmp0_ = g_atomic_int_dec_and_test (&self->priv->parser_thread_count);
	if (_tmp0_) {
		if (self->priv->_idle_id == 0) {
			guint _tmp1_;
			_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_project_manager_on_idle_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->_idle_id = _tmp1_;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void vtg_project_manager_on_completion_engine_file_parsed (VtgProjectManager* self, AfroditeCompletionEngine* sender, const gchar* filename, AfroditeParseResult* parse_result) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (parse_result != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _tmp1_;
		ValaList* _instance_list;
		gint _tmp2_;
		gint _instance_size;
		gint _instance_index;
		_tmp0_ = vtg_plugin_get_instances (vtg_plugin_main_instance);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_instance_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp2_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			VtgPluginInstance* instance;
			VtgProjectManagerUi* _tmp4_ = NULL;
			VtgProjectBuilder* _tmp5_ = NULL;
			VtgBuildLogView* _tmp6_ = NULL;
			VtgBuildLogView* _tmp7_;
			VtgBuildLogView* view;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp3_;
			_tmp4_ = vtg_plugin_instance_get_project_manager_ui (instance);
			_tmp5_ = vtg_project_manager_ui_get_project_builder (_tmp4_);
			_tmp6_ = vtg_project_builder_get_error_pane (_tmp5_);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			view = _tmp7_;
			vtg_build_log_view_clear_messages_for_source (view, filename);
			vtg_build_log_view_update_parse_result (view, filename, parse_result);
			_g_object_unref0 (view);
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
}


static gboolean vtg_project_manager_on_idle (VtgProjectManager* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint val;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_atomic_int_get (&self->priv->parser_thread_count);
	val = _tmp0_;
	if (val > 0) {
		if (!self->priv->_sc_building) {
			self->priv->_sc_building = TRUE;
			g_signal_emit_by_name (self, "symbol-cache-building", self);
		}
	} else {
		if (self->priv->_sc_building) {
			self->priv->_sc_building = FALSE;
			g_signal_emit_by_name (self, "symbol-cache-builded", self);
		}
	}
	self->priv->_idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static void vtg_project_manager_vcs_test (VtgProjectManager* self, const gchar* filename) {
	VtgVcsBackendsGit* _tmp0_ = NULL;
	VtgVcsBackendsVcsBase* backend;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = vtg_vcs_backends_git_new ();
	backend = (VtgVcsBackendsVcsBase*) _tmp0_;
	self->vcs_type = VTG_VCS_TYPES_NONE;
	_tmp1_ = vtg_vcs_backends_vcs_base_test (backend, filename);
	if (_tmp1_) {
		self->vcs_type = VTG_VCS_TYPES_GIT;
	} else {
		VtgVcsBackendsBzr* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp2_ = vtg_vcs_backends_bzr_new ();
		_g_object_unref0 (backend);
		backend = (VtgVcsBackendsVcsBase*) _tmp2_;
		_tmp3_ = vtg_vcs_backends_vcs_base_test (backend, filename);
		if (_tmp3_) {
			self->vcs_type = VTG_VCS_TYPES_BZR;
		} else {
			VtgVcsBackendsSvn* _tmp4_ = NULL;
			gboolean _tmp5_;
			_tmp4_ = vtg_vcs_backends_svn_new ();
			_g_object_unref0 (backend);
			backend = (VtgVcsBackendsVcsBase*) _tmp4_;
			_tmp5_ = vtg_vcs_backends_vcs_base_test (backend, filename);
			if (_tmp5_) {
				self->vcs_type = VTG_VCS_TYPES_SVN;
			}
		}
	}
	_g_object_unref0 (backend);
}


void vtg_project_manager_close (VtgProjectManager* self) {
	g_return_if_fail (self != NULL);
	vala_collection_clear ((ValaCollection*) self->exec_targets);
	vala_collection_clear ((ValaCollection*) self->all_vala_sources);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = NULL;
	_g_object_unref0 (self->priv->_project);
	self->priv->_project = NULL;
}


static void vtg_project_manager_on_project_updated (VtgProjectManager* self, VbfProject* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->in_update) {
		return;
	}
	self->priv->in_update = TRUE;
	vtg_project_manager_cleanup_completions (self);
	vtg_project_manager_parse_project (self);
	vtg_project_manager_build_tree_model (self);
	vtg_project_manager_setup_completions (self);
	g_signal_emit_by_name (self, "updated");
	self->priv->in_update = FALSE;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gint _vtg_project_manager_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_project_manager_sort_model (self, model, a, b);
	return result;
}


static void vtg_project_manager_build_tree_model (VtgProjectManager* self) {
	GtkTreeIter project_iter = {0};
	GtkTreeIter* modules_iter;
	GtkTreeIter groups_iter = {0};
	GtkTreeIter* group_iter;
	GtkImage* _tmp0_ = NULL;
	GtkImage* image;
	GtkTreeStore* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	gboolean reference_added;
	GtkTreeIter _tmp20_ = {0};
	GdkPixbuf* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	modules_iter = NULL;
	group_iter = NULL;
	_tmp0_ = (GtkImage*) gtk_image_new ();
	image = g_object_ref_sink (_tmp0_);
	_tmp1_ = gtk_tree_store_new (5, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_OBJECT, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp1_;
	gtk_tree_store_append (self->priv->_model, &_tmp2_, NULL);
	project_iter = _tmp2_;
	_tmp3_ = vtg_string_utils_is_null_or_empty (self->priv->_project->version);
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("%s", self->priv->_project->name);
		_tmp5_ = _tmp4_;
		gtk_tree_store_set (self->priv->_model, &project_iter, 0, vtg_utils_icon_project, 1, _tmp5_, 2, "project-root", 4, "", -1);
		_g_free0 (_tmp5_);
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_strdup_printf ("%s - %s", self->priv->_project->name, self->priv->_project->version);
		_tmp7_ = _tmp6_;
		gtk_tree_store_set (self->priv->_model, &project_iter, 0, vtg_utils_icon_project, 1, _tmp7_, 2, "project-root", 4, "", -1);
		_g_free0 (_tmp7_);
	}
	reference_added = FALSE;
	{
		ValaList* _tmp8_ = NULL;
		ValaList* _module_list;
		gint _tmp9_;
		gint _module_size;
		gint _module_index;
		_tmp8_ = vbf_project_get_modules (self->priv->_project);
		_module_list = _tmp8_;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _module_list);
		_module_size = _tmp9_;
		_module_index = -1;
		while (TRUE) {
			gpointer _tmp10_ = NULL;
			VbfModule* module;
			GtkTreeIter module_iter = {0};
			GtkTreeIter _tmp15_ = {0};
			_module_index = _module_index + 1;
			if (!(_module_index < _module_size)) {
				break;
			}
			_tmp10_ = vala_list_get (_module_list, _module_index);
			module = (VbfModule*) _tmp10_;
			if (!reference_added) {
				GtkTreeIter _tmp11_ = {0};
				GtkTreeIter* _tmp12_;
				GdkPixbuf* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gtk_tree_store_append (self->priv->_model, &_tmp11_, &project_iter);
				_g_free0 (modules_iter);
				_tmp12_ = __gtk_tree_iter_dup0 (&_tmp11_);
				modules_iter = _tmp12_;
				_tmp13_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU);
				_tmp14_ = _ ("References");
				gtk_tree_store_set (self->priv->_model, modules_iter, 0, _tmp13_, 1, _tmp14_, 2, "project-reference", 4, "1", -1);
				reference_added = TRUE;
			}
			gtk_tree_store_append (self->priv->_model, &_tmp15_, modules_iter);
			module_iter = _tmp15_;
			gtk_tree_store_set (self->priv->_model, &module_iter, 0, vtg_utils_icon_folder_packages, 1, module->name, 2, module->id, 3, module, 4, module->name, -1);
			{
				ValaList* _tmp16_ = NULL;
				ValaList* _package_list;
				gint _tmp17_;
				gint _package_size;
				gint _package_index;
				_tmp16_ = vbf_module_get_packages (module);
				_package_list = _tmp16_;
				_tmp17_ = vala_collection_get_size ((ValaCollection*) _package_list);
				_package_size = _tmp17_;
				_package_index = -1;
				while (TRUE) {
					gpointer _tmp18_ = NULL;
					VbfPackage* package;
					GtkTreeIter package_iter = {0};
					GtkTreeIter _tmp19_ = {0};
					_package_index = _package_index + 1;
					if (!(_package_index < _package_size)) {
						break;
					}
					_tmp18_ = vala_list_get (_package_list, _package_index);
					package = (VbfPackage*) _tmp18_;
					gtk_tree_store_append (self->priv->_model, &_tmp19_, &module_iter);
					package_iter = _tmp19_;
					gtk_tree_store_set (self->priv->_model, &package_iter, 0, vtg_utils_icon_package, 1, package->name, 2, package->id, 3, package, 4, package->name, -1);
					_g_object_unref0 (package);
				}
				_vala_iterable_unref0 (_package_list);
			}
			_g_object_unref0 (module);
		}
		_vala_iterable_unref0 (_module_list);
	}
	gtk_tree_store_append (self->priv->_model, &_tmp20_, &project_iter);
	groups_iter = _tmp20_;
	_tmp21_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU);
	_tmp22_ = _ ("Files");
	gtk_tree_store_set (self->priv->_model, &groups_iter, 0, _tmp21_, 1, _tmp22_, 2, "project-files", 4, "2", -1);
	{
		ValaList* _tmp23_ = NULL;
		ValaList* _group_list;
		gint _tmp24_;
		gint _group_size;
		gint _group_index;
		_tmp23_ = vbf_project_get_groups (self->priv->_project);
		_group_list = _tmp23_;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _group_list);
		_group_size = _tmp24_;
		_group_index = -1;
		while (TRUE) {
			gpointer _tmp25_ = NULL;
			VbfGroup* group;
			gboolean group_added;
			_group_index = _group_index + 1;
			if (!(_group_index < _group_size)) {
				break;
			}
			_tmp25_ = vala_list_get (_group_list, _group_index);
			group = (VbfGroup*) _tmp25_;
			group_added = FALSE;
			{
				ValaList* _tmp26_ = NULL;
				ValaList* _target_list;
				gint _tmp27_;
				gint _target_size;
				gint _target_index;
				_tmp26_ = vbf_group_get_targets (group);
				_target_list = _tmp26_;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _target_list);
				_target_size = _tmp27_;
				_target_index = -1;
				while (TRUE) {
					gpointer _tmp28_ = NULL;
					VbfTarget* target;
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_;
					_target_index = _target_index + 1;
					if (!(_target_index < _target_size)) {
						break;
					}
					_tmp28_ = vala_list_get (_target_list, _target_index);
					target = (VbfTarget*) _tmp28_;
					_tmp30_ = vbf_target_has_sources_of_type (target, VBF_FILE_TYPES_VALA_SOURCE);
					if (_tmp30_) {
						_tmp29_ = TRUE;
					} else {
						ValaList* _tmp31_ = NULL;
						ValaList* _tmp32_;
						gint _tmp33_;
						_tmp31_ = vbf_target_get_files (target);
						_tmp32_ = _tmp31_;
						_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
						_tmp29_ = _tmp33_ > 0;
						_vala_iterable_unref0 (_tmp32_);
					}
					if (_tmp29_) {
						GtkTreeIter target_iter;
						GtkTreeIter vapi_group_iter;
						gboolean target_added;
						gboolean vapi_group_added;
						target_iter = groups_iter;
						vapi_group_iter = target_iter;
						target_added = FALSE;
						{
							ValaList* _tmp34_ = NULL;
							ValaList* _source_list;
							gint _tmp35_;
							gint _source_size;
							gint _source_index;
							_tmp34_ = vbf_target_get_sources (target);
							_source_list = _tmp34_;
							_tmp35_ = vala_collection_get_size ((ValaCollection*) _source_list);
							_source_size = _tmp35_;
							_source_index = -1;
							while (TRUE) {
								gpointer _tmp36_ = NULL;
								VbfSource* source;
								gboolean _tmp37_ = FALSE;
								gboolean _tmp38_ = FALSE;
								gboolean _tmp39_ = FALSE;
								gboolean _tmp40_;
								GtkTreeIter source_iter = {0};
								GtkTreeIter _tmp50_ = {0};
								GdkPixbuf* _tmp51_ = NULL;
								_source_index = _source_index + 1;
								if (!(_source_index < _source_size)) {
									break;
								}
								_tmp36_ = vala_list_get (_source_list, _source_index);
								source = (VbfSource*) _tmp36_;
								_tmp40_ = g_str_has_prefix (((VbfFile*) source)->name, ".");
								if (_tmp40_) {
									_tmp39_ = TRUE;
								} else {
									gboolean _tmp41_;
									_tmp41_ = g_str_has_suffix (((VbfFile*) source)->name, ".c");
									_tmp39_ = _tmp41_;
								}
								if (_tmp39_) {
									_tmp38_ = TRUE;
								} else {
									gboolean _tmp42_;
									_tmp42_ = g_str_has_suffix (((VbfFile*) source)->name, ".h");
									_tmp38_ = _tmp42_;
								}
								if (_tmp38_) {
									_tmp37_ = TRUE;
								} else {
									gboolean _tmp43_;
									_tmp43_ = g_str_has_suffix (((VbfFile*) source)->name, ".stamp");
									_tmp37_ = _tmp43_;
								}
								if (_tmp37_) {
									_g_object_unref0 (source);
									continue;
								}
								if (!group_added) {
									GtkTreeIter _tmp44_ = {0};
									GtkTreeIter* _tmp45_;
									GdkPixbuf* _tmp46_ = NULL;
									gtk_tree_store_append (self->priv->_model, &_tmp44_, &groups_iter);
									_g_free0 (group_iter);
									_tmp45_ = __gtk_tree_iter_dup0 (&_tmp44_);
									group_iter = _tmp45_;
									_tmp46_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU);
									gtk_tree_store_set (self->priv->_model, group_iter, 0, _tmp46_, 1, group->name, 2, "group-targets", 3, group, 4, "2", -1);
									group_added = TRUE;
								}
								if (!target_added) {
									GtkTreeIter _tmp47_ = {0};
									GdkPixbuf* _tmp48_ = NULL;
									GdkPixbuf* _tmp49_;
									gtk_tree_store_append (self->priv->_model, &_tmp47_, group_iter);
									target_iter = _tmp47_;
									_tmp48_ = vtg_utils_get_small_icon_for_target_type (target->type);
									_tmp49_ = _tmp48_;
									gtk_tree_store_set (self->priv->_model, &target_iter, 0, _tmp49_, 1, target->name, 2, target->id, 3, target, 4, group->name, -1);
									_g_object_unref0 (_tmp49_);
									target_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &_tmp50_, &target_iter);
								source_iter = _tmp50_;
								_tmp51_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_FILE, GTK_ICON_SIZE_MENU);
								gtk_tree_store_set (self->priv->_model, &source_iter, 0, _tmp51_, 1, ((VbfFile*) source)->name, 2, ((VbfFile*) source)->uri, 3, source, 4, ((VbfFile*) source)->name, -1);
								_g_object_unref0 (source);
							}
							_vala_iterable_unref0 (_source_list);
						}
						{
							ValaList* _tmp52_ = NULL;
							ValaList* _file_list;
							gint _tmp53_;
							gint _file_size;
							gint _file_index;
							_tmp52_ = vbf_target_get_files (target);
							_file_list = _tmp52_;
							_tmp53_ = vala_collection_get_size ((ValaCollection*) _file_list);
							_file_size = _tmp53_;
							_file_index = -1;
							while (TRUE) {
								gpointer _tmp54_ = NULL;
								VbfFile* file;
								GtkTreeIter file_iter = {0};
								GtkTreeIter _tmp61_ = {0};
								GdkPixbuf* _tmp62_ = NULL;
								_file_index = _file_index + 1;
								if (!(_file_index < _file_size)) {
									break;
								}
								_tmp54_ = vala_list_get (_file_list, _file_index);
								file = (VbfFile*) _tmp54_;
								if (!group_added) {
									GtkTreeIter _tmp55_ = {0};
									GtkTreeIter* _tmp56_;
									GdkPixbuf* _tmp57_ = NULL;
									gtk_tree_store_append (self->priv->_model, &_tmp55_, &groups_iter);
									_g_free0 (group_iter);
									_tmp56_ = __gtk_tree_iter_dup0 (&_tmp55_);
									group_iter = _tmp56_;
									_tmp57_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU);
									gtk_tree_store_set (self->priv->_model, group_iter, 0, _tmp57_, 1, group->name, 2, "group-targets", 3, group, 4, "2", -1);
									group_added = TRUE;
								}
								if (!target_added) {
									GtkTreeIter _tmp58_ = {0};
									GdkPixbuf* _tmp59_ = NULL;
									GdkPixbuf* _tmp60_;
									gtk_tree_store_append (self->priv->_model, &_tmp58_, group_iter);
									target_iter = _tmp58_;
									_tmp59_ = vtg_utils_get_small_icon_for_target_type (target->type);
									_tmp60_ = _tmp59_;
									gtk_tree_store_set (self->priv->_model, &target_iter, 0, _tmp60_, 1, target->name, 2, target->id, 3, target, 4, group->name, -1);
									_g_object_unref0 (_tmp60_);
									target_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &_tmp61_, &target_iter);
								file_iter = _tmp61_;
								_tmp62_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) image, GTK_STOCK_FILE, GTK_ICON_SIZE_MENU);
								gtk_tree_store_set (self->priv->_model, &file_iter, 0, _tmp62_, 1, file->name, 2, file->uri, 3, file, 4, file->name, -1);
								_g_object_unref0 (file);
							}
							_vala_iterable_unref0 (_file_list);
						}
						vapi_group_added = FALSE;
						{
							ValaList* _tmp63_ = NULL;
							ValaList* _package_list;
							gint _tmp64_;
							gint _package_size;
							gint _package_index;
							_tmp63_ = vbf_target_get_packages (target);
							_package_list = _tmp63_;
							_tmp64_ = vala_collection_get_size ((ValaCollection*) _package_list);
							_package_size = _tmp64_;
							_package_index = -1;
							while (TRUE) {
								gpointer _tmp65_ = NULL;
								VbfPackage* package;
								GtkTreeIter vapi_iter = {0};
								GtkTreeIter _tmp68_ = {0};
								const gchar* _tmp69_ = NULL;
								_package_index = _package_index + 1;
								if (!(_package_index < _package_size)) {
									break;
								}
								_tmp65_ = vala_list_get (_package_list, _package_index);
								package = (VbfPackage*) _tmp65_;
								if (!vapi_group_added) {
									GtkTreeIter _tmp66_ = {0};
									const gchar* _tmp67_ = NULL;
									gtk_tree_store_append (self->priv->_model, &_tmp66_, &target_iter);
									vapi_group_iter = _tmp66_;
									_tmp67_ = _ ("Referenced packages");
									gtk_tree_store_set (self->priv->_model, &vapi_group_iter, 0, vtg_utils_icon_folder_packages, 1, _tmp67_, 2, "vapi-targets", 3, NULL, 4, "2", -1);
									vapi_group_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &_tmp68_, &vapi_group_iter);
								vapi_iter = _tmp68_;
								_tmp69_ = vbf_package_get_uri (package);
								gtk_tree_store_set (self->priv->_model, &vapi_iter, 0, vtg_utils_icon_package, 1, package->name, 2, _tmp69_, 3, package, 4, package->name, -1);
								_g_object_unref0 (package);
							}
							_vala_iterable_unref0 (_package_list);
						}
					}
					_g_object_unref0 (target);
				}
				_vala_iterable_unref0 (_target_list);
			}
			_g_object_unref0 (group);
		}
		_vala_iterable_unref0 (_group_list);
	}
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_model, 4, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_model, 4, _vtg_project_manager_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (image);
	_g_free0 (group_iter);
	_g_free0 (modules_iter);
}


static void vtg_project_manager_parse_project (VtgProjectManager* self) {
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	vala_collection_clear ((ValaCollection*) self->exec_targets);
	vala_collection_clear ((ValaCollection*) self->all_vala_sources);
	_g_free0 (self->changelog_uri);
	self->changelog_uri = NULL;
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _group_list;
		gint _tmp1_;
		gint _group_size;
		gint _group_index;
		_tmp0_ = vbf_project_get_groups (self->priv->_project);
		_group_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _group_list);
		_group_size = _tmp1_;
		_group_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfGroup* group;
			_group_index = _group_index + 1;
			if (!(_group_index < _group_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_group_list, _group_index);
			group = (VbfGroup*) _tmp2_;
			{
				ValaList* _tmp3_ = NULL;
				ValaList* _target_list;
				gint _tmp4_;
				gint _target_size;
				gint _target_index;
				_tmp3_ = vbf_group_get_targets (group);
				_target_list = _tmp3_;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _target_list);
				_target_size = _tmp4_;
				_target_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					VbfTarget* target;
					gboolean _tmp6_ = FALSE;
					_target_index = _target_index + 1;
					if (!(_target_index < _target_size)) {
						break;
					}
					_tmp5_ = vala_list_get (_target_list, _target_index);
					target = (VbfTarget*) _tmp5_;
					if (target->type == VBF_TARGET_TYPES_PROGRAM) {
						_tmp6_ = TRUE;
					} else {
						gboolean _tmp7_ = FALSE;
						if (target->type == VBF_TARGET_TYPES_BUILT_SOURCES) {
							gboolean _tmp8_;
							_tmp8_ = g_str_has_prefix (target->name, "lib");
							_tmp7_ = !_tmp8_;
						} else {
							_tmp7_ = FALSE;
						}
						_tmp6_ = _tmp7_;
					}
					if (_tmp6_) {
						vala_collection_add ((ValaCollection*) self->exec_targets, target);
					}
					{
						ValaList* _tmp9_ = NULL;
						ValaList* _source_list;
						gint _tmp10_;
						gint _source_size;
						gint _source_index;
						_tmp9_ = vbf_target_get_sources (target);
						_source_list = _tmp9_;
						_tmp10_ = vala_collection_get_size ((ValaCollection*) _source_list);
						_source_size = _tmp10_;
						_source_index = -1;
						while (TRUE) {
							gpointer _tmp11_ = NULL;
							VbfSource* source;
							_source_index = _source_index + 1;
							if (!(_source_index < _source_size)) {
								break;
							}
							_tmp11_ = vala_list_get (_source_list, _source_index);
							source = (VbfSource*) _tmp11_;
							if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
								vala_collection_add ((ValaCollection*) self->all_vala_sources, source);
							}
							_g_object_unref0 (source);
						}
						_vala_iterable_unref0 (_source_list);
					}
					_g_object_unref0 (target);
				}
				_vala_iterable_unref0 (_target_list);
			}
			_g_object_unref0 (group);
		}
		_vala_iterable_unref0 (_group_list);
	}
	_tmp12_ = g_build_filename (self->priv->_project->working_dir, "changelog", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_EXISTS);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = g_build_filename (self->priv->_project->working_dir, "changelog", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_filename_to_uri (_tmp17_, NULL, &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch39_g_error;
		}
		_g_free0 (self->changelog_uri);
		self->changelog_uri = _tmp20_;
	} else {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp21_ = g_build_filename (self->priv->_project->working_dir, "ChangeLog", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_test (_tmp22_, G_FILE_TEST_EXISTS);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		if (_tmp24_) {
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp25_ = g_build_filename (self->priv->_project->working_dir, "ChangeLog", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_filename_to_uri (_tmp26_, NULL, &_inner_error_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp26_);
			_tmp29_ = _tmp28_;
			if (_inner_error_ != NULL) {
				goto __catch39_g_error;
			}
			_g_free0 (self->changelog_uri);
			self->changelog_uri = _tmp29_;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectmanager.vala:609: error %s converting changelog file to uri", e->message);
		_g_error_free0 (e);
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gint vtg_project_manager_sort_model (VtgProjectManager* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gchar* vala = NULL;
	gchar* valb = NULL;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, a, 4, &vala, -1);
	gtk_tree_model_get (model, b, 4, &valb, -1);
	_tmp0_ = vtg_path_utils_compare_vala_filenames (vala, valb);
	result = _tmp0_;
	_g_free0 (valb);
	_g_free0 (vala);
	return result;
}


GtkTreeModel* vtg_project_manager_get_model (VtgProjectManager* self) {
	GtkTreeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GtkTreeModel*) self->priv->_model;
	return result;
}


VbfProject* vtg_project_manager_get_project (VtgProjectManager* self) {
	VbfProject* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project;
	return result;
}


gboolean vtg_project_manager_get_automanaged (VtgProjectManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automanaged;
	return result;
}


void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automanaged = value;
	g_object_notify ((GObject *) self, "automanaged");
}


gboolean vtg_project_manager_get_enable_completion (VtgProjectManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_completion;
	return result;
}


void vtg_project_manager_set_enable_completion (VtgProjectManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_enable_completion != value) {
		self->priv->_enable_completion = value;
		if (self->priv->_enable_completion) {
			vtg_project_manager_setup_completions (self);
		} else {
			vtg_project_manager_cleanup_completions (self);
		}
	}
	g_object_notify ((GObject *) self, "enable-completion");
}


ValaHashMap* vtg_project_manager_get_completions (VtgProjectManager* self) {
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_completions;
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void vtg_project_manager_class_init (VtgProjectManagerClass * klass) {
	vtg_project_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_project_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vtg_project_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_MODEL, g_param_spec_object ("model", "model", "model", GTK_TYPE_TREE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_PROJECT, g_param_spec_object ("project", "project", "project", VBF_TYPE_PROJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_AUTOMANAGED, g_param_spec_boolean ("automanaged", "automanaged", "automanaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_ENABLE_COMPLETION, g_param_spec_boolean ("enable-completion", "enable-completion", "enable-completion", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_COMPLETIONS, vala_param_spec_map ("completions", "completions", "completions", VALA_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("updated", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("symbol_cache_building", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, VTG_TYPE_PROJECT_MANAGER);
	g_signal_new ("symbol_cache_builded", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, VTG_TYPE_PROJECT_MANAGER);
	g_signal_new ("completion_begin_parsing", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, VTG_TYPE_PROJECT_MANAGER, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("completion_end_parsing", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, VTG_TYPE_PROJECT_MANAGER, AFRODITE_TYPE_COMPLETION_ENGINE);
}


static void vtg_project_manager_instance_init (VtgProjectManager * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	self->priv = VTG_PROJECT_MANAGER_GET_PRIVATE (self);
	self->priv->_project = NULL;
	self->priv->in_update = FALSE;
	self->priv->_completions = NULL;
	self->priv->parser_thread_count = 0;
	self->priv->_sc_building = FALSE;
	self->filename = NULL;
	self->is_default = FALSE;
	_tmp0_ = vala_array_list_new (VBF_TYPE_TARGET, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->exec_targets = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VBF_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->all_vala_sources = (ValaList*) _tmp1_;
	self->vcs_type = VTG_VCS_TYPES_NONE;
	self->changelog_uri = NULL;
}


static void vtg_project_manager_finalize (GObject* obj) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (obj);
	vtg_project_manager_cleanup_completions (self);
	_g_object_unref0 (self->priv->_project);
	_g_object_unref0 (self->priv->_model);
	_vala_map_unref0 (self->priv->_completions);
	_g_free0 (self->filename);
	_vala_iterable_unref0 (self->exec_targets);
	_vala_iterable_unref0 (self->all_vala_sources);
	_g_free0 (self->changelog_uri);
	G_OBJECT_CLASS (vtg_project_manager_parent_class)->finalize (obj);
}


GType vtg_project_manager_get_type (void) {
	return vtg_project_manager_type_id;
}


GType vtg_project_manager_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectManager), 0, (GInstanceInitFunc) vtg_project_manager_instance_init, NULL };
	vtg_project_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectManager", &g_define_type_info, 0);
	return vtg_project_manager_type_id;
}


static void _vala_vtg_project_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (object);
	switch (property_id) {
		case VTG_PROJECT_MANAGER_MODEL:
		g_value_set_object (value, vtg_project_manager_get_model (self));
		break;
		case VTG_PROJECT_MANAGER_PROJECT:
		g_value_set_object (value, vtg_project_manager_get_project (self));
		break;
		case VTG_PROJECT_MANAGER_AUTOMANAGED:
		g_value_set_boolean (value, vtg_project_manager_get_automanaged (self));
		break;
		case VTG_PROJECT_MANAGER_ENABLE_COMPLETION:
		g_value_set_boolean (value, vtg_project_manager_get_enable_completion (self));
		break;
		case VTG_PROJECT_MANAGER_COMPLETIONS:
		vala_value_set_map (value, vtg_project_manager_get_completions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vtg_project_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (object);
	switch (property_id) {
		case VTG_PROJECT_MANAGER_AUTOMANAGED:
		vtg_project_manager_set_automanaged (self, g_value_get_boolean (value));
		break;
		case VTG_PROJECT_MANAGER_ENABLE_COMPLETION:
		vtg_project_manager_set_enable_completion (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



