/* vtgbracketcompletion.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgbracketcompletion.vala, do not modify */

/*
 *  vtgbracketcompletion.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-view.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gdk/gdkkeysyms.h>
#include <float.h>
#include <math.h>


#define VTG_TYPE_BRACKET_COMPLETION (vtg_bracket_completion_get_type ())
#define VTG_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletion))
#define VTG_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))
#define VTG_IS_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_IS_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_BRACKET_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))

typedef struct _VtgBracketCompletion VtgBracketCompletion;
typedef struct _VtgBracketCompletionClass VtgBracketCompletionClass;
typedef struct _VtgBracketCompletionPrivate VtgBracketCompletionPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VtgBracketCompletion {
	GObject parent_instance;
	VtgBracketCompletionPrivate * priv;
};

struct _VtgBracketCompletionClass {
	GObjectClass parent_class;
};

struct _VtgBracketCompletionPrivate {
	VtgPluginInstance* _plugin_instance;
	GeditView* _view;
	gchar* tab_chars;
};


static gpointer vtg_bracket_completion_parent_class = NULL;
static GType vtg_bracket_completion_type_id = 0;

GType vtg_bracket_completion_get_type (void) G_GNUC_CONST;
GType vtg_bracket_completion_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_BRACKET_COMPLETION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionPrivate))
enum  {
	VTG_BRACKET_COMPLETION_DUMMY_PROPERTY
};
VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view);
VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view);
static void vtg_bracket_completion_connect_view (VtgBracketCompletion* self, GeditView* view);
void vtg_bracket_completion_deactivate (VtgBracketCompletion* self);
static void vtg_bracket_completion_disconnect_view (VtgBracketCompletion* self, GeditView* view);
static gboolean vtg_bracket_completion_on_view_key_press (GeditView* sender, GdkEventKey* evt, VtgBracketCompletion* instance);
static gboolean vtg_bracket_completion_enclose_selection_with_delimiters (VtgBracketCompletion* self, GtkTextBuffer* src, const gchar* start_delimiter, const gchar* end_delimiter);
static void vtg_bracket_completion_insert_chars (VtgBracketCompletion* self, GtkTextBuffer* src, const gchar* chars);
static void vtg_bracket_completion_move_backwards (VtgBracketCompletion* self, GtkTextBuffer* src, gint count);
static gchar* vtg_bracket_completion_subtract_indentation (VtgBracketCompletion* self, const gchar* indentation, gint levels);
static const gchar* vtg_bracket_completion_current_indentation_text (VtgBracketCompletion* self, GtkTextBuffer* src);
static void vtg_bracket_completion_backward_skip_spaces (VtgBracketCompletion* self, GtkTextIter* start);
static gboolean vtg_bracket_completion_find_char (VtgBracketCompletion* self, GtkTextIter* start, gunichar char_to_find, gunichar complementary_char, gunichar* stop_to_chars, int stop_to_chars_length1);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
void vtg_utils_trace (const gchar* format, ...);
gchar* vtg_parser_utils_get_line_to_end (GtkTextIter* start);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
static void vtg_bracket_completion_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view) {
	VtgBracketCompletion * self = NULL;
	GeditView* _tmp0_;
	GSettings* _tmp1_ = NULL;
	GSettings* gs;
	gboolean _tmp2_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	self = (VtgBracketCompletion*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	_tmp0_ = _g_object_ref0 (view);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.gedit.preferences.editor");
	gs = _tmp1_;
	_tmp2_ = g_settings_get_boolean (gs, "insert-spaces");
	if (_tmp2_) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = g_settings_get_int (gs, "tabs-size");
		_tmp4_ = g_strnfill ((gsize) _tmp3_, ' ');
		_g_free0 (self->priv->tab_chars);
		self->priv->tab_chars = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("\t");
		_g_free0 (self->priv->tab_chars);
		self->priv->tab_chars = _tmp5_;
	}
	vtg_bracket_completion_connect_view (self, self->priv->_view);
	_g_object_unref0 (gs);
	return self;
}


VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view) {
	return vtg_bracket_completion_construct (VTG_TYPE_BRACKET_COMPLETION, plugin_instance, view);
}


void vtg_bracket_completion_deactivate (VtgBracketCompletion* self) {
	g_return_if_fail (self != NULL);
	vtg_bracket_completion_disconnect_view (self, self->priv->_view);
}


static void vtg_bracket_completion_connect_view (VtgBracketCompletion* self, GeditView* view) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_signal_connect (view, "key-press-event", (GCallback) vtg_bracket_completion_on_view_key_press, self);
}


static void vtg_bracket_completion_disconnect_view (VtgBracketCompletion* self, GeditView* view) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_signal_handlers_disconnect_by_func (view, (void*) vtg_bracket_completion_on_view_key_press, self);
}


static gboolean vtg_bracket_completion_enclose_selection_with_delimiters (VtgBracketCompletion* self, GtkTextBuffer* src, const gchar* start_delimiter, const gchar* end_delimiter) {
	gboolean result = FALSE;
	GtkTextIter sel_start = {0};
	GtkTextIter sel_end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gchar* text;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (start_delimiter != NULL, FALSE);
	gtk_text_buffer_get_selection_bounds (src, &_tmp0_, &_tmp1_);
	sel_start = _tmp0_;
	sel_end = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_text (src, &sel_start, &sel_end, TRUE);
	text = _tmp2_;
	if (end_delimiter == NULL) {
		end_delimiter = start_delimiter;
	}
	_tmp4_ = g_str_has_prefix (text, start_delimiter);
	if (_tmp4_ == FALSE) {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (text, end_delimiter);
		_tmp3_ = _tmp5_ == FALSE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkTextMark* _tmp6_ = NULL;
		GtkTextMark* mark;
		GtkTextIter pos = {0};
		gchar* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_;
		_tmp6_ = gtk_text_buffer_get_insert (src);
		mark = GTK_TEXT_MARK (_tmp6_);
		_tmp7_ = g_strdup_printf ("%s%s%s", start_delimiter, text, end_delimiter);
		_g_free0 (text);
		text = _tmp7_;
		gtk_text_buffer_begin_user_action (src);
		gtk_text_buffer_delete_selection (src, TRUE, TRUE);
		gtk_text_buffer_get_iter_at_mark (src, &_tmp8_, mark);
		pos = _tmp8_;
		_tmp9_ = strlen (text);
		gtk_text_buffer_insert (src, &pos, text, (gint) _tmp9_);
		gtk_text_buffer_end_user_action (src);
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	result = FALSE;
	_g_free0 (text);
	return result;
}


static void vtg_bracket_completion_insert_chars (VtgBracketCompletion* self, GtkTextBuffer* src, const gchar* chars) {
	GtkTextMark* _tmp0_ = NULL;
	GtkTextMark* mark;
	GtkTextIter pos = {0};
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (chars != NULL);
	_tmp0_ = gtk_text_buffer_get_insert (src);
	mark = GTK_TEXT_MARK (_tmp0_);
	gtk_text_buffer_get_iter_at_mark (src, &_tmp1_, mark);
	pos = _tmp1_;
	gtk_text_buffer_begin_user_action (src);
	_tmp2_ = strlen (chars);
	gtk_text_buffer_insert (src, &pos, chars, (gint) _tmp2_);
	gtk_text_buffer_end_user_action (src);
}


static void vtg_bracket_completion_move_backwards (VtgBracketCompletion* self, GtkTextBuffer* src, gint count) {
	GtkTextMark* _tmp0_ = NULL;
	GtkTextMark* mark;
	GtkTextIter pos = {0};
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = gtk_text_buffer_get_insert (src);
	mark = GTK_TEXT_MARK (_tmp0_);
	gtk_text_buffer_get_iter_at_mark (src, &_tmp1_, mark);
	pos = _tmp1_;
	gtk_text_iter_backward_chars (&pos, count);
	gtk_text_buffer_place_cursor (src, &pos);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* vtg_bracket_completion_subtract_indentation (VtgBracketCompletion* self, const gchar* indentation, gint levels) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* current;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (indentation != NULL, NULL);
	_tmp0_ = g_strdup ("");
	current = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_ = NULL;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < levels)) {
					break;
				}
				_tmp2_ = g_strconcat (current, self->priv->tab_chars, NULL);
				_g_free0 (current);
				current = _tmp2_;
			}
		}
	}
	_tmp3_ = strlen (indentation);
	_tmp4_ = strlen (current);
	if (_tmp3_ < _tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_free0 (current);
		return result;
	}
	_tmp6_ = strlen (current);
	_tmp7_ = string_substring (indentation, (glong) _tmp6_, (glong) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s", _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	result = _tmp10_;
	_g_free0 (current);
	return result;
}


static const gchar* vtg_bracket_completion_current_indentation_text (VtgBracketCompletion* self, GtkTextBuffer* src) {
	const gchar* result = NULL;
	GtkTextMark* _tmp0_ = NULL;
	GtkTextMark* mark;
	GtkTextIter end = {0};
	GtkTextIter start = {0};
	const gchar* text;
	gint col = 0;
	gint line = 0;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = gtk_text_buffer_get_insert (src);
	mark = GTK_TEXT_MARK (_tmp0_);
	text = "";
	gtk_text_buffer_get_iter_at_mark (src, &_tmp1_, mark);
	end = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line_offset (&end);
	col = _tmp2_;
	if (col > 0) {
		gint _tmp3_;
		gunichar _tmp4_;
		gunichar ch;
		gboolean _tmp5_;
		gboolean _tmp12_;
		_tmp3_ = gtk_text_iter_get_line (&end);
		line = _tmp3_;
		gtk_text_iter_set_line_offset (&end, 0);
		start = end;
		_tmp4_ = gtk_text_iter_get_char (&end);
		ch = _tmp4_;
		_tmp5_ = g_unichar_isspace (ch);
		if (_tmp5_) {
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp7_;
				_tmp6_ = gtk_text_iter_forward_char (&end);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = gtk_text_iter_get_line (&end);
				if (line != _tmp7_) {
					gtk_text_iter_backward_char (&end);
					break;
				} else {
					gboolean _tmp8_;
					_tmp8_ = gtk_text_iter_starts_word (&end);
					if (_tmp8_) {
						break;
					} else {
						gint _tmp9_;
						_tmp9_ = gtk_text_iter_get_line_offset (&end);
						if (_tmp9_ >= col) {
							break;
						} else {
							gunichar _tmp10_;
							gboolean _tmp11_;
							_tmp10_ = gtk_text_iter_get_char (&end);
							ch = _tmp10_;
							_tmp11_ = g_unichar_isspace (ch);
							if (_tmp11_ == FALSE) {
								break;
							}
						}
					}
				}
			}
		}
		_tmp12_ = gtk_text_iter_equal (&start, &end);
		if (!_tmp12_) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = gtk_text_iter_get_text (&start, &end);
			text = _tmp13_;
		}
	}
	result = text;
	return result;
}


static void vtg_bracket_completion_backward_skip_spaces (VtgBracketCompletion* self, GtkTextIter* start) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gunichar _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = gtk_text_iter_backward_char (start);
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = gtk_text_iter_get_char (start);
		_tmp2_ = g_unichar_isspace (_tmp1_);
		if (!_tmp2_) {
			break;
		}
	}
}


static gboolean vtg_bracket_completion_find_char (VtgBracketCompletion* self, GtkTextIter* start, gunichar char_to_find, gunichar complementary_char, gunichar* stop_to_chars, int stop_to_chars_length1) {
	gboolean result = FALSE;
	gboolean _result_;
	gint level;
	GtkTextIter curr;
	g_return_val_if_fail (self != NULL, FALSE);
	_result_ = FALSE;
	level = 0;
	curr = *start;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gunichar _tmp2_;
			gunichar ch;
			gboolean stop_char_found;
			if (!_tmp0_) {
				gboolean _tmp1_;
				_tmp1_ = gtk_text_iter_forward_char (&curr);
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = gtk_text_iter_get_char (&curr);
			ch = _tmp2_;
			stop_char_found = FALSE;
			{
				gunichar* stop_to_char_collection;
				int stop_to_char_collection_length1;
				int stop_to_char_it;
				stop_to_char_collection = stop_to_chars;
				stop_to_char_collection_length1 = stop_to_chars_length1;
				for (stop_to_char_it = 0; stop_to_char_it < stop_to_chars_length1; stop_to_char_it = stop_to_char_it + 1) {
					gunichar stop_to_char;
					stop_to_char = stop_to_char_collection[stop_to_char_it];
					{
						if (ch == stop_to_char) {
							stop_char_found = TRUE;
							break;
						}
					}
				}
			}
			if (stop_char_found) {
				break;
			} else {
				if (ch == char_to_find) {
					if (level == 0) {
						_result_ = TRUE;
						break;
					} else {
						level--;
					}
				} else {
					if (ch == complementary_char) {
						level++;
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean vtg_bracket_completion_on_view_key_press (GeditView* sender, GdkEventKey* evt, VtgBracketCompletion* instance) {
	gboolean result = FALSE;
	gboolean _result_;
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (instance != NULL, FALSE);
	_result_ = FALSE;
	if (((*evt).state & GDK_MOD1_MASK) == 0) {
		GtkTextBuffer* _tmp0_ = NULL;
		GtkSourceBuffer* _tmp1_;
		GtkSourceBuffer* src;
		GtkTextMark* _tmp2_ = NULL;
		GtkTextMark* mark;
		GtkTextIter pos = {0};
		GtkTextIter _tmp3_ = {0};
		guint32 _tmp4_;
		gunichar ch;
		gboolean _tmp5_ = FALSE;
		const gchar* indent = NULL;
		gchar* buffer = NULL;
		_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) sender);
		_tmp1_ = _g_object_ref0 (GTK_SOURCE_BUFFER (_tmp0_));
		src = _tmp1_;
		_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) src);
		mark = GTK_TEXT_MARK (_tmp2_);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp3_, mark);
		pos = _tmp3_;
		_tmp4_ = gdk_keyval_to_unicode ((*evt).keyval);
		ch = (gunichar) _tmp4_;
		if ((*evt).keyval != GDK_KEY_Return) {
			_tmp5_ = ((*evt).state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK)) == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp6_;
			_tmp6_ = vtg_utils_is_inside_comment_or_literal (src, &pos);
			if (_tmp6_) {
				result = _result_;
				_g_object_unref0 (src);
				return result;
			}
		}
		if (ch == '(') {
			gboolean inside_block;
			GtkTextIter start;
			gboolean prev_char_is_parenthesis;
			gboolean line_has_semicolon;
			gunichar _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gint _tmp41_;
			gboolean _tmp42_;
			inside_block = FALSE;
			start = pos;
			while (TRUE) {
				gboolean _tmp7_;
				gunichar _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = gtk_text_iter_backward_char (&start);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = gtk_text_iter_get_char (&start);
				ch = _tmp8_;
				if (ch == ';') {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = ch == ')';
				}
				if (_tmp9_) {
					inside_block = TRUE;
					break;
				} else {
					if (ch == '{') {
						while (TRUE) {
							gboolean _tmp10_ = FALSE;
							gunichar _tmp12_;
							gboolean _tmp13_ = FALSE;
							if (!inside_block) {
								gboolean _tmp11_;
								_tmp11_ = gtk_text_iter_backward_char (&start);
								_tmp10_ = _tmp11_;
							} else {
								_tmp10_ = FALSE;
							}
							if (!_tmp10_) {
								break;
							}
							_tmp12_ = gtk_text_iter_get_char (&start);
							ch = _tmp12_;
							if (ch != ' ') {
								_tmp13_ = ch != '\t';
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								if (ch == ')') {
									inside_block = TRUE;
								} else {
									break;
								}
							}
						}
						break;
					} else {
						gboolean _tmp14_ = FALSE;
						gboolean _tmp15_ = FALSE;
						gboolean _tmp16_ = FALSE;
						if (ch == '}') {
							_tmp16_ = TRUE;
						} else {
							_tmp16_ = ch == '(';
						}
						if (_tmp16_) {
							_tmp15_ = TRUE;
						} else {
							_tmp15_ = ch == '|';
						}
						if (_tmp15_) {
							_tmp14_ = TRUE;
						} else {
							_tmp14_ = ch == '&';
						}
						if (_tmp14_) {
							inside_block = FALSE;
							break;
						}
					}
				}
			}
			if (inside_block) {
				gboolean _tmp17_;
				start = pos;
				_tmp17_ = gtk_text_iter_backward_word_start (&start);
				if (_tmp17_) {
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					_tmp18_ = gtk_text_iter_get_slice (&start, &pos);
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (buffer);
					buffer = _tmp19_;
					_tmp20_ = string_replace (buffer, " ", "");
					_tmp21_ = _tmp20_;
					_tmp22_ = string_replace (_tmp21_, "\t", "");
					_g_free0 (buffer);
					buffer = _tmp22_;
					_g_free0 (_tmp21_);
					if (g_strcmp0 (buffer, "if") == 0) {
						_tmp25_ = TRUE;
					} else {
						_tmp25_ = g_strcmp0 (buffer, "do") == 0;
					}
					if (_tmp25_) {
						_tmp24_ = TRUE;
					} else {
						_tmp24_ = g_strcmp0 (buffer, "while") == 0;
					}
					if (_tmp24_) {
						_tmp23_ = TRUE;
					} else {
						gboolean _tmp26_;
						_tmp26_ = g_str_has_prefix (buffer, "for");
						_tmp23_ = _tmp26_;
					}
					if (_tmp23_) {
						inside_block = FALSE;
					} else {
						while (TRUE) {
							gboolean _tmp27_;
							gunichar _tmp28_;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
							gboolean _tmp31_ = FALSE;
							gboolean _tmp32_ = FALSE;
							_tmp27_ = gtk_text_iter_backward_char (&start);
							if (!_tmp27_) {
								break;
							}
							_tmp28_ = gtk_text_iter_get_char (&start);
							ch = _tmp28_;
							if (ch == ';') {
								_tmp32_ = TRUE;
							} else {
								_tmp32_ = ch == '{';
							}
							if (_tmp32_) {
								_tmp31_ = TRUE;
							} else {
								_tmp31_ = ch == '=';
							}
							if (_tmp31_) {
								_tmp30_ = TRUE;
							} else {
								_tmp30_ = ch == '.';
							}
							if (_tmp30_) {
								_tmp29_ = TRUE;
							} else {
								_tmp29_ = ch == ')';
							}
							if (_tmp29_) {
								break;
							} else {
								gboolean _tmp33_ = FALSE;
								gboolean _tmp34_ = FALSE;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								if (ch != '\t') {
									_tmp36_ = ch != ' ';
								} else {
									_tmp36_ = FALSE;
								}
								if (_tmp36_) {
									_tmp35_ = ch != '\n';
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									_tmp34_ = ch != '\r';
								} else {
									_tmp34_ = FALSE;
								}
								if (_tmp34_) {
									gboolean _tmp37_;
									_tmp37_ = g_unichar_isalnum (ch);
									_tmp33_ = !_tmp37_;
								} else {
									_tmp33_ = FALSE;
								}
								if (_tmp33_) {
									vtg_utils_trace ("vtgbracketcompletion.vala:296: not a block %u", (guint) ch);
									inside_block = FALSE;
									break;
								}
							}
						}
					}
				}
			}
			prev_char_is_parenthesis = FALSE;
			line_has_semicolon = FALSE;
			start = pos;
			vtg_bracket_completion_backward_skip_spaces (instance, &start);
			_tmp38_ = gtk_text_iter_get_char (&start);
			prev_char_is_parenthesis = _tmp38_ == '(';
			_tmp39_ = vtg_parser_utils_get_line_to_end (&pos);
			_tmp40_ = _tmp39_;
			_tmp41_ = string_last_index_of (_tmp40_, ";", 0);
			line_has_semicolon = _tmp41_ != (-1);
			_g_free0 (_tmp40_);
			_tmp42_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src);
			if (_tmp42_) {
				gboolean _tmp43_;
				_tmp43_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "(", ")");
				if (_tmp43_) {
					gboolean _tmp44_ = FALSE;
					GtkTextIter _tmp45_ = {0};
					if (inside_block) {
						_tmp44_ = !line_has_semicolon;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ";");
					}
					gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp45_, mark);
					pos = _tmp45_;
					gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
					_result_ = TRUE;
				}
			} else {
				gboolean _tmp46_ = FALSE;
				if (prev_char_is_parenthesis) {
					_tmp46_ = TRUE;
				} else {
					gunichar* _tmp47_ = NULL;
					gunichar* _tmp48_;
					gint _tmp48__length1;
					gboolean _tmp49_;
					_tmp47_ = g_new0 (gunichar, 2);
					_tmp47_[0] = (gunichar) '}';
					_tmp47_[1] = (gunichar) ';';
					_tmp48_ = _tmp47_;
					_tmp48__length1 = 2;
					_tmp49_ = vtg_bracket_completion_find_char (instance, &pos, (gunichar) ')', (gunichar) '(', _tmp48_, 2);
					_tmp46_ = !_tmp49_;
					_tmp48_ = (g_free (_tmp48_), NULL);
				}
				if (_tmp46_) {
					gboolean _tmp50_ = FALSE;
					vtg_utils_trace ("vtgbracketcompletion.vala:324: inside %d next %d", (gint) inside_block, (gint) line_has_semicolon);
					if (inside_block) {
						_tmp50_ = !line_has_semicolon;
					} else {
						_tmp50_ = FALSE;
					}
					if (_tmp50_) {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ");");
						vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2);
					} else {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ")");
						vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
					}
				}
			}
		} else {
			if (ch == '[') {
				gunichar* _tmp51_ = NULL;
				gunichar* _tmp52_;
				gint _tmp52__length1;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp51_ = g_new0 (gunichar, 2);
				_tmp51_[0] = (gunichar) '}';
				_tmp51_[1] = (gunichar) ';';
				_tmp52_ = _tmp51_;
				_tmp52__length1 = 2;
				_tmp53_ = vtg_bracket_completion_find_char (instance, &pos, (gunichar) ']', (gunichar) '[', _tmp52_, 2);
				_tmp54_ = !_tmp53_;
				_tmp52_ = (g_free (_tmp52_), NULL);
				if (_tmp54_) {
					vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, "]");
					vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
				}
			} else {
				if (ch == '*') {
					const gchar* _tmp55_ = NULL;
					gboolean _tmp56_;
					_tmp55_ = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
					indent = _tmp55_;
					_tmp56_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src);
					if (_tmp56_) {
						GtkTextIter sel_start = {0};
						GtkTextIter sel_end = {0};
						GtkTextIter _tmp57_ = {0};
						GtkTextIter _tmp58_ = {0};
						gboolean _tmp59_ = FALSE;
						gunichar _tmp60_;
						gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) src, &_tmp57_, &_tmp58_);
						sel_start = _tmp57_;
						sel_end = _tmp58_;
						gtk_text_iter_backward_char (&sel_start);
						_tmp60_ = gtk_text_iter_get_char (&sel_start);
						if (_tmp60_ == '/') {
							gboolean _tmp61_;
							_tmp61_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "*", "*/");
							_tmp59_ = _tmp61_;
						} else {
							_tmp59_ = FALSE;
						}
						if (_tmp59_) {
							GtkTextIter _tmp62_ = {0};
							gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp62_, mark);
							pos = _tmp62_;
							gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
							_result_ = TRUE;
						}
					} else {
						gunichar _tmp63_;
						gtk_text_iter_backward_char (&pos);
						_tmp63_ = gtk_text_iter_get_char (&pos);
						if (_tmp63_ == '/') {
							gchar* _tmp64_;
							_tmp64_ = g_strdup ("*  */");
							_g_free0 (buffer);
							buffer = _tmp64_;
							vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
							gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
							vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 3);
							_result_ = TRUE;
						}
					}
				} else {
					if (ch == '{') {
						const gchar* _tmp65_ = NULL;
						gboolean _tmp66_;
						_tmp65_ = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
						indent = _tmp65_;
						_tmp66_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src);
						if (_tmp66_) {
							gchar* _tmp67_ = NULL;
							gchar* tmp;
							gchar* _tmp68_ = NULL;
							gchar* _tmp69_;
							gboolean _tmp70_;
							gboolean _tmp71_;
							_tmp67_ = vtg_bracket_completion_subtract_indentation (instance, indent, 1);
							tmp = _tmp67_;
							_tmp68_ = g_strdup_printf ("\n%s}\n", tmp);
							_tmp69_ = _tmp68_;
							_tmp70_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "{", _tmp69_);
							_tmp71_ = _tmp70_;
							_g_free0 (_tmp69_);
							if (_tmp71_) {
								GtkTextIter _tmp72_ = {0};
								gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp72_, mark);
								pos = _tmp72_;
								gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
							}
							_result_ = TRUE;
							_g_free0 (tmp);
						} else {
							gboolean _tmp73_;
							gboolean _tmp75_ = FALSE;
							ch = (gunichar) ' ';
							_tmp73_ = gtk_text_iter_backward_char (&pos);
							if (_tmp73_) {
								gunichar _tmp74_;
								_tmp74_ = gtk_text_iter_get_char (&pos);
								ch = _tmp74_;
							}
							if (ch != '\'') {
								_tmp75_ = ch != '\"';
							} else {
								_tmp75_ = FALSE;
							}
							if (_tmp75_) {
								gchar* _tmp76_;
								gchar* line;
								gboolean _tmp77_;
								gboolean _tmp83_ = FALSE;
								gboolean _tmp84_ = FALSE;
								gboolean _tmp85_;
								_tmp76_ = g_strdup ("{");
								_g_free0 (buffer);
								buffer = _tmp76_;
								line = NULL;
								_tmp77_ = gtk_text_iter_forward_line (&pos);
								if (_tmp77_) {
									GtkTextIter end;
									const gchar* _tmp78_ = NULL;
									gchar* _tmp79_;
									gchar* _tmp80_ = NULL;
									gchar* _tmp81_;
									gchar* _tmp82_ = NULL;
									end = pos;
									gtk_text_iter_forward_to_line_end (&end);
									_tmp78_ = gtk_text_iter_get_slice (&pos, &end);
									_tmp79_ = g_strdup (_tmp78_);
									_g_free0 (line);
									line = _tmp79_;
									_tmp80_ = string_replace (line, " ", "");
									_tmp81_ = _tmp80_;
									_tmp82_ = string_replace (_tmp81_, "\t", "");
									_g_free0 (line);
									line = _tmp82_;
									_g_free0 (_tmp81_);
								}
								_tmp85_ = vtg_string_utils_is_null_or_empty (line);
								if (_tmp85_) {
									_tmp84_ = TRUE;
								} else {
									gboolean _tmp86_;
									_tmp86_ = g_str_has_prefix (line, "\n");
									_tmp84_ = _tmp86_;
								}
								if (_tmp84_) {
									_tmp83_ = TRUE;
								} else {
									gboolean _tmp87_;
									_tmp87_ = g_str_has_prefix (line, "}");
									_tmp83_ = _tmp87_;
								}
								if (_tmp83_) {
									gchar* _tmp88_ = NULL;
									gint _tmp89_;
									_tmp88_ = g_strdup_printf ("{\n%s%s\n%s}", indent, instance->priv->tab_chars, indent);
									_g_free0 (buffer);
									buffer = _tmp88_;
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
									_tmp89_ = strlen (indent);
									vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2 + ((gint) _tmp89_));
									_result_ = TRUE;
								}
								_g_free0 (line);
							}
						}
					} else {
						if ((*evt).keyval == GDK_KEY_Return) {
							const gchar* _tmp90_ = NULL;
							_tmp90_ = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
							indent = _tmp90_;
							if (((*evt).state & GDK_SHIFT_MASK) != 0) {
								gboolean _tmp91_;
								_tmp91_ = gtk_text_iter_ends_line (&pos);
								if (!_tmp91_) {
									gtk_text_iter_forward_to_line_end (&pos);
									gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
								}
								if (((*evt).state & GDK_CONTROL_MASK) == 0) {
									gchar* _tmp92_;
									GtkTextIter tmp;
									gboolean _tmp97_;
									GtkTextIter _tmp103_ = {0};
									_tmp92_ = g_strdup (";");
									_g_free0 (buffer);
									buffer = _tmp92_;
									tmp = pos;
									while (TRUE) {
										gboolean _tmp93_;
										gunichar _tmp94_;
										gboolean _tmp95_;
										_tmp93_ = gtk_text_iter_backward_char (&pos);
										if (!_tmp93_) {
											break;
										}
										_tmp94_ = gtk_text_iter_get_char (&pos);
										ch = _tmp94_;
										_tmp95_ = g_unichar_isspace (ch);
										if (!_tmp95_) {
											if (ch == ';') {
												gchar* _tmp96_;
												_tmp96_ = g_strdup ("");
												_g_free0 (buffer);
												buffer = _tmp96_;
											}
											gtk_text_iter_forward_char (&pos);
											break;
										}
									}
									_tmp97_ = gtk_text_iter_equal (&tmp, &pos);
									if (_tmp97_) {
										gchar* _tmp98_ = NULL;
										gchar* _tmp99_;
										_tmp98_ = g_strdup_printf ("%s\n%s", buffer, indent);
										_tmp99_ = _tmp98_;
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp99_);
										_g_free0 (_tmp99_);
									} else {
										GtkTextIter _tmp100_ = {0};
										gchar* _tmp101_ = NULL;
										gchar* _tmp102_;
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										if (g_strcmp0 (buffer, "") != 0) {
											vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
										}
										gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp100_, mark);
										pos = _tmp100_;
										gtk_text_iter_forward_to_line_end (&pos);
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										_tmp101_ = g_strdup_printf ("\n%s", indent);
										_tmp102_ = _tmp101_;
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp102_);
										_g_free0 (_tmp102_);
									}
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
									gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp103_, mark);
									pos = _tmp103_;
									gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
								} else {
									gchar* _tmp104_ = NULL;
									gint _tmp105_;
									_tmp104_ = g_strdup_printf ("\n%s{\n%s%s\n%s}", indent, indent, instance->priv->tab_chars, indent);
									_g_free0 (buffer);
									buffer = _tmp104_;
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
									_tmp105_ = strlen (indent);
									vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2 + ((gint) _tmp105_));
								}
								_result_ = TRUE;
							} else {
								gboolean _tmp106_ = FALSE;
								if (indent != NULL) {
									_tmp106_ = g_strcmp0 (indent, "") != 0;
								} else {
									_tmp106_ = FALSE;
								}
								if (_tmp106_) {
									gchar* _tmp107_ = NULL;
									gchar* _tmp108_;
									_tmp107_ = g_strdup_printf ("\n%s", indent);
									_tmp108_ = _tmp107_;
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp108_);
									_g_free0 (_tmp108_);
									_result_ = TRUE;
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
								}
							}
						} else {
							if (ch == '\"') {
								gboolean _tmp109_;
								_tmp109_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src);
								if (_tmp109_) {
									gboolean _tmp110_;
									_tmp110_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "\"", NULL);
									if (_tmp110_) {
										GtkTextIter _tmp111_ = {0};
										gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp111_, mark);
										pos = _tmp111_;
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										_result_ = TRUE;
									}
								} else {
									gunichar* _tmp112_ = NULL;
									gunichar* _tmp113_;
									gint _tmp113__length1;
									gboolean _tmp114_;
									gboolean _tmp115_;
									_tmp112_ = g_new0 (gunichar, 2);
									_tmp112_[0] = (gunichar) '}';
									_tmp112_[1] = (gunichar) ';';
									_tmp113_ = _tmp112_;
									_tmp113__length1 = 2;
									_tmp114_ = vtg_bracket_completion_find_char (instance, &pos, (gunichar) '\"', (gunichar) '\"', _tmp113_, 2);
									_tmp115_ = !_tmp114_;
									_tmp113_ = (g_free (_tmp113_), NULL);
									if (_tmp115_) {
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, "\"");
										vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
									}
								}
							}
						}
					}
				}
			}
		}
		_g_free0 (buffer);
		_g_object_unref0 (src);
	}
	result = _result_;
	return result;
}


static void vtg_bracket_completion_class_init (VtgBracketCompletionClass * klass) {
	vtg_bracket_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgBracketCompletionPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_bracket_completion_finalize;
}


static void vtg_bracket_completion_instance_init (VtgBracketCompletion * self) {
	gchar* _tmp0_;
	self->priv = VTG_BRACKET_COMPLETION_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_view = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->tab_chars = _tmp0_;
}


static void vtg_bracket_completion_finalize (GObject* obj) {
	VtgBracketCompletion * self;
	self = VTG_BRACKET_COMPLETION (obj);
	_g_object_unref0 (self->priv->_view);
	_g_free0 (self->priv->tab_chars);
	G_OBJECT_CLASS (vtg_bracket_completion_parent_class)->finalize (obj);
}


GType vtg_bracket_completion_get_type (void) {
	return vtg_bracket_completion_type_id;
}


GType vtg_bracket_completion_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgBracketCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_bracket_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgBracketCompletion), 0, (GInstanceInitFunc) vtg_bracket_completion_instance_init, NULL };
	vtg_bracket_completion_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgBracketCompletion", &g_define_type_info, 0);
	return vtg_bracket_completion_type_id;
}



