/* vtgprojectsearch.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgprojectsearch.vala, do not modify */

/*
 *  vtgprojectsearch.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2009 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-window.h>
#include <gtk/gtk.h>
#include <vbf.h>
#include <valagee.h>
#include <glib/gi18n-lib.h>
#include <sys/wait.h>


#define VTG_TYPE_PROJECT_SEARCH (vtg_project_search_get_type ())
#define VTG_PROJECT_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearch))
#define VTG_PROJECT_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchClass))
#define VTG_IS_PROJECT_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_SEARCH))
#define VTG_IS_PROJECT_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_SEARCH))
#define VTG_PROJECT_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchClass))

typedef struct _VtgProjectSearch VtgProjectSearch;
typedef struct _VtgProjectSearchClass VtgProjectSearchClass;
typedef struct _VtgProjectSearchPrivate VtgProjectSearchPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW (vtg_project_search_results_view_get_type ())
#define VTG_PROJECT_SEARCH_RESULTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsView))
#define VTG_PROJECT_SEARCH_RESULTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsViewClass))
#define VTG_IS_PROJECT_SEARCH_RESULTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW))
#define VTG_IS_PROJECT_SEARCH_RESULTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW))
#define VTG_PROJECT_SEARCH_RESULTS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsViewClass))

typedef struct _VtgProjectSearchResultsView VtgProjectSearchResultsView;
typedef struct _VtgProjectSearchResultsViewClass VtgProjectSearchResultsViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _VtgProjectSearch {
	GObject parent_instance;
	VtgProjectSearchPrivate * priv;
};

struct _VtgProjectSearchClass {
	GObjectClass parent_class;
};

struct _VtgProjectSearchPrivate {
	VtgPluginInstance* _plugin_instance;
	VtgProjectSearchResultsView* _results_view;
	guint _child_watch_id;
	GPid child_pid;
	gboolean is_bottom_pane_visible;
	gint last_exit_code;
};

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_project_search_parent_class = NULL;
static GType vtg_project_search_type_id = 0;

GType vtg_project_search_get_type (void) G_GNUC_CONST;
GType vtg_project_search_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_search_results_view_get_type (void) G_GNUC_CONST;
GType vtg_project_search_results_view_register_type (GTypeModule * module);
#define VTG_PROJECT_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchPrivate))
enum  {
	VTG_PROJECT_SEARCH_DUMMY_PROPERTY,
	VTG_PROJECT_SEARCH_IS_SEARCHING
};
#define VTG_PROJECT_SEARCH_GREP "grep"
VtgProjectSearch* vtg_project_search_new (VtgPluginInstance* plugin_instance);
VtgProjectSearch* vtg_project_search_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgProjectSearchResultsView* vtg_project_search_results_view_new (VtgPluginInstance* plugin_instance);
VtgProjectSearchResultsView* vtg_project_search_results_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
void vtg_project_search_next_match (VtgProjectSearch* self);
void vtg_project_search_results_view_next_match (VtgProjectSearchResultsView* self);
void vtg_project_search_previous_match (VtgProjectSearch* self);
void vtg_project_search_results_view_previous_match (VtgProjectSearchResultsView* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
gboolean vtg_project_search_search (VtgProjectSearch* self, VtgProjectManager* project_manager, const gchar* text, gboolean match_case);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
void vtg_output_view_clean_output (VtgOutputView* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const gchar* message);
void vtg_utils_trace (const gchar* format, ...);
static void vtg_project_search_on_child_watch (VtgProjectSearch* self, GPid pid, gint status);
static void _vtg_project_search_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self);
void vtg_project_search_results_view_initialize (VtgProjectSearchResultsView* self, VtgProjectManager* project);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_activate (VtgOutputView* self);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
void vtg_project_search_results_view_activate (VtgProjectSearchResultsView* self);
gboolean vtg_project_search_get_is_searching (VtgProjectSearch* self);
static void vtg_project_search_finalize (GObject* obj);
static void _vala_vtg_project_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


VtgProjectSearch* vtg_project_search_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectSearch * self = NULL;
	VtgProjectSearchResultsView* _tmp0_ = NULL;
	GeditWindow* _tmp1_ = NULL;
	GeditPanel* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectSearch*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	_tmp0_ = vtg_project_search_results_view_new (self->priv->_plugin_instance);
	_g_object_unref0 (self->priv->_results_view);
	self->priv->_results_view = _tmp0_;
	_tmp1_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp2_ = gedit_window_get_bottom_panel (_tmp1_);
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	self->priv->is_bottom_pane_visible = _tmp3_;
	return self;
}


VtgProjectSearch* vtg_project_search_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_search_construct (VTG_TYPE_PROJECT_SEARCH, plugin_instance);
}


void vtg_project_search_next_match (VtgProjectSearch* self) {
	g_return_if_fail (self != NULL);
	vtg_project_search_results_view_next_match (self->priv->_results_view);
}


void vtg_project_search_previous_match (VtgProjectSearch* self) {
	g_return_if_fail (self != NULL);
	vtg_project_search_results_view_previous_match (self->priv->_results_view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch29_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch29_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _vtg_project_search_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self) {
	vtg_project_search_on_child_watch (self, pid, status);
}


gboolean vtg_project_search_search (VtgProjectSearch* self, VtgProjectManager* project_manager, const gchar* text, gboolean match_case) {
	gboolean result = FALSE;
	VbfProject* _tmp0_ = NULL;
	VbfProject* _tmp1_;
	VbfProject* project;
	gchar* _tmp2_;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	gint stdi = 0;
	VtgOutputView* _tmp3_ = NULL;
	VtgOutputView* _tmp4_;
	VtgOutputView* log;
	gchar* cmd = NULL;
	gchar** cmds = NULL;
	gint cmds_length1 = 0;
	gint _cmds_size_ = 0;
	gchar** _tmp35_ = NULL;
	gint _tmp36_;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* start_message;
	gint _tmp39_;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	GPid _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = vtg_project_manager_get_project (project_manager);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	project = _tmp1_;
	_tmp2_ = g_strdup (project->id);
	working_dir = _tmp2_;
	_tmp3_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	log = _tmp4_;
	vtg_output_view_clean_output (log);
	if (text == NULL) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("No command text to search specified for project %s", project->name);
		_tmp6_ = _tmp5_;
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp6_);
		_g_free0 (_tmp6_);
		result = FALSE;
		_g_free0 (cmd);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	} else {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* dirs;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		if (match_case) {
			_tmp7_ = "";
		} else {
			_tmp7_ = "i";
		}
		_tmp8_ = string_replace (text, " ", "\\ ");
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("sh -c '%s -Hn%s %s", VTG_PROJECT_SEARCH_GREP, _tmp7_, _tmp9_);
		_g_free0 (cmd);
		cmd = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = g_strdup ("");
		dirs = _tmp11_;
		{
			ValaList* _tmp12_ = NULL;
			ValaList* _group_list;
			gint _tmp13_;
			gint _group_size;
			gint _group_index;
			_tmp12_ = vbf_project_get_groups (project);
			_group_list = _tmp12_;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _group_list);
			_group_size = _tmp13_;
			_group_index = -1;
			while (TRUE) {
				gpointer _tmp14_ = NULL;
				VbfGroup* group;
				_group_index = _group_index + 1;
				if (!(_group_index < _group_size)) {
					break;
				}
				_tmp14_ = vala_list_get (_group_list, _group_index);
				group = (VbfGroup*) _tmp14_;
				{
					ValaList* _tmp15_ = NULL;
					ValaList* _target_list;
					gint _tmp16_;
					gint _target_size;
					gint _target_index;
					_tmp15_ = vbf_group_get_targets (group);
					_target_list = _tmp15_;
					_tmp16_ = vala_collection_get_size ((ValaCollection*) _target_list);
					_target_size = _tmp16_;
					_target_index = -1;
					while (TRUE) {
						gpointer _tmp17_ = NULL;
						VbfTarget* target;
						gboolean group_done;
						gboolean _tmp18_;
						gboolean _tmp24_;
						_target_index = _target_index + 1;
						if (!(_target_index < _target_size)) {
							break;
						}
						_tmp17_ = vala_list_get (_target_list, _target_index);
						target = (VbfTarget*) _tmp17_;
						group_done = FALSE;
						_tmp18_ = vbf_target_has_sources_of_type (target, VBF_FILE_TYPES_VALA_SOURCE);
						if (_tmp18_) {
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							gchar* _tmp23_ = NULL;
							_tmp19_ = g_build_filename (group->id, "*.vala", NULL);
							_tmp20_ = _tmp19_;
							_tmp21_ = string_replace (_tmp20_, " ", "\\ ");
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (dirs, " ", _tmp22_, NULL);
							_g_free0 (dirs);
							dirs = _tmp23_;
							_g_free0 (_tmp22_);
							_g_free0 (_tmp20_);
							group_done = TRUE;
						}
						_tmp24_ = vbf_target_has_file_with_extension (target, "vapi");
						if (_tmp24_) {
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_;
							gchar* _tmp27_ = NULL;
							gchar* _tmp28_;
							gchar* _tmp29_ = NULL;
							_tmp25_ = g_build_filename (group->id, "*.vapi", NULL);
							_tmp26_ = _tmp25_;
							_tmp27_ = string_replace (_tmp26_, " ", "\\ ");
							_tmp28_ = _tmp27_;
							_tmp29_ = g_strconcat (dirs, " ", _tmp28_, NULL);
							_g_free0 (dirs);
							dirs = _tmp29_;
							_g_free0 (_tmp28_);
							_g_free0 (_tmp26_);
							group_done = TRUE;
						}
						if (group_done) {
							_g_object_unref0 (target);
							break;
						}
						_g_object_unref0 (target);
					}
					_vala_iterable_unref0 (_target_list);
				}
				_g_object_unref0 (group);
			}
			_vala_iterable_unref0 (_group_list);
		}
		_tmp30_ = g_strconcat (" ", dirs, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "'", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (cmd, _tmp33_, NULL);
		_g_free0 (cmd);
		cmd = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (dirs);
	}
	vtg_utils_trace ("vtgprojectsearch.vala:106: project grep: %s", cmd);
	g_shell_parse_argv (cmd, &_tmp36_, &_tmp35_, &_inner_error_);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	cmds = _tmp35_;
	cmds_length1 = _tmp36_;
	if (_inner_error_ != NULL) {
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		goto __catch28_g_error;
	}
	_tmp37_ = _ ("Searching for '%s' in project %s\n");
	_tmp38_ = g_strdup_printf (_tmp37_, text, project->name);
	start_message = _tmp38_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp39_ = strlen (start_message);
	_tmp40_ = g_strnfill ((gsize) (_tmp39_ - 1), '-');
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf ("%s\n\n", _tmp41_);
	_tmp43_ = _tmp42_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	g_spawn_async_with_pipes (working_dir, cmds, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp44_, &_tmp45_, &_tmp46_, &_tmp47_, &_inner_error_);
	self->priv->child_pid = _tmp44_;
	stdi = _tmp45_;
	stdo = _tmp46_;
	stde = _tmp47_;
	if (_inner_error_ != NULL) {
		_g_free0 (start_message);
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		goto __catch28_g_error;
	}
	if (self->priv->child_pid != ((GPid) 0)) {
		guint _tmp48_;
		_tmp48_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->child_pid, _vtg_project_search_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp48_;
		vtg_project_search_results_view_initialize (self->priv->_results_view, project_manager);
		if (self->priv->last_exit_code == 0) {
			GeditWindow* _tmp49_ = NULL;
			GeditPanel* _tmp50_ = NULL;
			gboolean _tmp51_;
			_tmp49_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp50_ = gedit_window_get_bottom_panel (_tmp49_);
			_tmp51_ = gtk_widget_get_visible ((GtkWidget*) _tmp50_);
			self->priv->is_bottom_pane_visible = _tmp51_;
		}
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_SEARCH, self->priv->_child_watch_id, stdo, stde, stdi);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "search-start");
	} else {
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning process\n");
	}
	result = TRUE;
	_g_free0 (start_message);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	return result;
	_g_free0 (start_message);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_object_unref0 (log);
	goto __finally28;
	__catch28_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectsearch.vala:126: Error spawning search process: %s", err->message);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	__finally28:
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void vtg_project_search_on_child_watch (VtgProjectSearch* self, GPid pid, gint status) {
	VtgOutputView* _tmp0_ = NULL;
	VtgOutputView* _tmp1_;
	VtgOutputView* log;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	log = _tmp1_;
	_tmp2_ = WEXITSTATUS (status);
	self->priv->last_exit_code = _tmp2_;
	vtg_output_view_stop_watch (log, self->priv->_child_watch_id);
	g_spawn_close_pid (self->priv->child_pid);
	_tmp3_ = _ ("\nsearch terminated with exit status %d\n");
	_tmp4_ = g_strdup_printf (_tmp3_, status);
	_tmp5_ = _tmp4_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp5_);
	_g_free0 (_tmp5_);
	vtg_project_search_results_view_activate (self->priv->_results_view);
	self->priv->_child_watch_id = (guint) 0;
	_tmp6_ = WEXITSTATUS (status);
	g_signal_emit_by_name (self, "search-exit", _tmp6_);
	self->priv->child_pid = (GPid) 0;
	_g_object_unref0 (log);
}


gboolean vtg_project_search_get_is_searching (VtgProjectSearch* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_watch_id != 0;
	return result;
}


static void vtg_project_search_class_init (VtgProjectSearchClass * klass) {
	vtg_project_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectSearchPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_project_search_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_search_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_SEARCH_IS_SEARCHING, g_param_spec_boolean ("is-searching", "is-searching", "is-searching", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("search_start", VTG_TYPE_PROJECT_SEARCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("search_exit", VTG_TYPE_PROJECT_SEARCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void vtg_project_search_instance_init (VtgProjectSearch * self) {
	self->priv = VTG_PROJECT_SEARCH_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_results_view = NULL;
	self->priv->_child_watch_id = (guint) 0;
	self->priv->child_pid = (GPid) 0;
	self->priv->last_exit_code = 0;
}


static void vtg_project_search_finalize (GObject* obj) {
	VtgProjectSearch * self;
	self = VTG_PROJECT_SEARCH (obj);
	_g_object_unref0 (self->priv->_results_view);
	G_OBJECT_CLASS (vtg_project_search_parent_class)->finalize (obj);
}


GType vtg_project_search_get_type (void) {
	return vtg_project_search_type_id;
}


GType vtg_project_search_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectSearch), 0, (GInstanceInitFunc) vtg_project_search_instance_init, NULL };
	vtg_project_search_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectSearch", &g_define_type_info, 0);
	return vtg_project_search_type_id;
}


static void _vala_vtg_project_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectSearch * self;
	self = VTG_PROJECT_SEARCH (object);
	switch (property_id) {
		case VTG_PROJECT_SEARCH_IS_SEARCHING:
		g_value_set_boolean (value, vtg_project_search_get_is_searching (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



