
/*
 * GLX Server Extension
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef GLX_CONSTANTS_H
#define GLX_CONSTANTS_H

#include "resource.h"

#define GLX_MAJOR_VERSION 1
#define GLX_MINOR_VERSION 2

#define GLX_MAX_CLIENTS 10

#define GLX_PACKAGE_VERSION "0.9"
#define GLX_PROTOCOL_VERSION "1.2"

#define GLX_VENDOR_STRING "XFree86 GLX protocol written by Steven G. Parker"
#define GLX_EXTENSIONS_STRING " GLX_None "

typedef struct glRGBA {
    float r,g,b,a;
} glRGBA;

extern RESTYPE glContexts;
extern RESTYPE glPixmaps;
extern RESTYPE glWindows;
extern RESTYPE glxClients;

int __glxErrorBase;
int __glxReqBase;
int __glxEventBase;

#define __GLX_MAKE_CURRENT					\
   ctx=LookupIDByType(stuff->context_tag, glContexts);		\
   if (!ctx)							\
   {								\
      ErrorF( "GLX Error - bad context\n");			\
      return (GLXBadContextState);				\
   }								\
   GLXProcs.MakeCurrent(ctx);

#define __GLX_VERIFY_OPCODE(opcode)					\
    if (opcode > GLX_MAX_RENDER_OPCODE)					\
    {									\
        ErrorF( "GLX - opcode value too large (have %d, max %d)\n",	\
              opcode, GLX_MAX_RENDER_OPCODE );				\
        return (GLXBadLargeRequest);					\
    }	


#define __GLX_PARSE_RENDER_LARGE(ctx)					\
   {									\
      char *p = NULL;							\
      int packetlen;							\
									\
      p=(char*)(stuff+1);						\
      packetlen=stuff->data_bytes;					\
									\
      if (stuff->request_number == 1)					\
      {									\
         ctx->large_len =* (CARD32*)p;					\
         ctx->large_op  =* (CARD32*)(p+4);				\
         p += 8;							\
         packetlen -= 8;						\
         if (client->swapped) {						\
            register int _n;						\
            swapl(&ctx->large_len, _n);					\
            swapl(&ctx->large_op, _n);					\
         }								\
									\
         if (ctx->last_large_request != 0)				\
         {								\
            client->errorValue = stuff->request_number;			\
            ErrorF( "RenderLarge - prior seq not done (have %x, want %x)\n",\
                  stuff->request_number, ctx->last_large_request+1 );	\
            return (GLXBadLargeRequest);				\
         }								\
         ctx->large_buf=(char*)xalloc(ctx->large_len);			\
         ctx->large_bufp=0;						\
      }									\
      if (stuff->request_number != ctx->last_large_request+1)		\
      {									\
        ErrorF( "RenderLarge - requests in wrong order (have %x, expect %x)\n",\
              stuff->request_number, ctx->last_large_request+1 );	\
        return (GLXBadLargeRequest);					\
      }									\
									\
      if (ctx->large_bufp+packetlen > ctx->large_len)			\
      {									\
         ErrorF( "RenderLarge - request too large (have %x, max %x)\n",	\
              ctx->large_bufp+packetlen, ctx->large_len );		\
         return (GLXBadLargeRequest);					\
      }									\
									\
      bcopy(p, ctx->large_buf+ctx->large_bufp, packetlen);		\
      ctx->large_bufp+=packetlen;					\
      ctx->last_large_request++;					\
									\
      if (stuff->request_number != stuff->request_total)		\
         return (Success);						\
      ctx->last_large_request=0;					\
   }

#endif /* GLX_CONSTANTS_H */
