/* $Id: mach64regs.h,v 1.6 2000/03/25 07:10:49 gareth Exp $ */

/*
 * GLX Hardware Device Driver for ATI Rage Pro
 * Copyright (C) 1999 Gareth Hughes
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *    Gareth Hughes <gareth@precisioninsight.com>
 */

#ifndef __MACH64_REGS_H__
#define __MACH64_REGS_H__

/*
 * Setup and Control Memory Mapped Registers
 */

#define MACH64_BUS_CNTL 			0x04a0
#define MACH64_CONFIG_CHIP_ID 			0x04e0
#define MACH64_CONFIG_CNTL 			0x04dc
#define MACH64_CONFIG_STAT0 			0x04e4
#define MACH64_CONFIG_STAT1 			0x0494
#define MACH64_CONFIG_STAT2 			0x0498
#define MACH64_CRC_SIG 				0x04e8
#define MACH64_CUSTOM_MACRO_CNTL 		0x04d4
#define MACH64_DSP_CONFIG 			0x0420
#define MACH64_DSP_ON_OFF 			0x0424
#define MACH64_EXT_MEM_CNTL 			0x04ac
#define MACH64_GEN_TEST_CNTL 			0x04d0
#define MACH64_HW_DEBUG 			0x047c
#define MACH64_MEM_ADDR_CONFIG 			0x0434
#define MACH64_MEM_BUF_CNTL 			0x042c
#define MACH64_MEM_CNTL 			0x04b0
#define MACH64_SCRATCH_REG0 			0x0480
#define MACH64_SCRATCH_REG1 			0x0484
#define MACH64_TIMER_CONFIG 			0x0428
#define MACH64_VGA_DSP_CONFIG 			0x044c
#define MACH64_VGA_DSP_ON_OFF 			0x0450


/*
 * Accelerator CRTC and DAC Memory Mapped Registers
 */

#define MACH64_CUR_CLR0 			0x0460
#define MACH64_CUR_CLR1 			0x0464
#define MACH64_CUR_OFFSET 			0x0468
#define MACH64_CUR_HORZ_VERT_POSN 		0x046c
#define MACH64_CUR_HORZ_VERT_OFF 		0x0470


/*
 * Draw Engine Trajectory Memory Mapped Registers
 */

#define MACH64_ALPHA_TST_CNTL 			0x0550
#define MACH64_COMPOSITE_SHADOW_ID 		0x0798
#define MACH64_CONTEXT_LOAD_CNTL 		0x072c
#define MACH64_CONTEXT_MASK 			0x0720
#define MACH64_DST_BRES_DEC 			0x052c
#define MACH64_DST_BRES_ERR 			0x0524
#define MACH64_DST_BRES_INC 			0x0528
#define MACH64_DST_BRES_LNTH 			0x0520
#define MACH64_DST_CNTL 			0x0530
#define MACH64_DST_HEIGHT 			0x0514
#define MACH64_DST_HEIGHT_WIDTH 		0x0518
#define MACH64_DST_OFF_PITCH 			0x0500
#define MACH64_DST_WIDTH 			0x0510
#define MACH64_DST_WIDTH_HEIGHT 		0x06ec
#define MACH64_DST_X 				0x0504
#define MACH64_DST_X_WIDTH 			0x051c
#define MACH64_DST_X_Y 				0x06e8
#define MACH64_DST_Y 				0x0508
#define MACH64_DST_Y_X 				0x050c
#define MACH64_LEAD_BRES_DEC 			0x052c
#define MACH64_LEAD_BRES_INC 			0x0528
#define MACH64_LEAD_BRES_LNTH 			0x0544
#define MACH64_SRC_CNTL 			0x05b4
#define MACH64_SRC_HEIGHT1 			0x0594
#define MACH64_SRC_HEIGHT2 			0x05ac
#define MACH64_SRC_HEIGHT1_WIDTH1 		0x0598
#define MACH64_SRC_HEIGHT2_WIDTH2 		0x05b0
#define MACH64_SRC_OFF_PITCH 			0x0580
#define MACH64_SRC_WIDTH1 			0x0590
#define MACH64_SRC_WIDTH2 			0x05a8
#define MACH64_SRC_X 				0x0584
#define MACH64_SRC_X_START 			0x059c
#define MACH64_SRC_Y 				0x0588
#define MACH64_SRC_Y_START 			0x05a0
#define MACH64_SRC_Y_X 				0x058c
#define MACH64_SRC_Y_X_START 			0x05a4
#define MACH64_TRAIL_BRES_DEC 			0x0540
#define MACH64_TRAIL_BRES_ERR 			0x0538
#define MACH64_TRAIL_BRES_INC 			0x053c
#define MACH64_USR_DST_PITCH 			0x06f0
#define MACH64_Z_CNTL 				0x054c
#define MACH64_Z_OFF_PITCH 			0x0548


/*
 * Draw Engine Control Memory Mapped Registers
 */

#define MACH64_CLR_CMP_CLR 			0x0700
#define MACH64_CLR_CMP_CNTL 			0x0708
#define MACH64_CLR_CMP_MASK 			0x0704

#define MACH64_DP_BKGD_CLR 			0x06c0
#define MACH64_DP_CHAIN_MASK 			0x06cc
#define MACH64_DP_FOG_CLR 			0x06c4
#define MACH64_DP_FGRD_BKGD_CLR 		0x06e0
#define MACH64_DP_FRGD_CLR 			0x06c4
#define MACH64_DP_FGRD_CLR_MIX 			0x06dc
#define MACH64_DP_MIX 				0x06d4
#define MACH64_DP_PIX_WIDTH 			0x06d0
#define MACH64_DP_SET_GUI_ENGINE 		0x06fc
#define MACH64_DP_SET_GUI_ENGINE2 		0x06f8
#define MACH64_DP_SRC 				0x06d8
#define MACH64_DP_WRITE_MASK 			0x06c8

#define MACH64_FIFO_STAT 			0x0710
#define MACH64_GUI_CMDFIFO_DEBUG 		0x0170
#define MACH64_GUI_CMDFIFO_DATA 		0x0174
#define MACH64_GUI_CNTL 			0x0178
#define MACH64_GUI_STAT 			0x0738
#define MACH64_GUI_TRAJ_CNTL 			0x0730
#define MACH64_HOST_CNTL 			0x0640
#define MACH64_HOST_DATA0 			0x0600
#define MACH64_HOST_DATA1 			0x0604
#define MACH64_HOST_DATA2 			0x0608
#define MACH64_HOST_DATA3 			0x060c
#define MACH64_HOST_DATA4 			0x0610
#define MACH64_HOST_DATA5 			0x0614
#define MACH64_HOST_DATA6 			0x0618
#define MACH64_HOST_DATA7 			0x061c
#define MACH64_HOST_DATA8 			0x0620
#define MACH64_HOST_DATA9 			0x0624
#define MACH64_HOST_DATAA 			0x0628
#define MACH64_HOST_DATAB 			0x062c
#define MACH64_HOST_DATAC 			0x0630
#define MACH64_HOST_DATAD 			0x0634
#define MACH64_HOST_DATAE 			0x0638
#define MACH64_HOST_DATAF 			0x063c
#define MACH64_PAT_CNTL 			0x0688
#define MACH64_PAT_REG0 			0x0680
#define MACH64_PAT_REG1 			0x0684
#define MACH64_SC_BOTTOM 			0x06b0
#define MACH64_SC_LEFT 				0x06a0
#define MACH64_SC_LEFT_RIGHT 			0x06a8
#define MACH64_SC_RIGHT 			0x06a4
#define MACH64_SC_TOP 				0x06ac
#define MACH64_SC_TOP_BOTTOM 			0x06b4


/*
 * Scaler and 3D Accelerator Memory Mapped Registers
 */


/*
 * Front-End Scaler Pipe Memory Mapped Registers
 */

#define MACH64_SCALE_3D_CNTL 			0x05fc
#define MACH64_SCALE_DST_Y_X 			0x078c
#define MACH64_SCALE_HACC 			0x07c8
#define MACH64_SCALE_HEIGHT 			0x05e0
#define MACH64_SCALE_OFF 			0x05c0
#define MACH64_SCALE_OFF_ACC 			0x0788
#define MACH64_SCALE_PITCH 			0x0750
#define MACH64_SCALE_PITCH_BOTH 		0x0780
#define MACH64_SCALE_VACC 			0x05f8
#define MACH64_SCALE_WIDTH 			0x05dc
#define MACH64_SCALE_X_INC 			0x07c0
#define MACH64_SCALE_Y_INC 			0x07cc
#define MACH64_SECONDARY_SCALE_HACC 		0x07a4
#define MACH64_SECONDARY_SCALE_OFF 		0x0778
#define MACH64_SECONDARY_SCALE_OFF_ACC 		0x0784
#define MACH64_SECONDARY_SCALE_PITCH 		0x0768
#define MACH64_SECONDARY_SCALE_VACC 		0x07d4
#define MACH64_SECONDARY_SCALE_X_INC 		0x079c
#define MACH64_SECONDARY_SCALE_Y_INC 		0x07d0

/*
 * Texture Mapping Memory Mapped Registers
 */

#define MACH64_LOG_MAX_INC 			0x0748
#define MACH64_S_START 				0x0754
#define MACH64_S_X_INC 				0x074c
#define MACH64_S_Y_INC 				0x0750
#define MACH64_SECONDARY_S_START 		0x0564
#define MACH64_SECONDARY_S_X_INC 		0x055c
#define MACH64_SECONDARY_S_Y_INC 		0x0560
#define MACH64_SECONDARY_STW_EXP 		0x0558
#define MACH64_SECONDARY_TEX_OFF 		0x0778
#define MACH64_SECONDARY_T_START 		0x057c
#define MACH64_SECONDARY_T_X_INC 		0x0574
#define MACH64_SECONDARY_T_Y_INC 		0x0578
#define MACH64_SECONDARY_W_START 		0x0570
#define MACH64_SECONDARY_W_X_INC 		0x0568
#define MACH64_SECONDARY_W_Y_INC 		0x056c
#define MACH64_STW_EXP 				0x0744
#define MACH64_T_START 				0x076c
#define MACH64_T_X_INC 				0x0764
#define MACH64_T_Y_INC 				0x0768
#define MACH64_TEX_0_OFF 			0x05c0
#define MACH64_TEX_1_OFF 			0x05c4
#define MACH64_TEX_2_OFF 			0x05c8
#define MACH64_TEX_3_OFF 			0x05cc
#define MACH64_TEX_4_OFF 			0x05d0
#define MACH64_TEX_5_OFF 			0x05d4
#define MACH64_TEX_6_OFF 			0x05d8
#define MACH64_TEX_7_OFF 			0x05dc
#define MACH64_TEX_8_OFF 			0x05e0
#define MACH64_TEX_9_OFF 			0x05e4
#define MACH64_TEX_10_OFF 			0x05e8
#define MACH64_TEX_CNTL 			0x0774
#define MACH64_TEX_PALETTE 			0x077c
#define MACH64_TEX_PALETTE_INDEX 		0x0740
#define MACH64_TEX_SIZE_PITCH 			0x0770
#define MACH64_W_START 				0x0760
#define MACH64_W_X_INC 				0x0758
#define MACH64_W_Y_INC 				0x075c

/*
 * Specular, Color, Z and Alpha Interpolator Memory Mapped Registers
 */

#define MACH64_ALPHA_START 			0x07f8
#define MACH64_ALPHA_X_INC 			0x07f0
#define MACH64_ALPHA_Y_INC 			0x07f4
#define MACH64_BLUE_START 			0x07e0
#define MACH64_BLUE_X_INC 			0x07d8
#define MACH64_BLUE_Y_INC 			0x07dc
#define MACH64_GREEN_START 			0x07d4
#define MACH64_GREEN_X_INC 			0x07cc
#define MACH64_GREEN_Y_INC 			0x07d0
#define MACH64_RED_START 			0x07c8
#define MACH64_RED_X_INC 			0x07c0
#define MACH64_RED_Y_INC 			0x07c4
#define MACH64_SPECULAR_BLUE_START 		0x07bc
#define MACH64_SPECULAR_BLUE_X_INC 		0x07b4
#define MACH64_SPECULAR_BLUE_Y_INC 		0x07b8
#define MACH64_SPECULAR_GREEN_START 		0x07b0
#define MACH64_SPECULAR_GREEN_X_INC 		0x07a8
#define MACH64_SPECULAR_GREEN_Y_INC 		0x07ac
#define MACH64_SPECULAR_RED_START 		0x07a4
#define MACH64_SPECULAR_RED_X_INC 		0x079c
#define MACH64_SPECULAR_RED_Y_INC 		0x07a0
#define MACH64_Z_START 				0x07ec
#define MACH64_Z_X_INC 				0x07e4
#define MACH64_Z_Y_INC 				0x07e8

/*
 * Setup Engine Memory Mapped Registers
 */

#define MACH64_ONE_OVER_AREA 			0x029c
#define MACH64_ONE_OVER_AREA_UC 		0x0300
#define MACH64_SETUP_CNTL 			0x0304
#define MACH64_VERTEX_1_ARGB 			0x0254
#define MACH64_VERTEX_1_S 			0x0240
#define MACH64_VERTEX_1_SECONDARY_S 		0x0328
#define MACH64_VERTEX_1_SECONDARY_T 		0x032c
#define MACH64_VERTEX_1_SECONDARY_W 		0x0330
#define MACH64_VERTEX_1_SPEC_ARGB 		0x024c
#define MACH64_VERTEX_1_T 			0x0244
#define MACH64_VERTEX_1_W 			0x0248
#define MACH64_VERTEX_1_X_Y 			0x0258
#define MACH64_VERTEX_1_Z 			0x0250
#define MACH64_VERTEX_2_ARGB 			0x0274
#define MACH64_VERTEX_2_S 			0x0260
#define MACH64_VERTEX_2_SECONDARY_S 		0x0334
#define MACH64_VERTEX_2_SECONDARY_T 		0x0338
#define MACH64_VERTEX_2_SECONDARY_W 		0x033c
#define MACH64_VERTEX_2_SPEC_ARGB 		0x026c
#define MACH64_VERTEX_2_T 			0x0264
#define MACH64_VERTEX_2_W 			0x0268
#define MACH64_VERTEX_2_X_Y 			0x0278
#define MACH64_VERTEX_2_Z 			0x0270
#define MACH64_VERTEX_3_ARGB 			0x0294
#define MACH64_VERTEX_3_S 			0x0280
#define MACH64_VERTEX_3_SECONDARY_S 		0x02a0
#define MACH64_VERTEX_3_SECONDARY_T 		0x02a4
#define MACH64_VERTEX_3_SECONDARY_W 		0x02a8
#define MACH64_VERTEX_3_SPEC_ARGB 		0x028c
#define MACH64_VERTEX_3_T 			0x0284
#define MACH64_VERTEX_3_W 			0x0288
#define MACH64_VERTEX_3_X_Y 			0x0298
#define MACH64_VERTEX_3_Z 			0x0290

/*
 * Bus Mastering DMA Memory Mapped Registers
 */

#define MACH64_BM_ADDR 				0x0648
#define MACH64_BM_COMMAND 			0x0188
#define MACH64_BM_DATA 				0x0648
#define MACH64_BM_FRAME_BUF_OFFSET 		0x0180
#define MACH64_BM_GUI_TABLE 			0x01b8
#define MACH64_BM_GUI_TABLE_CMD 		0x064c
#define MACH64_BM_HOSTDATA 			0x0644
#define MACH64_BM_STATUS 			0x018c
#define MACH64_BM_SYSTEM_MEM_ADDR 		0x0184
#define MACH64_BM_SYSTEM_TABLE 			0x01bc

/*
 * AGP Memory Mapped Registers
 */

#define MACH64_AGP_BASE 			0x0148
#define MACH64_AGP_CNTL 			0x014c


/* ================================================================ */


/* BUS_CNTL, page 4-4 */

#define BUS_MSTR_RESET				(1 << 1)
#define BUS_FLUSH_BUF				(1 << 2)
#define BUS_MASTER_DIS				(1 << 6)
#define BUS_EXT_REG_EN				(1 << 27)

/* GEN_TEST_CNTL, page 4-20 */

#define HWCURSOR_ENABLE				(1 << 7)
#define GUI_ENGINE_ENABLE			(1 << 8)

/* DST_CNTL, page 5-5 */
#define DST_X_RIGHT_TO_LEFT			(0 << 0)
#define DST_X_LEFT_TO_RIGHT			(1 << 0)
#define DST_Y_BOTTOM_TO_TOP			(0 << 1)
#define DST_Y_TOP_TO_BOTTOM			(1 << 1)
#define DST_X_MAJOR				(0 << 2)
#define DST_Y_MAJOR				(1 << 2)
#define DST_X_TILE				(1 << 3)
#define DST_Y_TILE				(1 << 4)
#define DST_LAST_PEL				(1 << 5)
#define DST_POLYGON_ENABLE			(1 << 6)
#define DST_24_ROTATION_ENABLE			(1 << 7)

/* SRC_CNTL, page 5-21 */

#define SRC_PATTERN_ENABLE			(1 << 0)
#define SRC_ROTATION_ENABLE			(1 << 1)
#define SRC_LINEAR_ENABLE			(1 << 2)
#define SRC_BYTE_ALIGN				(1 << 3)
#define SRC_LINE_X_RIGHT_TO_LEFT		(0 << 4)
#define SRC_LINE_X_LEFT_TO_RIGHT		(1 << 4)
#define SRC_BM_ENABLE				(1 << 8)
#define SRC_BM_SYNC				(1 << 9)
#define SRC_BM_OP_FRAME_TO_SYSTEM		(0 << 10)
#define SRC_BM_OP_SYSTEM_TO_FRAME		(1 << 10)
#define SRC_BM_OP_REG_TO_SYSTEM			(2 << 10)
#define SRC_BM_OP_SYSTEM_TO_REG			(3 << 10)

/* HOST_CNTL, page 5-34 */

#define HOST_BYTE_ALIGN				(1 << 0)

/* PAT_CNTL, page 5-38 */

#define PAT_MONO_8x8_ENABLE			(1 << 0)
#define PAT_CLR_4x2_ENABLE			(1 << 1)
#define PAT_CLR_8x1_ENABLE			(1 << 2)

/* DP_PIX_WIDTH, page 5-46 */

#define DST_1BPP				(0 << 0)
#define DST_4BPP				(1 << 0)
#define DST_8BPP				(2 << 0)
#define DST_15BPP				(3 << 0)
#define DST_16BPP				(4 << 0)
#define DST_32BPP				(6 << 0)
#define COMP_1BPP				(0 << 4)
#define COMP_4BPP				(1 << 4)
#define COMP_8BPP				(2 << 4)
#define COMP_15BPP				(3 << 4)
#define COMP_16BPP				(4 << 4)
#define COMP_32BPP				(6 << 4)
#define SRC_1BPP				(0 << 8)
#define SRC_4BPP				(1 << 8)
#define SRC_8BPP				(2 << 8)
#define SRC_15BPP				(3 << 8)
#define SRC_16BPP				(4 << 8)
#define SRC_32BPP				(6 << 8)
#define HOST_TRIPLE_ENABLE			(1 << 13)
#define HOST_1BPP				(0 << 16)
#define HOST_4BPP				(1 << 16)
#define HOST_8BPP				(2 << 16)
#define HOST_15BPP				(3 << 16)
#define HOST_16BPP				(4 << 16)
#define HOST_32BPP				(6 << 16)
#define BYTE_ORDER_MSB_TO_LSB			(0 << 24)
#define BYTE_ORDER_LSB_TO_MSB			(1 << 24)
#define SCALE_1BPP				(0 << 28)
#define SCALE_4BPP				(1 << 28)
#define SCALE_8BPP				(2 << 28)
#define SCALE_15BPP				(3 << 28)
#define SCALE_16BPP				(4 << 28)
#define SCALE_32BPP				(6 << 28)

/* DP_MIX, page 5-50 */

#define BKGD_MIX_NOT_D				(0 << 0)
#define BKGD_MIX_ZERO				(1 << 0)
#define BKGD_MIX_ONE				(2 << 0)
#define BKGD_MIX_D				(3 << 0)
#define BKGD_MIX_NOT_S				(4 << 0)
#define BKGD_MIX_D_XOR_S			(5 << 0)
#define BKGD_MIX_NOT_D_XOR_S			(6 << 0)
#define BKGD_MIX_S				(7 << 0)
#define BKGD_MIX_NOT_D_OR_NOT_S			(8 << 0)
#define BKGD_MIX_D_OR_NOT_S			(9 << 0)
#define BKGD_MIX_NOT_D_OR_S			(10 << 0)
#define BKGD_MIX_D_OR_S				(11 << 0)
#define BKGD_MIX_D_AND_S			(12 << 0)
#define BKGD_MIX_NOT_D_AND_S			(13 << 0)
#define BKGD_MIX_D_AND_NOT_S			(14 << 0)
#define BKGD_MIX_NOT_D_AND_NOT_S		(15 << 0)
#define BKGD_MIX_D_PLUS_S_DIV2			(23 << 0)
#define FRGD_MIX_NOT_D				(0 << 16)
#define FRGD_MIX_ZERO				(1 << 16)
#define FRGD_MIX_ONE				(2 << 16)
#define FRGD_MIX_D				(3 << 16)
#define FRGD_MIX_NOT_S				(4 << 16)
#define FRGD_MIX_D_XOR_S			(5 << 16)
#define FRGD_MIX_NOT_D_XOR_S			(6 << 16)
#define FRGD_MIX_S				(7 << 16)
#define FRGD_MIX_NOT_D_OR_NOT_S			(8 << 16)
#define FRGD_MIX_D_OR_NOT_S			(9 << 16)
#define FRGD_MIX_NOT_D_OR_S			(10 << 16)
#define FRGD_MIX_D_OR_S				(11 << 16)
#define FRGD_MIX_D_AND_S			(12 << 16)
#define FRGD_MIX_NOT_D_AND_S			(13 << 16)
#define FRGD_MIX_D_AND_NOT_S			(14 << 16)
#define FRGD_MIX_NOT_D_AND_NOT_S		(15 << 16)
#define FRGD_MIX_D_PLUS_S_DIV2			(23 << 16)

/* DP_SRC, page 5-57 */

#define BKGD_SRC_BKGD_CLR			(0 << 0)
#define BKGD_SRC_FRGD_CLR			(1 << 0)
#define BKGD_SRC_HOST				(2 << 0)
#define BKGD_SRC_BLIT				(3 << 0)
#define BKGD_SRC_PATTERN			(4 << 0)
#define BKGD_SRC_3D				(5 << 0)
#define FRGD_SRC_BKGD_CLR			(0 << 8)
#define FRGD_SRC_FRGD_CLR			(1 << 8)
#define FRGD_SRC_HOST				(2 << 8)
#define FRGD_SRC_BLIT				(3 << 8)
#define FRGD_SRC_PATTERN			(4 << 8)
#define FRGD_SRC_3D				(5 << 8)
#define MONO_SRC_ONE				(0 << 16)
#define MONO_SRC_PATTERN			(1 << 16)
#define MONO_SRC_HOST				(2 << 16)
#define MONO_SRC_BLIT				(3 << 16)

/* CLR_CMP_CNTL, page 5-60 */

#define COMPARE_FALSE				(0 << 0)
#define COMPARE_TRUE				(1 << 0)
#define COMPARE_NOT_EQUAL			(4 << 0)
#define COMPARE_EQUAL				(5 << 0)
#define COMPARE_DESTINATION			(0 << 24)
#define COMPARE_2D_SOURCE			(1 << 24)
#define COMPARE_TEXEL_SOURCE			(2 << 24)

/* FIFO_STAT, 5-61 */

#define FIFO_ERR				(1 << 31)

/* GUI_STAT, page 5-65 */

#define ENGINE_IDLE				(0 << 0)
#define ENGINE_BUSY				(1 << 0)
#define SCISSOR_LEFT_FLAG			(1 << 8)
#define SCISSOR_RIGHT_FLAG			(1 << 9)
#define SCISSOR_TOP_FLAG			(1 << 10)
#define SCISSOR_BOTTOM_FLAG			(1 << 11)

/* SCALE_3D_CNTL, page 6-7 */

/* TEX_SIZE_PITCH, page 6-19 */

/* TEX_CNTL, page 6-20 */

/* SETUP_CNTL, page 6-43 */

#define DONT_START_TRI				(1 << 0)
#define DONT_START_ANY				(1 << 2)
#define FLAT_SHADE_OFF				(0 << 3)
#define FLAT_SHADE_FCN_V1			(1 << 3)
#define FLAT_SHADE_FCN_V2			(2 << 3)
#define FLAT_SHADE_FCN_V3			(3 << 3)
#define SOLID_MODE_OFF				(0 << 5)
#define SOLID_MODE_ON				(1 << 5)
#define LOG_MAX_INC_ADJ				(1 << 6)
#define SETUP_CONTINUE				(1 << 31)

/* BM_GUI_TABLE bits */

#define CIRCULAR_BUF_SIZE_16KB			(0 << 0)
#define CIRCULAR_BUF_SIZE_32KB			(1 << 0)
#define CIRCULAR_BUF_SIZE_64KB			(2 << 0)
#define CIRCULAR_BUF_SIZE_128KB			(3 << 0)

#define LAST_DESCRIPTOR				(1 << 31)

#endif /* __MACH64_REGS_H__ */
