
/**************************************************************************

Copyright 1998-1999 Precision Insight, Inc., Cedar Park, Texas.
All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sub license, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial portions
of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

**************************************************************************/

/*
 * Authors:
 *   Keith Whitwell <keithw@precisioninsight.com>
 *
 * $PI$
 */

#ifndef _I810_H
#define _I810_H


/* Very simple memory management. 
 */
struct i810_memrange {
   unsigned long Start;
   unsigned long End;
   unsigned long Size;
};


/* 
 */
struct i810_ringbuffer {
   int base_reg;
   int tail_mask;
   I810MemRange mem;
   char *virtual_start;
   int head;
   int tail;
   int space;
};



/* To remove all debugging, make sure I810_DEBUG is defined as a
 * preprocessor symbol, and equal to zero.  
 */
#define I810_DEBUG 0   
#ifndef I810_DEBUG
#warning "Debugging enabled - expect reduced performance"
extern int I810_DEBUG;
#endif

#define DEBUG_VERBOSE_ACCEL  0x1
#define DEBUG_VERBOSE_SYNC   0x2
#define DEBUG_VERBOSE_VGA    0x4
#define DEBUG_VERBOSE_RING   0x8
#define DEBUG_VERBOSE_OUTREG 0x10
#define DEBUG_VERBOSE_MEMORY 0x20
#define DEBUG_ALWAYS_SYNC    0x40
#define DEBUG_VERBOSE_MSG    0x80




#define OUT_RING(n) {					\
   if (I810_DEBUG & DEBUG_VERBOSE_RING)			\
      fprintf(stderr, "OUT_RING %x: %x\n", outring, n);	\
   *(volatile unsigned int *)(virt + outring) = n;	\
   outring += 4;					\
   outring &= ringmask;					\
}

#define ADVANCE_LP_RING() {				\
    GLXSYM(I810LpRing).tail = outring;				\
    OUTREG(GLXSYM(I810LpRing).base_reg + RING_TAIL, outring);	\
}

#define BEGIN_LP_RING(n)						\
   I810RingBuffer *ring = &GLXSYM(I810LpRing);				\
   unsigned int outring, ringmask;					\
   volatile char *virt;							\
   if (n>2 && (I810_DEBUG&DEBUG_ALWAYS_SYNC)) I810Sync();		\
   if (ring->space < n*4) I810WaitLpRing(n*4);				\
   ring->space -= n*4;							\
   if (I810_DEBUG & DEBUG_VERBOSE_RING)					\
      fprintf(stderr, "BEGIN_LP_RING %d (%s)\n", n, __FUNCTION__);	\
   outring = ring->tail;						\
   ringmask = ring->tail_mask;						\
   virt = ring->virtual_start;			


/* Memory mapped register access macros */
#define INREG8(addr)        *(volatile CARD8  *)(GLXSYM(I810MMIOBase) + (addr))
#define INREG16(addr)       *(volatile CARD16 *)(GLXSYM(I810MMIOBase) + (addr))
#define INREG(addr)         *(volatile CARD32 *)(GLXSYM(I810MMIOBase) + (addr))

#define OUTREG8(addr, val) do {				\
   *(volatile CARD8 *)(GLXSYM(I810MMIOBase)  + (addr)) = (val);	\
   if (I810_DEBUG&DEBUG_VERBOSE_OUTREG)			\
     fprintf(stderr, "OUTREG8(%x, %x)\n", addr, val);	\
} while (0)

#define OUTREG16(addr, val) do {			\
   *(volatile CARD16 *)(GLXSYM(I810MMIOBase) + (addr)) = (val);	\
   if (I810_DEBUG&DEBUG_VERBOSE_OUTREG)			\
     fprintf(stderr, "OUTREG16(%x, %x)\n", addr, val);	\
} while (0)

#define OUTREG(addr, val) do {				\
   *(volatile CARD32 *)(GLXSYM(I810MMIOBase) + (addr)) = (val);	\
   if (I810_DEBUG&DEBUG_VERBOSE_OUTREG)			\
     fprintf(stderr, "OUTREG(%x, %x)\n", addr, val);	\
} while (0)


#define OUTREG_(addr, val)   *(volatile CARD32 *)(GLXSYM(I810MMIOBase) + (addr)) = (val)


#endif
