#ifndef _PROTO_H
#define _PROTO_H

#include "glxcommon.h"

/* set a default path to look for glx.so if Makefile doesn't specify */
#ifndef GLX_SO_PATH
#define GLX_SO_PATH	"/usr/X11R6/lib/modules/glx.so"
#endif

struct _Client;

typedef struct {
   
   int (*XReply)( Display *display, xReply *reply, int, Bool );

   int (*XRead)( Display *dpy, char *data, long num_bytes);

   void (*XSend)( Display *dpy, _Xconst char *data, long nbytes);

   void (*GLXRenderFlush)( void );
   
   void (*GLXLargeRenderFlush)( void );	/* needed? */

   int (*XFlush)( Display *dpy );

   int (*XSync)( Display *dpy, Bool );

   void (*flush_request)( xReq * );

   xReq *pending;

   struct gl_api_table *api_table;
   
   int (**dispatch_table)( struct _Client * );	

   Bool IsDirect;

} Proto;



extern Display *directDisplay;	/* client */
extern int directScreenNum;

extern char *glx_buf;
extern int glx_buf_head, glx_buf_tail;

extern Proto xProto, directProto;

/* Consider at most one direct context... Could do
 * better here with little effort, but the current implementation
 * won't support more anyway. 
 */
#define __glx_get_proto(dpy) (dpy == directDisplay ? &directProto : &xProto )

#define protoLockDisplay(dpy) LockDisplay(dpy)
#define protoGetReq(name, req)						\
	if (!proto->IsDirect) {						\
	   GetReq(name, req);    					\
	} else {							\
	   if (dpy->bufptr != dpy->buffer)				\
	      _XFlush(dpy);	/* Flush all indirect requests? */	\
	   req = (x##name##Req *)(((char *)proto->pending) = glx_buf);	\
	   req->reqType = X_##name;					\
	   req->length = (SIZEOF(x##name##Req))>>2;			\
           glx_buf_head = glx_buf_tail = SIZEOF(x##name##Req);		\
        }

#define protoSyncHandle() SyncHandle()
#define protoUnlockDisplay( dpy )				\
    if (proto->pending) proto->flush_request( proto->pending );	\
    UnlockDisplay( dpy )




extern char *__glx_request_direct( Display *dpy );
extern Bool __glx_init_direct( Display *dpy, char *reply );
extern void __glx_unload_direct( void );

#endif
