/* api1.c,v 1.1 1998/10/10 11:31:28 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * api1.c,v
 * Revision 1.1  1998/10/10 11:31:28  ripperda
 * added for api table, integrating with Mesa
 *
 * Revision 3.4  1998/03/27 03:30:36  brianp
 * fixed G++ warnings
 *
 * Revision 3.3  1998/02/20 04:49:19  brianp
 * move extension functions into apiext.c
 *
 * Revision 3.2  1998/02/08 20:23:49  brianp
 * lots of bitmap rendering changes
 *
 * Revision 3.1  1998/02/01 20:05:10  brianp
 * added glDrawRangeElements()
 *
 * Revision 3.0  1998/01/31 20:42:56  brianp
 * initial rev
 *
 */

#include <stdio.h>
#include <assert.h>
#include "glxlib.h"
#include "api.h"
#include "map_points.h"

/**
#include "image.h"
**/


/*
 * Part 1 of API functions
 */



void APIENTRY glAccum( GLenum op, GLfloat value )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Accum)(op, value);
}


void APIENTRY glAlphaFunc( GLenum func, GLclampf ref )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.AlphaFunc)(func, ref);
}


GLboolean APIENTRY glAreTexturesResident( GLsizei n, const GLuint *textures,
								 GLboolean *residences )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(GL_FALSE);
   return (*GLCurrent->API.AreTexturesResident)(n, textures, residences);
}


void APIENTRY glArrayElement( GLint i )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ArrayElement)(i);
}


void APIENTRY glBegin( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Begin)( mode );
}


void APIENTRY glBindTexture( GLenum target, GLuint texture )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.BindTexture)(target, texture);
}


void APIENTRY glBitmap( GLsizei width, GLsizei height,
                        GLfloat xorig, GLfloat yorig,
                        GLfloat xmove, GLfloat ymove,
                        const GLubyte *bitmap )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Bitmap)( width, height, xorig, yorig,
                         xmove, ymove, bitmap );
}


void APIENTRY glBlendFunc( GLenum sfactor, GLenum dfactor )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.BlendFunc)(sfactor, dfactor);
}


void APIENTRY glCallList( GLuint list )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CallList)(list);
}


void APIENTRY glCallLists( GLsizei n, GLenum type, const GLvoid *lists )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CallLists)(n, type, lists);
}


void APIENTRY glClear( GLbitfield mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Clear)(mask);
}


void APIENTRY glClearAccum( GLfloat red, GLfloat green,
			  GLfloat blue, GLfloat alpha )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClearAccum)(red, green, blue, alpha);
}



void APIENTRY glClearIndex( GLfloat c )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClearIndex)(c);
}


void APIENTRY glClearColor( GLclampf red,
			  GLclampf green,
			  GLclampf blue,
			  GLclampf alpha )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClearColor)(red, green, blue, alpha);
}


void APIENTRY glClearDepth( GLclampd depth )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClearDepth)( depth );
}


void APIENTRY glClearStencil( GLint s )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClearStencil)(s);
}


void APIENTRY glClipPlane( GLenum plane, const GLdouble *equation )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClipPlane)(plane, equation );
}


void APIENTRY glColor3b( GLbyte red, GLbyte green, GLbyte blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( BYTE_TO_FLOAT(red), BYTE_TO_FLOAT(green),
                       BYTE_TO_FLOAT(blue) );
}


void APIENTRY glColor3d( GLdouble red, GLdouble green, GLdouble blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( (GLfloat) red, (GLfloat) green, (GLfloat) blue );
}


void APIENTRY glColor3f( GLfloat red, GLfloat green, GLfloat blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( red, green, blue );
}


void APIENTRY glColor3i( GLint red, GLint green, GLint blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( INT_TO_FLOAT(red), INT_TO_FLOAT(green),
                       INT_TO_FLOAT(blue) );
}


void APIENTRY glColor3s( GLshort red, GLshort green, GLshort blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( SHORT_TO_FLOAT(red), SHORT_TO_FLOAT(green),
                       SHORT_TO_FLOAT(blue) );
}


void APIENTRY glColor3ub( GLubyte red, GLubyte green, GLubyte blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4ub)( red, green, blue, 255 );
}


void APIENTRY glColor3ui( GLuint red, GLuint green, GLuint blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( UINT_TO_FLOAT(red), UINT_TO_FLOAT(green),
                       UINT_TO_FLOAT(blue) );
}


void APIENTRY glColor3us( GLushort red, GLushort green, GLushort blue )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( USHORT_TO_FLOAT(red), USHORT_TO_FLOAT(green),
                       USHORT_TO_FLOAT(blue) );
}


void APIENTRY glColor4b( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( BYTE_TO_FLOAT(red), BYTE_TO_FLOAT(green),
                       BYTE_TO_FLOAT(blue), BYTE_TO_FLOAT(alpha) );
}


void APIENTRY glColor4d( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( (GLfloat) red, (GLfloat) green,
                       (GLfloat) blue, (GLfloat) alpha );
}


void APIENTRY glColor4f( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( red, green, blue, alpha );
}

void APIENTRY glColor4i( GLint red, GLint green, GLint blue, GLint alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( INT_TO_FLOAT(red), INT_TO_FLOAT(green),
                       INT_TO_FLOAT(blue), INT_TO_FLOAT(alpha) );
}


void APIENTRY glColor4s( GLshort red, GLshort green, GLshort blue, GLshort alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( SHORT_TO_FLOAT(red), SHORT_TO_FLOAT(green),
                       SHORT_TO_FLOAT(blue), SHORT_TO_FLOAT(alpha) );
}

void APIENTRY glColor4ub( GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4ub)( red, green, blue, alpha );
}

void APIENTRY glColor4ui( GLuint red, GLuint green, GLuint blue, GLuint alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( UINT_TO_FLOAT(red), UINT_TO_FLOAT(green),
                       UINT_TO_FLOAT(blue), UINT_TO_FLOAT(alpha) );
}

void APIENTRY glColor4us( GLushort red, GLushort green, GLushort blue, GLushort alpha )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( USHORT_TO_FLOAT(red), USHORT_TO_FLOAT(green),
                       USHORT_TO_FLOAT(blue), USHORT_TO_FLOAT(alpha) );
}


void APIENTRY glColor3bv( const GLbyte *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( BYTE_TO_FLOAT(v[0]), BYTE_TO_FLOAT(v[1]),
                       BYTE_TO_FLOAT(v[2]) );
}


void APIENTRY glColor3dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( (GLdouble) v[0], (GLdouble) v[1], (GLdouble) v[2] );
}


void APIENTRY glColor3fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3fv)( v );
}


void APIENTRY glColor3iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( INT_TO_FLOAT(v[0]), INT_TO_FLOAT(v[1]),
                       INT_TO_FLOAT(v[2]) );
}


void APIENTRY glColor3sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( SHORT_TO_FLOAT(v[0]), SHORT_TO_FLOAT(v[1]),
                       SHORT_TO_FLOAT(v[2]) );
}


void APIENTRY glColor3ubv( const GLubyte *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4ub)( v[0], v[1], v[2], 255 );
}


void APIENTRY glColor3uiv( const GLuint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)( UINT_TO_FLOAT(v[0]), UINT_TO_FLOAT(v[1]),
                       UINT_TO_FLOAT(v[2]) );
}


void APIENTRY glColor3usv( const GLushort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color3f)(  USHORT_TO_FLOAT(v[0]), USHORT_TO_FLOAT(v[1]),
                       USHORT_TO_FLOAT(v[2]) );

}


void APIENTRY glColor4bv( const GLbyte *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(  BYTE_TO_FLOAT(v[0]), BYTE_TO_FLOAT(v[1]),
                       BYTE_TO_FLOAT(v[2]), BYTE_TO_FLOAT(v[3]) );
}


void APIENTRY glColor4dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)( (GLdouble) v[0], (GLdouble) v[1],
                       (GLdouble) v[2], (GLdouble) v[3] );
}


void APIENTRY glColor4fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(v[0], v[1], v[2], v[3] );
}


void APIENTRY glColor4iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(INT_TO_FLOAT(v[0]), INT_TO_FLOAT(v[1]),
                       INT_TO_FLOAT(v[2]), INT_TO_FLOAT(v[3]) );
}


void APIENTRY glColor4sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(SHORT_TO_FLOAT(v[0]), SHORT_TO_FLOAT(v[1]),
                       SHORT_TO_FLOAT(v[2]), SHORT_TO_FLOAT(v[3]) );
}


void APIENTRY glColor4ubv( const GLubyte *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4ubv)(v );
}


void APIENTRY glColor4uiv( const GLuint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(UINT_TO_FLOAT(v[0]), UINT_TO_FLOAT(v[1]),
                       UINT_TO_FLOAT(v[2]), UINT_TO_FLOAT(v[3]) );
}


void APIENTRY glColor4usv( const GLushort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Color4f)(USHORT_TO_FLOAT(v[0]), USHORT_TO_FLOAT(v[1]),
                       USHORT_TO_FLOAT(v[2]), USHORT_TO_FLOAT(v[3]) );
}


void APIENTRY glColorMask( GLboolean red, GLboolean green,
			 GLboolean blue, GLboolean alpha )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorMask)(red, green, blue, alpha);
}


void APIENTRY glColorMaterial( GLenum face, GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorMaterial)(face, mode);
}


void APIENTRY glColorPointer( GLint size, GLenum type, GLsizei stride,
					 const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorPointer)(size, type, stride, ptr);
}


#if BUILD_COLOR_TABLE_EXT 

void APIENTRY glColorTableEXT( GLenum target, GLenum internalFormat,
                               GLsizei width, GLenum format, GLenum type,
                               const GLvoid *table )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorTable)(target, internalFormat, width,format,type,table );
}


void APIENTRY glColorSubTableEXT( GLenum target, GLsizei start, GLsizei count, 
                                  GLenum format, GLenum type,
                                  const GLvoid *data )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorSubTable)(target, start, data );
}

#endif


void APIENTRY glCopyPixels( GLint x, GLint y, GLsizei width, GLsizei height,
			  GLenum type )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyPixels)(x, y, width, height, type);
}


void APIENTRY glCopyTexImage1D( GLenum target, GLint level,
                                GLenum internalformat,
                                GLint x, GLint y,
                                GLsizei width, GLint border )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyTexImage1D)(target, level, internalformat,
								 x, y, width, border );
}


void APIENTRY glCopyTexImage2D( GLenum target, GLint level,
                                GLenum internalformat,
                                GLint x, GLint y,
                                GLsizei width, GLsizei height, GLint border )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyTexImage2D)(target, level, internalformat,
                              x, y, width, height, border );
}


void APIENTRY glCopyTexSubImage1D( GLenum target, GLint level,
                                   GLint xoffset, GLint x, GLint y,
                                   GLsizei width )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyTexSubImage1D)(target, level, xoffset, x, y, width );
}


void APIENTRY glCopyTexSubImage2D( GLenum target, GLint level,
                                   GLint xoffset, GLint yoffset,
                                   GLint x, GLint y,
                                   GLsizei width, GLsizei height )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyTexSubImage2D)(target, level, xoffset, yoffset,
                                 x, y, width, height );
}


/* 1.2 */
void APIENTRY glCopyTexSubImage3D( GLenum target, GLint level, GLint xoffset,
                                   GLint yoffset, GLint zoffset,
                                   GLint x, GLint y, GLsizei width,
                                   GLsizei height )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CopyTexSubImage3DEXT)(target, level, xoffset, yoffset,
                                    zoffset, x, y, width, height );
}



void APIENTRY glCullFace( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.CullFace)( mode);
}


void APIENTRY glDepthFunc( GLenum func )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DepthFunc)(func );
}


void APIENTRY glDepthMask( GLboolean flag )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DepthMask)(flag );
}


void APIENTRY glDepthRange( GLclampd near_val, GLclampd far_val )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DepthRange)(near_val, far_val );
}


void APIENTRY glDeleteLists( GLuint list, GLsizei range )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DeleteLists)( list, range);
}


void APIENTRY glDeleteTextures( GLsizei n, const GLuint *textures)
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DeleteTextures)( n, textures);
}


void APIENTRY glDisable( GLenum cap )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Disable)(cap );
}


void APIENTRY glDisableClientState( GLenum cap )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DisableClientState)(cap );
}


void APIENTRY glDrawArrays( GLenum mode, GLint first, GLsizei count )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawArrays)( mode, first, count);
}


void APIENTRY glDrawBuffer( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawBuffer)( mode);
}


void APIENTRY glDrawElements( GLenum mode, GLsizei count,
                              GLenum type, const GLvoid *indices )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawElements)(mode, count, type, indices );
}


void APIENTRY glDrawPixels( GLsizei width, GLsizei height,
                            GLenum format, GLenum type, const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawPixels)(width, height, format, type, pixels);
}


/* GL_VERSION_1_2 */
void APIENTRY glDrawRangeElements( GLenum mode, GLuint start, GLuint end,
                         GLsizei count, GLenum type, const GLvoid *indices )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawRangeElements)(mode, start, end, count, type, indices );
}


void APIENTRY glEnable( GLenum cap )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Enable)(cap );
}


void APIENTRY glEnableClientState( GLenum cap )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EnableClientState)(cap );
}


void APIENTRY glEnd( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.End)( );
}


void APIENTRY glEndList( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EndList)();
}




void APIENTRY glEvalCoord1d( GLdouble u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord1f)((GLfloat) u );
}


void APIENTRY glEvalCoord1f( GLfloat u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord1f)(u );
}


void APIENTRY glEvalCoord1dv( const GLdouble *u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord1f)((GLfloat) *u );
}


void APIENTRY glEvalCoord1fv( const GLfloat *u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord1f)((GLfloat) *u );
}


void APIENTRY glEvalCoord2d( GLdouble u, GLdouble v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord2f)((GLfloat) u, (GLfloat) v );
}


void APIENTRY glEvalCoord2f( GLfloat u, GLfloat v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord2f)(u, v );
}


void APIENTRY glEvalCoord2dv( const GLdouble *u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord2f)((GLfloat) u[0], (GLfloat) u[1] );
}


void APIENTRY glEvalCoord2fv( const GLfloat *u )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalCoord2f)(u[0], u[1] );
}


void APIENTRY glEvalPoint1( GLint i )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalPoint1)(i );
}


void APIENTRY glEvalPoint2( GLint i, GLint j )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalPoint2)(i, j );
}


void APIENTRY glEvalMesh1( GLenum mode, GLint i1, GLint i2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalMesh1)(mode, i1, i2 );
}

void APIENTRY glEdgeFlag( GLboolean flag )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EdgeFlag)( flag);
}


void APIENTRY glEdgeFlagv( const GLboolean *flag )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EdgeFlag)( *flag);
}


#if defined(MESA31)
void APIENTRY glEdgeFlagPointer( GLsizei stride, const GLvoid *ptr )
#else /* Mesa 3.0 or lower */
void APIENTRY glEdgeFlagPointer( GLsizei stride, const GLboolean *ptr )
#endif
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EdgeFlagPointer)( stride, ptr);
}


void APIENTRY glEvalMesh2( GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EvalMesh2)(mode, i1, i2, j1, j2 );
}


void APIENTRY glFeedbackBuffer( GLsizei size, GLenum type, GLfloat *buffer )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.FeedbackBuffer)( size, type, buffer);
}


void APIENTRY glFinish( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Finish)();
}


void APIENTRY glFlush( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Flush)();
}


void APIENTRY glFogf( GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Fogfv)( pname, &param);
}


void APIENTRY glFogi( GLenum pname, GLint param )
{
   GLfloat fparam = (GLfloat) param;
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Fogfv)( pname, &fparam);
}


void APIENTRY glFogfv( GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Fogfv)( pname, params);
}


void APIENTRY glFogiv( GLenum pname, const GLint *params )
{
   GLfloat p[4];
   GET_CONTEXT;
   CHECK_CONTEXT;

   switch (pname) {
      case GL_FOG_MODE:
      case GL_FOG_DENSITY:
      case GL_FOG_START:
      case GL_FOG_END:
      case GL_FOG_INDEX:
	 p[0] = (GLfloat) *params;
	 break;
      case GL_FOG_COLOR:
	 p[0] = INT_TO_FLOAT( params[0] );
	 p[1] = INT_TO_FLOAT( params[1] );
	 p[2] = INT_TO_FLOAT( params[2] );
	 p[3] = INT_TO_FLOAT( params[3] );
	 break;
      default:
         /* Error will be caught later in gl_Fogfv */
         ;
   }
   (*GLCurrent->API.Fogfv)(pname, p );
}



void APIENTRY glFrontFace( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.FrontFace)( mode);
}


void APIENTRY glFrustum( GLdouble left, GLdouble right,
                         GLdouble bottom, GLdouble top,
                         GLdouble nearval, GLdouble farval )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Frustum)( left, right, bottom, top, nearval, farval);
}


GLuint APIENTRY glGenLists( GLsizei range )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(0);
   return (*GLCurrent->API.GenLists)( range);
}


void APIENTRY glGenTextures( GLsizei n, GLuint *textures )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GenTextures)( n, textures);
}


void APIENTRY glGetBooleanv( GLenum pname, GLboolean *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetBooleanv)( pname, params);
}


void APIENTRY glGetClipPlane( GLenum plane, GLdouble *equation )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetClipPlane)( plane, equation);
}


void APIENTRY glGetColorTableEXT( GLenum target, GLenum format,
                                  GLenum type, GLvoid *table )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetColorTable)( target, format, type, table);
}


void APIENTRY glGetColorTableParameterivEXT( GLenum target, GLenum pname,
                                             GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetColorTableParameteriv)( target, pname, params);
}


void APIENTRY glGetColorTableParameterfvEXT( GLenum target, GLenum pname,
                                             GLfloat *params )
{
   GLint iparams;
   glGetColorTableParameterivEXT( target, pname, &iparams );
   *params = (GLfloat) iparams;
}


void APIENTRY glGetDoublev( GLenum pname, GLdouble *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetDoublev)( pname, params);
}


GLenum APIENTRY glGetError( void )
{
   GET_CONTEXT;
   if (!GLCurrent) {
      /* No current context */
      return (GLenum) GL_NO_ERROR;
   }
   return (*GLCurrent->API.GetError)();
}


void APIENTRY glGetFloatv( GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetFloatv)( pname, params);
}


void APIENTRY glGetIntegerv( GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetIntegerv)( pname, params);
}


void APIENTRY glGetLightfv( GLenum light, GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetLightfv)( light, pname, params);
}


void APIENTRY glGetLightiv( GLenum light, GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetLightiv)( light, pname, params);
}


void APIENTRY glGetMapdv( GLenum target, GLenum query, GLdouble *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetMapdv)(target, query, v );
}


void APIENTRY glGetMapfv( GLenum target, GLenum query, GLfloat *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetMapfv)(target, query, v );
}


void APIENTRY glGetMapiv( GLenum target, GLenum query, GLint *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetMapiv)(target, query, v );
}


void APIENTRY glGetMaterialfv( GLenum face, GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetMaterialfv)( face, pname, params);
}


void APIENTRY glGetMaterialiv( GLenum face, GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetMaterialiv)( face, pname, params);
}


void APIENTRY glGetPixelMapfv( GLenum map, GLfloat *values )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPixelMapfv)( map, values);
}


void APIENTRY glGetPixelMapuiv( GLenum map, GLuint *values )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPixelMapuiv)( map, values);
}


void APIENTRY glGetPixelMapusv( GLenum map, GLushort *values )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPixelMapusv)( map, values);
}


void APIENTRY glGetPointerv( GLenum pname, GLvoid **params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPointerv)( pname, params);
}


void APIENTRY glGetPolygonStipple( GLubyte *mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPolygonStipple)( mask);
}


const GLubyte * APIENTRY glGetString( GLenum name )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(NULL);
   return (*GLCurrent->API.GetString)( name);
}



void APIENTRY glGetTexEnvfv( GLenum target, GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexEnvfv)( target, pname, params);
}


void APIENTRY glGetTexEnviv( GLenum target, GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexEnviv)( target, pname, params);
}


void APIENTRY glGetTexGeniv( GLenum coord, GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexGeniv)( coord, pname, params);
}


void APIENTRY glGetTexGendv( GLenum coord, GLenum pname, GLdouble *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexGendv)( coord, pname, params);
}


void APIENTRY glGetTexGenfv( GLenum coord, GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexGenfv)( coord, pname, params);
}



void APIENTRY glGetTexImage( GLenum target, GLint level, GLenum format,
                             GLenum type, GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexImage)( target, level, format, type, pixels);
}


void APIENTRY glGetTexLevelParameterfv( GLenum target, GLint level,
                                        GLenum pname, GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexLevelParameterfv)( target, level, pname, params);
}


void APIENTRY glGetTexLevelParameteriv( GLenum target, GLint level,
                                        GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexLevelParameteriv)( target, level, pname, params);
}




void APIENTRY glGetTexParameterfv( GLenum target, GLenum pname, GLfloat *params)
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexParameterfv)( target, pname, params);
}


void APIENTRY glGetTexParameteriv( GLenum target, GLenum pname, GLint *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetTexParameteriv)( target, pname, params);
}


void APIENTRY glHint( GLenum target, GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Hint)( target, mode);
}


void APIENTRY glIndexd( GLdouble c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexf)((GLfloat) c );
}


void APIENTRY glIndexf( GLfloat c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexf)(c );
}


void APIENTRY glIndexi( GLint c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)(c );
}


void APIENTRY glIndexs( GLshort c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)((GLint) c );
}


/* GL_VERSION_1_1 */
void APIENTRY glIndexub( GLubyte c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)((GLint) c );
}


void APIENTRY glIndexdv( const GLdouble *c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexf)((GLfloat) *c );
}


void APIENTRY glIndexfv( const GLfloat *c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexf)(*c );
}


void APIENTRY glIndexiv( const GLint *c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)(*c );
}


void APIENTRY glIndexsv( const GLshort *c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)((GLint) *c );
}


/* GL_VERSION_1_1 */
void APIENTRY glIndexubv( const GLubyte *c )
{
   GET_CONTEXT;
   (*GLCurrent->API.Indexi)((GLint) *c );
}


void APIENTRY glIndexMask( GLuint mask )
{
   GET_CONTEXT;
   (*GLCurrent->API.IndexMask)( mask);
}


void APIENTRY glIndexPointer( GLenum type, GLsizei stride, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.IndexPointer)( type, stride, ptr);
}


void APIENTRY glInterleavedArrays( GLenum format, GLsizei stride,
                                   const GLvoid *pointer )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.InterleavedArrays)(format, stride, pointer );
}


void APIENTRY glInitNames( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.InitNames)();
}


GLboolean APIENTRY glIsList( GLuint list )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(GL_FALSE);
   return (*GLCurrent->API.IsList)( list);
}


GLboolean APIENTRY glIsTexture( GLuint texture )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(GL_FALSE);
   return (*GLCurrent->API.IsTexture)( texture);
}


void APIENTRY glLightf( GLenum light, GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Lightfv)(light, pname, &param );
}



void APIENTRY glLighti( GLenum light, GLenum pname, GLint param )
{
   GLfloat fparam = (GLfloat) param;
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Lightfv)(light, pname, &fparam );
}



void APIENTRY glLightfv( GLenum light, GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Lightfv)(light, pname, params );
}



void APIENTRY glLightiv( GLenum light, GLenum pname, const GLint *params )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   CHECK_CONTEXT;

   switch (pname) {
      case GL_AMBIENT:
      case GL_DIFFUSE:
      case GL_SPECULAR:
         fparam[0] = INT_TO_FLOAT( params[0] );
         fparam[1] = INT_TO_FLOAT( params[1] );
         fparam[2] = INT_TO_FLOAT( params[2] );
         fparam[3] = INT_TO_FLOAT( params[3] );
         break;
      case GL_POSITION:
         fparam[0] = (GLfloat) params[0];
         fparam[1] = (GLfloat) params[1];
         fparam[2] = (GLfloat) params[2];
         fparam[3] = (GLfloat) params[3];
         break;
      case GL_SPOT_DIRECTION:
         fparam[0] = (GLfloat) params[0];
         fparam[1] = (GLfloat) params[1];
         fparam[2] = (GLfloat) params[2];
         break;
      case GL_SPOT_EXPONENT:
	  case GL_SPOT_CUTOFF:
      case GL_CONSTANT_ATTENUATION:
      case GL_LINEAR_ATTENUATION:
      case GL_QUADRATIC_ATTENUATION:
         fparam[0] = (GLfloat) params[0];
         break;
      default:
		 /* error will be caught later in gl_Lightfv */
		 ;
   }
   (*GLCurrent->API.Lightfv)(light, pname, fparam );
}



void APIENTRY glLightModelf( GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LightModelfv)(pname, &param );
}


void APIENTRY glLightModeli( GLenum pname, GLint param )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   fparam[0] = (GLfloat) param;
   (*GLCurrent->API.LightModelfv)(pname, fparam );
}


void APIENTRY glLightModelfv( GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LightModelfv)(pname, params );
}


void APIENTRY glLightModeliv( GLenum pname, const GLint *params )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   CHECK_CONTEXT;

   switch (pname) {
      case GL_LIGHT_MODEL_AMBIENT:
         fparam[0] = INT_TO_FLOAT( params[0] );
         fparam[1] = INT_TO_FLOAT( params[1] );
         fparam[2] = INT_TO_FLOAT( params[2] );
         fparam[3] = INT_TO_FLOAT( params[3] );
         break;
      case GL_LIGHT_MODEL_LOCAL_VIEWER:
      case GL_LIGHT_MODEL_TWO_SIDE:
         fparam[0] = (GLfloat) params[0];
         break;
      default:
         /* Error will be caught later in gl_LightModelfv */
         ;
   }
   (*GLCurrent->API.LightModelfv)(pname, fparam );
}


void APIENTRY glLineWidth( GLfloat width )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LineWidth)( width);
}


void APIENTRY glLineStipple( GLint factor, GLushort pattern )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LineStipple)( factor, pattern);
}


void APIENTRY glListBase( GLuint base )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ListBase)( base);
}


void APIENTRY glLoadIdentity( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LoadIdentity)( );
}


void APIENTRY glLoadMatrixd( const GLdouble *m )
{
   GLfloat fm[16];
   GLuint i;
   GET_CONTEXT;
   CHECK_CONTEXT;

   for (i=0;i<16;i++) {
	  fm[i] = (GLfloat) m[i];
   }

   (*GLCurrent->API.LoadMatrixf)(fm );
}


void APIENTRY glLoadMatrixf( const GLfloat *m )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LoadMatrixf)(m );
}


void APIENTRY glLoadName( GLuint name )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LoadName)( name);
}


void APIENTRY glLogicOp( GLenum opcode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.LogicOp)( opcode);
}



void APIENTRY glMap1d( GLenum target, GLdouble u1, GLdouble u2, GLint stride,
                       GLint order, const GLdouble *points )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Map1d)(target, u1, u2, stride, order, points );
}


void APIENTRY glMap1f( GLenum target, GLfloat u1, GLfloat u2, GLint stride,
                       GLint order, const GLfloat *points )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Map1f)(target, u1, u2, stride, order, points);
}


void APIENTRY glMap2d( GLenum target,
                       GLdouble u1, GLdouble u2, GLint ustride, GLint uorder,
                       GLdouble v1, GLdouble v2, GLint vstride, GLint vorder,
                       const GLdouble *points )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Map2d)(target, u1, u2, ustride, uorder,
                     v1, v2, vstride, vorder, points);
}


void APIENTRY glMap2f( GLenum target,
                       GLfloat u1, GLfloat u2, GLint ustride, GLint uorder,
                       GLfloat v1, GLfloat v2, GLint vstride, GLint vorder,
                       const GLfloat *points )
{
   GET_CONTEXT;
   CHECK_CONTEXT;

   (*GLCurrent->API.Map2f)(target, u1, u2, ustride, uorder,
                     v1, v2, vstride, vorder, points);
}


void APIENTRY glMapGrid1d( GLint un, GLdouble u1, GLdouble u2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MapGrid1d)(un, (GLfloat) u1, (GLfloat) u2 );
}


void APIENTRY glMapGrid1f( GLint un, GLfloat u1, GLfloat u2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MapGrid1f)(un, u1, u2 );
}


void APIENTRY glMapGrid2d( GLint un, GLdouble u1, GLdouble u2,
                           GLint vn, GLdouble v1, GLdouble v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MapGrid2d)(un, (GLfloat) u1, (GLfloat) u2,
                         vn, (GLfloat) v1, (GLfloat) v2 );
}


void APIENTRY glMapGrid2f( GLint un, GLfloat u1, GLfloat u2,
                           GLint vn, GLfloat v1, GLfloat v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MapGrid2f)(un, u1, u2, vn, v1, v2 );
}


void APIENTRY glMaterialf( GLenum face, GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Materialfv)(face, pname, &param );
}



void APIENTRY glMateriali( GLenum face, GLenum pname, GLint param )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   fparam[0] = (GLfloat) param;
   (*GLCurrent->API.Materialfv)(face, pname, fparam );
}


void APIENTRY glMaterialfv( GLenum face, GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Materialfv)(face, pname, params );
}


void APIENTRY glMaterialiv( GLenum face, GLenum pname, const GLint *params )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   switch (pname) {
      case GL_AMBIENT:
      case GL_DIFFUSE:
      case GL_SPECULAR:
      case GL_EMISSION:
      case GL_AMBIENT_AND_DIFFUSE:
         fparam[0] = INT_TO_FLOAT( params[0] );
         fparam[1] = INT_TO_FLOAT( params[1] );
         fparam[2] = INT_TO_FLOAT( params[2] );
         fparam[3] = INT_TO_FLOAT( params[3] );
         break;
      case GL_SHININESS:
         fparam[0] = (GLfloat) params[0];
         break;
      case GL_COLOR_INDEXES:
         fparam[0] = (GLfloat) params[0];
         fparam[1] = (GLfloat) params[1];
         fparam[2] = (GLfloat) params[2];
         break;
      default:
         /* Error will be caught later in gl_Materialfv */
         ;
   }
   (*GLCurrent->API.Materialfv)(face, pname, fparam );
}


void APIENTRY glMatrixMode( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MatrixMode)(mode );
}


void APIENTRY glMultMatrixd( const GLdouble *m )
{
   GLfloat fm[16];
   GLuint i;
   GET_CONTEXT;
   CHECK_CONTEXT;

   for (i=0;i<16;i++) {
	  fm[i] = (GLfloat) m[i];
   }

   (*GLCurrent->API.MultMatrixf)(fm );
}


void APIENTRY glMultMatrixf( const GLfloat *m )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.MultMatrixf)(m );
}


void APIENTRY glNewList( GLuint list, GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.NewList)( list, mode);
}

void APIENTRY glNormal3b( GLbyte nx, GLbyte ny, GLbyte nz )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(BYTE_TO_FLOAT(nx),
                        BYTE_TO_FLOAT(ny), BYTE_TO_FLOAT(nz) );
}


void APIENTRY glNormal3d( GLdouble nx, GLdouble ny, GLdouble nz )
{
   GLfloat fx, fy, fz;
   GET_CONTEXT;
   if (ABSD(nx)<0.00001)   fx = 0.0F;   else  fx = nx;
   if (ABSD(ny)<0.00001)   fy = 0.0F;   else  fy = ny;
   if (ABSD(nz)<0.00001)   fz = 0.0F;   else  fz = nz;
   (*GLCurrent->API.Normal3f)(fx, fy, fz );
}


void APIENTRY glNormal3f( GLfloat nx, GLfloat ny, GLfloat nz )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(nx, ny, nz );
}


void APIENTRY glNormal3i( GLint nx, GLint ny, GLint nz )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(INT_TO_FLOAT(nx),
                        INT_TO_FLOAT(ny), INT_TO_FLOAT(nz) );
}


void APIENTRY glNormal3s( GLshort nx, GLshort ny, GLshort nz )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(SHORT_TO_FLOAT(nx),
                        SHORT_TO_FLOAT(ny), SHORT_TO_FLOAT(nz) );
}


void APIENTRY glNormal3bv( const GLbyte *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(BYTE_TO_FLOAT(v[0]),
                        BYTE_TO_FLOAT(v[1]), BYTE_TO_FLOAT(v[2]) );
}


void APIENTRY glNormal3dv( const GLdouble *v )
{
   GLfloat fx, fy, fz;
   GET_CONTEXT;
   if (ABSD(v[0])<0.00001)   fx = 0.0F;   else  fx = v[0];
   if (ABSD(v[1])<0.00001)   fy = 0.0F;   else  fy = v[1];
   if (ABSD(v[2])<0.00001)   fz = 0.0F;   else  fz = v[2];
   (*GLCurrent->API.Normal3f)(fx, fy, fz );
}


void APIENTRY glNormal3fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3fv)(v );
}


void APIENTRY glNormal3iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(INT_TO_FLOAT(v[0]),
                        INT_TO_FLOAT(v[1]), INT_TO_FLOAT(v[2]) );
}


void APIENTRY glNormal3sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Normal3f)(SHORT_TO_FLOAT(v[0]),
                        SHORT_TO_FLOAT(v[1]), SHORT_TO_FLOAT(v[2]) );
}


void APIENTRY glNormalPointer( GLenum type, GLsizei stride, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.NormalPointer)(type, stride, ptr);
}

