/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include "common.h"

char *stamp(time_t epoch, const char *format)
{
    char buf[TIMEBUF];
    char *str = NULL;
    int i;
    struct tm *mytime;

    bzero(buf, sizeof(buf));
    mytime = localtime(&epoch);

    i = strftime(buf, sizeof(buf), format, mytime);

    buf[i] = 0;
    str = buf;

    return str;
}

/* remove characters (rm) from string (str) */
char *stripstr(char *str, char *rm)
{
    char buf[LINE_MAX], *orm;
    int i = 0, c;

    if (rm == NULL || str == NULL)
	return str;

    while (*str) {
	orm = rm;

	while (*orm) {
	    if (*str == *orm) {
		c = *str++;
		continue;
	    }

	    c = *orm++;
	}

        buf[i++] = *str++;
    }

    buf[i] = 0;

    return strdup(buf);
}

/* convert integer to ascii. this is by ndf@linux.mit.edu */
char *itoa(int i)
{
    char buf[13];
    char *pos = buf + sizeof(buf) - 1;
    unsigned int u;
    int negetive = 0;

    if (i < 0) {
	negetive = 1;
	u = ((unsigned int)(-(1+i))) + 1;
    }
    else
	u = i;

    *pos = 0;

    do {
	*--pos = '0' + (u % 10);
	u /= 10;
    } while (u);

    if (negetive)
	*--pos = '-';

    return pos;
}
