/* mipsel.r3000-ps1.h
   created from mipsel.r3000-ps1.bin, 21451 (0x53cb) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_MIPSEL_R3000_PS1_SIZE    21451
#define STUB_MIPSEL_R3000_PS1_ADLER32 0x31777899
#define STUB_MIPSEL_R3000_PS1_CRC32   0x6c00c346

unsigned char stub_mipsel_r3000_ps1[21451] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  8,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
156, 42,  0,  0,  1,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 74,  0, 71,  0,  0,  0,  8, 60,  0,  0,  8, 37, 35, 64,  8,  2,   /* 0x  30 */
  8,  0,  0,  1,236,255,189, 39,  0,  0,164,175,  4,  0,165,175,   /* 0x  40 */
  8,  0,166,175, 12,  0,167,175, 16,  0,191,175,  0,  0,  5, 60,   /* 0x  50 */
  0,  0,165, 36,  0,  0,  8, 60,  0,  0,  8, 37, 35, 64,  8,  2,   /* 0x  60 */
 20,  0,  1, 52,  8,  0,  0,  1, 35,232,161,  3,  0,  0,164,175,   /* 0x  70 */
  4,  0,165,175,  8,  0,166,175, 12,  0,167,175, 16,  0,191,175,   /* 0x  80 */
 20,  0,161,175,  0,  0,  5, 37, 24,  0,168, 39,  0,  0,  5, 60,   /* 0x  90 */
  0,  0,165, 36,  0,  0,  8, 60,  0,  0,  8, 37,  0,  0,  8, 60,   /* 0x  a0 */
160,  0, 10, 36,  9,248, 64,  1, 68,  0,  9, 36,  0,  0,164,143,   /* 0x  b0 */
  4,  0,165,143,  8,  0,166,143, 12,  0,167,143, 16,  0,191,143,   /* 0x  c0 */
  0,  0,  0,  8, 20,  0,189, 39, 24,  0,  1, 36, 35,232,161,  3,   /* 0x  d0 */
  0,  0,164,175,  4,  0,165,175,  8,  0,166,175, 12,  0,167,175,   /* 0x  e0 */
 16,  0,191,175, 20,  0,161,175, 24,  0,164, 39, 33, 64,128,  0,   /* 0x  f0 */
  0,  0,  5, 60,  0,  0,165, 36,  0,  0,  6, 52,  0,  0,174,140,   /* 0x 100 */
252,255,198, 36,  0,  0, 14,173,  4,  0,165, 36,251,255,192, 20,   /* 0x 110 */
  4,  0,  8, 37,  0,  0,  4, 37,  0,  0,165, 36,  0,  0,  8, 60,   /* 0x 120 */
  8,  0,128,  0,  0,  0,  8, 37,  8,  0,128,  0,  0,  0,  8, 60,   /* 0x 130 */
160,  0, 10, 36,  9,248, 64,  1, 68,  0,  9, 36,  0,  0,164,143,   /* 0x 140 */
  4,  0,165,143,  8,  0,166,143, 12,  0,167,143, 16,  0,191,143,   /* 0x 150 */
 20,  0,161,143,  0,  0,  0,  8, 33,232,161,  3,  0,  0,  8, 60,   /* 0x 160 */
  0,  0,  8, 37, 35, 64,  8,  2,  0,  0, 14, 60,232,255,206, 37,   /* 0x 170 */
  8,  0,  0,  1, 33,  8,160,  3,  0,  0,196,173,  4,  0,197,173,   /* 0x 180 */
  8,  0,198,173, 12,  0,199,173, 16,  0,223,173, 20,  0,193,173,   /* 0x 190 */
 33,232,192,  1,  0,  0,  5, 37, 24,  0,168, 39,  0,  0, 14, 60,   /* 0x 1a0 */
232,255,206, 37, 33,  8,160,  3,  0,  0,196,173,  4,  0,197,173,   /* 0x 1b0 */
  8,  0,198,173, 12,  0,199,173, 16,  0,223,173, 20,  0,193,173,   /* 0x 1c0 */
 33,232,192,  1, 24,  0,164, 39, 33, 64,128,  0,  0,  0,  5, 60,   /* 0x 1d0 */
  0,  0,165, 36,160,  0, 10, 36,  9,248, 64,  1, 68,  0,  9, 36,   /* 0x 1e0 */
  0,  0,164,143,  4,  0,165,143,  8,  0,166,143, 12,  0,167,143,   /* 0x 1f0 */
 16,  0,191,143, 20,  0,161,143,  0,  0,  0,  8, 33,232, 32,  0,   /* 0x 200 */
  0,  0,  6, 52,  0,  0,  0,173,255,255,198, 36,253,255,192, 20,   /* 0x 210 */
  4,  0,  8, 37,  0,  0,  6, 52,192, 48,  6,  0,  0,  0,  0,173,   /* 0x 220 */
255,255,198, 36,253,255,192, 20,  4,  0,  8, 37,  0,128, 13, 60,   /* 0x 230 */
 33, 72,160,  1,  1,  0, 11, 36,194,119,  9,  0,  7,  0,169, 21,   /* 0x 240 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 250 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,  1,  0, 15, 36,   /* 0x 260 */
  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,  0,  0, 14,161,   /* 0x 270 */
241,255,  0, 16,  1,  0,  8, 37,194,119,  9,  0,  7,  0,169, 21,   /* 0x 280 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 290 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0, 64,120, 15,  0,   /* 0x 2a0 */
 33,120,238,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 2b0 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 2c0 */
  2,114,  9,  0,  0, 78,  9,  0,235,255,192, 17,  2,  0, 14, 36,   /* 0x 2d0 */
  3,  0,238, 21,253,255,239, 37,  8,  0,  0, 16, 33,120, 96,  1,   /* 0x 2e0 */
  0,  0,174,144,  0,122, 15,  0, 33,120,238,  1,  1,  0,239, 37,   /* 0x 2f0 */
255,255,224, 17,  1,  0,165, 36, 33, 88,224,  1,194,119,  9,  0,   /* 0x 300 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 310 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 320 */
 33, 96,192,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 330 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 340 */
  2,114,  9,  0,  0, 78,  9,  0, 64, 96, 12,  0, 33, 96,142,  1,   /* 0x 350 */
 23,  0,128, 21,254,255,140, 37,  1,  0, 12, 36,194,119,  9,  0,   /* 0x 360 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 370 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 380 */
 64, 96, 12,  0, 33, 96,142,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x 390 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 3a0 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,235,255,192, 17,   /* 0x 3b0 */
  1, 13,238, 45,  4,  0,140, 37, 35, 96,142,  1,  4,  0,238, 41,   /* 0x 3c0 */
 13,  0,192, 21, 35,120, 15,  1,  4,  0,142, 41, 11,  0,192, 21,   /* 0x 3d0 */
  0,  0,238,153,  3,  0,238,137,252,255,140, 37,  0,  0, 14,185,   /* 0x 3e0 */
  3,  0, 14,169,  4,  0,239, 37,247,255,128, 21,  4,  0,  8, 37,   /* 0x 3f0 */
146,255,  0, 16,194,119,  9,  0,  0,  0,238,145,255,255,140, 37,   /* 0x 400 */
  1,  0,239, 37,  1,  0,  8, 37,251,255,128, 21,255,255, 14,161,   /* 0x 410 */
138,255,  0, 16,194,119,  9,  0,  0,128, 13, 60, 33, 72,160,  1,   /* 0x 420 */
  1,  0, 11, 36,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 430 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 440 */
  2,114,  9,  0,  0, 78,  9,  0,  1,  0, 15, 36,  5,  0,192, 17,   /* 0x 450 */
  0,  0,174,144,  1,  0,165, 36,  0,  0, 14,161,241,255,  0, 16,   /* 0x 460 */
  1,  0,  8, 37,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 470 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 480 */
  2,114,  9,  0,  0, 78,  9,  0, 64,120, 15,  0, 33,120,238,  1,   /* 0x 490 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,   /* 0x 4a0 */
  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,   /* 0x 4b0 */
  0, 78,  9,  0, 13,  0,192, 21,254,255,238, 37, 33,120,207,  1,   /* 0x 4c0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,   /* 0x 4d0 */
  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,   /* 0x 4e0 */
  0, 78,  9,  0,223,255,  0, 16, 33,120,238,  1, 13,  0,192, 21,   /* 0x 4f0 */
253,255,239, 37,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 500 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 510 */
  2,114,  9,  0,  0, 78,  9,  0, 33,120, 96,  1, 11,  0,  0, 16,   /* 0x 520 */
  1,  0,204, 49,  0,  0,174,144,  0,122, 15,  0, 33,120,238,  1,   /* 0x 530 */
  1,  0,238, 37,255,255,192, 17,  1,  0,165, 36, 66,120, 15,  0,   /* 0x 540 */
  1,  0,239, 37, 33, 88,224,  1,  1,  0,204, 49,194,119,  9,  0,   /* 0x 550 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 560 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 570 */
 64, 96, 12,  0, 33, 96,142,  1, 23,  0,128, 21,254,255,140, 37,   /* 0x 580 */
  1,  0, 12, 36,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 590 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 5a0 */
  2,114,  9,  0,  0, 78,  9,  0, 64, 96, 12,  0, 33, 96,142,  1,   /* 0x 5b0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,   /* 0x 5c0 */
  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,   /* 0x 5d0 */
  0, 78,  9,  0,235,255,192, 17,  1,  5,238, 45,  4,  0,140, 37,   /* 0x 5e0 */
 35, 96,142,  1,  4,  0,238, 41, 13,  0,192, 21, 35,120, 15,  1,   /* 0x 5f0 */
  4,  0,142, 41, 11,  0,192, 21,  0,  0,238,153,  3,  0,238,137,   /* 0x 600 */
252,255,140, 37,  0,  0, 14,185,  3,  0, 14,169,  4,  0,239, 37,   /* 0x 610 */
247,255,128, 21,  4,  0,  8, 37,131,255,  0, 16,194,119,  9,  0,   /* 0x 620 */
  0,  0,238,145,255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,   /* 0x 630 */
251,255,128, 21,255,255, 14,161,123,255,  0, 16,194,119,  9,  0,   /* 0x 640 */
  0,128, 13, 60, 33, 72,160,  1,  1,  0, 11, 36,194,119,  9,  0,   /* 0x 650 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 660 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 670 */
  1,  0, 15, 36,  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,   /* 0x 680 */
  0,  0, 14,161,241,255,  0, 16,  1,  0,  8, 37,194,119,  9,  0,   /* 0x 690 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 6a0 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 6b0 */
 64,120, 15,  0, 33,120,238,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x 6c0 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 6d0 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0, 13,  0,192, 21,   /* 0x 6e0 */
254,255,238, 37, 33,120,238,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x 6f0 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 700 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,223,255,  0, 16,   /* 0x 710 */
 33,120,238,  1, 13,  0,192, 21,253,255,239, 37,194,119,  9,  0,   /* 0x 720 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36,   /* 0x 730 */
 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0,   /* 0x 740 */
 33,120, 96,  1, 11,  0,  0, 16,  1,  0,204, 49,  0,  0,174,144,   /* 0x 750 */
  0,122, 15,  0, 33,120,238,  1,  1,  0,238, 37,255,255,192, 17,   /* 0x 760 */
  1,  0,165, 36, 66,120, 15,  0,  1,  0,239, 37, 33, 88,224,  1,   /* 0x 770 */
  1,  0,204, 49,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 780 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 790 */
  2,114,  9,  0,  0, 78,  9,  0, 35,  0,128, 21,254,255,204, 37,   /* 0x 7a0 */
 12,  0,192, 17,  1,  0, 12, 36,194,119,  9,  0,  7,  0,169, 21,   /* 0x 7b0 */
 64, 72,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x 7c0 */
  1,  0, 41, 37,  2,114,  9,  0,  0, 78,  9,  0, 22,  0,  0, 16,   /* 0x 7d0 */
 33, 96,192,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x 7e0 */
  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 7f0 */
  2,114,  9,  0,  0, 78,  9,  0, 64, 96, 12,  0, 33, 96,142,  1,   /* 0x 800 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,144,   /* 0x 810 */
  1,  0,165, 36, 64, 72,  9,  0,  1,  0, 41, 37,  2,114,  9,  0,   /* 0x 820 */
  0, 78,  9,  0,235,255,192, 17,  1,  5,238, 45,  5,  0,140, 37,   /* 0x 830 */
 35, 96,142,  1,  4,  0,238, 41, 13,  0,192, 21, 35,120, 15,  1,   /* 0x 840 */
  4,  0,142, 41, 11,  0,192, 21,  0,  0,238,153,  3,  0,238,137,   /* 0x 850 */
252,255,140, 37,  0,  0, 14,185,  3,  0, 14,169,  4,  0,239, 37,   /* 0x 860 */
247,255,128, 21,  4,  0,  8, 37,121,255,  0, 16,194,119,  9,  0,   /* 0x 870 */
  0,  0,238,145,255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,   /* 0x 880 */
251,255,128, 21,255,255, 14,161,113,255,  0, 16,194,119,  9,  0,   /* 0x 890 */
  0,128, 13, 60, 33, 72,160,  1,  1,  0, 11, 36,194,119,  9,  0,   /* 0x 8a0 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x 8b0 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 8c0 */
  1,  0, 15, 36,  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,   /* 0x 8d0 */
  0,  0, 14,161,241,255,  0, 16,  1,  0,  8, 37,194,119,  9,  0,   /* 0x 8e0 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x 8f0 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x 900 */
 64,120, 15,  0, 33,120,238,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x 910 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x 920 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,235,255,192, 17,   /* 0x 930 */
  2,  0, 14, 36,  3,  0,238, 21,253,255,239, 37,  8,  0,  0, 16,   /* 0x 940 */
 33,120, 96,  1,  0,  0,174,144,  0,122, 15,  0, 33,120,238,  1,   /* 0x 950 */
  1,  0,239, 37,255,255,224, 17,  1,  0,165, 36, 33, 88,224,  1,   /* 0x 960 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x 970 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x 980 */
  1,  0, 41, 37, 33, 96,192,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x 990 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x 9a0 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 64, 96, 12,  0,   /* 0x 9b0 */
 33, 96,142,  1, 23,  0,128, 21,254,255,140, 37,  1,  0, 12, 36,   /* 0x 9c0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x 9d0 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x 9e0 */
  1,  0, 41, 37, 64, 96, 12,  0, 33, 96,142,  1,194,119,  9,  0,   /* 0x 9f0 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x a00 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x a10 */
235,255,192, 17,  1, 13,238, 45,  4,  0,140, 37, 35, 96,142,  1,   /* 0x a20 */
  4,  0,238, 41, 13,  0,192, 21, 35,120, 15,  1,  4,  0,142, 41,   /* 0x a30 */
 11,  0,192, 21,  0,  0,238,153,  3,  0,238,137,252,255,140, 37,   /* 0x a40 */
  0,  0, 14,185,  3,  0, 14,169,  4,  0,239, 37,247,255,128, 21,   /* 0x a50 */
  4,  0,  8, 37,146,255,  0, 16,194,119,  9,  0,  0,  0,238,145,   /* 0x a60 */
255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,251,255,128, 21,   /* 0x a70 */
255,255, 14,161,138,255,  0, 16,194,119,  9,  0,  0,128, 13, 60,   /* 0x a80 */
 33, 72,160,  1,  1,  0, 11, 36,194,119,  9,  0,  7,  0,169, 21,   /* 0x a90 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x aa0 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,  1,  0, 15, 36,   /* 0x ab0 */
  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,  0,  0, 14,161,   /* 0x ac0 */
241,255,  0, 16,  1,  0,  8, 37,194,119,  9,  0,  7,  0,169, 21,   /* 0x ad0 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x ae0 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 64,120, 15,  0,   /* 0x af0 */
 33,120,238,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x b00 */
  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0,   /* 0x b10 */
 64, 72,  9,  0,  1,  0, 41, 37, 13,  0,192, 21,254,255,238, 37,   /* 0x b20 */
 33,120,207,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x b30 */
  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0,   /* 0x b40 */
 64, 72,  9,  0,  1,  0, 41, 37,223,255,  0, 16, 33,120,238,  1,   /* 0x b50 */
 13,  0,192, 21,253,255,239, 37,194,119,  9,  0,  7,  0,169, 21,   /* 0x b60 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x b70 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 33,120, 96,  1,   /* 0x b80 */
 11,  0,  0, 16,  1,  0,204, 49,  0,  0,174,144,  0,122, 15,  0,   /* 0x b90 */
 33,120,238,  1,  1,  0,238, 37,255,255,192, 17,  1,  0,165, 36,   /* 0x ba0 */
 66,120, 15,  0,  1,  0,239, 37, 33, 88,224,  1,  1,  0,204, 49,   /* 0x bb0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x bc0 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x bd0 */
  1,  0, 41, 37, 64, 96, 12,  0, 33, 96,142,  1, 23,  0,128, 21,   /* 0x be0 */
254,255,140, 37,  1,  0, 12, 36,194,119,  9,  0,  7,  0,169, 21,   /* 0x bf0 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x c00 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 64, 96, 12,  0,   /* 0x c10 */
 33, 96,142,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x c20 */
  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0,   /* 0x c30 */
 64, 72,  9,  0,  1,  0, 41, 37,235,255,192, 17,  1,  5,238, 45,   /* 0x c40 */
  4,  0,140, 37, 35, 96,142,  1,  4,  0,238, 41, 13,  0,192, 21,   /* 0x c50 */
 35,120, 15,  1,  4,  0,142, 41, 11,  0,192, 21,  0,  0,238,153,   /* 0x c60 */
  3,  0,238,137,252,255,140, 37,  0,  0, 14,185,  3,  0, 14,169,   /* 0x c70 */
  4,  0,239, 37,247,255,128, 21,  4,  0,  8, 37,131,255,  0, 16,   /* 0x c80 */
194,119,  9,  0,  0,  0,238,145,255,255,140, 37,  1,  0,239, 37,   /* 0x c90 */
  1,  0,  8, 37,251,255,128, 21,255,255, 14,161,123,255,  0, 16,   /* 0x ca0 */
194,119,  9,  0,  0,128, 13, 60, 33, 72,160,  1,  1,  0, 11, 36,   /* 0x cb0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x cc0 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x cd0 */
  1,  0, 41, 37,  1,  0, 15, 36,  5,  0,192, 17,  0,  0,174,144,   /* 0x ce0 */
  1,  0,165, 36,  0,  0, 14,161,241,255,  0, 16,  1,  0,  8, 37,   /* 0x cf0 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x d00 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x d10 */
  1,  0, 41, 37, 64,120, 15,  0, 33,120,238,  1,194,119,  9,  0,   /* 0x d20 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x d30 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x d40 */
 13,  0,192, 21,254,255,238, 37, 33,120,238,  1,194,119,  9,  0,   /* 0x d50 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x d60 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x d70 */
223,255,  0, 16, 33,120,238,  1, 13,  0,192, 21,253,255,239, 37,   /* 0x d80 */
194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,   /* 0x d90 */
  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,   /* 0x da0 */
  1,  0, 41, 37, 33,120, 96,  1, 11,  0,  0, 16,  1,  0,204, 49,   /* 0x db0 */
  0,  0,174,144,  0,122, 15,  0, 33,120,238,  1,  1,  0,238, 37,   /* 0x dc0 */
255,255,192, 17,  1,  0,165, 36, 66,120, 15,  0,  1,  0,239, 37,   /* 0x dd0 */
 33, 88,224,  1,  1,  0,204, 49,194,119,  9,  0,  7,  0,169, 21,   /* 0x de0 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x df0 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 35,  0,128, 21,   /* 0x e00 */
254,255,204, 37, 12,  0,192, 17,  1,  0, 12, 36,194,119,  9,  0,   /* 0x e10 */
  7,  0,169, 21, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x e20 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37,   /* 0x e30 */
 22,  0,  0, 16, 33, 96,192,  1,194,119,  9,  0,  7,  0,169, 21,   /* 0x e40 */
 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,   /* 0x e50 */
194,119,  9,  0, 64, 72,  9,  0,  1,  0, 41, 37, 64, 96, 12,  0,   /* 0x e60 */
 33, 96,142,  1,194,119,  9,  0,  7,  0,169, 21, 64, 72,  9,  0,   /* 0x e70 */
  0,  0,169,152,  3,  0,169,136,  4,  0,165, 36,194,119,  9,  0,   /* 0x e80 */
 64, 72,  9,  0,  1,  0, 41, 37,235,255,192, 17,  1,  5,238, 45,   /* 0x e90 */
  5,  0,140, 37, 35, 96,142,  1,  4,  0,238, 41, 13,  0,192, 21,   /* 0x ea0 */
 35,120, 15,  1,  4,  0,142, 41, 11,  0,192, 21,  0,  0,238,153,   /* 0x eb0 */
  3,  0,238,137,252,255,140, 37,  0,  0, 14,185,  3,  0, 14,169,   /* 0x ec0 */
  4,  0,239, 37,247,255,128, 21,  4,  0,  8, 37,121,255,  0, 16,   /* 0x ed0 */
194,119,  9,  0,  0,  0,238,145,255,255,140, 37,  1,  0,239, 37,   /* 0x ee0 */
  1,  0,  8, 37,251,255,128, 21,255,255, 14,161,113,255,  0, 16,   /* 0x ef0 */
194,119,  9,  0,  0,  0,169,144,  1,  0,165, 36, 64, 72,  9,  0,   /* 0x f00 */
  1,  0, 41, 37,192, 77,  9,  0,250,255,169, 17,194,119,  9,  0,   /* 0x f10 */
  8,  0,224,  3, 64, 72,  9,  0,  0,  0,169,152,  3,  0,169,136,   /* 0x f20 */
  4,  0,165, 36,194,119,  9,  0, 64, 72,  9,  0,  8,  0,224,  3,   /* 0x f30 */
  1,  0, 41, 37,248,255,169, 17,194,119,  9,  0,  8,  0,224,  3,   /* 0x f40 */
 64, 72,  9,  0,  0,128, 13, 60, 33, 72,160,  1,  1,  0, 11, 36,   /* 0x f50 */
255,255, 17,  4,  1,  0, 15, 36,  5,  0,192, 17,  0,  0,174,144,   /* 0x f60 */
  1,  0,165, 36,  0,  0, 14,161,249,255,  0, 16,  1,  0,  8, 37,   /* 0x f70 */
255,255, 17,  4, 64,120, 15,  0,255,255, 17,  4, 33,120,238,  1,   /* 0x f80 */
251,255,192, 17,  2,  0, 14, 36,  3,  0,238, 21,253,255,239, 37,   /* 0x f90 */
  8,  0,  0, 16, 33,120, 96,  1,  0,  0,174,144,  0,122, 15,  0,   /* 0x fa0 */
 33,120,238,  1,  1,  0,239, 37,255,255,224, 17,  1,  0,165, 36,   /* 0x fb0 */
 33, 88,224,  1,255,255, 17,  4,  0,  0,  0,  0, 33, 96,192,  1,   /* 0x fc0 */
255,255, 17,  4, 64, 96, 12,  0, 33, 96,142,  1,  7,  0,128, 21,   /* 0x fd0 */
254,255,140, 37,  1,  0, 12, 36,255,255, 17,  4, 64, 96, 12,  0,   /* 0x fe0 */
255,255, 17,  4, 33, 96,142,  1,251,255,192, 17,  1, 13,238, 45,   /* 0x ff0 */
  4,  0,140, 37, 35, 96,142,  1, 35,120, 15,  1,  0,  0,238,145,   /* 0x1000 */
255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,251,255,128, 21,   /* 0x1010 */
255,255, 14,161,206,255,  0, 16,  0,  0,  0,  0,  0,128, 13, 60,   /* 0x1020 */
 33, 72,160,  1,  1,  0, 11, 36,255,255, 17,  4,  1,  0, 15, 36,   /* 0x1030 */
  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,  0,  0, 14,161,   /* 0x1040 */
249,255,  0, 16,  1,  0,  8, 37,255,255, 17,  4, 64,120, 15,  0,   /* 0x1050 */
255,255, 17,  4, 33,120,238,  1,  5,  0,192, 21,254,255,238, 37,   /* 0x1060 */
255,255, 17,  4, 33,120,207,  1,247,255,  0, 16, 33,120,238,  1,   /* 0x1070 */
  5,  0,192, 21,253,255,239, 37,255,255, 17,  4, 33,120, 96,  1,   /* 0x1080 */
 11,  0,  0, 16,  1,  0,204, 49,  0,  0,174,144,  0,122, 15,  0,   /* 0x1090 */
 33,120,238,  1,  1,  0,238, 37,255,255,192, 17,  1,  0,165, 36,   /* 0x10a0 */
 66,120, 15,  0,  1,  0,239, 37, 33, 88,224,  1,  1,  0,204, 49,   /* 0x10b0 */
255,255, 17,  4, 64, 96, 12,  0, 33, 96,142,  1,  7,  0,128, 21,   /* 0x10c0 */
254,255,140, 37,  1,  0, 12, 36,255,255, 17,  4, 64, 96, 12,  0,   /* 0x10d0 */
255,255, 17,  4, 33, 96,142,  1,251,255,192, 17,  1,  5,238, 45,   /* 0x10e0 */
  4,  0,140, 37, 35, 96,142,  1, 35,120, 15,  1,  0,  0,238,145,   /* 0x10f0 */
255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,251,255,128, 21,   /* 0x1100 */
255,255, 14,161,200,255,  0, 16,  0,  0,  0,  0,  0,128, 13, 60,   /* 0x1110 */
 33, 72,160,  1,  1,  0, 11, 36,255,255, 17,  4,  1,  0, 15, 36,   /* 0x1120 */
  5,  0,192, 17,  0,  0,174,144,  1,  0,165, 36,  0,  0, 14,161,   /* 0x1130 */
249,255,  0, 16,  1,  0,  8, 37,255,255, 17,  4, 64,120, 15,  0,   /* 0x1140 */
255,255, 17,  4, 33,120,238,  1,  5,  0,192, 21,254,255,238, 37,   /* 0x1150 */
255,255, 17,  4, 33,120,238,  1,247,255,  0, 16, 33,120,238,  1,   /* 0x1160 */
  5,  0,192, 21,253,255,239, 37,255,255, 17,  4, 33,120, 96,  1,   /* 0x1170 */
 11,  0,  0, 16,  1,  0,204, 49,  0,  0,174,144,  0,122, 15,  0,   /* 0x1180 */
 33,120,238,  1,  1,  0,238, 37,255,255,192, 17,  1,  0,165, 36,   /* 0x1190 */
 66,120, 15,  0,  1,  0,239, 37, 33, 88,224,  1,  1,  0,204, 49,   /* 0x11a0 */
255,255, 17,  4,  0,  0,  0,  0, 12,  0,128, 21,254,255,204, 37,   /* 0x11b0 */
  5,  0,192, 17,  1,  0, 12, 36,255,255, 17,  4,  0,  0,  0,  0,   /* 0x11c0 */
  6,  0,  0, 16, 33, 96,192,  1,255,255, 17,  4, 64, 96, 12,  0,   /* 0x11d0 */
255,255, 17,  4, 33, 96,142,  1,251,255,192, 17,  1,  5,238, 45,   /* 0x11e0 */
  5,  0,140, 37, 35, 96,142,  1, 35,120, 15,  1,  0,  0,238,145,   /* 0x11f0 */
255,255,140, 37,  1,  0,239, 37,  1,  0,  8, 37,251,255,128, 21,   /* 0x1200 */
255,255, 14,161,196,255,  0, 16,  0,  0,  0,  0,240,255,  1, 36,   /* 0x1210 */
 33,232,161,  3,  2,  0,165, 36,  0,  0,  6, 60,  0,  0,198, 36,   /* 0x1220 */
  0,  0,  9, 60,  0,  0, 41, 37,  4,  0,170, 39,  8,  0,167, 39,   /* 0x1230 */
  0,  0,  1, 60,  0,  0, 33, 36,  0,  0,168,175, 16,  0,164, 39,   /* 0x1240 */
255,255, 17,  4,  0,  0,129,172,  0,  0,168,143,  4,  0,169,143,   /* 0x1250 */
240,255,  1, 36, 33, 64,  9,  1, 35,232,161,  3,200,255,189, 39,   /* 0x1260 */
 52,  0,183,175, 48,  0,182,175, 44,  0,181,175, 40,  0,180,175,   /* 0x1270 */
 36,  0,179,175, 32,  0,178,175, 28,  0,177,175, 24,  0,176,175,   /* 0x1280 */
 33,168,160,  0, 12,  0,167,175, 33,152,  0,  1, 16,  0,169,175,   /* 0x1290 */
 20,  0,170,175,  4,  0,144, 36,  2,  0,130,144,  1,  0,  3, 36,   /* 0x12a0 */
  4, 16, 67,  0,255,255, 66, 36,  8,  0,162,175,  1,  0,130,144,   /* 0x12b0 */
  0,  0,  0,  0,  4, 16, 67,  0,255,255, 66, 36,  4,  0,162,175,   /* 0x12c0 */
  0,  0,150,144,  0,  0,224,172,  0,  0, 64,173,  1,  0,132,144,   /* 0x12d0 */
  0,  0,  0,  0, 33, 32,196,  2,  0,  3,  2, 36,  4, 32,130,  0,   /* 0x12e0 */
 54,  7,132, 36, 33, 16,  0,  2,  4,  0,  0, 16, 33, 88,  0,  0,   /* 0x12f0 */
  0,  4,  3, 36,254,255, 67,164,  1,  0,107, 37,252,255,100, 21,   /* 0x1300 */
  2,  0, 66, 36, 33, 56,166,  2, 33,104,160,  2, 33,192,  0,  0,   /* 0x1310 */
 33, 32,  0,  0, 35, 16,245,  0,123,  2,130, 16,  0, 26, 24,  0,   /* 0x1320 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,132, 36,   /* 0x1330 */
  5,  0,  2, 36,247,255,130, 20,  1,  0,173, 37, 33, 80,  0,  0,   /* 0x1340 */
 33,112,  0,  0, 33,144,  0,  0,  1,  0, 17, 36,  1,  0, 20, 36,   /* 0x1350 */
  1,  0, 23, 36,  0,  0,183,175, 87,  2,  0, 16,255,255, 15, 36,   /* 0x1360 */
255,255, 70, 52, 43, 16,207,  0,  8,  0, 64, 20,  0,  0,  0,  0,   /* 0x1370 */
101,  2,167, 17,  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x1380 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,  8,  0,163,143,   /* 0x1390 */
  0,  0,  0,  0, 36, 40, 67,  1,  0,201, 18,  0, 33, 16,185,  0,   /* 0x13a0 */
 64, 16,  2,  0, 33, 88,  2,  2,  0,  0, 99,149,194, 18, 15,  0,   /* 0x13b0 */
 24,  0, 67,  0, 18, 96,  0,  0, 43, 16, 12,  3,125,  0, 64, 16,   /* 0x13c0 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x13d0 */
  0,  0, 98,165,  4,  0,163,143,  0,  0,  0,  0, 36, 16, 67,  1,   /* 0x13e0 */
  4, 24,194,  2,  8,  0,  2, 36, 35, 16, 86,  0,  7, 16, 78,  0,   /* 0x13f0 */
 33, 16, 98,  0, 64, 26,  2,  0,192, 18,  2,  0, 35, 16, 67,  0,   /* 0x1400 */
 33, 16,  2,  2,108, 14, 70, 36,  7,  0, 66, 42,  3,  0, 64, 16,   /* 0x1410 */
 33,120,128,  1, 85,  0,  0, 16,  1,  0,  5, 36, 35, 16, 81,  1,   /* 0x1420 */
 33, 16, 98,  2,  0,  0, 89,144,  1,  0,  5, 36,255,  0,  2, 60,   /* 0x1430 */
255,255, 66, 52, 43, 16, 79,  0,  8,  0, 64, 20,  0,  0,  0,  0,   /* 0x1440 */
 49,  2,167, 17,  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x1450 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37, 64,200, 25,  0,   /* 0x1460 */
  0,  1, 44, 51, 64, 16, 12,  0, 33, 16,194,  0, 64,112,  5,  0,   /* 0x1470 */
 33, 88, 78,  0,  0,  2, 99,149,194, 18, 15,  0, 24,  0, 67,  0,   /* 0x1480 */
 18, 32,  0,  0, 43, 16,  4,  3,  9,  0, 64, 16,  0,  8,  2, 36,   /* 0x1490 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,  0,  2, 98,165,   /* 0x14a0 */
 41,  0,128, 21, 33, 40,192,  1,  9,  0,  0, 16, 33,120,128,  0,   /* 0x14b0 */
 35,120,228,  1, 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x14c0 */
  0,  2, 98,165,  1,  0,162, 36, 40,  0,128, 17, 33, 40,162,  0,   /* 0x14d0 */
  0,  1,162, 40, 37,  0, 64, 16,255,  0,  2, 60,213,255,  0, 16,   /* 0x14e0 */
255,255, 66, 52,255,255, 66, 52, 43, 16, 79,  0,  9,  0, 64, 20,   /* 0x14f0 */
 64, 96,  5,  0,  4,  2,167, 17,  0,122, 15,  0,  0, 26, 24,  0,   /* 0x1500 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x1510 */
 64, 96,  5,  0, 33, 88,204,  0,  0,  0, 99,149,194, 18, 15,  0,   /* 0x1520 */
 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,  8,  0, 64, 16,   /* 0x1530 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x1540 */
  0,  0, 98,165, 33, 40,128,  1,  8,  0,  0, 16, 33,120,128,  0,   /* 0x1550 */
 35,120,228,  1, 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x1560 */
  0,  0, 98,165,  1,  0,162, 36, 33, 40,162,  0,  0,  1,162, 40,   /* 0x1570 */
220,255, 64, 20,255,  0,  2, 60,255,  0,174, 48, 33, 16,106,  2,   /* 0x1580 */
  0,  0, 78,160,  4,  0, 66, 42,  3,  0, 64, 16,  1,  0, 67, 37,   /* 0x1590 */
200,  1,  0, 16, 33,144,  0,  0, 10,  0, 66, 42,  3,  0, 64, 16,   /* 0x15a0 */
  0,  0,  0,  0,195,  1,  0, 16,253,255, 82, 38,193,  1,  0, 16,   /* 0x15b0 */
250,255, 82, 38, 35, 32,236,  1, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x15c0 */
  0,  0, 98,165, 43, 16,196,  0,  8,  0, 64, 20, 35,192, 12,  3,   /* 0x15d0 */
205,  1,167, 17,  0, 34,  4,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x15e0 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37, 64, 16, 18,  0,   /* 0x15f0 */
 33,112,  2,  2,128,  1,195,149,194, 18,  4,  0, 24,  0, 67,  0,   /* 0x1600 */
 18, 96,  0,  0, 43, 16, 12,  3, 15,  0, 64, 16,  0,  8,  2, 36,   /* 0x1610 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,128,  1,194,165,   /* 0x1620 */
  7,  0, 66, 42,  2,  0, 64, 20, 33,144,  0,  0,  3,  0, 18, 36,   /* 0x1630 */
100,  6, 14, 38,  0,  0,183,175, 33,184,128,  2, 33,160, 32,  2,   /* 0x1640 */
144,  0,  0, 16, 33, 88,128,  1, 35, 88,140,  0, 66, 17,  3,  0,   /* 0x1650 */
 35, 16, 98,  0,128,  1,194,165, 43, 16,203,  0,  8,  0, 64, 20,   /* 0x1660 */
 35,192, 12,  3,168,  1,167, 17,  0, 90, 11,  0,  0, 26, 24,  0,   /* 0x1670 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x1680 */
152,  1,195,149,194, 18, 11,  0, 24,  0, 67,  0, 18, 32,  0,  0,   /* 0x1690 */
 43, 16,  4,  3, 50,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x16a0 */
 67, 17,  2,  0, 33, 16, 98,  0,152,  1,194,165,  0,  1,  2, 60,   /* 0x16b0 */
 43, 16,130,  0,  8,  0, 64, 16, 33, 88,128,  0,146,  1,167, 17,   /* 0x16c0 */
  0, 90,  4,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x16d0 */
 37,192, 98,  0,  1,  0,173, 37, 64, 16, 25,  0, 33, 24,  2,  2,   /* 0x16e0 */
 64, 16,  5,  0, 33, 32, 98,  0,224,  1,131,148,194, 18, 11,  0,   /* 0x16f0 */
 24,  0, 67,  0, 18, 96,  0,  0, 43, 16, 12,  3, 18,  0, 64, 16,   /* 0x1700 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x1710 */
125,  1, 64, 17,224,  1,130,164,  7,  0, 66, 42,  2,  0, 64, 20,   /* 0x1720 */
  9,  0, 18, 36, 11,  0, 18, 36, 35, 16, 81,  1, 33, 16, 98,  2,   /* 0x1730 */
  0,  0, 78,144, 33, 16,106,  2,  0,  0, 78,160,  1,  0, 67, 37,   /* 0x1740 */
 92,  1,  0, 16, 33,120,128,  1, 35, 88,108,  1, 35,192, 12,  3,   /* 0x1750 */
 66, 17,  3,  0, 35, 16, 98,  0, 69,  0,  0, 16,224,  1,130,164,   /* 0x1760 */
 35, 88,100,  1, 66, 17,  3,  0, 35, 16, 98,  0,152,  1,194,165,   /* 0x1770 */
 43, 16,203,  0,  8,  0, 64, 20, 35,192,  4,  3, 98,  1,167, 17,   /* 0x1780 */
  0, 90, 11,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x1790 */
 37,192, 98,  0,  1,  0,173, 37,176,  1,195,149,194, 18, 11,  0,   /* 0x17a0 */
 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,  7,  0, 64, 16,   /* 0x17b0 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x17c0 */
176,  1,194,165, 28,  0,  0, 16, 33, 16,128,  2, 35, 88,100,  1,   /* 0x17d0 */
 66, 17,  3,  0, 35, 16, 98,  0,176,  1,194,165, 43, 16,203,  0,   /* 0x17e0 */
  8,  0, 64, 20, 35,192,  4,  3, 71,  1,167, 17,  0, 90, 11,  0,   /* 0x17f0 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x1800 */
  1,  0,173, 37,200,  1,195,149,194, 18, 11,  0, 24,  0, 67,  0,   /* 0x1810 */
 18, 32,  0,  0, 43, 16,  4,  3, 11,  0, 64, 16,  0,  8,  2, 36,   /* 0x1820 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,200,  1,194,165,   /* 0x1830 */
 33, 16,224,  2, 33,184,128,  2, 33,160, 32,  2, 33,136, 64,  0,   /* 0x1840 */
 11,  0,  0, 16, 33, 88,128,  0, 35, 88,100,  1, 35,192,  4,  3,   /* 0x1850 */
 66, 17,  3,  0, 35, 16, 98,  0,200,  1,194,165,  0,  0,162,143,   /* 0x1860 */
  0,  0,183,175, 33,184,128,  2, 33,160, 32,  2, 33,136, 64,  0,   /* 0x1870 */
  7,  0, 66, 42,  2,  0, 64, 20,  8,  0, 18, 36, 11,  0, 18, 36,   /* 0x1880 */
104, 10, 14, 38,255,  0,  2, 60,255,255, 76, 52, 43, 16,139,  1,   /* 0x1890 */
  8,  0, 64, 20,  0,  0,  0,  0, 27,  1,167, 17,  0, 90, 11,  0,   /* 0x18a0 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x18b0 */
  1,  0,173, 37,  0,  0,195,149,194, 18, 11,  0, 24,  0, 67,  0,   /* 0x18c0 */
 18, 32,  0,  0, 43, 16,  4,  3, 12,  0, 64, 16,  0,  8,  2, 36,   /* 0x18d0 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,  0,  0,194,165,   /* 0x18e0 */
  0, 17,  5,  0, 33, 16,194,  1,  4,  0, 69, 36, 33,120,128,  0,   /* 0x18f0 */
  3,  0,  8, 36, 41,  0,  0, 16, 33, 48,  0,  0, 35, 88,100,  1,   /* 0x1900 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  0,194,165, 43, 16,139,  1,   /* 0x1910 */
  8,  0, 64, 20, 35,192,  4,  3,251,  0,167, 17,  0, 90, 11,  0,   /* 0x1920 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x1930 */
  1,  0,173, 37,  2,  0,195,149,194, 18, 11,  0, 24,  0, 67,  0,   /* 0x1940 */
 18, 32,  0,  0, 43, 16,  4,  3, 12,  0, 64, 16,  0,  8,  2, 36,   /* 0x1950 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,  2,  0,194,165,   /* 0x1960 */
  0, 17,  5,  0, 33, 16,194,  1,  4,  1, 69, 36, 33,120,128,  0,   /* 0x1970 */
  3,  0,  8, 36,  9,  0,  0, 16,  8,  0,  6, 36, 35,120,100,  1,   /* 0x1980 */
 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,  2,  0,194,165,   /* 0x1990 */
  4,  2,197, 37,  8,  0,  8, 36, 16,  0,  6, 36, 33,112,  0,  1,   /* 0x19a0 */
  1,  0, 25, 36,255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,   /* 0x19b0 */
  9,  0, 64, 20, 64, 96, 25,  0,211,  0,167, 17,  0,122, 15,  0,   /* 0x19c0 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x19d0 */
  1,  0,173, 37, 64, 96, 25,  0, 33, 88,172,  0,  0,  0, 99,149,   /* 0x19e0 */
194, 18, 15,  0, 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,   /* 0x19f0 */
  8,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x1a00 */
 33, 16, 98,  0,  0,  0, 98,165, 33,200,128,  1,  8,  0,  0, 16,   /* 0x1a10 */
 33,120,128,  0, 35,120,228,  1, 35,192,  4,  3, 66, 17,  3,  0,   /* 0x1a20 */
 35, 16, 98,  0,  0,  0, 98,165,  1,  0, 34, 39, 33,200, 34,  3,   /* 0x1a30 */
255,255,206, 37,220,255,192, 21,255,  0,  2, 60,  1,  0,  2, 36,   /* 0x1a40 */
  4, 16,  2,  1, 35, 16, 34,  3, 33, 72, 70,  0,  4,  0, 66, 42,   /* 0x1a50 */
134,  0, 64, 16,  4,  0, 34, 41,  2,  0, 64, 20, 33, 24, 32,  1,   /* 0x1a60 */
  3,  0,  3, 36,192, 17,  3,  0, 33, 16,  2,  2, 96,  3, 70, 36,   /* 0x1a70 */
  1,  0, 14, 36,  6,  0, 25, 36,255,  0,  2, 60,255,255, 66, 52,   /* 0x1a80 */
 43, 16, 79,  0,  9,  0, 64, 20, 64, 96, 14,  0,158,  0,167, 17,   /* 0x1a90 */
  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x1aa0 */
 37,192, 98,  0,  1,  0,173, 37, 64, 96, 14,  0, 33, 88,204,  0,   /* 0x1ab0 */
  0,  0, 99,149,194, 18, 15,  0, 24,  0, 67,  0, 18, 32,  0,  0,   /* 0x1ac0 */
 43, 16,  4,  3,  8,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x1ad0 */
 67, 17,  2,  0, 33, 16, 98,  0,  0,  0, 98,165, 33,112,128,  1,   /* 0x1ae0 */
  8,  0,  0, 16, 33,120,128,  0, 35,120,228,  1, 35,192,  4,  3,   /* 0x1af0 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  0, 98,165,  1,  0,194, 37,   /* 0x1b00 */
 33,112,194,  1,255,255, 57, 39,220,255, 32, 23,255,  0,  2, 60,   /* 0x1b10 */
192,255,195, 37,  4,  0, 98, 40, 80,  0, 64, 20, 33,112, 96,  0,   /* 0x1b20 */
 67, 32,  3,  0,  1,  0, 98, 48,  2,  0, 75, 52, 14,  0, 98, 40,   /* 0x1b30 */
  8,  0, 64, 16,255,255,153, 36,  4,112, 43,  3, 64, 16, 14,  0,   /* 0x1b40 */
 33, 32,  2,  2, 64, 16,  3,  0, 35, 16,130,  0, 26,  0,  0, 16,   /* 0x1b50 */
 94,  5, 72, 36,251,255,132, 36,255,  0,  2, 60,255,255, 66, 52,   /* 0x1b60 */
 43, 16, 79,  0,  8,  0, 64, 20,  0,  0,  0,  0,102,  0,167, 17,   /* 0x1b70 */
  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x1b80 */
 37,192, 98,  0,  1,  0,173, 37, 66,120, 15,  0, 43, 16, 15,  3,   /* 0x1b90 */
  3,  0, 64, 20, 64, 88, 11,  0, 35,192, 15,  3,  1,  0,107, 53,   /* 0x1ba0 */
255,255,132, 36,237,255,128, 20,255,  0,  2, 60, 68,  6,  8, 38,   /* 0x1bb0 */
  0,113, 11,  0,  4,  0, 25, 36,  1,  0,  6, 36,  1,  0,  5, 36,   /* 0x1bc0 */
255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,  9,  0, 64, 20,   /* 0x1bd0 */
 64, 96,  5,  0, 76,  0,167, 17,  0,122, 15,  0,  0, 26, 24,  0,   /* 0x1be0 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x1bf0 */
 64, 96,  5,  0, 33, 88, 12,  1,  0,  0, 99,149,194, 18, 15,  0,   /* 0x1c00 */
 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,  8,  0, 64, 16,   /* 0x1c10 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x1c20 */
  0,  0, 98,165, 33, 40,128,  1,  9,  0,  0, 16, 33,120,128,  0,   /* 0x1c30 */
 35,120,228,  1, 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x1c40 */
  0,  0, 98,165,  1,  0,162, 36, 33, 40,162,  0, 37,112,198,  1,   /* 0x1c50 */
255,255, 57, 39,218,255, 32, 23, 64, 48,  6,  0,  1,  0,209, 37,   /* 0x1c60 */
 26,  0, 32, 18,255,  0,  2, 60,  7,  0, 82, 38, 43, 16, 81,  1,   /* 0x1c70 */
 38,  0, 64, 20,  1,  0,  2, 36, 35, 16, 81,  1, 33, 88, 98,  2,   /* 0x1c80 */
 33, 32,106,  2, 33, 24, 64,  1,  0,  0,110,145,  1,  0, 99, 36,   /* 0x1c90 */
 33, 16, 73,  1,  2,  0, 66, 36,  6,  0, 98, 16,  0,  0,142,160,   /* 0x1ca0 */
  1,  0,107, 37, 16,  0,162,143,  0,  0,  0,  0,246,255, 98, 20,   /* 0x1cb0 */
  1,  0,132, 36, 33, 80, 96,  0, 16,  0,163,143,  0,  0,  0,  0,   /* 0x1cc0 */
 43, 16, 67,  1,166,253, 64, 20,255,  0,  2, 60,255,255, 66, 52,   /* 0x1cd0 */
 43, 16, 79,  0,  4,  0, 64, 20, 35, 40,181,  1, 10,  0,167, 17,   /* 0x1ce0 */
  1,  0,173, 37, 35, 40,181,  1, 12,  0,162,143,  0,  0,  0,  0,   /* 0x1cf0 */
  0,  0, 69,172, 20,  0,163,143,  0,  0,  0,  0,  0,  0,106,172,   /* 0x1d00 */
  2,  0,  0, 16, 33, 16,  0,  0,  1,  0,  2, 36, 52,  0,183,143,   /* 0x1d10 */
 48,  0,182,143, 44,  0,181,143, 40,  0,180,143, 36,  0,179,143,   /* 0x1d20 */
 32,  0,178,143, 28,  0,177,143, 24,  0,176,143,  8,  0,224,  3,   /* 0x1d30 */
 56,  0,189, 39,200,255,189, 39, 52,  0,183,175, 48,  0,182,175,   /* 0x1d40 */
 44,  0,181,175, 40,  0,180,175, 36,  0,179,175, 32,  0,178,175,   /* 0x1d50 */
 28,  0,177,175, 24,  0,176,175, 33,168,160,  0, 12,  0,167,175,   /* 0x1d60 */
 33,152,  0,  1, 16,  0,169,175, 20,  0,170,175,  4,  0,144, 36,   /* 0x1d70 */
  2,  0,130,144,  1,  0,  3, 36,  4, 16, 67,  0,255,255, 66, 36,   /* 0x1d80 */
  8,  0,162,175,  1,  0,130,144,  0,  0,  0,  0,  4, 16, 67,  0,   /* 0x1d90 */
255,255, 66, 36,  4,  0,162,175,  0,  0,150,144,  0,  0,224,172,   /* 0x1da0 */
  0,  0, 64,173,  1,  0,132,144,  0,  0,  0,  0, 33, 32,196,  2,   /* 0x1db0 */
  0,  3,  2, 36,  4, 32,130,  0, 54,  7,132, 36, 33, 16,  0,  2,   /* 0x1dc0 */
  4,  0,  0, 16, 33, 88,  0,  0,  0,  4,  3, 36,254,255, 67,164,   /* 0x1dd0 */
  1,  0,107, 37,252,255,100, 21,  2,  0, 66, 36, 33, 56,166,  2,   /* 0x1de0 */
 33,104,160,  2, 33,192,  0,  0, 33, 32,  0,  0, 35, 16,245,  0,   /* 0x1df0 */
123,  2,130, 16,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x1e00 */
 37,192, 98,  0,  1,  0,132, 36,  5,  0,  2, 36,247,255,130, 20,   /* 0x1e10 */
  1,  0,173, 37, 33, 80,  0,  0, 33,112,  0,  0, 33,144,  0,  0,   /* 0x1e20 */
  1,  0, 17, 36,  1,  0, 20, 36,  1,  0, 23, 36,  0,  0,183,175,   /* 0x1e30 */
 87,  2,  0, 16,255,255, 15, 36,255,255, 70, 52, 43, 16,207,  0,   /* 0x1e40 */
  8,  0, 64, 20,  0,  0,  0,  0,101,  2,167, 17,  0,122, 15,  0,   /* 0x1e50 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x1e60 */
  1,  0,173, 37,  8,  0,163,143,  0,  0,  0,  0, 36, 40, 67,  1,   /* 0x1e70 */
  0,201, 18,  0, 33, 16,185,  0, 64, 16,  2,  0, 33, 88,  2,  2,   /* 0x1e80 */
  0,  0, 99,149,194, 18, 15,  0, 24,  0, 67,  0, 18, 96,  0,  0,   /* 0x1e90 */
 43, 16, 12,  3,125,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x1ea0 */
 67, 17,  2,  0, 33, 16, 98,  0,  0,  0, 98,165,  4,  0,163,143,   /* 0x1eb0 */
  0,  0,  0,  0, 36, 16, 67,  1,  4, 24,194,  2,  8,  0,  2, 36,   /* 0x1ec0 */
 35, 16, 86,  0,  7, 16, 78,  0, 33, 16, 98,  0, 64, 26,  2,  0,   /* 0x1ed0 */
192, 18,  2,  0, 35, 16, 67,  0, 33, 16,  2,  2,108, 14, 70, 36,   /* 0x1ee0 */
  7,  0, 66, 42,  3,  0, 64, 16, 33,120,128,  1, 85,  0,  0, 16,   /* 0x1ef0 */
  1,  0,  5, 36, 35, 16, 81,  1, 33, 16, 98,  2,  0,  0, 89,144,   /* 0x1f00 */
  1,  0,  5, 36,255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,   /* 0x1f10 */
  8,  0, 64, 20,  0,  0,  0,  0, 49,  2,167, 17,  0,122, 15,  0,   /* 0x1f20 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x1f30 */
  1,  0,173, 37, 64,200, 25,  0,  0,  1, 44, 51, 64, 16, 12,  0,   /* 0x1f40 */
 33, 16,194,  0, 64,112,  5,  0, 33, 88, 78,  0,  0,  2, 99,149,   /* 0x1f50 */
194, 18, 15,  0, 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,   /* 0x1f60 */
  9,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x1f70 */
 33, 16, 98,  0,  0,  2, 98,165, 41,  0,128, 21, 33, 40,192,  1,   /* 0x1f80 */
  9,  0,  0, 16, 33,120,128,  0, 35,120,228,  1, 35,192,  4,  3,   /* 0x1f90 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  2, 98,165,  1,  0,162, 36,   /* 0x1fa0 */
 40,  0,128, 17, 33, 40,162,  0,  0,  1,162, 40, 37,  0, 64, 16,   /* 0x1fb0 */
255,  0,  2, 60,213,255,  0, 16,255,255, 66, 52,255,255, 66, 52,   /* 0x1fc0 */
 43, 16, 79,  0,  9,  0, 64, 20, 64, 96,  5,  0,  4,  2,167, 17,   /* 0x1fd0 */
  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x1fe0 */
 37,192, 98,  0,  1,  0,173, 37, 64, 96,  5,  0, 33, 88,204,  0,   /* 0x1ff0 */
  0,  0, 99,149,194, 18, 15,  0, 24,  0, 67,  0, 18, 32,  0,  0,   /* 0x2000 */
 43, 16,  4,  3,  8,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x2010 */
 67, 17,  2,  0, 33, 16, 98,  0,  0,  0, 98,165, 33, 40,128,  1,   /* 0x2020 */
  8,  0,  0, 16, 33,120,128,  0, 35,120,228,  1, 35,192,  4,  3,   /* 0x2030 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  0, 98,165,  1,  0,162, 36,   /* 0x2040 */
 33, 40,162,  0,  0,  1,162, 40,220,255, 64, 20,255,  0,  2, 60,   /* 0x2050 */
255,  0,174, 48, 33, 16,106,  2,  0,  0, 78,160,  4,  0, 66, 42,   /* 0x2060 */
  3,  0, 64, 16,  1,  0, 67, 37,200,  1,  0, 16, 33,144,  0,  0,   /* 0x2070 */
 10,  0, 66, 42,  3,  0, 64, 16,  0,  0,  0,  0,195,  1,  0, 16,   /* 0x2080 */
253,255, 82, 38,193,  1,  0, 16,250,255, 82, 38, 35, 32,236,  1,   /* 0x2090 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  0, 98,165, 43, 16,196,  0,   /* 0x20a0 */
  8,  0, 64, 20, 35,192, 12,  3,205,  1,167, 17,  0, 34,  4,  0,   /* 0x20b0 */
  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,   /* 0x20c0 */
  1,  0,173, 37, 64, 16, 18,  0, 33,112,  2,  2,128,  1,195,149,   /* 0x20d0 */
194, 18,  4,  0, 24,  0, 67,  0, 18, 96,  0,  0, 43, 16, 12,  3,   /* 0x20e0 */
 15,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x20f0 */
 33, 16, 98,  0,128,  1,194,165,  7,  0, 66, 42,  2,  0, 64, 20,   /* 0x2100 */
 33,144,  0,  0,  3,  0, 18, 36,100,  6, 14, 38,  0,  0,183,175,   /* 0x2110 */
 33,184,128,  2, 33,160, 32,  2,144,  0,  0, 16, 33, 88,128,  1,   /* 0x2120 */
 35, 88,140,  0, 66, 17,  3,  0, 35, 16, 98,  0,128,  1,194,165,   /* 0x2130 */
 43, 16,203,  0,  8,  0, 64, 20, 35,192, 12,  3,168,  1,167, 17,   /* 0x2140 */
  0, 90, 11,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x2150 */
 37,192, 98,  0,  1,  0,173, 37,152,  1,195,149,194, 18, 11,  0,   /* 0x2160 */
 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3, 50,  0, 64, 16,   /* 0x2170 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x2180 */
152,  1,194,165,  0,  1,  2, 60, 43, 16,130,  0,  8,  0, 64, 16,   /* 0x2190 */
 33, 88,128,  0,146,  1,167, 17,  0, 90,  4,  0,  0, 26, 24,  0,   /* 0x21a0 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x21b0 */
 64, 16, 25,  0, 33, 24,  2,  2, 64, 16,  5,  0, 33, 32, 98,  0,   /* 0x21c0 */
224,  1,131,148,194, 18, 11,  0, 24,  0, 67,  0, 18, 96,  0,  0,   /* 0x21d0 */
 43, 16, 12,  3, 18,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x21e0 */
 67, 17,  2,  0, 33, 16, 98,  0,125,  1, 64, 17,224,  1,130,164,   /* 0x21f0 */
  7,  0, 66, 42,  2,  0, 64, 20,  9,  0, 18, 36, 11,  0, 18, 36,   /* 0x2200 */
 35, 16, 81,  1, 33, 16, 98,  2,  0,  0, 78,144, 33, 16,106,  2,   /* 0x2210 */
  0,  0, 78,160,  1,  0, 67, 37, 92,  1,  0, 16, 33,120,128,  1,   /* 0x2220 */
 35, 88,108,  1, 35,192, 12,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x2230 */
 69,  0,  0, 16,224,  1,130,164, 35, 88,100,  1, 66, 17,  3,  0,   /* 0x2240 */
 35, 16, 98,  0,152,  1,194,165, 43, 16,203,  0,  8,  0, 64, 20,   /* 0x2250 */
 35,192,  4,  3, 98,  1,167, 17,  0, 90, 11,  0,  0, 26, 24,  0,   /* 0x2260 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x2270 */
176,  1,195,149,194, 18, 11,  0, 24,  0, 67,  0, 18, 32,  0,  0,   /* 0x2280 */
 43, 16,  4,  3,  7,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x2290 */
 67, 17,  2,  0, 33, 16, 98,  0,176,  1,194,165, 28,  0,  0, 16,   /* 0x22a0 */
 33, 16,128,  2, 35, 88,100,  1, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x22b0 */
176,  1,194,165, 43, 16,203,  0,  8,  0, 64, 20, 35,192,  4,  3,   /* 0x22c0 */
 71,  1,167, 17,  0, 90, 11,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x22d0 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,200,  1,195,149,   /* 0x22e0 */
194, 18, 11,  0, 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,   /* 0x22f0 */
 11,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x2300 */
 33, 16, 98,  0,200,  1,194,165, 33, 16,224,  2, 33,184,128,  2,   /* 0x2310 */
 33,160, 32,  2, 33,136, 64,  0, 11,  0,  0, 16, 33, 88,128,  0,   /* 0x2320 */
 35, 88,100,  1, 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x2330 */
200,  1,194,165,  0,  0,162,143,  0,  0,183,175, 33,184,128,  2,   /* 0x2340 */
 33,160, 32,  2, 33,136, 64,  0,  7,  0, 66, 42,  2,  0, 64, 20,   /* 0x2350 */
  8,  0, 18, 36, 11,  0, 18, 36,104, 10, 14, 38,255,  0,  2, 60,   /* 0x2360 */
255,255, 76, 52, 43, 16,139,  1,  8,  0, 64, 20,  0,  0,  0,  0,   /* 0x2370 */
 27,  1,167, 17,  0, 90, 11,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x2380 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,  0,  0,195,149,   /* 0x2390 */
194, 18, 11,  0, 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,   /* 0x23a0 */
 12,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x23b0 */
 33, 16, 98,  0,  0,  0,194,165,  0, 17,  5,  0, 33, 16,194,  1,   /* 0x23c0 */
  4,  0, 69, 36, 33,120,128,  0,  3,  0,  8, 36, 41,  0,  0, 16,   /* 0x23d0 */
 33, 48,  0,  0, 35, 88,100,  1, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x23e0 */
  0,  0,194,165, 43, 16,139,  1,  8,  0, 64, 20, 35,192,  4,  3,   /* 0x23f0 */
251,  0,167, 17,  0, 90, 11,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x2400 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,  2,  0,195,149,   /* 0x2410 */
194, 18, 11,  0, 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,   /* 0x2420 */
 12,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0,   /* 0x2430 */
 33, 16, 98,  0,  2,  0,194,165,  0, 17,  5,  0, 33, 16,194,  1,   /* 0x2440 */
  4,  1, 69, 36, 33,120,128,  0,  3,  0,  8, 36,  9,  0,  0, 16,   /* 0x2450 */
  8,  0,  6, 36, 35,120,100,  1, 35,192,  4,  3, 66, 17,  3,  0,   /* 0x2460 */
 35, 16, 98,  0,  2,  0,194,165,  4,  2,197, 37,  8,  0,  8, 36,   /* 0x2470 */
 16,  0,  6, 36, 33,112,  0,  1,  1,  0, 25, 36,255,  0,  2, 60,   /* 0x2480 */
255,255, 66, 52, 43, 16, 79,  0,  9,  0, 64, 20, 64, 96, 25,  0,   /* 0x2490 */
211,  0,167, 17,  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,   /* 0x24a0 */
  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37, 64, 96, 25,  0,   /* 0x24b0 */
 33, 88,172,  0,  0,  0, 99,149,194, 18, 15,  0, 24,  0, 67,  0,   /* 0x24c0 */
 18, 32,  0,  0, 43, 16,  4,  3,  8,  0, 64, 16,  0,  8,  2, 36,   /* 0x24d0 */
 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,  0,  0, 98,165,   /* 0x24e0 */
 33,200,128,  1,  8,  0,  0, 16, 33,120,128,  0, 35,120,228,  1,   /* 0x24f0 */
 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,  0,  0, 98,165,   /* 0x2500 */
  1,  0, 34, 39, 33,200, 34,  3,255,255,206, 37,220,255,192, 21,   /* 0x2510 */
255,  0,  2, 60,  1,  0,  2, 36,  4, 16,  2,  1, 35, 16, 34,  3,   /* 0x2520 */
 33, 72, 70,  0,  4,  0, 66, 42,134,  0, 64, 16,  4,  0, 34, 41,   /* 0x2530 */
  2,  0, 64, 20, 33, 24, 32,  1,  3,  0,  3, 36,192, 17,  3,  0,   /* 0x2540 */
 33, 16,  2,  2, 96,  3, 70, 36,  1,  0, 14, 36,  6,  0, 25, 36,   /* 0x2550 */
255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,  9,  0, 64, 20,   /* 0x2560 */
 64, 96, 14,  0,158,  0,167, 17,  0,122, 15,  0,  0, 26, 24,  0,   /* 0x2570 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x2580 */
 64, 96, 14,  0, 33, 88,204,  0,  0,  0, 99,149,194, 18, 15,  0,   /* 0x2590 */
 24,  0, 67,  0, 18, 32,  0,  0, 43, 16,  4,  3,  8,  0, 64, 16,   /* 0x25a0 */
  0,  8,  2, 36, 35, 16, 67,  0, 67, 17,  2,  0, 33, 16, 98,  0,   /* 0x25b0 */
  0,  0, 98,165, 33,112,128,  1,  8,  0,  0, 16, 33,120,128,  0,   /* 0x25c0 */
 35,120,228,  1, 35,192,  4,  3, 66, 17,  3,  0, 35, 16, 98,  0,   /* 0x25d0 */
  0,  0, 98,165,  1,  0,194, 37, 33,112,194,  1,255,255, 57, 39,   /* 0x25e0 */
220,255, 32, 23,255,  0,  2, 60,192,255,195, 37,  4,  0, 98, 40,   /* 0x25f0 */
 80,  0, 64, 20, 33,112, 96,  0, 67, 32,  3,  0,  1,  0, 98, 48,   /* 0x2600 */
  2,  0, 75, 52, 14,  0, 98, 40,  8,  0, 64, 16,255,255,153, 36,   /* 0x2610 */
  4,112, 43,  3, 64, 16, 14,  0, 33, 32,  2,  2, 64, 16,  3,  0,   /* 0x2620 */
 35, 16,130,  0, 26,  0,  0, 16, 94,  5, 72, 36,251,255,132, 36,   /* 0x2630 */
255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,  8,  0, 64, 20,   /* 0x2640 */
  0,  0,  0,  0,102,  0,167, 17,  0,122, 15,  0,  0, 26, 24,  0,   /* 0x2650 */
  0,  0,162,145,  0,  0,  0,  0, 37,192, 98,  0,  1,  0,173, 37,   /* 0x2660 */
 66,120, 15,  0, 43, 16, 15,  3,  3,  0, 64, 20, 64, 88, 11,  0,   /* 0x2670 */
 35,192, 15,  3,  1,  0,107, 53,255,255,132, 36,237,255,128, 20,   /* 0x2680 */
255,  0,  2, 60, 68,  6,  8, 38,  0,113, 11,  0,  4,  0, 25, 36,   /* 0x2690 */
  1,  0,  6, 36,  1,  0,  5, 36,255,  0,  2, 60,255,255, 66, 52,   /* 0x26a0 */
 43, 16, 79,  0,  9,  0, 64, 20, 64, 96,  5,  0, 76,  0,167, 17,   /* 0x26b0 */
  0,122, 15,  0,  0, 26, 24,  0,  0,  0,162,145,  0,  0,  0,  0,   /* 0x26c0 */
 37,192, 98,  0,  1,  0,173, 37, 64, 96,  5,  0, 33, 88, 12,  1,   /* 0x26d0 */
  0,  0, 99,149,194, 18, 15,  0, 24,  0, 67,  0, 18, 32,  0,  0,   /* 0x26e0 */
 43, 16,  4,  3,  8,  0, 64, 16,  0,  8,  2, 36, 35, 16, 67,  0,   /* 0x26f0 */
 67, 17,  2,  0, 33, 16, 98,  0,  0,  0, 98,165, 33, 40,128,  1,   /* 0x2700 */
  9,  0,  0, 16, 33,120,128,  0, 35,120,228,  1, 35,192,  4,  3,   /* 0x2710 */
 66, 17,  3,  0, 35, 16, 98,  0,  0,  0, 98,165,  1,  0,162, 36,   /* 0x2720 */
 33, 40,162,  0, 37,112,198,  1,255,255, 57, 39,218,255, 32, 23,   /* 0x2730 */
 64, 48,  6,  0,  1,  0,209, 37, 26,  0, 32, 18,255,  0,  2, 60,   /* 0x2740 */
  7,  0, 82, 38, 43, 16, 81,  1, 38,  0, 64, 20,  1,  0,  2, 36,   /* 0x2750 */
 35, 16, 81,  1, 33, 88, 98,  2, 33, 32,106,  2, 33, 24, 64,  1,   /* 0x2760 */
  0,  0,110,145,  1,  0, 99, 36, 33, 16, 73,  1,  2,  0, 66, 36,   /* 0x2770 */
  6,  0, 98, 16,  0,  0,142,160,  1,  0,107, 37, 16,  0,162,143,   /* 0x2780 */
  0,  0,  0,  0,246,255, 98, 20,  1,  0,132, 36, 33, 80, 96,  0,   /* 0x2790 */
 16,  0,163,143,  0,  0,  0,  0, 43, 16, 67,  1,166,253, 64, 20,   /* 0x27a0 */
255,  0,  2, 60,255,255, 66, 52, 43, 16, 79,  0,  4,  0, 64, 20,   /* 0x27b0 */
 35, 40,181,  1, 10,  0,167, 17,  1,  0,173, 37, 35, 40,181,  1,   /* 0x27c0 */
 12,  0,162,143,  0,  0,  0,  0,  0,  0, 69,172, 20,  0,163,143,   /* 0x27d0 */
  0,  0,  0,  0,  0,  0,106,172,  2,  0,  0, 16, 33, 16,  0,  0,   /* 0x27e0 */
  1,  0,  2, 36, 52,  0,183,143, 48,  0,182,143, 44,  0,181,143,   /* 0x27f0 */
 40,  0,180,143, 36,  0,179,143, 32,  0,178,143, 28,  0,177,143,   /* 0x2800 */
 24,  0,176,143,  8,  0,224,  3, 56,  0,189, 39, 85, 80, 88, 33,   /* 0x2810 */
161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x2820 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,116,109,112, 47,   /* 0x2830 */
109,105,112,115,101,108, 46,114, 51, 48, 48, 48, 45,112,115, 49,   /* 0x2840 */
 46, 98,105,110, 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,   /* 0x2850 */
111,114,109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,   /* 0x2860 */
108,101,109,105,112,115, 10, 10, 83,101, 99,116,105,111,110,115,   /* 0x2870 */
 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,   /* 0x2880 */
 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,   /* 0x2890 */
 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,   /* 0x28a0 */
 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,   /* 0x28b0 */
 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 99,100, 98, 46,   /* 0x28c0 */
115,116, 97,114,116, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x28d0 */
 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x28e0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52,   /* 0x28f0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2900 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2910 */
 89, 10, 32, 32, 49, 32, 99,100, 98, 46,101,110,116,114,121, 32,   /* 0x2920 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48, 48,   /* 0x2930 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2940 */
 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42, 48,   /* 0x2950 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2960 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32,   /* 0x2970 */
 99,100, 98, 46,115,116, 97,114,116, 46,108,122,109, 97, 32, 48,   /* 0x2980 */
 48, 48, 48, 48, 48, 49, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2990 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x29a0 */
 48, 48, 48, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x29b0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x29c0 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 99,100, 98, 46,101,   /* 0x29d0 */
110,116,114,121, 46,108,122,109, 97, 32, 48, 48, 48, 48, 48, 48,   /* 0x29e0 */
 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x29f0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 99,   /* 0x2a00 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2a10 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2a20 */
 89, 10, 32, 32, 52, 32, 99,100, 98, 46,108,122,109, 97, 46, 99,   /* 0x2a30 */
112,114, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48,   /* 0x2a40 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2a50 */
 32, 32, 48, 48, 48, 48, 48, 48, 57, 99, 32, 32, 50, 42, 42, 48,   /* 0x2a60 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2a70 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32,   /* 0x2a80 */
 99,100, 98, 46,100,101, 99, 46,112,116,114, 32, 32, 32, 48, 48,   /* 0x2a90 */
 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2aa0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2ab0 */
 48, 48, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2ac0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2ad0 */
 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 99,100, 98, 46,100,101,   /* 0x2ae0 */
 99, 46,112,116,114, 46,104,105, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2af0 */
 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2b00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 99, 32,   /* 0x2b10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2b20 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2b30 */
 10, 32, 32, 55, 32, 99,100, 98, 46,101,120,105,116, 32, 32, 32,   /* 0x2b40 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 56, 32, 32, 48, 48, 48,   /* 0x2b50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2b60 */
 32, 48, 48, 48, 48, 48, 48, 98, 48, 32, 32, 50, 42, 42, 48, 32,   /* 0x2b70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2b80 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 99,   /* 0x2b90 */
111,110, 46,115,116, 97,114,116, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2ba0 */
 48, 48, 48, 51, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2bb0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2bc0 */
 48,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2bd0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2be0 */
 79, 78, 76, 89, 10, 32, 32, 57, 32, 99,111,110, 46,109, 99,112,   /* 0x2bf0 */
121, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32,   /* 0x2c00 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2c10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 48, 56, 32, 32, 50,   /* 0x2c20 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2c30 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2c40 */
 49, 48, 32,108,122,109, 97, 46,112,114,101,112, 32, 32, 32, 32,   /* 0x2c50 */
 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48,   /* 0x2c60 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2c70 */
 48, 48, 48, 48, 49, 50, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2c80 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2c90 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 99,111,110,   /* 0x2ca0 */
 46,112, 97,100, 99,100, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2cb0 */
 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2cc0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50,   /* 0x2cd0 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2ce0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2cf0 */
 76, 89, 10, 32, 49, 50, 32,100,101, 99, 46,112,116,114, 32, 32,   /* 0x2d00 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48,   /* 0x2d10 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2d20 */
 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32, 50, 42, 42,   /* 0x2d30 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2d40 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51,   /* 0x2d50 */
 32,100,101, 99, 46,112,116,114, 46,104,105, 32, 32, 32, 32, 48,   /* 0x2d60 */
 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2d70 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2d80 */
 48, 48, 49, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2d90 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2da0 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 99,111,110, 46,101,   /* 0x2db0 */
110,116,114,121, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2dc0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2dd0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 52, 48, 32,   /* 0x2de0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2df0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 99,111,   /* 0x2e00 */
110, 46,101,120,105,116, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2e10 */
 48, 48, 50, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2e20 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x2e30 */
 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2e40 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2e50 */
 78, 76, 89, 10, 32, 49, 54, 32, 98,115,115, 46, 99,100, 98, 46,   /* 0x2e60 */
115,116, 97,114,116, 46,108,122,109, 97, 32, 48, 48, 48, 48, 48,   /* 0x2e70 */
 48, 49, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2e80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,   /* 0x2e90 */
 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2ea0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2eb0 */
 76, 89, 10, 32, 49, 55, 32, 98,115,115, 46, 99,100, 98, 46,101,   /* 0x2ec0 */
110,116,114,121, 46,108,122,109, 97, 32, 48, 48, 48, 48, 48, 48,   /* 0x2ed0 */
 50, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2ee0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 56,   /* 0x2ef0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2f00 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2f10 */
 89, 10, 32, 49, 56, 32, 98,115,115, 46, 99,111,110, 46,115,116,   /* 0x2f20 */
 97,114,116, 32, 48, 48, 48, 48, 48, 48, 51, 56, 32, 32, 48, 48,   /* 0x2f30 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2f40 */
 32, 32, 48, 48, 48, 48, 48, 49, 97, 99, 32, 32, 50, 42, 42, 48,   /* 0x2f50 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2f60 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32,   /* 0x2f70 */
 98,115,115, 46,101,120,105,116, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2f80 */
 48, 48, 48, 48, 50, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2f90 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2fa0 */
 48, 49,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2fb0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2fc0 */
 68, 79, 78, 76, 89, 10, 32, 50, 48, 32,109,101,109,115,101,116,   /* 0x2fd0 */
 46,115,104,111,114,116, 32, 32, 48, 48, 48, 48, 48, 48, 49, 52,   /* 0x2fe0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2ff0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 49, 48, 32, 32,   /* 0x3000 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3010 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3020 */
 32, 50, 49, 32,109,101,109,115,101,116, 46,108,111,110,103, 32,   /* 0x3030 */
 32, 32, 48, 48, 48, 48, 48, 48, 49, 56, 32, 32, 48, 48, 48, 48,   /* 0x3040 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3050 */
 48, 48, 48, 48, 48, 50, 50, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3060 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3070 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32,110,114,   /* 0x3080 */
118, 50, 98, 46, 56, 98,105,116, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3090 */
 48, 49,101, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x30a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x30b0 */
 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x30c0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x30d0 */
 78, 76, 89, 10, 32, 50, 51, 32,110,114,118, 50,100, 46, 56, 98,   /* 0x30e0 */
105,116, 32, 32, 32, 32, 48, 48, 48, 48, 48, 50, 50, 56, 32, 32,   /* 0x30f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3100 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 50, 56, 32, 32, 50, 42,   /* 0x3110 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3120 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x3130 */
 52, 32,110,114,118, 50,101, 46, 56, 98,105,116, 32, 32, 32, 32,   /* 0x3140 */
 48, 48, 48, 48, 48, 50, 53, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3150 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3160 */
 48, 48, 48, 54, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3170 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x3180 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32,110,114,118, 50,   /* 0x3190 */
 98, 46, 51, 50, 98,105,116, 32, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x31a0 */
101, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x31b0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 56, 97, 48,   /* 0x31c0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x31d0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x31e0 */
 89, 10, 32, 50, 54, 32,110,114,118, 50,100, 46, 51, 50, 98,105,   /* 0x31f0 */
116, 32, 32, 32, 48, 48, 48, 48, 48, 50, 50, 56, 32, 32, 48, 48,   /* 0x3200 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3210 */
 32, 32, 48, 48, 48, 48, 48, 97, 56, 99, 32, 32, 50, 42, 42, 48,   /* 0x3220 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x3230 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32,   /* 0x3240 */
110,114,118, 50,101, 46, 51, 50, 98,105,116, 32, 32, 32, 48, 48,   /* 0x3250 */
 48, 48, 48, 50, 53, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3260 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3270 */
 48, 99, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3280 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3290 */
 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 56, 98,105,116, 46,115,   /* 0x32a0 */
117, 98, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52,   /* 0x32b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x32c0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 48, 52, 32, 32,   /* 0x32d0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x32e0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 57, 32, 51, 50, 98,   /* 0x32f0 */
105,116, 46,115,117, 98, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3300 */
 48, 50, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3310 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 50,   /* 0x3320 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3330 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32,   /* 0x3340 */
110,114,118, 50, 98, 46,115,109, 97,108,108, 32, 32, 32, 48, 48,   /* 0x3350 */
 48, 48, 48, 48,100, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3360 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3370 */
 48,102, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3380 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3390 */
 68, 79, 78, 76, 89, 10, 32, 51, 49, 32,110,114,118, 50,100, 46,   /* 0x33a0 */
115,109, 97,108,108, 32, 32, 32, 48, 48, 48, 48, 48, 48,102, 48,   /* 0x33b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x33c0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 48, 50, 99, 32, 32,   /* 0x33d0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x33e0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x33f0 */
 32, 51, 50, 32,110,114,118, 50,101, 46,115,109, 97,108,108, 32,   /* 0x3400 */
 32, 32, 48, 48, 48, 48, 48, 49, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3410 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3420 */
 48, 48, 48, 48, 49, 49, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3430 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3440 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32,110,114,   /* 0x3450 */
118, 46,100,111,110,101, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3460 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3470 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50,   /* 0x3480 */
 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3490 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52,   /* 0x34a0 */
 32,100,101, 99,111,109,112,114,101,115,115,111,114, 46,115,116,   /* 0x34b0 */
 97,114,116, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x34c0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x34d0 */
 32, 32, 48, 48, 48, 48, 49, 50, 49, 99, 32, 32, 50, 42, 42, 48,   /* 0x34e0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x34f0 */
 79, 78, 76, 89, 10, 32, 51, 53, 32,108,122,109, 97, 46,105,110,   /* 0x3500 */
105,116, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 48, 32,   /* 0x3510 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3520 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50, 49, 99, 32, 32, 50,   /* 0x3530 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3540 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3550 */
 51, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32,   /* 0x3560 */
 32, 48, 48, 48, 48, 48, 97,100, 56, 32, 32, 48, 48, 48, 48, 48,   /* 0x3570 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3580 */
 48, 48, 48, 49, 50, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3590 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x35a0 */
 89, 10, 32, 51, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x35b0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 97,100, 56, 32, 32, 48, 48,   /* 0x35c0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x35d0 */
 32, 32, 48, 48, 48, 48, 49,100, 52, 52, 32, 32, 50, 42, 42, 48,   /* 0x35e0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x35f0 */
 79, 78, 76, 89, 10, 32, 51, 56, 32, 85, 80, 88, 49, 72, 69, 65,   /* 0x3600 */
 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32,   /* 0x3610 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3620 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 56, 49, 99, 32, 32, 50,   /* 0x3630 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3640 */
 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84,   /* 0x3650 */
 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3660 */
 32, 32, 32, 32,100, 32, 32,110,114,118, 46,100,111,110,101,  9,   /* 0x3670 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 46,100,111,110,   /* 0x3680 */
101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3690 */
100, 32, 32,100,101, 99,111,109,112,114,101,115,115,111,114, 46,   /* 0x36a0 */
115,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,100,   /* 0x36b0 */
101, 99,111,109,112,114,101,115,115,111,114, 46,115,116, 97,114,   /* 0x36c0 */
116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x36d0 */
100, 32, 32, 99,100, 98, 46,115,116, 97,114,116,  9, 48, 48, 48,   /* 0x36e0 */
 48, 48, 48, 48, 48, 32, 99,100, 98, 46,115,116, 97,114,116, 10,   /* 0x36f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x3700 */
 32, 99,100, 98, 46,101,110,116,114,121,  9, 48, 48, 48, 48, 48,   /* 0x3710 */
 48, 48, 48, 32, 99,100, 98, 46,101,110,116,114,121, 10, 48, 48,   /* 0x3720 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,   /* 0x3730 */
100, 98, 46,115,116, 97,114,116, 46,108,122,109, 97,  9, 48, 48,   /* 0x3740 */
 48, 48, 48, 48, 48, 48, 32, 99,100, 98, 46,115,116, 97,114,116,   /* 0x3750 */
 46,108,122,109, 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3760 */
 32, 32, 32, 32,100, 32, 32, 99,100, 98, 46,101,110,116,114,121,   /* 0x3770 */
 46,108,122,109, 97,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x3780 */
100, 98, 46,101,110,116,114,121, 46,108,122,109, 97, 10, 48, 48,   /* 0x3790 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,   /* 0x37a0 */
100, 98, 46,108,122,109, 97, 46, 99,112,114,  9, 48, 48, 48, 48,   /* 0x37b0 */
 48, 48, 48, 48, 32, 99,100, 98, 46,108,122,109, 97, 46, 99,112,   /* 0x37c0 */
114, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x37d0 */
100, 32, 32, 99,100, 98, 46,100,101, 99, 46,112,116,114,  9, 48,   /* 0x37e0 */
 48, 48, 48, 48, 48, 48, 48, 32, 99,100, 98, 46,100,101, 99, 46,   /* 0x37f0 */
112,116,114, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x3800 */
 32, 32,100, 32, 32, 99,100, 98, 46,100,101, 99, 46,112,116,114,   /* 0x3810 */
 46,104,105,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,100, 98,   /* 0x3820 */
 46,100,101, 99, 46,112,116,114, 46,104,105, 10, 48, 48, 48, 48,   /* 0x3830 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,100, 98,   /* 0x3840 */
 46,101,120,105,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x3850 */
100, 98, 46,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3860 */
 32,108, 32, 32, 32, 32,100, 32, 32, 99,111,110, 46,115,116, 97,   /* 0x3870 */
114,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,110, 46,   /* 0x3880 */
115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3890 */
 32, 32, 32, 32,100, 32, 32, 99,111,110, 46,109, 99,112,121,  9,   /* 0x38a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,110, 46,109, 99,112,   /* 0x38b0 */
121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x38c0 */
100, 32, 32,108,122,109, 97, 46,112,114,101,112,  9, 48, 48, 48,   /* 0x38d0 */
 48, 48, 48, 48, 48, 32,108,122,109, 97, 46,112,114,101,112, 10,   /* 0x38e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x38f0 */
 32, 99,111,110, 46,112, 97,100, 99,100,  9, 48, 48, 48, 48, 48,   /* 0x3900 */
 48, 48, 48, 32, 99,111,110, 46,112, 97,100, 99,100, 10, 48, 48,   /* 0x3910 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,100,   /* 0x3920 */
101, 99, 46,112,116,114,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3930 */
100,101, 99, 46,112,116,114, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3940 */
 32,108, 32, 32, 32, 32,100, 32, 32,100,101, 99, 46,112,116,114,   /* 0x3950 */
 46,104,105,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,100,101, 99,   /* 0x3960 */
 46,112,116,114, 46,104,105, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3970 */
 32,108, 32, 32, 32, 32,100, 32, 32, 99,111,110, 46,101,110,116,   /* 0x3980 */
114,121,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,110, 46,   /* 0x3990 */
101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x39a0 */
 32, 32, 32, 32,100, 32, 32, 99,111,110, 46,101,120,105,116,  9,   /* 0x39b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,110, 46,101,120,105,   /* 0x39c0 */
116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x39d0 */
100, 32, 32, 98,115,115, 46, 99,100, 98, 46,115,116, 97,114,116,   /* 0x39e0 */
 46,108,122,109, 97,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,   /* 0x39f0 */
115,115, 46, 99,100, 98, 46,115,116, 97,114,116, 46,108,122,109,   /* 0x3a00 */
 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3a10 */
100, 32, 32, 98,115,115, 46, 99,100, 98, 46,101,110,116,114,121,   /* 0x3a20 */
 46,108,122,109, 97,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,   /* 0x3a30 */
115,115, 46, 99,100, 98, 46,101,110,116,114,121, 46,108,122,109,   /* 0x3a40 */
 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3a50 */
100, 32, 32, 98,115,115, 46, 99,111,110, 46,115,116, 97,114,116,   /* 0x3a60 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,115,115, 46, 99,111,   /* 0x3a70 */
110, 46,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3a80 */
 32,108, 32, 32, 32, 32,100, 32, 32, 98,115,115, 46,101,120,105,   /* 0x3a90 */
116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,115,115, 46,101,   /* 0x3aa0 */
120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x3ab0 */
 32, 32,100, 32, 32,109,101,109,115,101,116, 46,115,104,111,114,   /* 0x3ac0 */
116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,109,101,109,115,101,   /* 0x3ad0 */
116, 46,115,104,111,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ae0 */
 32,108, 32, 32, 32, 32,100, 32, 32,109,101,109,115,101,116, 46,   /* 0x3af0 */
108,111,110,103,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,109,101,   /* 0x3b00 */
109,115,101,116, 46,108,111,110,103, 10, 48, 48, 48, 48, 48, 48,   /* 0x3b10 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50, 98,   /* 0x3b20 */
 46, 56, 98,105,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,   /* 0x3b30 */
114,118, 50, 98, 46, 56, 98,105,116, 10, 48, 48, 48, 48, 48, 48,   /* 0x3b40 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50,100,   /* 0x3b50 */
 46, 56, 98,105,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,   /* 0x3b60 */
114,118, 50,100, 46, 56, 98,105,116, 10, 48, 48, 48, 48, 48, 48,   /* 0x3b70 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50,101,   /* 0x3b80 */
 46, 56, 98,105,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,   /* 0x3b90 */
114,118, 50,101, 46, 56, 98,105,116, 10, 48, 48, 48, 48, 48, 48,   /* 0x3ba0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50, 98,   /* 0x3bb0 */
 46, 51, 50, 98,105,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3bc0 */
110,114,118, 50, 98, 46, 51, 50, 98,105,116, 10, 48, 48, 48, 48,   /* 0x3bd0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118,   /* 0x3be0 */
 50,100, 46, 51, 50, 98,105,116,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3bf0 */
 48, 32,110,114,118, 50,100, 46, 51, 50, 98,105,116, 10, 48, 48,   /* 0x3c00 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,   /* 0x3c10 */
114,118, 50,101, 46, 51, 50, 98,105,116,  9, 48, 48, 48, 48, 48,   /* 0x3c20 */
 48, 48, 48, 32,110,114,118, 50,101, 46, 51, 50, 98,105,116, 10,   /* 0x3c30 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x3c40 */
 32, 56, 98,105,116, 46,115,117, 98,  9, 48, 48, 48, 48, 48, 48,   /* 0x3c50 */
 48, 48, 32, 56, 98,105,116, 46,115,117, 98, 10, 48, 48, 48, 48,   /* 0x3c60 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 51, 50, 98,   /* 0x3c70 */
105,116, 46,115,117, 98,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3c80 */
 51, 50, 98,105,116, 46,115,117, 98, 10, 48, 48, 48, 48, 48, 48,   /* 0x3c90 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50, 98,   /* 0x3ca0 */
 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3cb0 */
110,114,118, 50, 98, 46,115,109, 97,108,108, 10, 48, 48, 48, 48,   /* 0x3cc0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118,   /* 0x3cd0 */
 50,100, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ce0 */
 48, 32,110,114,118, 50,100, 46,115,109, 97,108,108, 10, 48, 48,   /* 0x3cf0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,   /* 0x3d00 */
114,118, 50,101, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48,   /* 0x3d10 */
 48, 48, 48, 32,110,114,118, 50,101, 46,115,109, 97,108,108, 10,   /* 0x3d20 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x3d30 */
 32,108,122,109, 97, 46,105,110,105,116,  9, 48, 48, 48, 48, 48,   /* 0x3d40 */
 48, 48, 48, 32,108,122,109, 97, 46,105,110,105,116, 10, 48, 48,   /* 0x3d50 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x3d60 */
 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x3d70 */
 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3d80 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x3d90 */
 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x3da0 */
 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3db0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85,   /* 0x3dc0 */
 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3dd0 */
 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x3de0 */
 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,   /* 0x3df0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 83, 86, 82, 10, 48,   /* 0x3e00 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3e10 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,   /* 0x3e20 */
 80, 68, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x3e30 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x3e40 */
 48, 48, 48, 32,108,100,114, 95,115,122, 10, 48, 48, 48, 48, 48,   /* 0x3e50 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x3e60 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,   /* 0x3e70 */
 99,112,114, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x3e80 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x3e90 */
 48, 48, 48, 32, 68, 69, 67, 79, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ea0 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x3eb0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,101,110,116,114,121, 10, 48,   /* 0x3ec0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3ed0 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 68,   /* 0x3ee0 */
 67, 82, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x3ef0 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x3f00 */
 48, 48, 48, 32,108,122,109, 97, 95,105,110,105,116, 95,111,102,   /* 0x3f10 */
102, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x3f20 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f30 */
 48, 32, 80, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3f40 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x3f50 */
 48, 48, 48, 48, 48, 32,119,114,107,109,101,109, 10, 48, 48, 48,   /* 0x3f60 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x3f70 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 67, 10,   /* 0x3f80 */
 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32, 32, 79,   /* 0x3f90 */
 32, 56, 98,105,116, 46,115,117, 98,  9, 48, 48, 48, 48, 48, 48,   /* 0x3fa0 */
 48, 48, 32,103, 98, 56, 95,101, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x3fb0 */
 99, 32,103, 32, 32, 32, 32, 32, 79, 32, 51, 50, 98,105,116, 46,   /* 0x3fc0 */
115,117, 98,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 98, 51,   /* 0x3fd0 */
 50, 95,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x3fe0 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x3ff0 */
 48, 48, 48, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4000 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x4010 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116,   /* 0x4020 */
 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48,   /* 0x4030 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x4040 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,   /* 0x4050 */
 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4060 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x4070 */
 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110,   /* 0x4080 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4090 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x40a0 */
 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115,   /* 0x40b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x40c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,100, 98, 46,115,116,   /* 0x40d0 */
 97,114,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x40e0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x40f0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4100 */
 82, 95, 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32,   /* 0x4110 */
 32, 32, 80, 83, 86, 82, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,   /* 0x4120 */
 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32,   /* 0x4130 */
 32, 32, 80, 83, 86, 82, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x4140 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x4150 */
 99,100, 98, 46,101,110,116,114,121, 93, 58, 10, 79, 70, 70, 83,   /* 0x4160 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x4170 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x4180 */
 48, 48, 48, 49, 52, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73, 49,   /* 0x4190 */
 54, 32, 32, 32, 32, 32, 32, 32, 67, 80, 68, 79, 10, 48, 48, 48,   /* 0x41a0 */
 48, 48, 48, 49, 56, 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49,   /* 0x41b0 */
 54, 32, 32, 32, 32, 32, 32, 32, 67, 80, 68, 79, 10, 10, 82, 69,   /* 0x41c0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x41d0 */
 32, 70, 79, 82, 32, 91, 99,100, 98, 46,115,116, 97,114,116, 46,   /* 0x41e0 */
108,122,109, 97, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x41f0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4200 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4210 */
 32, 82, 95, 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32, 32, 32,   /* 0x4220 */
 32, 32, 32, 80, 83, 86, 82, 10, 48, 48, 48, 48, 48, 48, 48, 52,   /* 0x4230 */
 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32,   /* 0x4240 */
 32, 32, 32, 80, 83, 86, 82, 10, 48, 48, 48, 48, 48, 48, 48, 99,   /* 0x4250 */
 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32,   /* 0x4260 */
 32, 32, 32,108,100,114, 95,115,122, 10, 10, 82, 69, 76, 79, 67,   /* 0x4270 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x4280 */
 82, 32, 91, 99,100, 98, 46,101,110,116,114,121, 46,108,122,109,   /* 0x4290 */
 97, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x42a0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x42b0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95,   /* 0x42c0 */
 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,   /* 0x42d0 */
108,122,109, 97, 95, 99,112,114, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x42e0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x42f0 */
 32, 91, 99,100, 98, 46,108,122,109, 97, 46, 99,112,114, 93, 58,   /* 0x4300 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x4310 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x4320 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80,   /* 0x4330 */
 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32, 67, 80, 68,   /* 0x4340 */
 79, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 77, 73, 80,   /* 0x4350 */
 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 67, 80, 68,   /* 0x4360 */
 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x4370 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,100, 98, 46,100,   /* 0x4380 */
101, 99, 46,112,116,114, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x4390 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x43a0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x43b0 */
 48, 48, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32,   /* 0x43c0 */
 32, 32, 32, 32, 32, 68, 69, 67, 79, 10, 48, 48, 48, 48, 48, 48,   /* 0x43d0 */
 48, 52, 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32,   /* 0x43e0 */
 32, 32, 32, 32, 32, 68, 69, 67, 79, 10, 10, 82, 69, 76, 79, 67,   /* 0x43f0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x4400 */
 82, 32, 91, 99,100, 98, 46,100,101, 99, 46,112,116,114, 46,104,   /* 0x4410 */
105, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x4420 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x4430 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,   /* 0x4440 */
 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32,   /* 0x4450 */
 68, 69, 67, 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x4460 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,100,   /* 0x4470 */
 98, 46,101,120,105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x4480 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4490 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x44a0 */
 50, 48, 32, 82, 95, 77, 73, 80, 83, 95, 50, 54, 32, 32, 32, 32,   /* 0x44b0 */
 32, 32, 32, 32, 32,101,110,116,114,121, 10, 10, 82, 69, 76, 79,   /* 0x44c0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x44d0 */
 79, 82, 32, 91, 99,111,110, 46,115,116, 97,114,116, 93, 58, 10,   /* 0x44e0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x44f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x4500 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80, 83,   /* 0x4510 */
 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,108,100,114, 95,   /* 0x4520 */
115,122, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 77, 73,   /* 0x4530 */
 80, 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 67,   /* 0x4540 */
 82, 84, 10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 77, 73,   /* 0x4550 */
 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 67,   /* 0x4560 */
 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x4570 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,111,110, 46,   /* 0x4580 */
109, 99,112,121, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x4590 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x45a0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x45b0 */
 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32,   /* 0x45c0 */
 32, 32, 32,108,100,114, 95,115,122, 10, 10, 82, 69, 76, 79, 67,   /* 0x45d0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x45e0 */
 82, 32, 91,108,122,109, 97, 46,112,114,101,112, 93, 58, 10, 79,   /* 0x45f0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x4600 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x4610 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80, 83, 95,   /* 0x4620 */
 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,   /* 0x4630 */
105,110,105,116, 95,111,102,102, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x4640 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x4650 */
 32, 91, 99,111,110, 46,112, 97,100, 99,100, 93, 58, 10, 79, 70,   /* 0x4660 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x4670 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x4680 */
 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80, 83, 95, 76,   /* 0x4690 */
 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 80, 65, 68, 10, 10, 82,   /* 0x46a0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x46b0 */
 83, 32, 70, 79, 82, 32, 91,100,101, 99, 46,112,116,114, 93, 58,   /* 0x46c0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x46d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x46e0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80,   /* 0x46f0 */
 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 69, 67,   /* 0x4700 */
 79, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 77, 73, 80,   /* 0x4710 */
 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 69, 67,   /* 0x4720 */
 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x4730 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,100,101, 99, 46,112,   /* 0x4740 */
116,114, 46,104,105, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x4750 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4760 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4770 */
 52, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32, 32,   /* 0x4780 */
 32, 32, 32, 32, 68, 69, 67, 79, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x4790 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x47a0 */
 32, 91, 99,111,110, 46,101,120,105,116, 93, 58, 10, 79, 70, 70,   /* 0x47b0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x47c0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x47d0 */
 48, 48, 48, 48, 50, 52, 32, 82, 95, 77, 73, 80, 83, 95, 50, 54,   /* 0x47e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32,101,110,116,114,121, 10, 10,   /* 0x47f0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x4800 */
 68, 83, 32, 70, 79, 82, 32, 91, 98,115,115, 46, 99,100, 98, 46,   /* 0x4810 */
115,116, 97,114,116, 46,108,122,109, 97, 93, 58, 10, 79, 70, 70,   /* 0x4820 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x4830 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x4840 */
 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73,   /* 0x4850 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 80, 83, 86, 82, 10, 48, 48,   /* 0x4860 */
 48, 48, 48, 48, 48, 52, 32, 82, 95, 77, 73, 80, 83, 95, 76, 79,   /* 0x4870 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 80, 83, 86, 82, 10, 48, 48,   /* 0x4880 */
 48, 48, 48, 48, 48, 99, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73,   /* 0x4890 */
 49, 54, 32, 32, 32, 32, 32, 32, 32,119,114,107,109,101,109, 10,   /* 0x48a0 */
 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 77, 73, 80, 83, 95,   /* 0x48b0 */
 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,119,114,107,109,101,   /* 0x48c0 */
109, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x48d0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 98,115,115, 46, 99,   /* 0x48e0 */
100, 98, 46,101,110,116,114,121, 46,108,122,109, 97, 93, 58, 10,   /* 0x48f0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x4900 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x4910 */
 10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95, 77, 73, 80, 83,   /* 0x4920 */
 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,   /* 0x4930 */
 95, 99,112,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x4940 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 98,115,   /* 0x4950 */
115, 46, 99,111,110, 46,115,116, 97,114,116, 93, 58, 10, 79, 70,   /* 0x4960 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x4970 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x4980 */
 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80, 83, 95, 72,   /* 0x4990 */
 73, 49, 54, 32, 32, 32, 32, 32, 32, 32,119,114,107,109,101,109,   /* 0x49a0 */
 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 77, 73, 80, 83,   /* 0x49b0 */
 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,119,114,107,109,   /* 0x49c0 */
101,109, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 77, 73,   /* 0x49d0 */
 80, 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 67,   /* 0x49e0 */
 82, 84, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 77, 73,   /* 0x49f0 */
 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 68, 67,   /* 0x4a00 */
 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x4a10 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 98,115,115, 46,   /* 0x4a20 */
101,120,105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x4a30 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4a40 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 52,   /* 0x4a50 */
 32, 82, 95, 77, 73, 80, 83, 95, 50, 54, 32, 32, 32, 32, 32, 32,   /* 0x4a60 */
 32, 32, 32,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x4a70 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x4a80 */
 32, 91,109,101,109,115,101,116, 46,115,104,111,114,116, 93, 58,   /* 0x4a90 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x4aa0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x4ab0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 77, 73, 80,   /* 0x4ac0 */
 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32, 83, 67, 10,   /* 0x4ad0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x4ae0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91,109,101,109,115,101,116, 46,   /* 0x4af0 */
108,111,110,103, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x4b00 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4b10 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4b20 */
 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32,   /* 0x4b30 */
 32, 32, 32, 83, 67, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x4b40 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,110,   /* 0x4b50 */
114,118, 50, 98, 46, 56, 98,105,116, 93, 58, 10, 79, 70, 70, 83,   /* 0x4b60 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x4b70 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x4b80 */
 48, 48, 48, 99, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49,   /* 0x4b90 */
 54, 32, 32, 32, 32, 32, 32, 32,110,114,118, 46,100,111,110,101,   /* 0x4ba0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x4bb0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,110,114,118, 50,100, 46,   /* 0x4bc0 */
 56, 98,105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x4bd0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4be0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 49, 49, 99,   /* 0x4bf0 */
 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32,   /* 0x4c00 */
 32, 32, 32,110,114,118, 46,100,111,110,101, 10, 10, 82, 69, 76,   /* 0x4c10 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x4c20 */
 70, 79, 82, 32, 91,110,114,118, 50,101, 46, 56, 98,105,116, 93,   /* 0x4c30 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x4c40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x4c50 */
 85, 69, 10, 48, 48, 48, 48, 48, 49, 49, 99, 32, 82, 95, 77, 73,   /* 0x4c60 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,110,114,   /* 0x4c70 */
118, 46,100,111,110,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x4c80 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x4c90 */
110,114,118, 50, 98, 46, 51, 50, 98,105,116, 93, 58, 10, 79, 70,   /* 0x4ca0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x4cb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x4cc0 */
 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4cd0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,110,114,118, 46,100,111,   /* 0x4ce0 */
110,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x4cf0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,110,114,118, 50,   /* 0x4d00 */
100, 46, 51, 50, 98,105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x4d10 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4d20 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x4d30 */
 49, 49, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x4d40 */
 32, 32, 32, 32, 32, 32,110,114,118, 46,100,111,110,101, 10, 10,   /* 0x4d50 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x4d60 */
 68, 83, 32, 70, 79, 82, 32, 91,110,114,118, 50,101, 46, 51, 50,   /* 0x4d70 */
 98,105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x4d80 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4d90 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 49, 49, 99, 32,   /* 0x4da0 */
 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x4db0 */
 32, 32,110,114,118, 46,100,111,110,101, 10, 10, 82, 69, 76, 79,   /* 0x4dc0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x4dd0 */
 79, 82, 32, 91,110,114,118, 50, 98, 46,115,109, 97,108,108, 93,   /* 0x4de0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x4df0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x4e00 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 77, 73,   /* 0x4e10 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x4e20 */
 95,101, 10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 77, 73,   /* 0x4e30 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x4e40 */
 95,101, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 77, 73,   /* 0x4e50 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x4e60 */
 95,101, 10, 48, 48, 48, 48, 48, 48, 54, 52, 32, 82, 95, 77, 73,   /* 0x4e70 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,110,114,   /* 0x4e80 */
118, 46,100,111,110,101, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32,   /* 0x4e90 */
 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x4ea0 */
 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32,   /* 0x4eb0 */
 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x4ec0 */
 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32,   /* 0x4ed0 */
 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x4ee0 */
 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,   /* 0x4ef0 */
 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x4f00 */
 32, 32,103, 98, 95,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x4f10 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x4f20 */
110,114,118, 50,100, 46,115,109, 97,108,108, 93, 58, 10, 79, 70,   /* 0x4f30 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x4f40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x4f50 */
 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4f60 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x4f70 */
 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4f80 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x4f90 */
 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4fa0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x4fb0 */
 48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4fc0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x4fd0 */
 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x4fe0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x4ff0 */
 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x5000 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,110,114,118, 46,100,111,   /* 0x5010 */
110,101, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 77, 73,   /* 0x5020 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x5030 */
 95,101, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 77, 73,   /* 0x5040 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x5050 */
 95,101, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 77, 73,   /* 0x5060 */
 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98,   /* 0x5070 */
 95,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5080 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,110,114,118, 50,   /* 0x5090 */
101, 46,115,109, 97,108,108, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x50a0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x50b0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x50c0 */
 48, 48, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x50d0 */
 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48,   /* 0x50e0 */
 48, 50, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x50f0 */
 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48,   /* 0x5100 */
 48, 51, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x5110 */
 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48,   /* 0x5120 */
 48, 52, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x5130 */
 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48,   /* 0x5140 */
 48, 53, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x5150 */
 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48, 48, 48, 48, 48,   /* 0x5160 */
 48, 55, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32,   /* 0x5170 */
 32, 32, 32, 32, 32, 32,110,114,118, 46,100,111,110,101, 10, 48,   /* 0x5180 */
 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x5190 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x51a0 */
 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x51b0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x51c0 */
 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x51d0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 48,   /* 0x51e0 */
 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 77, 73, 80, 83, 95, 80,   /* 0x51f0 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,103, 98, 95,101, 10, 10,   /* 0x5200 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x5210 */
 68, 83, 32, 70, 79, 82, 32, 91,108,122,109, 97, 46,105,110,105,   /* 0x5220 */
116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x5230 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5240 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,   /* 0x5250 */
 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,   /* 0x5260 */
108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,   /* 0x5270 */
116, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 77, 73, 80,   /* 0x5280 */
 83, 95, 72, 73, 49, 54, 32, 32, 32, 32, 32, 32, 32,108,122,109,   /* 0x5290 */
 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49, 48,   /* 0x52a0 */
 32, 82, 95, 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32,   /* 0x52b0 */
 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,   /* 0x52c0 */
 48, 48, 48, 48, 49, 52, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73,   /* 0x52d0 */
 49, 54, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,   /* 0x52e0 */
108,101,110, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 77,   /* 0x52f0 */
 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,108,   /* 0x5300 */
122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,   /* 0x5310 */
 50, 52, 32, 82, 95, 77, 73, 80, 83, 95, 72, 73, 49, 54, 32, 32,   /* 0x5320 */
 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,114,   /* 0x5330 */
116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95,   /* 0x5340 */
 77, 73, 80, 83, 95, 76, 79, 49, 54, 32, 32, 32, 32, 32, 32, 32,   /* 0x5350 */
108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10,   /* 0x5360 */
 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 77, 73, 80, 83, 95,   /* 0x5370 */
 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,100,101, 99,111,109,   /* 0x5380 */
112,114,101,115,115,111,114, 46,115,116, 97,114,116, 10, 48, 48,   /* 0x5390 */
 48, 48, 48, 48, 52, 52, 32, 82, 95, 77, 73, 80, 83, 95, 76, 79,   /* 0x53a0 */
 49, 54, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116,   /* 0x53b0 */
 97, 99,107, 95, 97,100,106,117,115,116, 10                        /* 0x53c0 */
};
