/* i386-linux.kernel.vmlinuz.h
   created from i386-linux.kernel.vmlinuz.bin, 26461 (0x675d) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I386_LINUX_KERNEL_VMLINUZ_SIZE    26461
#define STUB_I386_LINUX_KERNEL_VMLINUZ_ADLER32 0x5f2137d7
#define STUB_I386_LINUX_KERNEL_VMLINUZ_CRC32   0xe63c2a03

unsigned char stub_i386_linux_kernel_vmlinuz[26461] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
 72, 30,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
152,  0,149,  0,140,200,131,192,  8,142,216,142,192,141,142,  0,   /* 0x  30 */
  0,  0,  0,137, 73,248,137, 65,252, 15,178, 97,248,106,  0,157,   /* 0x  40 */
184,  0,  0,  0,  0, 14, 80, 87, 86,131,205,255, 80, 80,106,  0,   /* 0x  50 */
104,  0,  0,  0,  0,190,  0,  0,  0,  0,191,  0,  0,  0,  0,185,   /* 0x  60 */
  0,  0,  0,  0,253,243,165,252,190,  0,  0,  0,  0,151,233,252,   /* 0x  70 */
255,255,255, 71,137,125,  1, 57, 56,116,248,252,190,  0,  0,  0,   /* 0x  80 */
  0,151,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,   /* 0x  90 */
  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,   /* 0x  a0 */
255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x  b0 */
219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,255,   /* 0x  c0 */
  1,219,115,255,117,  9,139, 30,131,238,252, 17,219,115,255, 49,   /* 0x  d0 */
201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,   /* 0x  e0 */
255,137,197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x  f0 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,   /* 0x 100 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,   /* 0x 110 */
  7,139, 30,131,238,252, 17,219,115, 48,  1,219,115, 48,117,  9,   /* 0x 120 */
139, 30,131,238,252, 17,219,115, 48, 65, 65,131,193,  2,129,253,   /* 0x 130 */
  0,243,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,   /* 0x 140 */
255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2,   /* 0x 150 */
 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,   /* 0x 160 */
  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,   /* 0x 170 */
255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,   /* 0x 180 */
  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,   /* 0x 190 */
255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 1a0 */
219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 15,   /* 0x 1b0 */
  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,114, 15, 72,   /* 0x 1c0 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,255, 49,   /* 0x 1d0 */
201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,   /* 0x 1e0 */
255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252,   /* 0x 1f0 */
 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 200 */
201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 210 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 68,  1,219,   /* 0x 220 */
115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68, 65, 65,131,   /* 0x 230 */
193,  2,129,253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,   /* 0x 240 */
164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,   /* 0x 250 */
118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,   /* 0x 260 */
139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,   /* 0x 270 */
207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,   /* 0x 280 */
 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,   /* 0x 290 */
 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,   /* 0x 2a0 */
131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,   /* 0x 2b0 */
 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,   /* 0x 2c0 */
219,114, 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 2d0 */
192,235,255,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x 2e0 */
235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,   /* 0x 2f0 */
240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,   /* 0x 300 */
131,238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,   /* 0x 310 */
252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 320 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,   /* 0x 330 */
219,115, 81,117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,   /* 0x 340 */
131,193,  2,129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,   /* 0x 350 */
243,164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4,   /* 0x 360 */
 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,   /* 0x 370 */
255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,   /* 0x 380 */
  1,207,233,252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0,   /* 0x 390 */
 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,   /* 0x 3a0 */
131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,   /* 0x 3b0 */
  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,   /* 0x 3c0 */
192,233,  3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,   /* 0x 3d0 */
255,131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,   /* 0x 3e0 */
  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36,   /* 0x 3f0 */
 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86,   /* 0x 400 */
 83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,   /* 0x 410 */
  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141,   /* 0x 420 */
 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,   /* 0x 430 */
195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224,   /* 0x 440 */
 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199,   /* 0x 450 */
 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,   /* 0x 460 */
  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36,   /* 0x 470 */
 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36,   /* 0x 480 */
 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,   /* 0x 490 */
  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115,   /* 0x 4a0 */
 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,   /* 0x 4b0 */
156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,   /* 0x 4c0 */
137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59,   /* 0x 4d0 */
 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66,   /* 0x 4e0 */
 67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57,   /* 0x 4f0 */
 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,   /* 0x 500 */
108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,   /* 0x 510 */
  1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59,   /* 0x 520 */
 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x 530 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,   /* 0x 540 */
232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,   /* 0x 550 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,   /* 0x 560 */
248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,   /* 0x 570 */
137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,   /* 0x 580 */
224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,   /* 0x 590 */
  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,   /* 0x 5a0 */
137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68,   /* 0x 5b0 */
 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36,   /* 0x 5c0 */
 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,   /* 0x 5d0 */
129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68,   /* 0x 5e0 */
 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,   /* 0x 5f0 */
132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x 600 */
 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232,   /* 0x 610 */
 11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,   /* 0x 620 */
  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,   /* 0x 630 */
141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68,   /* 0x 640 */
 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,   /* 0x 650 */
131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,   /* 0x 660 */
255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,   /* 0x 670 */
  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36,   /* 0x 680 */
 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,   /* 0x 690 */
  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,   /* 0x 6a0 */
 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198,   /* 0x 6b0 */
 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,   /* 0x 6c0 */
214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36,   /* 0x 6d0 */
 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,   /* 0x 6e0 */
137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,   /* 0x 6f0 */
  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137,   /* 0x 700 */
 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,   /* 0x 710 */
  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,   /* 0x 720 */
  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36,   /* 0x 730 */
 72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102,   /* 0x 740 */
 41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,   /* 0x 750 */
141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,   /* 0x 760 */
241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,   /* 0x 770 */
139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0,   /* 0x 780 */
 15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,   /* 0x 790 */
  0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,   /* 0x 7a0 */
  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,   /* 0x 7b0 */
128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88,   /* 0x 7c0 */
 49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,   /* 0x 7d0 */
141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199,   /* 0x 7e0 */
 41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,   /* 0x 7f0 */
254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92,   /* 0x 800 */
 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,   /* 0x 810 */
  8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,   /* 0x 820 */
152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,   /* 0x 830 */
  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,   /* 0x 840 */
  8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,   /* 0x 850 */
137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,   /* 0x 860 */
  5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22,   /* 0x 870 */
 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,   /* 0x 880 */
193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,   /* 0x 890 */
232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,   /* 0x 8a0 */
193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,   /* 0x 8b0 */
116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,   /* 0x 8c0 */
  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,   /* 0x 8d0 */
139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139,   /* 0x 8e0 */
 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,   /* 0x 8f0 */
  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,   /* 0x 900 */
137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,   /* 0x 910 */
233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36,   /* 0x 920 */
 56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,   /* 0x 930 */
  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,   /* 0x 940 */
182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,   /* 0x 950 */
240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,   /* 0x 960 */
193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108,   /* 0x 970 */
 36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139,   /* 0x 980 */
 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,   /* 0x 990 */
102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,   /* 0x 9a0 */
  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,   /* 0x 9b0 */
161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,   /* 0x 9c0 */
139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0,   /* 0x 9d0 */
 15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,   /* 0x 9e0 */
  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,   /* 0x 9f0 */
200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,   /* 0x a00 */
137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,   /* 0x a10 */
200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,   /* 0x a20 */
139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,   /* 0x a30 */
137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,   /* 0x a40 */
159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,   /* 0x a50 */
129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,   /* 0x a60 */
  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,   /* 0x a70 */
 17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,   /* 0x a80 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,   /* 0x a90 */
193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,   /* 0x aa0 */
  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,   /* 0x ab0 */
198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,   /* 0x ac0 */
255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,   /* 0x ad0 */
  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,   /* 0x ae0 */
  2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,   /* 0x af0 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,   /* 0x b00 */
193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84,   /* 0x b10 */
 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36,   /* 0x b20 */
 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,   /* 0x b30 */
208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,   /* 0x b40 */
  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,   /* 0x b50 */
129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,   /* 0x b60 */
  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,   /* 0x b70 */
129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,   /* 0x b80 */
209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,   /* 0x b90 */
  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,   /* 0x ba0 */
175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,   /* 0x bb0 */
200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68,   /* 0x bc0 */
 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,   /* 0x bd0 */
141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76,   /* 0x be0 */
 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,   /* 0x bf0 */
124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68,   /* 0x c00 */
 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,   /* 0x c10 */
116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,   /* 0x c20 */
  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,   /* 0x c30 */
  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119,   /* 0x c40 */
 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8,   /* 0x c50 */
 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,   /* 0x c60 */
193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36,   /* 0x c70 */
 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,   /* 0x c80 */
  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,   /* 0x c90 */
  5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,   /* 0x ca0 */
108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142,   /* 0x cb0 */
 39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,   /* 0x cc0 */
131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,   /* 0x cd0 */
211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,   /* 0x ce0 */
  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,   /* 0x cf0 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,   /* 0x d00 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36,   /* 0x d10 */
 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1,   /* 0x d20 */
 74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,   /* 0x d30 */
  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68,   /* 0x d40 */
 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,   /* 0x d50 */
192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119,   /* 0x d60 */
 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8,   /* 0x d70 */
 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,   /* 0x d80 */
  0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68,   /* 0x d90 */
 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,   /* 0x da0 */
137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,   /* 0x db0 */
208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,   /* 0x dc0 */
139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28,   /* 0x dd0 */
 73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,   /* 0x de0 */
116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2,   /* 0x df0 */
 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43,   /* 0x e00 */
 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,   /* 0x e10 */
136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172,   /* 0x e20 */
 36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,   /* 0x e30 */
164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124,   /* 0x e40 */
 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,   /* 0x e50 */
  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,   /* 0x e60 */
148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,   /* 0x e70 */
116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91,   /* 0x e80 */
 94, 95, 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,   /* 0x e90 */
  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172,   /* 0x ea0 */
 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,   /* 0x eb0 */
  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108,   /* 0x ec0 */
 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,   /* 0x ed0 */
  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,   /* 0x ee0 */
  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,   /* 0x ef0 */
116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,   /* 0x f00 */
  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,   /* 0x f10 */
  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,   /* 0x f20 */
  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,   /* 0x f30 */
131,192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68,   /* 0x f40 */
 36, 72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137,   /* 0x f50 */
 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,   /* 0x f60 */
182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140,   /* 0x f70 */
 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,   /* 0x f80 */
116, 36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,   /* 0x f90 */
224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,   /* 0x fa0 */
141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,   /* 0x fb0 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x fc0 */
 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199,   /* 0x fd0 */
 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,   /* 0x fe0 */
200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2,   /* 0x ff0 */
 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,   /* 0x1000 */
104,139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,   /* 0x1010 */
211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,   /* 0x1020 */
132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,   /* 0x1030 */
139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,   /* 0x1040 */
182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141,   /* 0x1050 */
 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,   /* 0x1060 */
255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119,   /* 0x1070 */
 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8,   /* 0x1080 */
 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,   /* 0x1090 */
  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115,   /* 0x10a0 */
 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,   /* 0x10b0 */
  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,   /* 0x10c0 */
116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,   /* 0x10d0 */
193,232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,   /* 0x10e0 */
  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,   /* 0x10f0 */
235,121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36,   /* 0x1100 */
 20,  1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36,   /* 0x1110 */
 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,   /* 0x1120 */
231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11,   /* 0x1130 */
 15,183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,   /* 0x1140 */
  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,   /* 0x1150 */
  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,   /* 0x1160 */
232,  5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,   /* 0x1170 */
240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,   /* 0x1180 */
131,124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,   /* 0x1190 */
  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,   /* 0x11a0 */
108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,   /* 0x11b0 */
  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,   /* 0x11c0 */
208,102,193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137,   /* 0x11d0 */
 85,  0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22,   /* 0x11e0 */
 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,   /* 0x11f0 */
193,225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,   /* 0x1200 */
139,149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,   /* 0x1210 */
137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,   /* 0x1220 */
139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139,   /* 0x1230 */
 76, 36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108,   /* 0x1240 */
 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,   /* 0x1250 */
129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,   /* 0x1260 */
  0,  0,137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76,   /* 0x1270 */
 36, 56,102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,   /* 0x1280 */
  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,   /* 0x1290 */
  3,193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,   /* 0x12a0 */
193,234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208,   /* 0x12b0 */
 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,   /* 0x12c0 */
197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,   /* 0x12d0 */
  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,   /* 0x12e0 */
139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,   /* 0x12f0 */
  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0,   /* 0x1300 */
 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,   /* 0x1310 */
  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,   /* 0x1320 */
115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137,   /* 0x1330 */
 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,   /* 0x1340 */
  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,   /* 0x1350 */
172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,   /* 0x1360 */
  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,   /* 0x1370 */
  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,   /* 0x1380 */
  0,  0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,   /* 0x1390 */
137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,   /* 0x13a0 */
193,232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,   /* 0x13b0 */
255,  0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,   /* 0x13c0 */
132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,   /* 0x13d0 */
199,139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,   /* 0x13e0 */
  0, 15,183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,   /* 0x13f0 */
  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,   /* 0x1400 */
133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241,   /* 0x1410 */
 41,199, 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36,   /* 0x1420 */
 56,129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22,   /* 0x1430 */
 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,   /* 0x1440 */
193,225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,   /* 0x1450 */
139,150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,   /* 0x1460 */
137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,   /* 0x1470 */
141,  4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,   /* 0x1480 */
137,206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139,   /* 0x1490 */
 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68,   /* 0x14a0 */
 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108,   /* 0x14b0 */
 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,   /* 0x14c0 */
  6,139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68,   /* 0x14d0 */
 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92,   /* 0x14e0 */
 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,   /* 0x14f0 */
  8, 67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,   /* 0x1500 */
175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,   /* 0x1510 */
232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,   /* 0x1520 */
  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137,   /* 0x1530 */
 76, 36, 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102,   /* 0x1540 */
 41,194,129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36,   /* 0x1550 */
 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8,   /* 0x1560 */
 67,  9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,   /* 0x1570 */
175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,   /* 0x1580 */
232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,   /* 0x1590 */
  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,   /* 0x15a0 */
  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235,   /* 0x15b0 */
 47, 41,198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199,   /* 0x15c0 */
 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,   /* 0x15d0 */
  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,   /* 0x15e0 */
139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,   /* 0x15f0 */
139,116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24,   /* 0x1600 */
 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,   /* 0x1610 */
182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,   /* 0x1620 */
232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,   /* 0x1630 */
184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,   /* 0x1640 */
137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,   /* 0x1650 */
102, 41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116,   /* 0x1660 */
 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,   /* 0x1670 */
194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,   /* 0x1680 */
231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,   /* 0x1690 */
184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,   /* 0x16a0 */
  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,   /* 0x16b0 */
  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36,   /* 0x16c0 */
 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,   /* 0x16d0 */
  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,   /* 0x16e0 */
 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,   /* 0x16f0 */
199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,   /* 0x1700 */
  5,141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,   /* 0x1710 */
199,137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,   /* 0x1720 */
139,108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,   /* 0x1730 */
  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,   /* 0x1740 */
131,230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,   /* 0x1750 */
127, 28,139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,   /* 0x1760 */
  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,   /* 0x1770 */
251,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x1780 */
132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x1790 */
 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,   /* 0x17a0 */
124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,   /* 0x17b0 */
137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,   /* 0x17c0 */
137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,   /* 0x17d0 */
  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36,   /* 0x17e0 */
 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,   /* 0x17f0 */
  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,   /* 0x1800 */
 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198,   /* 0x1810 */
 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,   /* 0x1820 */
248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41,   /* 0x1830 */
 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68,   /* 0x1840 */
 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76,   /* 0x1850 */
 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,   /* 0x1860 */
255,139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,   /* 0x1870 */
108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,   /* 0x1880 */
  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,   /* 0x1890 */
141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,   /* 0x18a0 */
116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,   /* 0x18b0 */
226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,   /* 0x18c0 */
187,246,255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92,   /* 0x18d0 */
 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,   /* 0x18e0 */
235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,   /* 0x18f0 */
  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,   /* 0x1900 */
137, 11,131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,   /* 0x1910 */
192,141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,   /* 0x1920 */
236, 49,201, 89, 90, 95,235, 27,138,  7,131,199,  1, 60,128,114,   /* 0x1930 */
 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,   /* 0x1940 */
255, 56, 23,117,255,139,  7,102,193,232,  8,193,192, 16,134,196,   /* 0x1950 */
 41,248,137,  7,131,199,  4,131,233,  4,138,  7,131,199,  1,226,   /* 0x1960 */
 13,131,233,  1,127,  1, 95,185,  0,  0,  0,  0,138,  7, 71, 44,   /* 0x1970 */
232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,102,   /* 0x1980 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,   /* 0x1990 */
  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,176,   /* 0x19a0 */
233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,193,232,  8,   /* 0x19b0 */
134,196,193,192, 16,134,196, 41,248,171,235,  4, 94, 95, 49,219,   /* 0x19c0 */
203, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,   /* 0x19d0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x19e0 */
 45,116,109,112, 47,105, 51, 56, 54, 45,108,105,110,117,120, 46,   /* 0x19f0 */
107,101,114,110,101,108, 46,118,109,108,105,110,117,122, 46, 98,   /* 0x1a00 */
105,110, 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,   /* 0x1a10 */
109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10,   /* 0x1a20 */
 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,   /* 0x1a30 */
109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,   /* 0x1a40 */
 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a50 */
 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,   /* 0x1a60 */
102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,   /* 0x1a70 */
 32, 32, 48, 32, 76, 73, 78, 85, 90, 48, 48, 48, 32, 32, 32, 32,   /* 0x1a80 */
 32, 32, 48, 48, 48, 48, 48, 48, 50, 53, 32, 32, 48, 48, 48, 48,   /* 0x1a90 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1aa0 */
 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1ab0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1ac0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 73,   /* 0x1ad0 */
 78, 85, 90, 48, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1ae0 */
 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1af0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b00 */
 53, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1b10 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,   /* 0x1b20 */
 32, 76, 90, 67, 65, 76, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x1b30 */
 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b40 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1b50 */
 48, 48, 48, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1b60 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1b70 */
 32, 32, 51, 32, 76, 90, 67, 75, 76, 76, 84, 49, 32, 32, 32, 32,   /* 0x1b80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48,   /* 0x1b90 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1ba0 */
 48, 48, 48, 48, 48, 48, 53,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1bb0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1bc0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 76, 66,   /* 0x1bd0 */
 90, 73, 77, 65, 71, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1be0 */
 48, 48, 49,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1bf0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1c00 */
 54, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1c10 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x1c20 */
 78, 76, 89, 10, 32, 32, 53, 32, 76, 90, 73, 77, 65, 71, 69, 48,   /* 0x1c30 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,   /* 0x1c40 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1c50 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 51, 32, 32, 50, 42,   /* 0x1c60 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x1c70 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,   /* 0x1c80 */
 54, 32, 76, 90, 67, 85, 84, 80, 79, 73, 32, 32, 32, 32, 32, 32,   /* 0x1c90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1ca0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1cb0 */
 48, 48, 48, 48, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1cc0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1cd0 */
 10, 32, 32, 55, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32,   /* 0x1ce0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,   /* 0x1cf0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d00 */
 32, 48, 48, 48, 48, 48, 48, 57, 50, 32, 32, 50, 42, 42, 48, 32,   /* 0x1d10 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1d20 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78,   /* 0x1d30 */
 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1d40 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d50 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1d60 */
 48, 57, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1d70 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1d80 */
 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 50, 66, 70, 65, 83, 49,   /* 0x1d90 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x1da0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1db0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 55, 32, 32, 50,   /* 0x1dc0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1dd0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 50, 66, 68,   /* 0x1de0 */
 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1df0 */
 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1e00 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57,100,   /* 0x1e10 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1e20 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 78,   /* 0x1e30 */
 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1e40 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1e50 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1e60 */
 48, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1e70 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1e80 */
 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 50, 66, 70, 65, 83, 50,   /* 0x1e90 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32,   /* 0x1ea0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1eb0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97,100, 32, 32, 50,   /* 0x1ec0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1ed0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1ee0 */
 49, 51, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32,   /* 0x1ef0 */
 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,   /* 0x1f00 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1f10 */
 48, 48, 48, 48, 48, 98, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1f20 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1f30 */
 89, 10, 32, 49, 52, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32,   /* 0x1f40 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48,   /* 0x1f50 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f60 */
 32, 32, 48, 48, 48, 48, 48, 48, 99, 51, 32, 32, 50, 42, 42, 48,   /* 0x1f70 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1f80 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32,   /* 0x1f90 */
 78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1fa0 */
 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1fb0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1fc0 */
 48, 48,100, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1fd0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x1fe0 */
 68, 79, 78, 76, 89, 10, 32, 49, 54, 32, 78, 50, 66, 68, 69, 67,   /* 0x1ff0 */
 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101,   /* 0x2000 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2010 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100,102, 32, 32,   /* 0x2020 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2030 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2040 */
 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32,   /* 0x2050 */
 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48,   /* 0x2060 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2070 */
 48, 48, 48, 48, 48, 49, 49,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2080 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2090 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32, 78, 50,   /* 0x20a0 */
 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x20b0 */
 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x20c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x20d0 */
 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x20e0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x20f0 */
 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 83, 77, 65, 53, 48,   /* 0x2100 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x2110 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2120 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 57, 32, 32, 50, 42,   /* 0x2130 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2140 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 78, 50, 66, 70, 65,   /* 0x2150 */
 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2160 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2170 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 98, 32,   /* 0x2180 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2190 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 49, 32, 78, 50,   /* 0x21a0 */
 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x21b0 */
 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x21c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x21d0 */
 51,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x21e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50,   /* 0x21f0 */
 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2200 */
 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2210 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2220 */
 48, 48, 49, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2230 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2240 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 66, 70, 65,   /* 0x2250 */
 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x2260 */
 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2270 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 53, 51, 32,   /* 0x2280 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2290 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x22a0 */
 10, 32, 50, 52, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32,   /* 0x22b0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48,   /* 0x22c0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x22d0 */
 32, 48, 48, 48, 48, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32,   /* 0x22e0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x22f0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32, 78,   /* 0x2300 */
 50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2310 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2320 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2330 */
 49, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2340 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x2350 */
 54, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32,   /* 0x2360 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2370 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2380 */
 48, 48, 48, 49, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2390 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x23a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 78, 50, 68, 70,   /* 0x23b0 */
 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x23c0 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x23d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 53,   /* 0x23e0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x23f0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2400 */
 89, 10, 32, 50, 56, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32,   /* 0x2410 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48,   /* 0x2420 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2430 */
 32, 32, 48, 48, 48, 48, 48, 49, 56, 55, 32, 32, 50, 42, 42, 48,   /* 0x2440 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2450 */
 79, 78, 76, 89, 10, 32, 50, 57, 32, 78, 50, 68, 68, 69, 67, 49,   /* 0x2460 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32,   /* 0x2470 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2480 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56,100, 32, 32, 50,   /* 0x2490 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x24a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50, 68, 83,   /* 0x24b0 */
 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x24c0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x24d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 57, 56,   /* 0x24e0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x24f0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2500 */
 89, 10, 32, 51, 49, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32,   /* 0x2510 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48,   /* 0x2520 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2530 */
 32, 32, 48, 48, 48, 48, 48, 49, 57,100, 32, 32, 50, 42, 42, 48,   /* 0x2540 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2550 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 50, 32,   /* 0x2560 */
 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2570 */
 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2580 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2590 */
 48, 49, 97, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x25a0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x25b0 */
 51, 51, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32,   /* 0x25c0 */
 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,   /* 0x25d0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x25e0 */
 48, 48, 48, 48, 49, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x25f0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2600 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 78, 50, 68,   /* 0x2610 */
 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2620 */
 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2630 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99,   /* 0x2640 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2650 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2660 */
 76, 89, 10, 32, 51, 53, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32,   /* 0x2670 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 50, 32, 32, 48,   /* 0x2680 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2690 */
 48, 32, 32, 48, 48, 48, 48, 48, 49, 99,102, 32, 32, 50, 42, 42,   /* 0x26a0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x26b0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 54,   /* 0x26c0 */
 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x26d0 */
 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x26e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x26f0 */
 48, 48, 50, 50, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2700 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2710 */
 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50, 68, 70, 65,   /* 0x2720 */
 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2730 */
102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2740 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50,101, 32,   /* 0x2750 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2760 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2770 */
 10, 32, 51, 56, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32,   /* 0x2780 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x2790 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x27a0 */
 32, 48, 48, 48, 48, 48, 50, 51,100, 32, 32, 50, 42, 42, 48, 32,   /* 0x27b0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x27c0 */
 78, 76, 89, 10, 32, 51, 57, 32, 78, 50, 68, 70, 65, 83, 53, 48,   /* 0x27d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,   /* 0x27e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x27f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51,102, 32, 32, 50, 42,   /* 0x2800 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2810 */
 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 78, 50, 68, 68, 69,   /* 0x2820 */
 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2830 */
 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2840 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 50, 32,   /* 0x2850 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2860 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32, 78, 50,   /* 0x2870 */
 68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2880 */
 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2890 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x28a0 */
 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x28b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x28c0 */
 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 54, 48,   /* 0x28d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32,   /* 0x28e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x28f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 55, 32, 32, 50, 42,   /* 0x2900 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2910 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52,   /* 0x2920 */
 51, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32,   /* 0x2930 */
 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2940 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2950 */
 48, 48, 48, 50, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2960 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x2970 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32, 78, 50, 68, 68,   /* 0x2980 */
 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2990 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x29a0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 54,   /* 0x29b0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x29c0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 53, 32, 78,   /* 0x29d0 */
 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x29e0 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x29f0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a00 */
 50, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2a10 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2a20 */
 79, 78, 76, 89, 10, 32, 52, 54, 32, 78, 50, 69, 70, 65, 83, 49,   /* 0x2a30 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0x2a40 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a50 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 57, 32, 32, 50,   /* 0x2a60 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2a70 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2a80 */
 52, 55, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32,   /* 0x2a90 */
 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48,   /* 0x2aa0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2ab0 */
 48, 48, 48, 48, 50, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2ac0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2ad0 */
 89, 10, 32, 52, 56, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32,   /* 0x2ae0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48,   /* 0x2af0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b00 */
 32, 32, 48, 48, 48, 48, 48, 50, 57, 49, 32, 32, 50, 42, 42, 48,   /* 0x2b10 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2b20 */
 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 83, 77, 65, 50,   /* 0x2b30 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x2b40 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2b50 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57, 99, 32, 32, 50,   /* 0x2b60 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2b70 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2b80 */
 53, 48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32,   /* 0x2b90 */
 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,   /* 0x2ba0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2bb0 */
 48, 48, 48, 48, 50, 97, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2bc0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2bd0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 49, 32, 78, 50, 69,   /* 0x2be0 */
 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2bf0 */
 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2c00 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97,   /* 0x2c10 */
 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2c20 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 50, 32,   /* 0x2c30 */
 78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2c40 */
 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2c50 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2c60 */
 48, 50, 98, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2c70 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2c80 */
 68, 79, 78, 76, 89, 10, 32, 53, 51, 32, 78, 50, 69, 70, 65, 83,   /* 0x2c90 */
 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102,   /* 0x2ca0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2cb0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 99, 52, 32, 32,   /* 0x2cc0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2cd0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2ce0 */
 32, 53, 52, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32,   /* 0x2cf0 */
 32, 32, 48, 48, 48, 48, 48, 48, 53,102, 32, 32, 48, 48, 48, 48,   /* 0x2d00 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2d10 */
 48, 48, 48, 48, 48, 50,100, 51, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2d20 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2d30 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53, 32, 78, 50,   /* 0x2d40 */
 69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2d50 */
 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2d60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x2d70 */
 51, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2d80 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2d90 */
 78, 76, 89, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65, 83, 52, 48,   /* 0x2da0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,   /* 0x2db0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2dc0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51,102, 32, 32, 50, 42,   /* 0x2dd0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2de0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,   /* 0x2df0 */
 55, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32,   /* 0x2e00 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2e10 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2e20 */
 48, 48, 48, 51, 52,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2e30 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2e40 */
 10, 32, 53, 56, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32,   /* 0x2e50 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,   /* 0x2e60 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2e70 */
 32, 48, 48, 48, 48, 48, 51, 53, 48, 32, 32, 50, 42, 42, 48, 32,   /* 0x2e80 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2e90 */
 78, 76, 89, 10, 32, 53, 57, 32, 78, 50, 69, 68, 69, 67, 53, 48,   /* 0x2ea0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32,   /* 0x2eb0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2ec0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 51, 32, 32, 50, 42,   /* 0x2ed0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2ee0 */
 65, 68, 79, 78, 76, 89, 10, 32, 54, 48, 32, 78, 50, 69, 83, 77,   /* 0x2ef0 */
 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2f00 */
 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2f10 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 99, 32,   /* 0x2f20 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2f30 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2f40 */
 10, 32, 54, 49, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32,   /* 0x2f50 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48,   /* 0x2f60 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2f70 */
 32, 48, 48, 48, 48, 48, 51, 54, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x2f80 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2f90 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 50, 32, 78,   /* 0x2fa0 */
 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2fb0 */
 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2fc0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2fd0 */
 51, 56, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2fe0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2ff0 */
 79, 78, 76, 89, 10, 32, 54, 51, 32, 78, 50, 69, 68, 69, 67, 54,   /* 0x3000 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3010 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3020 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 57, 55, 32, 32, 50,   /* 0x3030 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3040 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 52, 32, 76, 90, 77, 65,   /* 0x3050 */
 95, 68, 69, 67, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3060 */
 50,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3070 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 57, 55,   /* 0x3080 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x3090 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x30a0 */
 89, 10, 32, 54, 53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,   /* 0x30b0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48,   /* 0x30c0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x30d0 */
 32, 32, 48, 48, 48, 48, 48, 51, 99, 53, 32, 32, 50, 42, 42, 48,   /* 0x30e0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x30f0 */
 79, 78, 76, 89, 10, 32, 54, 54, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3100 */
 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32,   /* 0x3110 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3120 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 48,100, 32, 32, 50,   /* 0x3130 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3140 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 55, 32, 76, 90, 77, 65,   /* 0x3150 */
 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97,   /* 0x3160 */
 56, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3170 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 57, 51,   /* 0x3180 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x3190 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 56, 32, 76,   /* 0x31a0 */
 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48,   /* 0x31b0 */
 48, 48, 48, 49, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x31c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x31d0 */
 57, 49, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x31e0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54,   /* 0x31f0 */
 57, 32, 76, 90, 67, 75, 76, 76, 84, 57, 32, 32, 32, 32, 32, 32,   /* 0x3200 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3210 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3220 */
 48, 48, 49, 57, 51, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3230 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3240 */
 10, 32, 55, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 32,   /* 0x3250 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48,   /* 0x3260 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3270 */
 32, 48, 48, 48, 48, 49, 57, 51, 54, 32, 32, 50, 42, 42, 48, 32,   /* 0x3280 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x3290 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 49, 32, 99,   /* 0x32a0 */
116,111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x32b0 */
 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x32c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x32d0 */
 57, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x32e0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x32f0 */
 79, 78, 76, 89, 10, 32, 55, 50, 32, 99,116,111,107, 51, 50, 46,   /* 0x3300 */
 50, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,102, 32,   /* 0x3310 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3320 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52, 98, 32, 32, 50,   /* 0x3330 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3340 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3350 */
 55, 51, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32,   /* 0x3360 */
 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48,   /* 0x3370 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3380 */
 48, 48, 48, 49, 57, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3390 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x33a0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 99,116,111,   /* 0x33b0 */
107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x33c0 */
 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x33d0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55,   /* 0x33e0 */
 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x33f0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3400 */
 76, 89, 10, 32, 55, 53, 32, 76, 90, 67, 65, 76, 76, 84, 57, 32,   /* 0x3410 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48,   /* 0x3420 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3430 */
 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 54, 32, 32, 50, 42, 42,   /* 0x3440 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3450 */
 68, 79, 78, 76, 89, 10, 32, 55, 54, 32, 67, 65, 76, 76, 84, 82,   /* 0x3460 */
 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,   /* 0x3470 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3480 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 55, 32, 32,   /* 0x3490 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x34a0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x34b0 */
 32, 55, 55, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32,   /* 0x34c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x34d0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x34e0 */
 48, 48, 48, 48, 49, 57, 56, 53, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x34f0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3500 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 67, 65,   /* 0x3510 */
 76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3520 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3530 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3540 */
 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3550 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 57,   /* 0x3560 */
 32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x3570 */
 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3580 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3590 */
 48, 49, 57, 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x35a0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x35b0 */
 32, 56, 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32,   /* 0x35c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x35d0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x35e0 */
 48, 48, 48, 48, 49, 57, 57, 51, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x35f0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3600 */
 76, 89, 10, 32, 56, 49, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32,   /* 0x3610 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,   /* 0x3620 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3630 */
 48, 32, 32, 48, 48, 48, 48, 49, 57, 57, 53, 32, 32, 50, 42, 42,   /* 0x3640 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3650 */
 68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 67, 65, 76, 76, 84, 82,   /* 0x3660 */
 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,   /* 0x3670 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3680 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 57, 97, 32, 32,   /* 0x3690 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x36a0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x36b0 */
 32, 56, 51, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32,   /* 0x36c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x36d0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x36e0 */
 48, 48, 48, 48, 49, 57, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x36f0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3700 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 67, 65,   /* 0x3710 */
 76, 76, 84, 82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3720 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3730 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3740 */
 97,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3750 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 53,   /* 0x3760 */
 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48,   /* 0x3770 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3780 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3790 */
 48, 49, 57, 97,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x37a0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x37b0 */
 32, 56, 54, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32,   /* 0x37c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48,   /* 0x37d0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x37e0 */
 48, 48, 48, 48, 49, 57, 98, 49, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x37f0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3800 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55, 32, 67, 84,   /* 0x3810 */
 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3820 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3830 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3840 */
 98, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3850 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x3860 */
 78, 76, 89, 10, 32, 56, 56, 32, 67, 65, 76, 76, 84, 82, 49, 50,   /* 0x3870 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x3880 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3890 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 98, 97, 32, 32, 50, 42,   /* 0x38a0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x38b0 */
 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 67, 84, 66, 83, 72,   /* 0x38c0 */
 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x38d0 */
 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x38e0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 98, 99, 32,   /* 0x38f0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3900 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 48, 32, 67, 84,   /* 0x3910 */
 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3920 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3930 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3940 */
 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3950 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49,   /* 0x3960 */
 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x3970 */
 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3980 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3990 */
 48, 49, 57, 99, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x39a0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x39b0 */
 32, 57, 50, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32,   /* 0x39c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x39d0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x39e0 */
 48, 48, 48, 48, 49, 57, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x39f0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3a00 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 51, 32, 76, 73,   /* 0x3a10 */
 78, 85, 90, 57, 57, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3a20 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3a30 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3a40 */
 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3a50 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 52,   /* 0x3a60 */
 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,   /* 0x3a70 */
 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3a80 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3a90 */
 48, 49, 57,100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3aa0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3ab0 */
 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48,   /* 0x3ac0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3ad0 */
 50, 66, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ae0 */
 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3af0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,   /* 0x3b00 */
 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x3b10 */
 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3b20 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,  9,   /* 0x3b30 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 49,   /* 0x3b40 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3b50 */
100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,   /* 0x3b60 */
 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3b70 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3b80 */
 50, 66, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3b90 */
 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3ba0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,   /* 0x3bb0 */
 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x3bc0 */
 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3bd0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,  9,   /* 0x3be0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54,   /* 0x3bf0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3c00 */
100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48,   /* 0x3c10 */
 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48,   /* 0x3c20 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3c30 */
 50, 68, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3c40 */
 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3c50 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,   /* 0x3c60 */
 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x3c70 */
 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3c80 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48,  9,   /* 0x3c90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 49,   /* 0x3ca0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3cb0 */
100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,   /* 0x3cc0 */
 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3cd0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3ce0 */
 50, 68, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3cf0 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3d00 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,   /* 0x3d10 */
 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x3d20 */
 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3d30 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49,  9,   /* 0x3d40 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54,   /* 0x3d50 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3d60 */
100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48,   /* 0x3d70 */
 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48,   /* 0x3d80 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3d90 */
 50, 69, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3da0 */
 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3db0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,   /* 0x3dc0 */
 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x3dd0 */
 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3de0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,  9,   /* 0x3df0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 49,   /* 0x3e00 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3e10 */
100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,   /* 0x3e20 */
 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3e30 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x3e40 */
 50, 69, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3e50 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3e60 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,   /* 0x3e70 */
 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x3e80 */
 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3e90 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,  9,   /* 0x3ea0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54,   /* 0x3eb0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3ec0 */
100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48,   /* 0x3ed0 */
 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48, 48,   /* 0x3ee0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,   /* 0x3ef0 */
116,111,107, 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f00 */
 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48,   /* 0x3f10 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,   /* 0x3f20 */
107, 51, 50, 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3f30 */
 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3f40 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,   /* 0x3f50 */
 50, 46, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,   /* 0x3f60 */
111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f70 */
 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,   /* 0x3f80 */
 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107,   /* 0x3f90 */
 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x3fa0 */
 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9,   /* 0x3fb0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0x3fc0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x3fd0 */
100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48,   /* 0x3fe0 */
 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48,   /* 0x3ff0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x4000 */
 65, 76, 76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4010 */
 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x4020 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,   /* 0x4030 */
 82, 49, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,   /* 0x4040 */
 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4050 */
 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 48, 48, 48,  9,   /* 0x4060 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 48, 48,   /* 0x4070 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4080 */
100, 32, 32, 76, 73, 78, 85, 90, 48, 48, 49,  9, 48, 48, 48, 48,   /* 0x4090 */
 48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 48, 48, 49, 10, 48, 48,   /* 0x40a0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x40b0 */
 90, 67, 65, 76, 76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x40c0 */
 32, 76, 90, 67, 65, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x40d0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 67, 75, 76,   /* 0x40e0 */
 76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 67,   /* 0x40f0 */
 75, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4100 */
 32, 32, 32, 32,100, 32, 32, 76, 66, 90, 73, 77, 65, 71, 69,  9,   /* 0x4110 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 66, 90, 73, 77, 65, 71,   /* 0x4120 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4130 */
100, 32, 32, 76, 90, 73, 77, 65, 71, 69, 48,  9, 48, 48, 48, 48,   /* 0x4140 */
 48, 48, 48, 48, 32, 76, 90, 73, 77, 65, 71, 69, 48, 10, 48, 48,   /* 0x4150 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x4160 */
 90, 67, 85, 84, 80, 79, 73,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4170 */
 32, 76, 90, 67, 85, 84, 80, 79, 73, 10, 48, 48, 48, 48, 48, 48,   /* 0x4180 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,   /* 0x4190 */
 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x41a0 */
 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x41b0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48,  9,   /* 0x41c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 50,   /* 0x41d0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x41e0 */
100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48,   /* 0x41f0 */
 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48,   /* 0x4200 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x4210 */
 50, 66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4220 */
 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x4230 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,   /* 0x4240 */
 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x4250 */
 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4260 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48,  9,   /* 0x4270 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 52,   /* 0x4280 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4290 */
100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48,   /* 0x42a0 */
 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48,   /* 0x42b0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x42c0 */
 50, 66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x42d0 */
 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x42e0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,   /* 0x42f0 */
 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x4300 */
 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4310 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48,  9,   /* 0x4320 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 54,   /* 0x4330 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4340 */
100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48,   /* 0x4350 */
 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48, 48,   /* 0x4360 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x4370 */
 50, 68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4380 */
 32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x4390 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,   /* 0x43a0 */
 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x43b0 */
 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x43c0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50, 48,  9,   /* 0x43d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 50,   /* 0x43e0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x43f0 */
100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48,   /* 0x4400 */
 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10, 48, 48,   /* 0x4410 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x4420 */
 50, 68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4430 */
 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x4440 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,   /* 0x4450 */
 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x4460 */
 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4470 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48,  9,   /* 0x4480 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 52,   /* 0x4490 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x44a0 */
100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48,   /* 0x44b0 */
 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48,   /* 0x44c0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x44d0 */
 50, 68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x44e0 */
 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x44f0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,   /* 0x4500 */
 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x4510 */
 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4520 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48,  9,   /* 0x4530 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54,   /* 0x4540 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4550 */
100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48,   /* 0x4560 */
 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48,   /* 0x4570 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x4580 */
 50, 69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4590 */
 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x45a0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,   /* 0x45b0 */
 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x45c0 */
 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x45d0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48,  9,   /* 0x45e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 51,   /* 0x45f0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4600 */
100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48,   /* 0x4610 */
 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48, 48,   /* 0x4620 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x4630 */
 50, 69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4640 */
 32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x4650 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,   /* 0x4660 */
 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x4670 */
 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4680 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53, 48,  9,   /* 0x4690 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 53,   /* 0x46a0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x46b0 */
100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48,   /* 0x46c0 */
 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10, 48, 48,   /* 0x46d0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x46e0 */
 50, 69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x46f0 */
 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x4700 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,   /* 0x4710 */
 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x4720 */
 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4730 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48,   /* 0x4740 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x4750 */
 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4760 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,   /* 0x4770 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x4780 */
 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4790 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x47a0 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x47b0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x47c0 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x47d0 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x47e0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x47f0 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,   /* 0x4800 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x4810 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x4820 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 67, 75, 76, 76, 84, 57,  9,   /* 0x4830 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 67, 75, 76, 76, 84,   /* 0x4840 */
 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x4850 */
100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,  9, 48, 48, 48,   /* 0x4860 */
 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10,   /* 0x4870 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x4880 */
 32, 76, 90, 67, 65, 76, 76, 84, 57,  9, 48, 48, 48, 48, 48, 48,   /* 0x4890 */
 48, 48, 32, 76, 90, 67, 65, 76, 76, 84, 57, 10, 48, 48, 48, 48,   /* 0x48a0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,   /* 0x48b0 */
 76, 69, 86, 69, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,   /* 0x48c0 */
 84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x48d0 */
 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0x48e0 */
 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,   /* 0x48f0 */
 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x4900 */
 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48, 49,  9, 48, 48,   /* 0x4910 */
 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10,   /* 0x4920 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x4930 */
 32, 67, 84, 66, 82, 79, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48,   /* 0x4940 */
 48, 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48,   /* 0x4950 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,   /* 0x4960 */
 83, 87, 65, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,   /* 0x4970 */
 84, 66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4980 */
 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0x4990 */
 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,   /* 0x49a0 */
 82, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x49b0 */
 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56,  9, 48, 48,   /* 0x49c0 */
 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10,   /* 0x49d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x49e0 */
 32, 67, 65, 76, 76, 84, 82, 69, 57,  9, 48, 48, 48, 48, 48, 48,   /* 0x49f0 */
 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48,   /* 0x4a00 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,   /* 0x4a10 */
 76, 69, 86, 69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,   /* 0x4a20 */
 84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4a30 */
 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49,   /* 0x4a40 */
 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,   /* 0x4a50 */
 82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x4a60 */
 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,  9, 48, 48,   /* 0x4a70 */
 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10,   /* 0x4a80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x4a90 */
 32, 67, 84, 66, 82, 79, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48,   /* 0x4aa0 */
 48, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48,   /* 0x4ab0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,   /* 0x4ac0 */
 83, 87, 65, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,   /* 0x4ad0 */
 84, 66, 83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4ae0 */
 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 57, 57,   /* 0x4af0 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90,   /* 0x4b00 */
 57, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x4b10 */
 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48,   /* 0x4b20 */
 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10,   /* 0x4b30 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4b40 */
 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4b50 */
115,116, 97, 99,107, 95,111,102,102,115,101,116, 10, 48, 48, 48,   /* 0x4b60 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4b70 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,   /* 0x4b80 */
103,105,110, 97,108, 95,101,110,116,114,121, 10, 48, 48, 48, 48,   /* 0x4b90 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x4ba0 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,   /* 0x4bb0 */
101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4bc0 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x4bd0 */
 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114, 95,108,101,   /* 0x4be0 */
110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x4bf0 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x4c00 */
 48, 48, 48, 48, 32, 99,111,112,121, 95,115,111,117,114, 99,101,   /* 0x4c10 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4c20 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c30 */
 32, 99,111,112,121, 95,100,101,115,116, 10, 48, 48, 48, 48, 48,   /* 0x4c40 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x4c50 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,119,111,114,100,115,   /* 0x4c60 */
 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c70 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x4c80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,115,114, 99, 95,102,111,114,   /* 0x4c90 */
 95,100,101, 99,111,109,112,114,101,115,115,111,114, 10, 48, 48,   /* 0x4ca0 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x4cb0 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,100,101,   /* 0x4cc0 */
 99,111,109,112,114,101,115,115,111,114, 10, 48, 48, 48, 48, 48,   /* 0x4cd0 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x4ce0 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,   /* 0x4cf0 */
115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48,   /* 0x4d00 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4d10 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109,   /* 0x4d20 */
 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4d30 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,   /* 0x4d40 */
 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,   /* 0x4d50 */
101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,   /* 0x4d60 */
 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,   /* 0x4d70 */
 48, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,   /* 0x4d80 */
101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x4d90 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85,   /* 0x4da0 */
 90, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x4db0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4dc0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 98,   /* 0x4dd0 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x4de0 */
 32, 32, 32,115,116, 97, 99,107, 95,111,102,102,115,101,116, 10,   /* 0x4df0 */
 48, 48, 48, 48, 48, 48, 49,100, 32, 82, 95, 51, 56, 54, 95, 51,   /* 0x4e00 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,   /* 0x4e10 */
110, 97,108, 95,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67,   /* 0x4e20 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x4e30 */
 82, 32, 91, 76, 90, 67, 75, 76, 76, 84, 49, 93, 58, 10, 79, 70,   /* 0x4e40 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x4e50 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x4e60 */
 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,   /* 0x4e70 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,   /* 0x4e80 */
 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,   /* 0x4e90 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4ea0 */
102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82,   /* 0x4eb0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x4ec0 */
 83, 32, 70, 79, 82, 32, 91, 76, 66, 90, 73, 77, 65, 71, 69, 93,   /* 0x4ed0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x4ee0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x4ef0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x4f00 */
 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,   /* 0x4f10 */
112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48,   /* 0x4f20 */
 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,   /* 0x4f30 */
 32, 32, 32, 32, 32, 99,111,112,121, 95,100,101,115,116, 10, 48,   /* 0x4f40 */
 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 51, 56, 54, 95, 51, 50,   /* 0x4f50 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,119,111,114,100,115, 95,   /* 0x4f60 */
116,111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 49, 52,   /* 0x4f70 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x4f80 */
 32, 32, 32,115,114, 99, 95,102,111,114, 95,100,101, 99,111,109,   /* 0x4f90 */
112,114,101,115,115,111,114, 10, 48, 48, 48, 48, 48, 48, 49, 97,   /* 0x4fa0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,   /* 0x4fb0 */
 32, 32, 32,100,101, 99,111,109,112,114,101,115,115,111,114, 10,   /* 0x4fc0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x4fd0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 73, 77, 65, 71, 69,   /* 0x4fe0 */
 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x4ff0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5000 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,   /* 0x5010 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5020 */
115,114, 99, 95,102,111,114, 95,100,101, 99,111,109,112,114,101,   /* 0x5030 */
115,115,111,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5040 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5050 */
 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5060 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5070 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x5080 */
 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5090 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,   /* 0x50a0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x50b0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93,   /* 0x50c0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x50d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x50e0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x50f0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5100 */
 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x5110 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x5120 */
 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x5130 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5140 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x5150 */
 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x5160 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10,   /* 0x5170 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x5180 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50,   /* 0x5190 */
 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x51a0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x51b0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,   /* 0x51c0 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x51d0 */
 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x51e0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x51f0 */
 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70,   /* 0x5200 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x5210 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x5220 */
 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x5230 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50,   /* 0x5240 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5250 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,   /* 0x5260 */
 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5270 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5280 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,   /* 0x5290 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x52a0 */
 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x52b0 */
 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x52c0 */
 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10,   /* 0x52d0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x52e0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x52f0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x5300 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x5310 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51,   /* 0x5320 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5330 */
 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102,   /* 0x5340 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5350 */
 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76,   /* 0x5360 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5370 */
 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10,   /* 0x5380 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5390 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x53a0 */
 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,   /* 0x53b0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,   /* 0x53c0 */
 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x53d0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x53e0 */
 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x53f0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5400 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x5410 */
 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5420 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x5430 */
 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x5440 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51,   /* 0x5450 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5460 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77,   /* 0x5470 */
 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5480 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5490 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x54a0 */
 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x54b0 */
 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x54c0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x54d0 */
 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79,   /* 0x54e0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x54f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5500 */
 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5510 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65,   /* 0x5520 */
 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51,   /* 0x5530 */
 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5540 */
 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5550 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5560 */
 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83,   /* 0x5570 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5580 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5590 */
 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x55a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,   /* 0x55b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x55c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,   /* 0x55d0 */
 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x55e0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x55f0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0x5600 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5610 */
 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5620 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5630 */
 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70,   /* 0x5640 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5650 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5660 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5670 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x5680 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5690 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83,   /* 0x56a0 */
 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x56b0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x56c0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x56d0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x56e0 */
 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76,   /* 0x56f0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5700 */
 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10,   /* 0x5710 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5720 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5730 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x5740 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70,   /* 0x5750 */
 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5760 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5770 */
 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5780 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5790 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x57a0 */
 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x57b0 */
 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x57c0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x57d0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93,   /* 0x57e0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x57f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x5800 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,   /* 0x5810 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5820 */
 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,   /* 0x5830 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5840 */
 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,   /* 0x5850 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5860 */
 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79,   /* 0x5870 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5880 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5890 */
 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x58a0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x58b0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51,   /* 0x58c0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x58d0 */
 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51,   /* 0x58e0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x58f0 */
 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76,   /* 0x5900 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5910 */
 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10,   /* 0x5920 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5930 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5940 */
 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,   /* 0x5950 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,   /* 0x5960 */
 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5970 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5980 */
 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5990 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x59a0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x59b0 */
 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x59c0 */
 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x59d0 */
 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x59e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51,   /* 0x59f0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5a00 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,   /* 0x5a10 */
 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5a20 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5a30 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x5a40 */
 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x5a50 */
 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x5a60 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5a70 */
 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79,   /* 0x5a80 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5a90 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5aa0 */
 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5ab0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65,   /* 0x5ac0 */
 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51,   /* 0x5ad0 */
 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5ae0 */
 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5af0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5b00 */
 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83,   /* 0x5b10 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5b20 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5b30 */
 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x5b40 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x5b50 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x5b60 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,   /* 0x5b70 */
 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x5b80 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5b90 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0x5ba0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5bb0 */
 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5bc0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5bd0 */
 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70,   /* 0x5be0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5bf0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5c00 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5c10 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x5c20 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5c30 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83,   /* 0x5c40 */
 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x5c50 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5c60 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x5c70 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5c80 */
 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76,   /* 0x5c90 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5ca0 */
 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10,   /* 0x5cb0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5cc0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5cd0 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x5ce0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70,   /* 0x5cf0 */
 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5d00 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5d10 */
 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5d20 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5d30 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x5d40 */
 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5d50 */
 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x5d60 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x5d70 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93,   /* 0x5d80 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x5d90 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x5da0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,   /* 0x5db0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5dc0 */
 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,   /* 0x5dd0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5de0 */
 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,   /* 0x5df0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5e00 */
 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79,   /* 0x5e10 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5e20 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5e30 */
 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5e40 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x5e50 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51,   /* 0x5e60 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5e70 */
 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48,   /* 0x5e80 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5e90 */
 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76,   /* 0x5ea0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5eb0 */
 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10,   /* 0x5ec0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5ed0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5ee0 */
 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,   /* 0x5ef0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,   /* 0x5f00 */
 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5f10 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5f20 */
 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5f30 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5f40 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x5f50 */
 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5f60 */
 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x5f70 */
 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x5f80 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51,   /* 0x5f90 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5fa0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,   /* 0x5fb0 */
 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5fc0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5fd0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x5fe0 */
 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x5ff0 */
 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x6000 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x6010 */
 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79,   /* 0x6020 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x6030 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x6040 */
 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6050 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65,   /* 0x6060 */
 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51,   /* 0x6070 */
 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x6080 */
 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6090 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x60a0 */
 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83,   /* 0x60b0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x60c0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x60d0 */
 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x60e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x60f0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6100 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68,   /* 0x6110 */
 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x6120 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6130 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x6140 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x6150 */
 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,   /* 0x6160 */
106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95,   /* 0x6170 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6180 */
108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48,   /* 0x6190 */
 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,   /* 0x61a0 */
 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110,   /* 0x61b0 */
 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95,   /* 0x61c0 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,   /* 0x61d0 */
 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76,   /* 0x61e0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x61f0 */
 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58,   /* 0x6200 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x6210 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6220 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x6230 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,   /* 0x6240 */
107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x6250 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x6260 */
 99,116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x6270 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6280 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6290 */
 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x62a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50,   /* 0x62b0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x62c0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,   /* 0x62d0 */
 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x62e0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x62f0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x6300 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x6310 */
 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,   /* 0x6320 */
 48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x6330 */
 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,   /* 0x6340 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x6350 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,   /* 0x6360 */
 50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x6370 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6380 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54,   /* 0x6390 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x63a0 */
 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69,   /* 0x63b0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x63c0 */
 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93,   /* 0x63d0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x63e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x63f0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,   /* 0x6400 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,   /* 0x6410 */
111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6420 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x6430 */
 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x6440 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6450 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6460 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x6470 */
 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,   /* 0x6480 */
101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x6490 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x64a0 */
 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x64b0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x64c0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x64d0 */
 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32,   /* 0x64e0 */
 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111,   /* 0x64f0 */
 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95,   /* 0x6500 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,   /* 0x6510 */
 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x6520 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,   /* 0x6530 */
 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x6540 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6550 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x6560 */
 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x6570 */
 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82,   /* 0x6580 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x6590 */
 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93,   /* 0x65a0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x65b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x65c0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x65d0 */
 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,   /* 0x65e0 */
108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76,   /* 0x65f0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x6600 */
 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10,   /* 0x6610 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x6620 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x6630 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x6640 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,   /* 0x6650 */
 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x6660 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,   /* 0x6670 */
 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x6680 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6690 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x66a0 */
 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,   /* 0x66b0 */
 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,   /* 0x66c0 */
 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x66d0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,   /* 0x66e0 */
 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x66f0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,   /* 0x6700 */
 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x6710 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6720 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x6730 */
 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x6740 */
 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10                /* 0x6750 */
};
