/* i386-linux.elf.interp-entry.h
   created from i386-linux.elf.interp-entry.bin, 45295 (0xb0ef) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I386_LINUX_ELF_INTERP_ENTRY_SIZE    45295
#define STUB_I386_LINUX_ELF_INTERP_ENTRY_ADLER32 0xbfcd2be1
#define STUB_I386_LINUX_ELF_INTERP_ENTRY_CRC32   0x587a45f6

unsigned char stub_i386_linux_elf_interp_entry[45295] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
224, 36,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 45,  1, 42,  1,232, 31,  0,  0,  0,131,248, 70,139, 13,  0,  0,   /* 0x  30 */
  0,  0,116, 17,131,248, 73,139, 13,  0,  0,  0,  0,116,  6,139,   /* 0x  40 */
 13, 35,  0,  0,  0,137,200,195,232,252,255,255,255,131,248,  2,   /* 0x  50 */
139, 13,  0,  0,  0,  0,116,237,131,248,  5,139, 13,  0,  0,  0,   /* 0x  60 */
  0,116,226,131,248,  8,139, 13,  0,  0,  0,  0,116,215,131,248,   /* 0x  70 */
 11,139, 13,  0,  0,  0,  0,116,204,235,196, 96,131,205,255,139,   /* 0x  80 */
116, 36, 36,139,124, 36, 44,235,  3,164,235,  3,138,  6, 70,136,   /* 0x  90 */
  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,   /* 0x  a0 */
192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139,   /* 0x  b0 */
 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,   /* 0x  c0 */
252, 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252,   /* 0x  d0 */
 17,219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6,   /* 0x  e0 */
 70,131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,   /* 0x  f0 */
252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 100 */
 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 110 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,   /* 0x 120 */
219,115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,   /* 0x 130 */
131,193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,   /* 0x 140 */
243,164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4,   /* 0x 150 */
 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,   /* 0x 160 */
255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,   /* 0x 170 */
  1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,   /* 0x 180 */
  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,   /* 0x 190 */
192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139,   /* 0x 1a0 */
 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,   /* 0x 1b0 */
252, 17,219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252,   /* 0x 1c0 */
 17,219,114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 1d0 */
 17,192,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6,   /* 0x 1e0 */
 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,   /* 0x 1f0 */
139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,   /* 0x 200 */
238,252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,   /* 0x 210 */
238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 220 */
219,115, 68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,   /* 0x 230 */
115, 68, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1,   /* 0x 240 */
 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,   /* 0x 250 */
253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,   /* 0x 260 */
233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,   /* 0x 270 */
233,  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,   /* 0x 280 */
138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 290 */
219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,   /* 0x 2a0 */
219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,   /* 0x 2b0 */
139, 30,131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139,   /* 0x 2c0 */
 30,131,238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,   /* 0x 2d0 */
238,252, 17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,   /* 0x 2e0 */
252, 17,219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,   /* 0x 2f0 */
  8,138,  6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,   /* 0x 300 */
219,117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,   /* 0x 310 */
  7,139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,   /* 0x 320 */
131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,   /* 0x 330 */
 17,219,115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,   /* 0x 340 */
219,115, 81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,   /* 0x 350 */
  2, 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,   /* 0x 360 */
131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,   /* 0x 370 */
247,233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,   /* 0x 380 */
131,233,  4,119,241,  1,207,233,252,255,255,255,255,210,  1,219,   /* 0x 390 */
117,  2,255,210,144,232,252,255,255,255,  1,219,116,255,195,139,   /* 0x 3a0 */
 30,131,238,252, 17,219,195, 41,201, 17,201,114, 11, 17,201,114,   /* 0x 3b0 */
  6, 17,201, 17,192, 72, 17,192,131,233,  1,115,  1,141, 72, 15,   /* 0x 3c0 */
 61,240,255,  0,  0,114, 14,141,  4, 14, 80,233, 14,  0,  0,  0,   /* 0x 3d0 */
 17,201, 17,201,131,193, 13,235,  1,133,201,116, 25, 65,131,193,   /* 0x 3e0 */
  8,235,  1, 41,201, 90, 41,219,141, 65,  1,115, 22,114, 21,114,   /* 0x 3f0 */
 20,114, 19,131,193,  2,114,  6, 65,114,  5,233,252,255,255,255,   /* 0x 400 */
 17,201,209,233,115,  1,164,209,233,115,  2,102,165,243,165,141,   /* 0x 410 */
 65,  1,235,  3,164,164,164, 17,192,115, 22,131,232,  3,114, 11,   /* 0x 420 */
193,224,  8,172,131,240,255,116, 50,137,197, 17,201, 17,201,117,   /* 0x 430 */
255, 65, 17,201,115,  0,131,193,  2,129,253,  0,243,255,255,131,   /* 0x 440 */
209,  1, 86,141, 52, 47,131,253,252,119, 19,209,233,115,  1,164,   /* 0x 450 */
209,233,115,  2,102,165,243,165, 94,233,252,255,255,255,131,253,   /* 0x 460 */
255,117,  5,172,243,170,235,240,243,164,235,236,137,229,141,156,   /* 0x 470 */
 36,  0,  0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,   /* 0x 480 */
  0,  0,  0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,   /* 0x 490 */
195,  4, 83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172,   /* 0x 4a0 */
 74,136,193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,   /* 0x 4b0 */
164, 92,144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,   /* 0x 4c0 */
131,195,  4,139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,   /* 0x 4d0 */
172, 74,136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86,   /* 0x 4e0 */
 83, 80, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,   /* 0x 4f0 */
199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,   /* 0x 500 */
156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0,   /* 0x 510 */
 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,   /* 0x 520 */
182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,   /* 0x 530 */
  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,   /* 0x 540 */
  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116,   /* 0x 550 */
 36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,   /* 0x 560 */
  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,   /* 0x 570 */
  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0,   /* 0x 580 */
 57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,   /* 0x 590 */
192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36,   /* 0x 5a0 */
 72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84,   /* 0x 5b0 */
 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,   /* 0x 5c0 */
  3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,   /* 0x 5d0 */
164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116,   /* 0x 5e0 */
 36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,   /* 0x 5f0 */
  4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141,   /* 0x 600 */
 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100,   /* 0x 610 */
 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,   /* 0x 620 */
102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,   /* 0x 630 */
131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,   /* 0x 640 */
138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,   /* 0x 650 */
182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,   /* 0x 660 */
139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,   /* 0x 670 */
250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,   /* 0x 680 */
  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139,   /* 0x 690 */
 68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,   /* 0x 6a0 */
  4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20,   /* 0x 6b0 */
 54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,   /* 0x 6c0 */
255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24,   /* 0x 6d0 */
 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,   /* 0x 6e0 */
182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,   /* 0x 6f0 */
  2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,   /* 0x 700 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,   /* 0x 710 */
131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116,   /* 0x 720 */
 34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,   /* 0x 730 */
232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,   /* 0x 740 */
  0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,   /* 0x 750 */
121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,   /* 0x 760 */
  1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,   /* 0x 770 */
 15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,   /* 0x 780 */
  8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,   /* 0x 790 */
183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,   /* 0x 7a0 */
  0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,   /* 0x 7b0 */
235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,   /* 0x 7c0 */
  5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,   /* 0x 7d0 */
139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,   /* 0x 7e0 */
124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,   /* 0x 7f0 */
  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108,   /* 0x 800 */
 36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,   /* 0x 810 */
  0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,   /* 0x 820 */
102,193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,   /* 0x 830 */
  0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59,   /* 0x 840 */
 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,   /* 0x 850 */
225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,   /* 0x 860 */
149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,   /* 0x 870 */
198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139,   /* 0x 880 */
 76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76,   /* 0x 890 */
 36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36,   /* 0x 8a0 */
 84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,   /* 0x 8b0 */
193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,   /* 0x 8c0 */
  0,137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36,   /* 0x 8d0 */
 56,102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,   /* 0x 8e0 */
  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,   /* 0x 8f0 */
193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,   /* 0x 900 */
234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,   /* 0x 910 */
215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,   /* 0x 920 */
199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,   /* 0x 930 */
139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139,   /* 0x 940 */
 76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,   /* 0x 950 */
141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,   /* 0x 960 */
182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,   /* 0x 970 */
  0,  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115,   /* 0x 980 */
 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68,   /* 0x 990 */
 36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,   /* 0x 9a0 */
  0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172,   /* 0x 9b0 */
 36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,   /* 0x 9c0 */
137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,   /* 0x 9d0 */
136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,   /* 0x 9e0 */
  0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,   /* 0x 9f0 */
149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,   /* 0x a00 */
232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,   /* 0x a10 */
  0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,   /* 0x a20 */
 22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,   /* 0x a30 */
139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0,   /* 0x a40 */
 15,183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,   /* 0x a50 */
  0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,   /* 0x a60 */
176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,   /* 0x a70 */
199, 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,   /* 0x a80 */
129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59,   /* 0x a90 */
 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,   /* 0x aa0 */
225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,   /* 0x ab0 */
150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,   /* 0x ac0 */
198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,   /* 0x ad0 */
  4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,   /* 0x ae0 */
206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68,   /* 0x af0 */
 36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36,   /* 0x b00 */
 80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36,   /* 0x b10 */
 92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,   /* 0x b20 */
139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,   /* 0x b30 */
  8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36,   /* 0x b40 */
 76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8,   /* 0x b50 */
 67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,   /* 0x b60 */
197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,   /* 0x b70 */
193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,   /* 0x b80 */
141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76,   /* 0x b90 */
 36, 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,   /* 0x ba0 */
194,129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76,   /* 0x bb0 */
 15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,   /* 0x bc0 */
  9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,   /* 0x bd0 */
197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,   /* 0x be0 */
193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,   /* 0x bf0 */
141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,   /* 0x c00 */
  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47,   /* 0x c10 */
 41,198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68,   /* 0x c20 */
 36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,   /* 0x c30 */
  0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139,   /* 0x c40 */
 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,   /* 0x c50 */
116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59,   /* 0x c60 */
 92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x c70 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232,   /* 0x c80 */
 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,   /* 0x c90 */
  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,   /* 0x ca0 */
  6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,   /* 0x cb0 */
 41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36,   /* 0x cc0 */
 40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,   /* 0x cd0 */
  3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,   /* 0x ce0 */
  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,   /* 0x cf0 */
  3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,   /* 0x d00 */
  0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,   /* 0x d10 */
  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,   /* 0x d20 */
255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,   /* 0x d30 */
193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,   /* 0x d40 */
 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,   /* 0x d50 */
115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,   /* 0x d60 */
141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,   /* 0x d70 */
137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,   /* 0x d80 */
108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,   /* 0x d90 */
137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,   /* 0x da0 */
230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127,   /* 0x db0 */
 28,139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0,   /* 0x dc0 */
 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,   /* 0x dd0 */
129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,   /* 0x de0 */
 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,   /* 0x df0 */
  9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124,   /* 0x e00 */
 36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137,   /* 0x e10 */
 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137,   /* 0x e20 */
 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,   /* 0x e30 */
139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,   /* 0x e40 */
255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,   /* 0x e50 */
193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,   /* 0x e60 */
 36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,   /* 0x e70 */
199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,   /* 0x e80 */
  5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68,   /* 0x e90 */
 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36,   /* 0x ea0 */
 24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36,   /* 0x eb0 */
 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,   /* 0x ec0 */
139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108,   /* 0x ed0 */
 36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,   /* 0x ee0 */
  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141,   /* 0x ef0 */
 52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116,   /* 0x f00 */
 73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,   /* 0x f10 */
235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,   /* 0x f20 */
246,255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36,   /* 0x f30 */
 76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235,   /* 0x f40 */
 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,   /* 0x f50 */
  0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137,   /* 0x f60 */
 11,131,196,124, 91, 94, 95, 93, 85, 87, 86, 83,131,236,124,139,   /* 0x f70 */
148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68,   /* 0x f80 */
 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,   /* 0x f90 */
120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217,   /* 0x fa0 */
 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,   /* 0x fb0 */
139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,   /* 0x fc0 */
  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,   /* 0x fd0 */
  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,   /* 0x fe0 */
199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,   /* 0x ff0 */
199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,   /* 0x1000 */
141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,   /* 0x1010 */
102,199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,   /* 0x1020 */
  0, 49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,   /* 0x1030 */
152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,   /* 0x1040 */
124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,   /* 0x1050 */
  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,   /* 0x1060 */
100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,   /* 0x1070 */
139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36,   /* 0x1080 */
 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132,   /* 0x1090 */
 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,   /* 0x10a0 */
  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202,   /* 0x10b0 */
 15,175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,   /* 0x10c0 */
  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,   /* 0x10d0 */
  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68,   /* 0x10e0 */
 36,116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,   /* 0x10f0 */
  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,   /* 0x1100 */
124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,   /* 0x1110 */
142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,   /* 0x1120 */
160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,   /* 0x1130 */
139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,   /* 0x1140 */
  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36,   /* 0x1150 */
 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,   /* 0x1160 */
193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,   /* 0x1170 */
 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,   /* 0x1180 */
175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,   /* 0x1190 */
240,137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,   /* 0x11a0 */
133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,   /* 0x11b0 */
200,141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,   /* 0x11c0 */
102,137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,   /* 0x11d0 */
142, 87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141,   /* 0x11e0 */
 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,   /* 0x11f0 */
119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,   /* 0x1200 */
  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,   /* 0x1210 */
 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137,   /* 0x1220 */
 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,   /* 0x1230 */
  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,   /* 0x1240 */
141,114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,   /* 0x1250 */
139, 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,   /* 0x1260 */
115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,   /* 0x1270 */
199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36,   /* 0x1280 */
 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108,   /* 0x1290 */
 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116,   /* 0x12a0 */
 36, 96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,   /* 0x12b0 */
255,255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,   /* 0x12c0 */
116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,   /* 0x12d0 */
182,  3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,   /* 0x12e0 */
200,193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,   /* 0x12f0 */
197, 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108,   /* 0x1300 */
 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,   /* 0x1310 */
137, 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139,   /* 0x1320 */
 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36,   /* 0x1330 */
 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68,   /* 0x1340 */
 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,   /* 0x1350 */
193,232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,   /* 0x1360 */
102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,   /* 0x1370 */
  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,   /* 0x1380 */
108, 36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,   /* 0x1390 */
183,193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,   /* 0x13a0 */
  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,   /* 0x13b0 */
193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,   /* 0x13c0 */
  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,   /* 0x13d0 */
129,250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,   /* 0x13e0 */
132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,   /* 0x13f0 */
199,102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202,   /* 0x1400 */
 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,   /* 0x1410 */
139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,   /* 0x1420 */
102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,   /* 0x1430 */
124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,   /* 0x1440 */
159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68,   /* 0x1450 */
 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84,   /* 0x1460 */
 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,   /* 0x1470 */
  5,102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,   /* 0x1480 */
137,200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,   /* 0x1490 */
215,129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22,   /* 0x14a0 */
 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,   /* 0x14b0 */
193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,   /* 0x14c0 */
139,145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,   /* 0x14d0 */
137,198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,   /* 0x14e0 */
141,  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,   /* 0x14f0 */
  0,  0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102,   /* 0x1500 */
 41,194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,   /* 0x1510 */
  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,   /* 0x1520 */
182,  3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,   /* 0x1530 */
200,193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,   /* 0x1540 */
197, 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108,   /* 0x1550 */
 36, 56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139,   /* 0x1560 */
 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,   /* 0x1570 */
  5,102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139,   /* 0x1580 */
 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137,   /* 0x1590 */
 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,   /* 0x15a0 */
192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104,   /* 0x15b0 */
 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,   /* 0x15c0 */
  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,   /* 0x15d0 */
193,231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232,   /* 0x15e0 */
 11, 15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,   /* 0x15f0 */
  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68,   /* 0x1600 */
 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,   /* 0x1610 */
141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,   /* 0x1620 */
102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,   /* 0x1630 */
119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,   /* 0x1640 */
231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232,   /* 0x1650 */
 11, 15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,   /* 0x1660 */
  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68,   /* 0x1670 */
 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,   /* 0x1680 */
  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,   /* 0x1690 */
  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,   /* 0x16a0 */
102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199,   /* 0x16b0 */
 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,   /* 0x16c0 */
  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76,   /* 0x16d0 */
 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,   /* 0x16e0 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,   /* 0x16f0 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x1700 */
 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,   /* 0x1710 */
 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,   /* 0x1720 */
  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,   /* 0x1730 */
208,102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116,   /* 0x1740 */
 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,   /* 0x1750 */
  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137,   /* 0x1760 */
 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,   /* 0x1770 */
  3,137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,   /* 0x1780 */
  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,   /* 0x1790 */
137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,   /* 0x17a0 */
  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,   /* 0x17b0 */
 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,   /* 0x17c0 */
  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,   /* 0x17d0 */
202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,   /* 0x17e0 */
  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21,   /* 0x17f0 */
 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141,   /* 0x1800 */
 69,  1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,   /* 0x1810 */
141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,   /* 0x1820 */
208,137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250,   /* 0x1830 */
 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137,   /* 0x1840 */
 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,   /* 0x1850 */
  4,235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24,   /* 0x1860 */
 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,   /* 0x1870 */
182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124,   /* 0x1880 */
 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68,   /* 0x1890 */
 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36,   /* 0x18a0 */
 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,   /* 0x18b0 */
  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,   /* 0x18c0 */
  1,197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,   /* 0x18d0 */
 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,   /* 0x18e0 */
  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,   /* 0x18f0 */
183,242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,   /* 0x1900 */
  0,  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68,   /* 0x1910 */
 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,   /* 0x1920 */
102, 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,   /* 0x1930 */
  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32,   /* 0x1940 */
 15,133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,   /* 0x1950 */
139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119,   /* 0x1960 */
 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148,   /* 0x1970 */
 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,   /* 0x1980 */
  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0,   /* 0x1990 */
 57,108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57,   /* 0x19a0 */
 68, 36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,   /* 0x19b0 */
  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,   /* 0x19c0 */
184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,   /* 0x19d0 */
192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156,   /* 0x19e0 */
 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93,  3,115,   /* 0x19f0 */
252,  3,123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80,   /* 0x1a00 */
 57,204,117,251,137,236, 49,201,233,252,255,255,255,139, 84, 36,   /* 0x1a10 */
 36,  3, 84, 36, 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84,   /* 0x1a20 */
 36, 48,137, 58,137, 68, 36, 28, 97,195,185,  0,  0,  0,  0,138,   /* 0x1a30 */
  7, 71, 44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138,   /* 0x1a40 */
 95,  4,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,   /* 0x1a50 */
235,232,137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,   /* 0x1a60 */
176,232,176,233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,   /* 0x1a70 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,171,235,  4,235,   /* 0x1a80 */
  4, 90, 88, 89,151, 96, 49,219,187,  0,  0,  0,  0,106, 15, 88,   /* 0x1a90 */
138,100, 36, 32,106, 15, 91,138,124, 36, 32,138, 84, 36, 32,233,   /* 0x1aa0 */
252,255,255,255, 15,183, 47, 43,110, 12, 41,221,117,255,131,237,   /* 0x1ab0 */
  1,115,255,136, 95,255, 73,136,  7, 71,139,  7,156,102,193,232,   /* 0x1ac0 */
  8,193,192, 16,134,196,157,115,255,176,  0, 15,200,115,255,193,   /* 0x1ad0 */
232,  1,115,  4,254,203, 75, 35, 30,125,  2,  3, 30,137,  4,156,   /* 0x1ae0 */
235,255,141, 20, 24, 15,182,210, 35, 22, 59, 22,114,  2, 43, 22,   /* 0x1af0 */
139,  4,148,254,203, 75, 35, 30,125,  2,  3, 30,139, 44,156,133,   /* 0x1b00 */
237,117,  9, 80,139, 70,  4,254,200, 72, 35,  6,125,  2,  3,  6,   /* 0x1b10 */
 49,237,137, 70,  4,135,108,132,  4, 88,137, 44,148,137,  4,156,   /* 0x1b20 */
 41,248,131,233,  4,  3, 70, 16,  1,240,137,  7,131,199,  4,235,   /* 0x1b30 */
255,233,252,255,255,255, 80,176,233,176,232, 80,106,  0, 83,137,   /* 0x1b40 */
230, 94,137,218,178,233,178,232, 67,106,  0,254,203, 75,117,255,   /* 0x1b50 */
 15,183,  7,131,199,  1, 60,128,114,  4, 60,143,118,255, 41,208,   /* 0x1b60 */
 43, 70,  8,131,232,  2,116,255,131,232,  1,114,255,115,255,122,   /* 0x1b70 */
  0,123,  0,248,235,255,131,233,  1,127,255,137,231,185,  4,  1,   /* 0x1b80 */
  0,  0,139, 14,131,193,  5,139, 14,131,193,  4, 49,192,243,171,   /* 0x1b90 */
137,252, 86, 97,151, 81, 80, 82,195, 96,139,124, 36, 36,139, 76,   /* 0x1ba0 */
 36, 40,139, 84, 36, 44,137,254,235, 29,138,  7,131,199,  1, 60,   /* 0x1bb0 */
128,114, 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,   /* 0x1bc0 */
  1,119,255, 56, 23,117,255,139,  7,102,193,232,  8,193,192, 16,   /* 0x1bd0 */
134,196, 41,248,  1,240,137,  7,131,199,  4,131,233,  4,138,  7,   /* 0x1be0 */
131,199,  1,226, 13,131,233,  1,127,  3, 97,195,116,109,112, 47,   /* 0x1bf0 */
105, 51, 56, 54, 45,108,105,110,117,120, 46,101,108,102, 46,105,   /* 0x1c00 */
110,116,101,114,112, 45,101,110,116,114,121, 46, 98,105,110, 58,   /* 0x1c10 */
 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116,   /* 0x1c20 */
 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,   /* 0x1c30 */
116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,   /* 0x1c40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,   /* 0x1c50 */
 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,   /* 0x1c60 */
 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,   /* 0x1c70 */
 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,   /* 0x1c80 */
 32, 76, 88, 80, 84, 73, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x1c90 */
 48, 48, 48, 48, 48, 53, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ca0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1cb0 */
 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1cc0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x1cd0 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 88, 80, 84, 73,   /* 0x1ce0 */
 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1cf0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1d00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32,   /* 0x1d10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1d20 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 88,   /* 0x1d30 */
 80, 84, 73, 48, 52, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1d40 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1d50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1d60 */
 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1d70 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51,   /* 0x1d80 */
 32, 76, 88, 80, 84, 73, 48, 52, 50, 32, 32, 32, 32, 32, 32, 48,   /* 0x1d90 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1da0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1db0 */
 48, 48, 48, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1dc0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1dd0 */
 32, 32, 52, 32, 76, 88, 80, 84, 73, 48, 52, 51, 32, 32, 32, 32,   /* 0x1de0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1df0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1e00 */
 48, 48, 48, 48, 48, 48, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1e10 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1e20 */
 76, 89, 10, 32, 32, 53, 32, 76, 88, 80, 84, 73, 48, 53, 48, 32,   /* 0x1e30 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48,   /* 0x1e40 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e50 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32, 32, 50, 42, 42,   /* 0x1e60 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x1e70 */
 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78, 50, 66, 83, 77, 65,   /* 0x1e80 */
 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x1e90 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1ea0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 55, 32, 32,   /* 0x1eb0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1ec0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1ed0 */
 32, 32, 55, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32,   /* 0x1ee0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x1ef0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1f00 */
 48, 48, 48, 48, 48, 48, 57, 97, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1f10 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1f20 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 50,   /* 0x1f30 */
 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1f40 */
 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1f50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1f60 */
 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1f70 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57,   /* 0x1f80 */
 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x1f90 */
 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1fa0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1fb0 */
 48, 48, 48, 97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1fc0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1fd0 */
 32, 49, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32,   /* 0x1fe0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x1ff0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2000 */
 48, 48, 48, 48, 48, 48, 97,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2010 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2020 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 78, 50,   /* 0x2030 */
 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2040 */
 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2050 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2060 */
 98, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2070 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2080 */
 78, 76, 89, 10, 32, 49, 50, 32, 78, 50, 66, 68, 69, 67, 50, 48,   /* 0x2090 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,   /* 0x20a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x20b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 98, 32, 32, 50, 42,   /* 0x20c0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x20d0 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 50, 66, 83, 77,   /* 0x20e0 */
 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x20f0 */
100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2100 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 56, 32,   /* 0x2110 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2120 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2130 */
 10, 32, 49, 52, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32,   /* 0x2140 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48,   /* 0x2150 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2160 */
 32, 48, 48, 48, 48, 48, 48,100, 53, 32, 32, 50, 42, 42, 48, 32,   /* 0x2170 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2180 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 78,   /* 0x2190 */
 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x21a0 */
 48, 48, 48, 51,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x21b0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x21c0 */
 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x21d0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x21e0 */
 79, 78, 76, 89, 10, 32, 49, 54, 32, 78, 50, 66, 83, 77, 65, 52,   /* 0x21f0 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0x2200 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2210 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 50, 32, 32, 50,   /* 0x2220 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2230 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2240 */
 49, 55, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32,   /* 0x2250 */
 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48,   /* 0x2260 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2270 */
 48, 48, 48, 48, 49, 50,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2280 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2290 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32, 78, 50, 66,   /* 0x22a0 */
 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x22b0 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x22c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51,   /* 0x22d0 */
101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x22e0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32,   /* 0x22f0 */
 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2300 */
 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2310 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2320 */
 48, 49, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2330 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2340 */
 50, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32,   /* 0x2350 */
 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,   /* 0x2360 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2370 */
 48, 48, 48, 48, 49, 52, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2380 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2390 */
 89, 10, 32, 50, 49, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32,   /* 0x23a0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48,   /* 0x23b0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x23c0 */
 32, 32, 48, 48, 48, 48, 48, 49, 52, 99, 32, 32, 50, 42, 42, 48,   /* 0x23d0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x23e0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32,   /* 0x23f0 */
 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2400 */
 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2410 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2420 */
 48, 49, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2430 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2440 */
 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 66, 70, 65, 83,   /* 0x2450 */
 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54,   /* 0x2460 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2470 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 49, 32, 32,   /* 0x2480 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2490 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x24a0 */
 32, 50, 52, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32,   /* 0x24b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x24c0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x24d0 */
 48, 48, 48, 48, 48, 49, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x24e0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x24f0 */
 76, 89, 10, 32, 50, 53, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32,   /* 0x2500 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,   /* 0x2510 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2520 */
 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 55, 32, 32, 50, 42, 42,   /* 0x2530 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2540 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54,   /* 0x2550 */
 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2560 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2570 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2580 */
 48, 48, 49, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2590 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x25a0 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 78, 50, 68, 70, 65,   /* 0x25b0 */
 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x25c0 */
 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x25d0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 99, 32,   /* 0x25e0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x25f0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 78, 50,   /* 0x2600 */
 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2610 */
 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2620 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x2630 */
 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2640 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 57,   /* 0x2650 */
 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2660 */
 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2670 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2680 */
 48, 48, 49, 57,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2690 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x26a0 */
 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50, 68, 70, 65,   /* 0x26b0 */
 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x26c0 */
 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x26d0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 97, 50, 32,   /* 0x26e0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x26f0 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2700 */
 10, 32, 51, 49, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32,   /* 0x2710 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48,   /* 0x2720 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2730 */
 32, 48, 48, 48, 48, 48, 49, 97, 98, 32, 32, 50, 42, 42, 48, 32,   /* 0x2740 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2750 */
 78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 68, 83, 77, 65, 51, 48,   /* 0x2760 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,   /* 0x2770 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2780 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98, 56, 32, 32, 50, 42,   /* 0x2790 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x27a0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,   /* 0x27b0 */
 51, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32,   /* 0x27c0 */
 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x27d0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x27e0 */
 48, 48, 48, 49, 99, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x27f0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x2800 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 78, 50, 68, 68,   /* 0x2810 */
 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2820 */
 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2830 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,100, 52,   /* 0x2840 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2850 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2860 */
 89, 10, 32, 51, 53, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32,   /* 0x2870 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48,   /* 0x2880 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2890 */
 32, 32, 48, 48, 48, 48, 48, 50, 50, 54, 32, 32, 50, 42, 42, 48,   /* 0x28a0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x28b0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 54, 32,   /* 0x28c0 */
 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x28d0 */
 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x28e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x28f0 */
 48, 50, 51, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2900 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2910 */
 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50, 68, 83, 77, 65,   /* 0x2920 */
 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x2930 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2940 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 50, 32, 32,   /* 0x2950 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2960 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68,   /* 0x2970 */
 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2980 */
 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2990 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52,   /* 0x29a0 */
 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x29b0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 57, 32,   /* 0x29c0 */
 78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x29d0 */
 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x29e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x29f0 */
 48, 50, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2a00 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2a10 */
 52, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32,   /* 0x2a20 */
 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a30 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2a40 */
 48, 48, 48, 48, 50, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2a50 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2a60 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32, 78, 50, 68,   /* 0x2a70 */
 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a80 */
 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2a90 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53,   /* 0x2aa0 */
 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2ab0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2ac0 */
 76, 89, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32,   /* 0x2ad0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48,   /* 0x2ae0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2af0 */
 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 53, 32, 32, 50, 42, 42,   /* 0x2b00 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2b10 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51,   /* 0x2b20 */
 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2b30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b40 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2b50 */
 48, 48, 50, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2b60 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2b70 */
 32, 52, 52, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32,   /* 0x2b80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,   /* 0x2b90 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2ba0 */
 48, 48, 48, 48, 48, 50, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2bb0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2bc0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 53, 32, 78, 50,   /* 0x2bd0 */
 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2be0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2bf0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x2c00 */
 56,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2c10 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2c20 */
 78, 76, 89, 10, 32, 52, 54, 32, 78, 50, 69, 70, 65, 83, 49, 49,   /* 0x2c30 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32,   /* 0x2c40 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2c50 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57, 48, 32, 32, 50, 42,   /* 0x2c60 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2c70 */
 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32, 78, 50, 69, 68, 69,   /* 0x2c80 */
 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2c90 */
 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2ca0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57, 54, 32,   /* 0x2cb0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2cc0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32, 78, 50,   /* 0x2cd0 */
 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2ce0 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2cf0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x2d00 */
 97, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2d10 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2d20 */
 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 70, 65, 83, 50, 48,   /* 0x2d30 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32,   /* 0x2d40 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2d50 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97, 54, 32, 32, 50, 42,   /* 0x2d60 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2d70 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,   /* 0x2d80 */
 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32,   /* 0x2d90 */
 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2da0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2db0 */
 48, 48, 48, 50, 97,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2dc0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2dd0 */
 10, 32, 53, 49, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32,   /* 0x2de0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48,   /* 0x2df0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2e00 */
 32, 48, 48, 48, 48, 48, 50, 98, 99, 32, 32, 50, 42, 42, 48, 32,   /* 0x2e10 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2e20 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 50, 32, 78,   /* 0x2e30 */
 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2e40 */
 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2e50 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2e60 */
 50, 99, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2e70 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2e80 */
 79, 78, 76, 89, 10, 32, 53, 51, 32, 78, 50, 69, 68, 69, 67, 51,   /* 0x2e90 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53,102, 32,   /* 0x2ea0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2eb0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,100, 56, 32, 32, 50,   /* 0x2ec0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2ed0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2ee0 */
 53, 52, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32,   /* 0x2ef0 */
 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,   /* 0x2f00 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2f10 */
 48, 48, 48, 48, 51, 51, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2f20 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2f30 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53, 32, 78, 50, 69,   /* 0x2f40 */
 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2f50 */
 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2f60 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52,   /* 0x2f70 */
 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2f80 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2f90 */
 76, 89, 10, 32, 53, 54, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32,   /* 0x2fa0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x2fb0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2fc0 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 51, 32, 32, 50, 42, 42,   /* 0x2fd0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x2fe0 */
 68, 79, 78, 76, 89, 10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83,   /* 0x2ff0 */
 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x3000 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3010 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 53, 32, 32,   /* 0x3020 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3030 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78, 50, 69,   /* 0x3040 */
 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3050 */
 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3060 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53,   /* 0x3070 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3080 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 57, 32,   /* 0x3090 */
 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x30a0 */
 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x30b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x30c0 */
 48, 51, 54, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x30d0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x30e0 */
 68, 79, 78, 76, 89, 10, 32, 54, 48, 32, 78, 50, 69, 70, 65, 83,   /* 0x30f0 */
 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57,   /* 0x3100 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3110 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 54,100, 32, 32,   /* 0x3120 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3130 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3140 */
 32, 54, 49, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32,   /* 0x3150 */
 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48,   /* 0x3160 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3170 */
 48, 48, 48, 48, 48, 51, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3180 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3190 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 50, 32, 78, 50,   /* 0x31a0 */
 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x31b0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x31c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x31d0 */
 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x31e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 51,   /* 0x31f0 */
 32, 67, 76, 49, 83, 77, 65, 49, 66, 32, 32, 32, 32, 32, 32, 48,   /* 0x3200 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3210 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3220 */
 48, 48, 51, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3230 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3240 */
 32, 54, 52, 32, 67, 76, 49, 70, 65, 83, 49, 66, 32, 32, 32, 32,   /* 0x3250 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,   /* 0x3260 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3270 */
 48, 48, 48, 48, 48, 51, 57,101, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3280 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3290 */
 76, 89, 10, 32, 54, 53, 32, 67, 76, 49, 71, 69, 84, 49, 66, 32,   /* 0x32a0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x32b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x32c0 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 97, 52, 32, 32, 50, 42, 42,   /* 0x32d0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x32e0 */
 68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 67, 76, 49, 69, 78, 84,   /* 0x32f0 */
 69, 82, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54,   /* 0x3300 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3310 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 97, 52, 32, 32,   /* 0x3320 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3330 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3340 */
 32, 54, 55, 32, 67, 76, 49, 83, 77, 65, 49, 48, 32, 32, 32, 32,   /* 0x3350 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x3360 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3370 */
 48, 48, 48, 48, 48, 51, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3380 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3390 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 56, 32, 67, 76,   /* 0x33a0 */
 49, 82, 76, 79, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x33b0 */
 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x33c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x33d0 */
 97,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x33e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 57,   /* 0x33f0 */
 32, 67, 76, 49, 87, 73, 68, 48, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x3400 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3410 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3420 */
 48, 48, 51, 98, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3430 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3440 */
 32, 55, 48, 32, 67, 76, 49, 87, 73, 68, 48, 50, 32, 32, 32, 32,   /* 0x3450 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x3460 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3470 */
 48, 48, 48, 48, 48, 51, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3480 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3490 */
 76, 89, 10, 32, 55, 49, 32, 67, 76, 49, 87, 73, 68, 48, 51, 32,   /* 0x34a0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x34b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x34c0 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 98, 98, 32, 32, 50, 42, 42,   /* 0x34d0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x34e0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 50,   /* 0x34f0 */
 32, 67, 76, 49, 87, 73, 68, 48, 52, 32, 32, 32, 32, 32, 32, 48,   /* 0x3500 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3510 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3520 */
 48, 48, 51, 98,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3530 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3540 */
 32, 55, 51, 32, 67, 76, 49, 87, 73, 68, 48, 53, 32, 32, 32, 32,   /* 0x3550 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x3560 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3570 */
 48, 48, 48, 48, 48, 51, 98,102, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3580 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3590 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 67, 76,   /* 0x35a0 */
 49, 87, 73, 68, 48, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x35b0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x35c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x35d0 */
 99, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x35e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 53,   /* 0x35f0 */
 32, 67, 76, 49, 87, 73, 68, 48, 55, 32, 32, 32, 32, 32, 32, 48,   /* 0x3600 */
 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3610 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3620 */
 48, 48, 51, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3630 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3640 */
 32, 55, 54, 32, 67, 76, 49, 87, 73, 68, 48, 56, 32, 32, 32, 32,   /* 0x3650 */
 32, 32, 48, 48, 48, 48, 48, 48, 49, 97, 32, 32, 48, 48, 48, 48,   /* 0x3660 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3670 */
 48, 48, 48, 48, 48, 51, 99, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3680 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3690 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 55, 32, 67, 76,   /* 0x36a0 */
 49, 87, 73, 68, 48, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x36b0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x36c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x36d0 */
101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x36e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 56,   /* 0x36f0 */
 32, 67, 76, 49, 87, 73, 68, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x3700 */
 48, 48, 48, 48, 48, 49, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3710 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3720 */
 48, 48, 51,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3730 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x3740 */
 65, 68, 79, 78, 76, 89, 10, 32, 55, 57, 32, 67, 76, 49, 83, 84,   /* 0x3750 */
 65, 82, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3760 */
 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3770 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,102, 51, 32,   /* 0x3780 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3790 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32, 67, 76,   /* 0x37a0 */
 49, 84, 79, 80, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x37b0 */
 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x37c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x37d0 */
102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x37e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 49,   /* 0x37f0 */
 32, 67, 76, 49, 84, 79, 80, 48, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x3800 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3810 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3820 */
 48, 48, 51,102, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3830 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x3840 */
 65, 68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 67, 76, 49, 84, 79,   /* 0x3850 */
 80, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3860 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3870 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,102,100, 32,   /* 0x3880 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3890 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x38a0 */
 10, 32, 56, 51, 32, 67, 76, 49, 84, 79, 80, 48, 51, 32, 32, 32,   /* 0x38b0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x38c0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x38d0 */
 32, 48, 48, 48, 48, 48, 51,102,102, 32, 32, 50, 42, 42, 48, 32,   /* 0x38e0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x38f0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 67,   /* 0x3900 */
 76, 49, 84, 79, 80, 48, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x3910 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3920 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3930 */
 52, 48, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3940 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3950 */
 79, 78, 76, 89, 10, 32, 56, 53, 32, 67, 76, 49, 84, 79, 80, 48,   /* 0x3960 */
 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,   /* 0x3970 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3980 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 48, 54, 32, 32, 50,   /* 0x3990 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x39a0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x39b0 */
 56, 54, 32, 67, 76, 49, 84, 79, 80, 48, 54, 32, 32, 32, 32, 32,   /* 0x39c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48,   /* 0x39d0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x39e0 */
 48, 48, 48, 48, 52, 48, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x39f0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x3a00 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55, 32, 67, 76, 49,   /* 0x3a10 */
 84, 79, 80, 48, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3a20 */
 48, 49, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3a30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 49,   /* 0x3a40 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3a50 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 56, 32,   /* 0x3a60 */
 67, 76, 49, 79, 70, 70, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x3a70 */
 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3a80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3a90 */
 48, 52, 50, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3aa0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3ab0 */
 56, 57, 32, 67, 76, 49, 79, 70, 70, 48, 50, 32, 32, 32, 32, 32,   /* 0x3ac0 */
 32, 48, 48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x3ad0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3ae0 */
 48, 48, 48, 48, 52, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3af0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x3b00 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 48, 32, 67, 76, 49,   /* 0x3b10 */
 79, 70, 70, 48, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3b20 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3b30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 51,   /* 0x3b40 */
 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3b50 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32,   /* 0x3b60 */
 67, 76, 49, 79, 70, 70, 48, 52, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x3b70 */
 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3b80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3b90 */
 48, 52, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3ba0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3bb0 */
 68, 79, 78, 76, 89, 10, 32, 57, 50, 32, 67, 76, 49, 76, 69, 78,   /* 0x3bc0 */
 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x3bd0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3be0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 52, 49, 32, 32,   /* 0x3bf0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3c00 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 51, 32, 67, 76, 49,   /* 0x3c10 */
 76, 69, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3c20 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3c30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 52,   /* 0x3c40 */
 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3c50 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 52, 32,   /* 0x3c60 */
 67, 76, 49, 76, 69, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x3c70 */
 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3c80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3c90 */
 48, 52, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3ca0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3cb0 */
 68, 79, 78, 76, 89, 10, 32, 57, 53, 32, 67, 76, 49, 67, 79, 80,   /* 0x3cc0 */
 89, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 51,   /* 0x3cd0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3ce0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 52, 57, 32, 32,   /* 0x3cf0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3d00 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3d10 */
 32, 57, 54, 32, 67, 76, 49, 69, 78, 68, 32, 32, 32, 32, 32, 32,   /* 0x3d20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3d30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3d40 */
 48, 48, 48, 48, 48, 52, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3d50 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3d60 */
 76, 89, 10, 32, 57, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48,   /* 0x3d70 */
 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32, 48,   /* 0x3d80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3d90 */
 48, 32, 32, 48, 48, 48, 48, 48, 52, 55, 99, 32, 32, 50, 42, 42,   /* 0x3da0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x3db0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 56,   /* 0x3dc0 */
 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48,   /* 0x3dd0 */
 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3de0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3df0 */
 48, 48, 52, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x3e00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3e10 */
 32, 57, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32,   /* 0x3e20 */
 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48, 48,   /* 0x3e30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3e40 */
 48, 48, 48, 48, 48, 52,102, 50, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3e50 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3e60 */
 76, 89, 10, 49, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3e70 */
 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48,   /* 0x3e80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3e90 */
 48, 32, 32, 48, 48, 48, 48, 48,102, 55, 56, 32, 32, 50, 42, 42,   /* 0x3ea0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3eb0 */
 68, 79, 78, 76, 89, 10, 49, 48, 49, 32, 76, 90, 77, 65, 95, 68,   /* 0x3ec0 */
 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 97,   /* 0x3ed0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3ee0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,102,101, 32, 32,   /* 0x3ef0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3f00 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 50, 32, 76, 88, 80,   /* 0x3f10 */
 84, 73, 48, 57, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3f20 */
 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3f30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49,   /* 0x3f40 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3f50 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3f60 */
 76, 89, 10, 49, 48, 51, 32, 76, 88, 80, 84, 73, 48, 57, 49, 32,   /* 0x3f70 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,100, 32, 32, 48,   /* 0x3f80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f90 */
 48, 32, 32, 48, 48, 48, 48, 49, 97, 49,100, 32, 32, 50, 42, 42,   /* 0x3fa0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3fb0 */
 68, 79, 78, 76, 89, 10, 49, 48, 52, 32, 67, 65, 76, 76, 84, 82,   /* 0x3fc0 */
 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,   /* 0x3fd0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3fe0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 51, 97, 32, 32,   /* 0x3ff0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x4000 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4010 */
 49, 48, 53, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32,   /* 0x4020 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x4030 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4040 */
 48, 48, 48, 48, 49, 97, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4050 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4060 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 54, 32, 67, 65,   /* 0x4070 */
 76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4080 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4090 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x40a0 */
 52,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x40b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 55,   /* 0x40c0 */
 32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x40d0 */
 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x40e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x40f0 */
 48, 49, 97, 53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4100 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4110 */
 49, 48, 56, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32,   /* 0x4120 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x4130 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4140 */
 48, 48, 48, 48, 49, 97, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4150 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x4160 */
 76, 89, 10, 49, 48, 57, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32,   /* 0x4170 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,   /* 0x4180 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4190 */
 48, 32, 32, 48, 48, 48, 48, 49, 97, 53, 56, 32, 32, 50, 42, 42,   /* 0x41a0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x41b0 */
 68, 79, 78, 76, 89, 10, 49, 49, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x41c0 */
 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,   /* 0x41d0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x41e0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 53,100, 32, 32,   /* 0x41f0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x4200 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4210 */
 49, 49, 49, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32,   /* 0x4220 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x4230 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4240 */
 48, 48, 48, 48, 49, 97, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4250 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4260 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 50, 32, 67, 65,   /* 0x4270 */
 76, 76, 84, 82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4280 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4290 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x42a0 */
 55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x42b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 51,   /* 0x42c0 */
 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48,   /* 0x42d0 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x42e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x42f0 */
 48, 49, 97, 55, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4300 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4310 */
 49, 49, 52, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32,   /* 0x4320 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48,   /* 0x4330 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4340 */
 48, 48, 48, 48, 49, 97, 55, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4350 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4360 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 53, 32, 67, 84,   /* 0x4370 */
 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4380 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4390 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x43a0 */
 55, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x43b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x43c0 */
 78, 76, 89, 10, 49, 49, 54, 32, 67, 65, 76, 76, 84, 82, 49, 50,   /* 0x43d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x43e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x43f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 55,100, 32, 32, 50, 42,   /* 0x4400 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x4410 */
 65, 68, 79, 78, 76, 89, 10, 49, 49, 55, 32, 67, 84, 66, 83, 72,   /* 0x4420 */
 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4430 */
 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4440 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 55,102, 32,   /* 0x4450 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4460 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 56, 32, 67, 84,   /* 0x4470 */
 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4480 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4490 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x44a0 */
 56, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x44b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 57,   /* 0x44c0 */
 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x44d0 */
 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x44e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x44f0 */
 48, 49, 97, 56, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4500 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4510 */
 49, 50, 48, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32,   /* 0x4520 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x4530 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4540 */
 48, 48, 48, 48, 49, 97, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4550 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4560 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 49, 32, 76, 88,   /* 0x4570 */
 85, 78, 70, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4580 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4590 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x45a0 */
 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x45b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x45c0 */
 78, 76, 89, 10, 49, 50, 50, 32, 76, 88, 85, 78, 70, 48, 48, 50,   /* 0x45d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,   /* 0x45e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x45f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 57, 49, 32, 32, 50, 42,   /* 0x4600 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x4610 */
 65, 68, 79, 78, 76, 89, 10, 49, 50, 51, 32, 77, 82, 85, 66, 89,   /* 0x4620 */
 84, 69, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4630 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4640 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 57, 54, 32,   /* 0x4650 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4660 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 52, 32, 76, 88,   /* 0x4670 */
 77, 82, 85, 48, 48, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4680 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4690 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x46a0 */
 57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x46b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x46c0 */
 78, 76, 89, 10, 49, 50, 53, 32, 76, 88, 77, 82, 85, 48, 48, 54,   /* 0x46d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32,   /* 0x46e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x46f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 57,100, 32, 32, 50, 42,   /* 0x4700 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x4710 */
 65, 68, 79, 78, 76, 89, 10, 49, 50, 54, 32, 76, 88, 77, 82, 85,   /* 0x4720 */
 48, 48, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4730 */
 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4740 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97, 52, 32,   /* 0x4750 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4760 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 55, 32, 76, 88,   /* 0x4770 */
 85, 78, 70, 48, 48, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4780 */
 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4790 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x47a0 */
 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x47b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 56,   /* 0x47c0 */
 32, 76, 88, 85, 78, 70, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x47d0 */
 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x47e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x47f0 */
 48, 49, 97, 97,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4800 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x4810 */
 65, 68, 79, 78, 76, 89, 10, 49, 50, 57, 32, 76, 88, 74, 67, 67,   /* 0x4820 */
 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4830 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4840 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 98, 52, 32,   /* 0x4850 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4860 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 48, 32, 76, 88,   /* 0x4870 */
 77, 82, 85, 48, 52, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4880 */
 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4890 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x48a0 */
 98, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x48b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 49,   /* 0x48c0 */
 32, 76, 88, 77, 82, 85, 48, 52, 54, 32, 32, 32, 32, 32, 32, 48,   /* 0x48d0 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x48e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x48f0 */
 48, 49, 97, 98, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4900 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4910 */
 49, 51, 50, 32, 76, 88, 74, 67, 67, 48, 50, 48, 32, 32, 32, 32,   /* 0x4920 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x4930 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4940 */
 48, 48, 48, 48, 49, 97, 98, 99, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4950 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4960 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 51, 32, 76, 88,   /* 0x4970 */
 74, 67, 67, 48, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4980 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4990 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x49a0 */
 98,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x49b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x49c0 */
 78, 76, 89, 10, 49, 51, 52, 32, 76, 88, 74, 67, 67, 48, 50, 51,   /* 0x49d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32,   /* 0x49e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x49f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 51, 32, 32, 50, 42,   /* 0x4a00 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x4a10 */
 65, 68, 79, 78, 76, 89, 10, 49, 51, 53, 32, 76, 88, 85, 78, 70,   /* 0x4a20 */
 48, 51, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4a30 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4a40 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 97, 32,   /* 0x4a50 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4a60 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 54, 32, 76, 88,   /* 0x4a70 */
 85, 78, 70, 51, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4a80 */
 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4a90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x4aa0 */
 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x4ab0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 55,   /* 0x4ac0 */
 32, 76, 88, 85, 78, 70, 51, 56, 55, 32, 32, 32, 32, 32, 32, 48,   /* 0x4ad0 */
 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4ae0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4af0 */
 48, 49, 97, 99,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4b00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4b10 */
 49, 51, 56, 32, 76, 88, 85, 78, 70, 51, 56, 56, 32, 32, 32, 32,   /* 0x4b20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,   /* 0x4b30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4b40 */
 48, 48, 48, 48, 49, 97,100, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4b50 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x4b60 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 57, 32, 76, 88,   /* 0x4b70 */
 85, 78, 70, 52, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4b80 */
 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4b90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x4ba0 */
100, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x4bb0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 48,   /* 0x4bc0 */
 32, 76, 88, 85, 78, 70, 52, 56, 55, 32, 32, 32, 32, 32, 32, 48,   /* 0x4bd0 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4be0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4bf0 */
 48, 49, 97,100,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4c00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x4c10 */
 65, 68, 79, 78, 76, 89, 10, 49, 52, 49, 32, 76, 88, 77, 82, 85,   /* 0x4c20 */
 48, 54, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c30 */
 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4c40 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,100,102, 32,   /* 0x4c50 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4c60 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x4c70 */
 10, 49, 52, 50, 32, 77, 82, 85, 66, 89, 84, 69, 51, 32, 32, 32,   /* 0x4c80 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x4c90 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4ca0 */
 32, 48, 48, 48, 48, 49, 97,101, 52, 32, 32, 50, 42, 42, 48, 32,   /* 0x4cb0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x4cc0 */
 78, 76, 89, 10, 49, 52, 51, 32, 77, 82, 85, 65, 82, 66, 51, 48,   /* 0x4cd0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32,   /* 0x4ce0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x4cf0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,101, 54, 32, 32, 50, 42,   /* 0x4d00 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x4d10 */
 65, 68, 79, 78, 76, 89, 10, 49, 52, 52, 32, 77, 82, 85, 66, 73,   /* 0x4d20 */
 84, 83, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4d30 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4d40 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,101, 55, 32,   /* 0x4d50 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4d60 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 53, 32, 77, 82,   /* 0x4d70 */
 85, 65, 82, 66, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4d80 */
 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4d90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x4da0 */
101, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x4db0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 54,   /* 0x4dc0 */
 32, 76, 88, 77, 82, 85, 48, 55, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x4dd0 */
 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4de0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4df0 */
 48, 49, 97,101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4e00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x4e10 */
 65, 68, 79, 78, 76, 89, 10, 49, 52, 55, 32, 77, 82, 85, 66, 89,   /* 0x4e20 */
 84, 69, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4e30 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4e40 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,102, 53, 32,   /* 0x4e50 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x4e60 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 56, 32, 77, 82,   /* 0x4e70 */
 85, 66, 73, 84, 83, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x4e80 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4e90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,   /* 0x4ea0 */
102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x4eb0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 57,   /* 0x4ec0 */
 32, 77, 82, 85, 65, 82, 66, 53, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x4ed0 */
 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4ee0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x4ef0 */
 48, 49, 97,102, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x4f00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x4f10 */
 49, 53, 48, 32, 76, 88, 77, 82, 85, 48, 56, 48, 32, 32, 32, 32,   /* 0x4f20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,   /* 0x4f30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4f40 */
 48, 48, 48, 48, 49, 98, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x4f50 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x4f60 */
 76, 89, 10, 49, 53, 49, 32, 77, 82, 85, 66, 89, 84, 69, 53, 32,   /* 0x4f70 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x4f80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x4f90 */
 48, 32, 32, 48, 48, 48, 48, 49, 98, 48, 51, 32, 32, 50, 42, 42,   /* 0x4fa0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x4fb0 */
 68, 79, 78, 76, 89, 10, 49, 53, 50, 32, 77, 82, 85, 65, 82, 66,   /* 0x4fc0 */
 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x4fd0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x4fe0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 48, 53, 32, 32,   /* 0x4ff0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x5000 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 51, 32, 77, 82, 85,   /* 0x5010 */
 66, 73, 84, 83, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x5020 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x5030 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 48,   /* 0x5040 */
 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x5050 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 52, 32,   /* 0x5060 */
 77, 82, 85, 65, 82, 66, 55, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x5070 */
 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x5080 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5090 */
 49, 98, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x50a0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,   /* 0x50b0 */
 53, 53, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 32, 32, 32, 32,   /* 0x50c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48,   /* 0x50d0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x50e0 */
 48, 48, 48, 49, 98, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x50f0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x5100 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 54, 32, 77, 82, 85,   /* 0x5110 */
 66, 89, 84, 69, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x5120 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x5130 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 49,   /* 0x5140 */
 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x5150 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 55, 32,   /* 0x5160 */
 77, 82, 85, 65, 82, 66, 56, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x5170 */
 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x5180 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5190 */
 49, 98, 49, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x51a0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,   /* 0x51b0 */
 53, 56, 32, 77, 82, 85, 66, 73, 84, 83, 54, 32, 32, 32, 32, 32,   /* 0x51c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x51d0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x51e0 */
 48, 48, 48, 49, 98, 49, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x51f0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x5200 */
 89, 10, 49, 53, 57, 32, 77, 82, 85, 65, 82, 66, 57, 48, 32, 32,   /* 0x5210 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,   /* 0x5220 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x5230 */
 32, 32, 48, 48, 48, 48, 49, 98, 49, 99, 32, 32, 50, 42, 42, 48,   /* 0x5240 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x5250 */
 79, 78, 76, 89, 10, 49, 54, 48, 32, 76, 88, 77, 82, 85, 49, 48,   /* 0x5260 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32,   /* 0x5270 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x5280 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 50, 48, 32, 32, 50,   /* 0x5290 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x52a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 49, 32, 76, 88, 85, 78,   /* 0x52b0 */
 70, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x52c0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x52d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 51, 48,   /* 0x52e0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x52f0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 50, 32, 76,   /* 0x5300 */
 88, 77, 82, 85, 49, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x5310 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5320 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x5330 */
 98, 51, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x5340 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54,   /* 0x5350 */
 51, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 32, 32, 32, 32, 32,   /* 0x5360 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5370 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5380 */
 48, 48, 49, 98, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x5390 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x53a0 */
 10, 49, 54, 52, 32, 76, 88, 85, 78, 70, 48, 52, 49, 32, 32, 32,   /* 0x53b0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48,   /* 0x53c0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x53d0 */
 32, 48, 48, 48, 48, 49, 98, 51, 97, 32, 32, 50, 42, 42, 48, 32,   /* 0x53e0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x53f0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 53, 32, 76,   /* 0x5400 */
 88, 85, 78, 70, 48, 52, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x5410 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5420 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x5430 */
 98, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x5440 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54,   /* 0x5450 */
 54, 32, 76, 69, 88, 69, 67, 48, 49, 54, 32, 32, 32, 32, 32, 32,   /* 0x5460 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5470 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5480 */
 48, 48, 49, 98, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x5490 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x54a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 55, 32, 76, 88, 77, 82,   /* 0x54b0 */
 85, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x54c0 */
 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x54d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 52, 54,   /* 0x54e0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x54f0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 56, 32, 76,   /* 0x5500 */
 88, 74, 77, 80, 65, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x5510 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5520 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x5530 */
 98, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x5540 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54,   /* 0x5550 */
 57, 32, 76, 88, 67, 65, 76, 76, 66, 48, 32, 32, 32, 32, 32, 32,   /* 0x5560 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5570 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5580 */
 48, 48, 49, 98, 52, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x5590 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x55a0 */
 10, 49, 55, 48, 32, 76, 88, 85, 78, 70, 48, 50, 49, 32, 32, 32,   /* 0x55b0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48,   /* 0x55c0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x55d0 */
 32, 48, 48, 48, 48, 49, 98, 52, 98, 32, 32, 50, 42, 42, 48, 32,   /* 0x55e0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x55f0 */
 78, 76, 89, 10, 49, 55, 49, 32, 76, 88, 77, 82, 85, 48, 50, 50,   /* 0x5600 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,   /* 0x5610 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5620 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 53, 49, 32, 32, 50, 42,   /* 0x5630 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x5640 */
 65, 68, 79, 78, 76, 89, 10, 49, 55, 50, 32, 76, 88, 74, 77, 80,   /* 0x5650 */
 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x5660 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x5670 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 53, 52, 32,   /* 0x5680 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x5690 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 55, 51, 32, 76, 88,   /* 0x56a0 */
 67, 65, 76, 76, 66, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x56b0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x56c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,   /* 0x56d0 */
 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x56e0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 55, 52,   /* 0x56f0 */
 32, 77, 82, 85, 66, 73, 84, 83, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x5700 */
 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x5710 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x5720 */
 48, 49, 98, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x5730 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x5740 */
 49, 55, 53, 32, 76, 88, 77, 82, 85, 48, 51, 48, 32, 32, 32, 32,   /* 0x5750 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x5760 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x5770 */
 48, 48, 48, 48, 49, 98, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x5780 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x5790 */
 76, 89, 10, 49, 55, 54, 32, 77, 82, 85, 66, 89, 84, 69, 49, 32,   /* 0x57a0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x57b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x57c0 */
 48, 32, 32, 48, 48, 48, 48, 49, 98, 53, 98, 32, 32, 50, 42, 42,   /* 0x57d0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x57e0 */
 68, 79, 78, 76, 89, 10, 49, 55, 55, 32, 77, 82, 85, 65, 82, 66,   /* 0x57f0 */
 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x5800 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5810 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 53,100, 32, 32,   /* 0x5820 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x5830 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 55, 56, 32, 76, 88, 77,   /* 0x5840 */
 82, 85, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x5850 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x5860 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 53,   /* 0x5870 */
101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x5880 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x5890 */
 76, 89, 10, 49, 55, 57, 32, 76, 88, 85, 78, 70, 48, 51, 48, 32,   /* 0x58a0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,   /* 0x58b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x58c0 */
 48, 32, 32, 48, 48, 48, 48, 49, 98, 54, 48, 32, 32, 50, 42, 42,   /* 0x58d0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x58e0 */
 68, 79, 78, 76, 89, 10, 49, 56, 48, 32, 76, 88, 74, 67, 67, 48,   /* 0x58f0 */
 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56,   /* 0x5900 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5910 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 54, 54, 32, 32,   /* 0x5920 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x5930 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x5940 */
 49, 56, 49, 32, 76, 88, 67, 74, 48, 77, 82, 85, 32, 32, 32, 32,   /* 0x5950 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x5960 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x5970 */
 48, 48, 48, 48, 49, 98, 54,101, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x5980 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x5990 */
 76, 89, 10, 49, 56, 50, 32, 76, 88, 67, 74, 49, 77, 82, 85, 32,   /* 0x59a0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,   /* 0x59b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x59c0 */
 48, 32, 32, 48, 48, 48, 48, 49, 98, 55, 48, 32, 32, 50, 42, 42,   /* 0x59d0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x59e0 */
 68, 79, 78, 76, 89, 10, 49, 56, 51, 32, 76, 88, 67, 65, 76, 74,   /* 0x59f0 */
 77, 80, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x5a00 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5a10 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 55, 51, 32, 32,   /* 0x5a20 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x5a30 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 56, 52, 32, 76, 88, 67,   /* 0x5a40 */
 65, 76, 76, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x5a50 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x5a60 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 55,   /* 0x5a70 */
 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x5a80 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x5a90 */
 76, 89, 10, 49, 56, 53, 32, 76, 88, 67, 65, 76, 76, 48, 49, 32,   /* 0x5aa0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,   /* 0x5ab0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x5ac0 */
 48, 32, 32, 48, 48, 48, 48, 49, 98, 55, 56, 32, 32, 50, 42, 42,   /* 0x5ad0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x5ae0 */
 68, 79, 78, 76, 89, 10, 49, 56, 54, 32, 76, 88, 67, 74, 50, 77,   /* 0x5af0 */
 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x5b00 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x5b10 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 55, 98, 32, 32,   /* 0x5b20 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x5b30 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x5b40 */
 49, 56, 55, 32, 76, 88, 67, 74, 52, 77, 82, 85, 32, 32, 32, 32,   /* 0x5b50 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x5b60 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x5b70 */
 48, 48, 48, 48, 49, 98, 55,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x5b80 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x5b90 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 56, 56, 32, 76, 88,   /* 0x5ba0 */
 67, 74, 54, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x5bb0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x5bc0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,   /* 0x5bd0 */
 55,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x5be0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x5bf0 */
 78, 76, 89, 10, 49, 56, 57, 32, 76, 88, 67, 74, 55, 77, 82, 85,   /* 0x5c00 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x5c10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5c20 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 56, 49, 32, 32, 50, 42,   /* 0x5c30 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x5c40 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 57,   /* 0x5c50 */
 48, 32, 76, 88, 67, 74, 56, 77, 82, 85, 32, 32, 32, 32, 32, 32,   /* 0x5c60 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5c70 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5c80 */
 48, 48, 49, 98, 56, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x5c90 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x5ca0 */
 69, 65, 68, 79, 78, 76, 89, 10, 49, 57, 49, 32, 76, 88, 85, 78,   /* 0x5cb0 */
 70, 48, 51, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5cc0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5cd0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 56, 54,   /* 0x5ce0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x5cf0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x5d00 */
 89, 10, 49, 57, 50, 32, 76, 88, 77, 82, 85, 48, 53, 53, 32, 32,   /* 0x5d10 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,   /* 0x5d20 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x5d30 */
 32, 32, 48, 48, 48, 48, 49, 98, 56, 98, 32, 32, 50, 42, 42, 48,   /* 0x5d40 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x5d50 */
 79, 78, 76, 89, 10, 49, 57, 51, 32, 77, 82, 85, 66, 89, 84, 69,   /* 0x5d60 */
 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x5d70 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x5d80 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 56,100, 32, 32, 50,   /* 0x5d90 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x5da0 */
 69, 65, 68, 79, 78, 76, 89, 10, 49, 57, 52, 32, 77, 82, 85, 66,   /* 0x5db0 */
 73, 84, 83, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5dc0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5dd0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 57, 50,   /* 0x5de0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x5df0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 57, 53, 32, 77,   /* 0x5e00 */
 82, 85, 65, 82, 66, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x5e10 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5e20 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x5e30 */
 98, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x5e40 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 57,   /* 0x5e50 */
 54, 32, 76, 88, 77, 82, 85, 48, 53, 55, 32, 32, 32, 32, 32, 32,   /* 0x5e60 */
 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5e70 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x5e80 */
 48, 48, 49, 98, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x5e90 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x5ea0 */
 10, 49, 57, 55, 32, 76, 88, 77, 82, 85, 48, 53, 56, 32, 32, 32,   /* 0x5eb0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48,   /* 0x5ec0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5ed0 */
 32, 48, 48, 48, 48, 49, 98, 97, 50, 32, 32, 50, 42, 42, 48, 32,   /* 0x5ee0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x5ef0 */
 78, 76, 89, 10, 49, 57, 56, 32, 76, 88, 85, 78, 70, 48, 51, 53,   /* 0x5f00 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32,   /* 0x5f10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x5f20 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 97, 51, 32, 32, 50, 42,   /* 0x5f30 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x5f40 */
 65, 68, 79, 78, 76, 89, 10, 49, 57, 57, 32, 76, 88, 80, 84, 73,   /* 0x5f50 */
 49, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x5f60 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x5f70 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 97, 57, 32,   /* 0x5f80 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x5f90 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 50, 48, 48, 32, 76, 88,   /* 0x5fa0 */
 80, 84, 73, 49, 52, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x5fb0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x5fc0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,   /* 0x5fd0 */
 97, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x5fe0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 50, 48, 49,   /* 0x5ff0 */
 32, 76, 88, 80, 84, 73, 49, 53, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x6000 */
 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x6010 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x6020 */
 48, 49, 98, 97, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x6030 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x6040 */
 50, 48, 50, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 32, 32,   /* 0x6050 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48,   /* 0x6060 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x6070 */
 48, 48, 48, 48, 49, 98, 98, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x6080 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x6090 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 50, 48, 51, 32, 99,116,   /* 0x60a0 */
111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x60b0 */
 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x60c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,   /* 0x60d0 */
 98,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x60e0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x60f0 */
 78, 76, 89, 10, 50, 48, 52, 32, 99,116,111,107, 51, 50, 46, 50,   /* 0x6100 */
 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 49, 32, 32,   /* 0x6110 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x6120 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 98, 99,100, 32, 32, 50, 42,   /* 0x6130 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x6140 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 50, 48,   /* 0x6150 */
 53, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32,   /* 0x6160 */
 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x6170 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x6180 */
 48, 48, 49, 98,101,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x6190 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x61a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 50, 48, 54, 32, 99,116,111,107,   /* 0x61b0 */
 51, 50, 46, 52, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x61c0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x61d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,102, 53,   /* 0x61e0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x61f0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x6200 */
 89, 10, 50, 48, 55, 32, 76, 88, 80, 84, 73, 49, 54, 48, 32, 32,   /* 0x6210 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,   /* 0x6220 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6230 */
 32, 32, 48, 48, 48, 48, 49, 98,102, 97, 32, 32, 50, 42, 42, 48,   /* 0x6240 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x6250 */
 79, 78, 76, 89, 10, 50, 48, 56, 32, 76, 88, 80, 84, 73, 50, 48,   /* 0x6260 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x6270 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x6280 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 98,102, 99, 32, 32, 50,   /* 0x6290 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x62a0 */
 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84,   /* 0x62b0 */
 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x62c0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 48, 48, 48,  9,   /* 0x62d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 48, 48,   /* 0x62e0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x62f0 */
100, 32, 32, 76, 88, 80, 84, 73, 48, 52, 48,  9, 48, 48, 48, 48,   /* 0x6300 */
 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 48, 52, 48, 10, 48, 48,   /* 0x6310 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x6320 */
 88, 80, 84, 73, 48, 52, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6330 */
 32, 76, 88, 80, 84, 73, 48, 52, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x6340 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73,   /* 0x6350 */
 48, 52, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80,   /* 0x6360 */
 84, 73, 48, 52, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6370 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 48, 52, 51,  9,   /* 0x6380 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 48, 52,   /* 0x6390 */
 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x63a0 */
100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48,   /* 0x63b0 */
 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48,   /* 0x63c0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x63d0 */
 50, 66, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x63e0 */
 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x63f0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,   /* 0x6400 */
 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x6410 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6420 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,  9,   /* 0x6430 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 50,   /* 0x6440 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6450 */
100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,   /* 0x6460 */
 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x6470 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6480 */
 50, 66, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6490 */
 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x64a0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,   /* 0x64b0 */
 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x64c0 */
 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x64d0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48,  9,   /* 0x64e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 54,   /* 0x64f0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6500 */
100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48,   /* 0x6510 */
 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48,   /* 0x6520 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6530 */
 50, 68, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6540 */
 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x6550 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,   /* 0x6560 */
 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x6570 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6580 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,  9,   /* 0x6590 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 50,   /* 0x65a0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x65b0 */
100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,   /* 0x65c0 */
 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x65d0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x65e0 */
 50, 68, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x65f0 */
 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6600 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,   /* 0x6610 */
 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x6620 */
 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6630 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48,  9,   /* 0x6640 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 54,   /* 0x6650 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6660 */
100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48,   /* 0x6670 */
 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48,   /* 0x6680 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6690 */
 50, 69, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x66a0 */
 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x66b0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,   /* 0x66c0 */
 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x66d0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x66e0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,  9,   /* 0x66f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 50,   /* 0x6700 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6710 */
100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,   /* 0x6720 */
 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48,   /* 0x6730 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6740 */
 50, 69, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6750 */
 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6760 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,   /* 0x6770 */
 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x6780 */
 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6790 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48,  9,   /* 0x67a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 54,   /* 0x67b0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x67c0 */
100, 32, 32, 67, 76, 49, 82, 76, 79, 65, 68,  9, 48, 48, 48, 48,   /* 0x67d0 */
 48, 48, 48, 48, 32, 67, 76, 49, 82, 76, 79, 65, 68, 10, 48, 48,   /* 0x67e0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x67f0 */
 76, 49, 87, 73, 68, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6800 */
 32, 67, 76, 49, 87, 73, 68, 48, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x6810 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73,   /* 0x6820 */
 68, 48, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x6830 */
 87, 73, 68, 48, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6840 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 56,  9,   /* 0x6850 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48,   /* 0x6860 */
 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6870 */
100, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48,  9, 48, 48, 48, 48,   /* 0x6880 */
 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 49, 48, 10, 48, 48,   /* 0x6890 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x68a0 */
 76, 49, 83, 84, 65, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x68b0 */
 32, 67, 76, 49, 83, 84, 65, 82, 84, 10, 48, 48, 48, 48, 48, 48,   /* 0x68c0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79,   /* 0x68d0 */
 80, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x68e0 */
 84, 79, 80, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x68f0 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 54,  9,   /* 0x6900 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48,   /* 0x6910 */
 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6920 */
100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55,  9, 48, 48, 48, 48,   /* 0x6930 */
 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 48, 48,   /* 0x6940 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x6950 */
 76, 49, 76, 69, 78, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6960 */
 32, 67, 76, 49, 76, 69, 78, 48, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6970 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 67, 79,   /* 0x6980 */
 80, 89, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x6990 */
 67, 79, 80, 89, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x69a0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 48, 57, 49,  9,   /* 0x69b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 48, 57,   /* 0x69c0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x69d0 */
100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9, 48, 48, 48, 48,   /* 0x69e0 */
 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48, 48,   /* 0x69f0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x6a00 */
 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6a10 */
 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6a20 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,   /* 0x6a30 */
 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,   /* 0x6a40 */
 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6a50 */
 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51,  9,   /* 0x6a60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49,   /* 0x6a70 */
 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6a80 */
100, 32, 32, 76, 88, 85, 78, 70, 48, 49, 48,  9, 48, 48, 48, 48,   /* 0x6a90 */
 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 48, 49, 48, 10, 48, 48,   /* 0x6aa0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x6ab0 */
 88, 74, 67, 67, 48, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6ac0 */
 32, 76, 88, 74, 67, 67, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6ad0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x6ae0 */
 48, 51, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x6af0 */
 78, 70, 48, 51, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6b00 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 55, 48,  9,   /* 0x6b10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 55,   /* 0x6b20 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6b30 */
100, 32, 32, 76, 88, 77, 82, 85, 49, 48, 48,  9, 48, 48, 48, 48,   /* 0x6b40 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 49, 48, 48, 10, 48, 48,   /* 0x6b50 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x6b60 */
 88, 85, 78, 70, 48, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6b70 */
 32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6b80 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x6b90 */
 48, 52, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x6ba0 */
 78, 70, 48, 52, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6bb0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 51, 48,  9,   /* 0x6bc0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 51,   /* 0x6bd0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6be0 */
100, 32, 32, 76, 88, 85, 78, 70, 48, 51, 48,  9, 48, 48, 48, 48,   /* 0x6bf0 */
 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 48, 51, 48, 10, 48, 48,   /* 0x6c00 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x6c10 */
 88, 67, 74, 56, 77, 82, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6c20 */
 32, 76, 88, 67, 74, 56, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48,   /* 0x6c30 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x6c40 */
 48, 51, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x6c50 */
 78, 70, 48, 51, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6c60 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 49, 52, 48,  9,   /* 0x6c70 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 49, 52,   /* 0x6c80 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6c90 */
100, 32, 32, 76, 88, 80, 84, 73, 49, 52, 49,  9, 48, 48, 48, 48,   /* 0x6ca0 */
 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 49, 52, 49, 10, 48, 48,   /* 0x6cb0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,   /* 0x6cc0 */
116,111,107, 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x6cd0 */
 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48,   /* 0x6ce0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,   /* 0x6cf0 */
107, 51, 50, 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x6d00 */
 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6d10 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,   /* 0x6d20 */
 50, 46, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,   /* 0x6d30 */
111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6d40 */
 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,   /* 0x6d50 */
 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107,   /* 0x6d60 */
 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6d70 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 50, 48, 48,  9,   /* 0x6d80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 50, 48,   /* 0x6d90 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6da0 */
100, 32, 32, 76, 88, 80, 84, 73, 48, 53, 48,  9, 48, 48, 48, 48,   /* 0x6db0 */
 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 48, 53, 48, 10, 48, 48,   /* 0x6dc0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6dd0 */
 50, 66, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6de0 */
 32, 78, 50, 66, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6df0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,   /* 0x6e00 */
 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x6e10 */
 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6e20 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9,   /* 0x6e30 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50,   /* 0x6e40 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6e50 */
100, 32, 32, 78, 50, 66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48,   /* 0x6e60 */
 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48,   /* 0x6e70 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6e80 */
 50, 66, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6e90 */
 32, 78, 50, 66, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6ea0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,   /* 0x6eb0 */
 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x6ec0 */
 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6ed0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9,   /* 0x6ee0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52,   /* 0x6ef0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6f00 */
100, 32, 32, 78, 50, 66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48,   /* 0x6f10 */
 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48,   /* 0x6f20 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6f30 */
 50, 66, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6f40 */
 32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6f50 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,   /* 0x6f60 */
 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,   /* 0x6f70 */
 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x6f80 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9,   /* 0x6f90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54,   /* 0x6fa0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x6fb0 */
100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48,   /* 0x6fc0 */
 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48,   /* 0x6fd0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x6fe0 */
 50, 68, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x6ff0 */
 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7000 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,   /* 0x7010 */
 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x7020 */
 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7030 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9,   /* 0x7040 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51,   /* 0x7050 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7060 */
100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48,   /* 0x7070 */
 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48,   /* 0x7080 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x7090 */
 50, 68, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x70a0 */
 32, 78, 50, 68, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x70b0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,   /* 0x70c0 */
 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x70d0 */
 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x70e0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9,   /* 0x70f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53,   /* 0x7100 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7110 */
100, 32, 32, 78, 50, 68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48,   /* 0x7120 */
 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48,   /* 0x7130 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x7140 */
 50, 68, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7150 */
 32, 78, 50, 68, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7160 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,   /* 0x7170 */
 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,   /* 0x7180 */
 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7190 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9,   /* 0x71a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49,   /* 0x71b0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x71c0 */
100, 32, 32, 78, 50, 69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48,   /* 0x71d0 */
 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48,   /* 0x71e0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x71f0 */
 50, 69, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7200 */
 32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7210 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,   /* 0x7220 */
 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x7230 */
 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7240 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9,   /* 0x7250 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51,   /* 0x7260 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7270 */
100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48,   /* 0x7280 */
 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48,   /* 0x7290 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x72a0 */
 50, 69, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x72b0 */
 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x72c0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,   /* 0x72d0 */
 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,   /* 0x72e0 */
 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x72f0 */
 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9,   /* 0x7300 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53,   /* 0x7310 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7320 */
100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48,   /* 0x7330 */
 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48,   /* 0x7340 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x7350 */
 50, 69, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7360 */
 32, 78, 50, 69, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7370 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 83, 77,   /* 0x7380 */
 65, 49, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x7390 */
 83, 77, 65, 49, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x73a0 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 70, 65, 83, 49, 66,  9,   /* 0x73b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 70, 65, 83, 49,   /* 0x73c0 */
 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x73d0 */
100, 32, 32, 67, 76, 49, 71, 69, 84, 49, 66,  9, 48, 48, 48, 48,   /* 0x73e0 */
 48, 48, 48, 48, 32, 67, 76, 49, 71, 69, 84, 49, 66, 10, 48, 48,   /* 0x73f0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x7400 */
 76, 49, 69, 78, 84, 69, 82,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7410 */
 32, 67, 76, 49, 69, 78, 84, 69, 82, 10, 48, 48, 48, 48, 48, 48,   /* 0x7420 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 83, 77,   /* 0x7430 */
 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x7440 */
 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7450 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 50,  9,   /* 0x7460 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48,   /* 0x7470 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7480 */
100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 51,  9, 48, 48, 48, 48,   /* 0x7490 */
 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 51, 10, 48, 48,   /* 0x74a0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x74b0 */
 76, 49, 87, 73, 68, 48, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x74c0 */
 32, 67, 76, 49, 87, 73, 68, 48, 52, 10, 48, 48, 48, 48, 48, 48,   /* 0x74d0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73,   /* 0x74e0 */
 68, 48, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x74f0 */
 87, 73, 68, 48, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7500 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 55,  9,   /* 0x7510 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48,   /* 0x7520 */
 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7530 */
100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 57,  9, 48, 48, 48, 48,   /* 0x7540 */
 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 57, 10, 48, 48,   /* 0x7550 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x7560 */
 76, 49, 84, 79, 80, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7570 */
 32, 67, 76, 49, 84, 79, 80, 48, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x7580 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79,   /* 0x7590 */
 80, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x75a0 */
 84, 79, 80, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x75b0 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 51,  9,   /* 0x75c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48,   /* 0x75d0 */
 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x75e0 */
100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 52,  9, 48, 48, 48, 48,   /* 0x75f0 */
 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48, 52, 10, 48, 48,   /* 0x7600 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x7610 */
 76, 49, 84, 79, 80, 48, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7620 */
 32, 67, 76, 49, 84, 79, 80, 48, 53, 10, 48, 48, 48, 48, 48, 48,   /* 0x7630 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 79, 70,   /* 0x7640 */
 70, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x7650 */
 79, 70, 70, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7660 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 79, 70, 70, 48, 50,  9,   /* 0x7670 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 79, 70, 70, 48,   /* 0x7680 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7690 */
100, 32, 32, 67, 76, 49, 79, 70, 70, 48, 51,  9, 48, 48, 48, 48,   /* 0x76a0 */
 48, 48, 48, 48, 32, 67, 76, 49, 79, 70, 70, 48, 51, 10, 48, 48,   /* 0x76b0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x76c0 */
 76, 49, 79, 70, 70, 48, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x76d0 */
 32, 67, 76, 49, 79, 70, 70, 48, 52, 10, 48, 48, 48, 48, 48, 48,   /* 0x76e0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 76, 69,   /* 0x76f0 */
 78, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49,   /* 0x7700 */
 76, 69, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7710 */
 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 76, 69, 78, 48, 50,  9,   /* 0x7720 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 76, 69, 78, 48,   /* 0x7730 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7740 */
100, 32, 32, 67, 76, 49, 69, 78, 68,  9, 48, 48, 48, 48, 48, 48,   /* 0x7750 */
 48, 48, 32, 67, 76, 49, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x7760 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,   /* 0x7770 */
 68, 69, 67, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x7780 */
 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7790 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,   /* 0x77a0 */
 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x77b0 */
 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x77c0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,   /* 0x77d0 */
 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x77e0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x77f0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,   /* 0x7800 */
 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x7810 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7820 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,   /* 0x7830 */
 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x7840 */
 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7850 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73,   /* 0x7860 */
 48, 57, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80,   /* 0x7870 */
 84, 73, 48, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7880 */
 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49,  9,   /* 0x7890 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69,   /* 0x78a0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x78b0 */
100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48, 48, 48, 48,   /* 0x78c0 */
 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48,   /* 0x78d0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x78e0 */
 84, 66, 83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x78f0 */
 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x7900 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79,   /* 0x7910 */
 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66,   /* 0x7920 */
 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7930 */
 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49,  9,   /* 0x7940 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 48,   /* 0x7950 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7960 */
100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48, 48, 48, 48,   /* 0x7970 */
 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48,   /* 0x7980 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x7990 */
 65, 76, 76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x79a0 */
 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48,   /* 0x79b0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,   /* 0x79c0 */
 82, 69, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,   /* 0x79d0 */
 76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x79e0 */
 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50,  9,   /* 0x79f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69,   /* 0x7a00 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7a10 */
100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48, 48, 48, 48,   /* 0x7a20 */
 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48,   /* 0x7a30 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x7a40 */
 84, 66, 83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7a50 */
 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x7a60 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79,   /* 0x7a70 */
 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66,   /* 0x7a80 */
 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7a90 */
 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49,  9,   /* 0x7aa0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 49,   /* 0x7ab0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7ac0 */
100, 32, 32, 76, 88, 85, 78, 70, 48, 48, 48,  9, 48, 48, 48, 48,   /* 0x7ad0 */
 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 48, 48, 48, 10, 48, 48,   /* 0x7ae0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7af0 */
 88, 85, 78, 70, 48, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7b00 */
 32, 76, 88, 85, 78, 70, 48, 48, 50, 10, 48, 48, 48, 48, 48, 48,   /* 0x7b10 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89,   /* 0x7b20 */
 84, 69, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x7b30 */
 66, 89, 84, 69, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7b40 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 53,  9,   /* 0x7b50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 48,   /* 0x7b60 */
 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7b70 */
100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 54,  9, 48, 48, 48, 48,   /* 0x7b80 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 48, 54, 10, 48, 48,   /* 0x7b90 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7ba0 */
 88, 77, 82, 85, 48, 48, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7bb0 */
 32, 76, 88, 77, 82, 85, 48, 48, 55, 10, 48, 48, 48, 48, 48, 48,   /* 0x7bc0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x7bd0 */
 48, 48, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x7be0 */
 78, 70, 48, 48, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7bf0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 53,  9,   /* 0x7c00 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 52,   /* 0x7c10 */
 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7c20 */
100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 54,  9, 48, 48, 48, 48,   /* 0x7c30 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 52, 54, 10, 48, 48,   /* 0x7c40 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7c50 */
 88, 74, 67, 67, 48, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7c60 */
 32, 76, 88, 74, 67, 67, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7c70 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67,   /* 0x7c80 */
 48, 50, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 74,   /* 0x7c90 */
 67, 67, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7ca0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 50, 51,  9,   /* 0x7cb0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 67, 67, 48, 50,   /* 0x7cc0 */
 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7cd0 */
100, 32, 32, 76, 88, 85, 78, 70, 51, 56, 54,  9, 48, 48, 48, 48,   /* 0x7ce0 */
 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 51, 56, 54, 10, 48, 48,   /* 0x7cf0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7d00 */
 88, 85, 78, 70, 51, 56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7d10 */
 32, 76, 88, 85, 78, 70, 51, 56, 55, 10, 48, 48, 48, 48, 48, 48,   /* 0x7d20 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x7d30 */
 51, 56, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x7d40 */
 78, 70, 51, 56, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7d50 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 52, 56, 54,  9,   /* 0x7d60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 52, 56,   /* 0x7d70 */
 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7d80 */
100, 32, 32, 76, 88, 85, 78, 70, 52, 56, 55,  9, 48, 48, 48, 48,   /* 0x7d90 */
 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 52, 56, 55, 10, 48, 48,   /* 0x7da0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7db0 */
 88, 77, 82, 85, 48, 54, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7dc0 */
 32, 76, 88, 77, 82, 85, 48, 54, 53, 10, 48, 48, 48, 48, 48, 48,   /* 0x7dd0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89,   /* 0x7de0 */
 84, 69, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x7df0 */
 66, 89, 84, 69, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7e00 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 51, 48,  9,   /* 0x7e10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 51,   /* 0x7e20 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7e30 */
100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 51,  9, 48, 48, 48, 48,   /* 0x7e40 */
 48, 48, 48, 48, 32, 77, 82, 85, 66, 73, 84, 83, 51, 10, 48, 48,   /* 0x7e50 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,   /* 0x7e60 */
 82, 85, 65, 82, 66, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7e70 */
 32, 77, 82, 85, 65, 82, 66, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7e80 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89,   /* 0x7e90 */
 84, 69, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x7ea0 */
 66, 89, 84, 69, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7eb0 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 52,  9,   /* 0x7ec0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 73, 84, 83,   /* 0x7ed0 */
 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7ee0 */
100, 32, 32, 77, 82, 85, 65, 82, 66, 53, 48,  9, 48, 48, 48, 48,   /* 0x7ef0 */
 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 53, 48, 10, 48, 48,   /* 0x7f00 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x7f10 */
 88, 77, 82, 85, 48, 56, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7f20 */
 32, 76, 88, 77, 82, 85, 48, 56, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7f30 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89,   /* 0x7f40 */
 84, 69, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x7f50 */
 66, 89, 84, 69, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x7f60 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 54, 48,  9,   /* 0x7f70 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 54,   /* 0x7f80 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x7f90 */
100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 53,  9, 48, 48, 48, 48,   /* 0x7fa0 */
 48, 48, 48, 48, 32, 77, 82, 85, 66, 73, 84, 83, 53, 10, 48, 48,   /* 0x7fb0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,   /* 0x7fc0 */
 82, 85, 65, 82, 66, 55, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x7fd0 */
 32, 77, 82, 85, 65, 82, 66, 55, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x7fe0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85,   /* 0x7ff0 */
 48, 57, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77,   /* 0x8000 */
 82, 85, 48, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8010 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69, 54,  9,   /* 0x8020 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89, 84, 69,   /* 0x8030 */
 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8040 */
100, 32, 32, 77, 82, 85, 65, 82, 66, 56, 48,  9, 48, 48, 48, 48,   /* 0x8050 */
 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 56, 48, 10, 48, 48,   /* 0x8060 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,   /* 0x8070 */
 82, 85, 66, 73, 84, 83, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8080 */
 32, 77, 82, 85, 66, 73, 84, 83, 54, 10, 48, 48, 48, 48, 48, 48,   /* 0x8090 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82,   /* 0x80a0 */
 66, 57, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x80b0 */
 65, 82, 66, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x80c0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 49, 49, 48,  9,   /* 0x80d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 49, 49,   /* 0x80e0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x80f0 */
100, 32, 32, 76, 88, 77, 82, 85, 49, 49, 49,  9, 48, 48, 48, 48,   /* 0x8100 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 49, 49, 49, 10, 48, 48,   /* 0x8110 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x8120 */
 88, 85, 78, 70, 48, 52, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8130 */
 32, 76, 88, 85, 78, 70, 48, 52, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x8140 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67,   /* 0x8150 */
 48, 49, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88,   /* 0x8160 */
 69, 67, 48, 49, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8170 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 49, 48,  9,   /* 0x8180 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 49,   /* 0x8190 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x81a0 */
100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 48,  9, 48, 48, 48, 48,   /* 0x81b0 */
 48, 48, 48, 48, 32, 76, 88, 74, 77, 80, 65, 48, 48, 10, 48, 48,   /* 0x81c0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x81d0 */
 88, 67, 65, 76, 76, 66, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x81e0 */
 32, 76, 88, 67, 65, 76, 76, 66, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x81f0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x8200 */
 48, 50, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x8210 */
 78, 70, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8220 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 50, 50,  9,   /* 0x8230 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 50,   /* 0x8240 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8250 */
100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 49,  9, 48, 48, 48, 48,   /* 0x8260 */
 48, 48, 48, 48, 32, 76, 88, 74, 77, 80, 65, 48, 49, 10, 48, 48,   /* 0x8270 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x8280 */
 88, 67, 65, 76, 76, 66, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8290 */
 32, 76, 88, 67, 65, 76, 76, 66, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x82a0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 73,   /* 0x82b0 */
 84, 83, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x82c0 */
 66, 73, 84, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x82d0 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69, 49,  9,   /* 0x82e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89, 84, 69,   /* 0x82f0 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8300 */
100, 32, 32, 77, 82, 85, 65, 82, 66, 49, 48,  9, 48, 48, 48, 48,   /* 0x8310 */
 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 49, 48, 10, 48, 48,   /* 0x8320 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x8330 */
 88, 77, 82, 85, 48, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8340 */
 32, 76, 88, 77, 82, 85, 48, 52, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x8350 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67,   /* 0x8360 */
 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 74,   /* 0x8370 */
 67, 67, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8380 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 48, 77, 82, 85,  9,   /* 0x8390 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 48, 77, 82,   /* 0x83a0 */
 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x83b0 */
100, 32, 32, 76, 88, 67, 74, 49, 77, 82, 85,  9, 48, 48, 48, 48,   /* 0x83c0 */
 48, 48, 48, 48, 32, 76, 88, 67, 74, 49, 77, 82, 85, 10, 48, 48,   /* 0x83d0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x83e0 */
 88, 67, 65, 76, 74, 77, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x83f0 */
 32, 76, 88, 67, 65, 76, 74, 77, 80, 10, 48, 48, 48, 48, 48, 48,   /* 0x8400 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76,   /* 0x8410 */
 76, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67,   /* 0x8420 */
 65, 76, 76, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8430 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 76, 48, 49,  9,   /* 0x8440 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 65, 76, 76, 48,   /* 0x8450 */
 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8460 */
100, 32, 32, 76, 88, 67, 74, 50, 77, 82, 85,  9, 48, 48, 48, 48,   /* 0x8470 */
 48, 48, 48, 48, 32, 76, 88, 67, 74, 50, 77, 82, 85, 10, 48, 48,   /* 0x8480 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x8490 */
 88, 67, 74, 52, 77, 82, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x84a0 */
 32, 76, 88, 67, 74, 52, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48,   /* 0x84b0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 54,   /* 0x84c0 */
 77, 82, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67,   /* 0x84d0 */
 74, 54, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x84e0 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 55, 77, 82, 85,  9,   /* 0x84f0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 55, 77, 82,   /* 0x8500 */
 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8510 */
100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 53,  9, 48, 48, 48, 48,   /* 0x8520 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 53, 53, 10, 48, 48,   /* 0x8530 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,   /* 0x8540 */
 82, 85, 66, 89, 84, 69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8550 */
 32, 77, 82, 85, 66, 89, 84, 69, 50, 10, 48, 48, 48, 48, 48, 48,   /* 0x8560 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 73,   /* 0x8570 */
 84, 83, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85,   /* 0x8580 */
 66, 73, 84, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8590 */
 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 50, 48,  9,   /* 0x85a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 50,   /* 0x85b0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x85c0 */
100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 55,  9, 48, 48, 48, 48,   /* 0x85d0 */
 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 53, 55, 10, 48, 48,   /* 0x85e0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x85f0 */
 88, 77, 82, 85, 48, 53, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8600 */
 32, 76, 88, 77, 82, 85, 48, 53, 56, 10, 48, 48, 48, 48, 48, 48,   /* 0x8610 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,   /* 0x8620 */
 48, 51, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85,   /* 0x8630 */
 78, 70, 48, 51, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x8640 */
 32, 32, 32, 32,100, 32, 32, 76, 88, 80, 84, 73, 49, 53, 48,  9,   /* 0x8650 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 80, 84, 73, 49, 53,   /* 0x8660 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x8670 */
100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,  9, 48, 48, 48,   /* 0x8680 */
 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10,   /* 0x8690 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x86a0 */
 32, 76, 88, 80, 84, 73, 49, 54, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x86b0 */
 48, 48, 32, 76, 88, 80, 84, 73, 49, 54, 48, 10, 48, 48, 48, 48,   /* 0x86c0 */
 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80,   /* 0x86d0 */
 84, 73, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,   /* 0x86e0 */
115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x86f0 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x8700 */
 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107,   /* 0x8710 */
 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x8720 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,   /* 0x8730 */
 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,   /* 0x8740 */
101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,   /* 0x8750 */
 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,   /* 0x8760 */
 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,   /* 0x8770 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x8780 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,   /* 0x8790 */
109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48, 48,   /* 0x87a0 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x87b0 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,   /* 0x87c0 */
108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,   /* 0x87d0 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x87e0 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,   /* 0x87f0 */
101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x8800 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x8810 */
 48, 48, 48, 48, 48, 48, 32, 78, 77, 82, 85, 10, 10, 82, 69, 76,   /* 0x8820 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x8830 */
 70, 79, 82, 32, 91, 76, 88, 80, 84, 73, 48, 48, 48, 93, 58, 10,   /* 0x8840 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x8850 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x8860 */
 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95,   /* 0x8870 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80, 84,   /* 0x8880 */
 73, 49, 52, 48, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95,   /* 0x8890 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x88a0 */
 76, 88, 80, 84, 73, 49, 52, 49, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x88b0 */
100, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x88c0 */
 32, 32, 32, 32, 76, 88, 80, 84, 73, 48, 48, 48, 10, 48, 48, 48,   /* 0x88d0 */
 48, 48, 48, 50, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x88e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80, 84, 73, 50, 48, 48,   /* 0x88f0 */
 10, 48, 48, 48, 48, 48, 48, 50,101, 32, 82, 95, 51, 56, 54, 95,   /* 0x8900 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80, 84,   /* 0x8910 */
 73, 48, 52, 48, 10, 48, 48, 48, 48, 48, 48, 51, 57, 32, 82, 95,   /* 0x8920 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8930 */
 76, 88, 80, 84, 73, 48, 52, 49, 10, 48, 48, 48, 48, 48, 48, 52,   /* 0x8940 */
 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x8950 */
 32, 32, 32, 32, 76, 88, 80, 84, 73, 48, 52, 50, 10, 48, 48, 48,   /* 0x8960 */
 48, 48, 48, 52,102, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x8970 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80, 84, 73, 48, 52, 51,   /* 0x8980 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x8990 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,   /* 0x89a0 */
 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x89b0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x89c0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0x89d0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x89e0 */
 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x89f0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x8a00 */
 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70,   /* 0x8a10 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x8a20 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x8a30 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x8a40 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x8a50 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x8a60 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,   /* 0x8a70 */
 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x8a80 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8a90 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x8aa0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x8ab0 */
 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76,   /* 0x8ac0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x8ad0 */
 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10,   /* 0x8ae0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x8af0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x8b00 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x8b10 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70,   /* 0x8b20 */
 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x8b30 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x8b40 */
 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x8b50 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8b60 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x8b70 */
 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x8b80 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82,   /* 0x8b90 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x8ba0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93,   /* 0x8bb0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x8bc0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x8bd0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56,   /* 0x8be0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x8bf0 */
 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,   /* 0x8c00 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x8c10 */
 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79,   /* 0x8c20 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x8c30 */
 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79,   /* 0x8c40 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x8c50 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x8c60 */
 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x8c70 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x8c80 */
 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51,   /* 0x8c90 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x8ca0 */
 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x8cb0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x8cc0 */
 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x8cd0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x8ce0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x8cf0 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x8d00 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x8d10 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x8d20 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,   /* 0x8d30 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x8d40 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8d50 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x8d60 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8d70 */
 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x8d80 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x8d90 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x8da0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x8db0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93,   /* 0x8dc0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x8dd0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x8de0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x8df0 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x8e00 */
 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x8e10 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x8e20 */
 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x8e30 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8e40 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x8e50 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x8e60 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10,   /* 0x8e70 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x8e80 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x8e90 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x8ea0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,   /* 0x8eb0 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x8ec0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8ed0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x8ee0 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x8ef0 */
 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x8f00 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x8f10 */
 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58,   /* 0x8f20 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x8f30 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x8f40 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x8f50 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,   /* 0x8f60 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x8f70 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x8f80 */
 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x8f90 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x8fa0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x8fb0 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x8fc0 */
 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10,   /* 0x8fd0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x8fe0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48,   /* 0x8ff0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x9000 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x9010 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x9020 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x9030 */
 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x9040 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x9050 */
 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x9060 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x9070 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x9080 */
 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x9090 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,   /* 0x90a0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x90b0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,   /* 0x90c0 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x90d0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x90e0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x90f0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9100 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x9110 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x9120 */
 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70,   /* 0x9130 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x9140 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x9150 */
 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x9160 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x9170 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,   /* 0x9180 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x9190 */
 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x91a0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x91b0 */
 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x91c0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x91d0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x91e0 */
 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x91f0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10,   /* 0x9200 */
 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x9210 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x9220 */
 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51,   /* 0x9230 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x9240 */
 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x9250 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x9260 */
 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x9270 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x9280 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x9290 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x92a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x92b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x92c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,   /* 0x92d0 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x92e0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x92f0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x9300 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9310 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x9320 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x9330 */
 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x9340 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x9350 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93,   /* 0x9360 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x9370 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x9380 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x9390 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x93a0 */
 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x93b0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x93c0 */
 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x93d0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x93e0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x93f0 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x9400 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10,   /* 0x9410 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x9420 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x9430 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x9440 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x9450 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x9460 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9470 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x9480 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x9490 */
 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x94a0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x94b0 */
 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58,   /* 0x94c0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x94d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x94e0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x94f0 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,   /* 0x9500 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x9510 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x9520 */
 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x9530 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9540 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x9550 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x9560 */
 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10,   /* 0x9570 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x9580 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48,   /* 0x9590 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x95a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x95b0 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x95c0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x95d0 */
 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x95e0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x95f0 */
 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x9600 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x9610 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x9620 */
 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x9630 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,   /* 0x9640 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x9650 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,   /* 0x9660 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x9670 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9680 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x9690 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x96a0 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x96b0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x96c0 */
 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70,   /* 0x96d0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x96e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x96f0 */
 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x9700 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x9710 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,   /* 0x9720 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x9730 */
 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x9740 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x9750 */
 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x9760 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9770 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x9780 */
 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x9790 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10,   /* 0x97a0 */
 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x97b0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x97c0 */
 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51,   /* 0x97d0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x97e0 */
 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x97f0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x9800 */
 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x9810 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x9820 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x9830 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x9840 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x9850 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x9860 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,   /* 0x9870 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x9880 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9890 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x98a0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x98b0 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x98c0 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x98d0 */
 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x98e0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x98f0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93,   /* 0x9900 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x9910 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x9920 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x9930 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x9940 */
 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x9950 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x9960 */
 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x9970 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9980 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x9990 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x99a0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10,   /* 0x99b0 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x99c0 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x99d0 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x99e0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x99f0 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x9a00 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9a10 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x9a20 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x9a30 */
 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x9a40 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x9a50 */
 32, 70, 79, 82, 32, 91, 67, 76, 49, 69, 78, 84, 69, 82, 93, 58,   /* 0x9a60 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x9a70 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x9a80 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,   /* 0x9a90 */
 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49,   /* 0x9aa0 */
 83, 84, 65, 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x9ab0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x9ac0 */
 76, 49, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x9ad0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9ae0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x9af0 */
 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x9b00 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 82, 76, 79, 65, 68, 10, 10,   /* 0x9b10 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x9b20 */
 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68, 48, 51,   /* 0x9b30 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x9b40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x9b50 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x9b60 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,   /* 0x9b70 */
 76, 49, 87, 73, 68, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x9b80 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x9b90 */
 91, 67, 76, 49, 87, 73, 68, 48, 53, 93, 58, 10, 79, 70, 70, 83,   /* 0x9ba0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x9bb0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x9bc0 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x9bd0 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48,   /* 0x9be0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x9bf0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68,   /* 0x9c00 */
 48, 56, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x9c10 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9c20 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82,   /* 0x9c30 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9c40 */
 32, 67, 76, 49, 87, 73, 68, 48, 54, 10, 48, 48, 48, 48, 48, 48,   /* 0x9c50 */
 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x9c60 */
 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48, 10, 48, 48,   /* 0x9c70 */
 48, 48, 48, 48, 49, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,   /* 0x9c80 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89,   /* 0x9c90 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x9ca0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73,   /* 0x9cb0 */
 68, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x9cc0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9cd0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x9ce0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x9cf0 */
 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 48, 48, 48, 48, 48,   /* 0x9d00 */
 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x9d10 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 48, 56, 10, 48,   /* 0x9d20 */
 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x9d30 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80,   /* 0x9d40 */
 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x9d50 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84,   /* 0x9d60 */
 79, 80, 48, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x9d70 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9d80 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x9d90 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x9da0 */
 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76,   /* 0x9db0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x9dc0 */
 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 50, 93, 58, 10,   /* 0x9dd0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x9de0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x9df0 */
 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,   /* 0x9e00 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84,   /* 0x9e10 */
 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x9e20 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76,   /* 0x9e30 */
 49, 84, 79, 80, 48, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x9e40 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9e50 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x9e60 */
 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x9e70 */
 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82,   /* 0x9e80 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x9e90 */
 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 52, 93,   /* 0x9ea0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x9eb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x9ec0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x9ed0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76,   /* 0x9ee0 */
 49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x9ef0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x9f00 */
 67, 76, 49, 84, 79, 80, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x9f10 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9f20 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x9f30 */
 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x9f40 */
 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 54, 10,   /* 0x9f50 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x9f60 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48,   /* 0x9f70 */
 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x9f80 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x9f90 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,   /* 0x9fa0 */
 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x9fb0 */
 67, 76, 49, 87, 73, 68, 48, 49, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x9fc0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x9fd0 */
 32, 91, 67, 76, 49, 79, 70, 70, 48, 50, 93, 58, 10, 79, 70, 70,   /* 0x9fe0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x9ff0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0xa000 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0xa010 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48,   /* 0xa020 */
 55, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54,   /* 0xa030 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49,   /* 0xa040 */
 67, 79, 80, 89, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0xa050 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0xa060 */
 76, 49, 79, 70, 70, 48, 52, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0xa070 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa080 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0xa090 */
 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0xa0a0 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89, 48, 10, 10,   /* 0xa0b0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0xa0c0 */
 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 76, 69, 78, 48, 50,   /* 0xa0d0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0xa0e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0xa0f0 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0xa100 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,   /* 0xa110 */
 76, 49, 76, 69, 78, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0xa120 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0xa130 */
 91, 67, 76, 49, 67, 79, 80, 89, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0xa140 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0xa150 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0xa160 */
 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0xa170 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 48,   /* 0xa180 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0xa190 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68,   /* 0xa1a0 */
 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0xa1b0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa1c0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0xa1d0 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0xa1e0 */
 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,   /* 0xa1f0 */
106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95,   /* 0xa200 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa210 */
108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48,   /* 0xa220 */
 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,   /* 0xa230 */
 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110,   /* 0xa240 */
 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95,   /* 0xa250 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,   /* 0xa260 */
 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76,   /* 0xa270 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0xa280 */
 70, 79, 82, 32, 91, 76, 88, 80, 84, 73, 48, 57, 48, 93, 58, 10,   /* 0xa290 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0xa2a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0xa2b0 */
 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,   /* 0xa2c0 */
 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 80, 84,   /* 0xa2d0 */
 73, 48, 57, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0xa2e0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,   /* 0xa2f0 */
 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0xa300 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa310 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0xa320 */
 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,   /* 0xa330 */
 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,   /* 0xa340 */
116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0xa350 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76,   /* 0xa360 */
 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0xa370 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa380 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0xa390 */
 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa3a0 */
 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,   /* 0xa3b0 */
 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0xa3c0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0xa3d0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0xa3e0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84,   /* 0xa3f0 */
 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0xa400 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa410 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0xa420 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0xa430 */
 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79,   /* 0xa440 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0xa450 */
 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58, 10, 79,   /* 0xa460 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0xa470 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0xa480 */
 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51,   /* 0xa490 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,   /* 0xa4a0 */
114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0xa4b0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0xa4c0 */
 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79, 70, 70,   /* 0xa4d0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0xa4e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0xa4f0 */
 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0xa500 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49,   /* 0xa510 */
 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0xa520 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69,   /* 0xa530 */
 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0xa540 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa550 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0xa560 */
 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa570 */
 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,   /* 0xa580 */
 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0xa590 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49,   /* 0xa5a0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0xa5b0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82,   /* 0xa5c0 */
 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0xa5d0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa5e0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,   /* 0xa5f0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa600 */
 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0xa610 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0xa620 */
 82, 32, 91, 76, 88, 85, 78, 70, 48, 48, 48, 93, 58, 10, 79, 70,   /* 0xa630 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0xa640 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0xa650 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0xa660 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,   /* 0xa670 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0xa680 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82,   /* 0xa690 */
 85, 48, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0xa6a0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa6b0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0xa6c0 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0xa6d0 */
 32, 32, 32, 78, 77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0xa6e0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0xa6f0 */
 91, 76, 88, 85, 78, 70, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0xa700 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0xa710 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0xa720 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0xa730 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 50,   /* 0xa740 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0xa750 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 74, 67, 67, 48,   /* 0xa760 */
 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0xa770 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa780 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0xa790 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa7a0 */
 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10, 82, 69, 76, 79, 67,   /* 0xa7b0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0xa7c0 */
 82, 32, 91, 76, 88, 74, 67, 67, 48, 50, 49, 93, 58, 10, 79, 70,   /* 0xa7d0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0xa7e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0xa7f0 */
 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0xa800 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,   /* 0xa810 */
 51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0xa820 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78,   /* 0xa830 */
 70, 51, 56, 56, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0xa840 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa850 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0xa860 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0xa870 */
 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 10, 82, 69, 76,   /* 0xa880 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0xa890 */
 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 52, 56, 55, 93, 58, 10,   /* 0xa8a0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0xa8b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0xa8c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,   /* 0xa8d0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78,   /* 0xa8e0 */
 70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0xa8f0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88,   /* 0xa900 */
 77, 82, 85, 48, 54, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0xa910 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa920 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0xa930 */
 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0xa940 */
 32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 48, 55, 48, 10, 10, 82,   /* 0xa950 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0xa960 */
 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 55, 48, 93,   /* 0xa970 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0xa980 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0xa990 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,   /* 0xa9a0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,   /* 0xa9b0 */
 85, 78, 70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0xa9c0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0xa9d0 */
 76, 88, 77, 82, 85, 48, 57, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0xa9e0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xa9f0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0xaa00 */
 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0xaa10 */
 32, 32, 32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 49, 48, 48, 10,   /* 0xaa20 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0xaa30 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 52,   /* 0xaa40 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0xaa50 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0xaa60 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95,   /* 0xaa70 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xaa80 */
 76, 88, 85, 78, 70, 48, 51, 52, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0xaa90 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0xaaa0 */
 32, 91, 76, 69, 88, 69, 67, 48, 49, 54, 93, 58, 10, 79, 70, 70,   /* 0xaab0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0xaac0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0xaad0 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,   /* 0xaae0 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52,   /* 0xaaf0 */
 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0xab00 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85,   /* 0xab10 */
 48, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0xab20 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xab30 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0xab40 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0xab50 */
 32, 32, 76, 88, 77, 82, 85, 48, 51, 48, 10, 10, 82, 69, 76, 79,   /* 0xab60 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0xab70 */
 79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 48, 48, 93, 58, 10, 79,   /* 0xab80 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0xab90 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0xaba0 */
 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0xabb0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 74, 67, 67,   /* 0xabc0 */
 48, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0xabd0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67,   /* 0xabe0 */
 65, 76, 76, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0xabf0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xac00 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0xac10 */
 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0xac20 */
 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69,   /* 0xac30 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0xac40 */
 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 50, 77, 82, 85, 93, 58,   /* 0xac50 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0xac60 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0xac70 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0xac80 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,   /* 0xac90 */
 78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0xaca0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,   /* 0xacb0 */
 88, 67, 74, 52, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0xacc0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xacd0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0xace0 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0xacf0 */
 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10,   /* 0xad00 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0xad10 */
 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 54, 77, 82, 85,   /* 0xad20 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0xad30 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0xad40 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0xad50 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0xad60 */
 88, 67, 74, 56, 77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0xad70 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0xad80 */
 91, 76, 88, 67, 74, 55, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83,   /* 0xad90 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0xada0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0xadb0 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0xadc0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 67, 74, 56, 77, 82, 85,   /* 0xadd0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0xade0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 56, 77,   /* 0xadf0 */
 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0xae00 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xae10 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,   /* 0xae20 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xae30 */
 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67,   /* 0xae40 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0xae50 */
 82, 32, 91, 76, 88, 85, 78, 70, 48, 51, 52, 93, 58, 10, 79, 70,   /* 0xae60 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0xae70 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0xae80 */
 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0xae90 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,   /* 0xaea0 */
 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0xaeb0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107,   /* 0xaec0 */
 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0xaed0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xaee0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0xaef0 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0xaf00 */
 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82,   /* 0xaf10 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0xaf20 */
 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48,   /* 0xaf30 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0xaf40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0xaf50 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51,   /* 0xaf60 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,   /* 0xaf70 */
116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0xaf80 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0xaf90 */
 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70,   /* 0xafa0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0xafb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0xafc0 */
 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0xafd0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50,   /* 0xafe0 */
 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 57, 32, 82, 95, 51,   /* 0xaff0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,   /* 0xb000 */
116,111,107, 51, 50, 46, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0xb010 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0xb020 */
 32, 91, 99,116,111,107, 51, 50, 46, 51, 48, 93, 58, 10, 79, 70,   /* 0xb030 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0xb040 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0xb050 */
 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0xb060 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50,   /* 0xb070 */
 46, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0xb080 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,   /* 0xb090 */
107, 51, 50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0xb0a0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0xb0b0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0xb0c0 */
 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0xb0d0 */
 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10        /* 0xb0e0 */
};
