/*
 * File:        ops.h
 * Program:     unhtml 
 * Written by:	Kevin Swan, 013639s@dragon.acadiau.ca)
 * Completed: 	February 3, 1998
 * Version: 	2.3
 */



#include <stdio.h>
#include <errno.h>



#ifndef OPS_H
#define OPS_H



#ifndef MAX_TAG_SIZE
#define MAX_TAG_SIZE 65536
#endif



/*
 * Checks if a given tag is an HTML script opening tag, <SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script opening tag, 0 otherwise.
 */
int isScriptOpeningTag (char *tag);



/*
 * Checks if a given tag is an HTML script closing tag, </SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script closing tag, 0 otherwise.
 */
int isScriptClosingTag (char *tag);



#endif
