/* Unhide yjesus@security-projects.com */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/resource.h>
#include <errno.h>
#include <dirent.h>
#include <sched.h>
#include <sys/types.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/sysinfo.h>


#define COMMAND "nice -20 ps axHo sess,pid | awk '{ print $2 }' | grep -v PID"
#define SESSION "ps axHo sess,pid | awk '{ print $1 }' | grep -v SESS"
#define PGID "ps axHo pgid,pid | awk '{ print $1 }' | grep -v PGID"


// sysctl kernel.pid_max
int maxpid= 32768;


int isfaked(int pidtmp) {
	
	
	int count ;
	struct dirent *ptr;
	DIR *dirp;
	char path[1000] ;
	
	sprintf(path,"/proc/%i/task",pidtmp);
	
	errno= 0 ;
	
	dirp = opendir(path) ;

	count = 0;
	
		
	if ( errno == 0) { 	
		
		
		while ((ptr = readdir(dirp)) != NULL) {

			count++;
		}
		
		if ( count > 3 ) { return(1) ;}
	
		else {return(0);}

	}
	
	else {return(0);}


}


void checkps(int tmppid, int morechecks) {
	
	int ok = 0;
	char pids[30];
	char sessionpids[30] ;
	char pgidpids[30] ;
	
	char compare[100];
	char comparesession[100];
	char comparepgid[100];
	
	
	FILE *fich_tmp ;
	
	fich_tmp=popen (COMMAND, "r") ;
	
	
	while (!feof(fich_tmp) && ok == 0) {
		
		fgets(pids, 30, fich_tmp);
		
		sprintf(compare,"%i\n",tmppid);
		
		if (strcmp(pids, compare) == 0) {ok = 1;}
		
		
        }
	
	pclose(fich_tmp);
	
	if (morechecks == 1) {
	
		FILE *fich_session ;
	
		fich_session=popen (SESSION, "r") ;
	
	
		while (!feof(fich_session) && ok == 0) {
		
			fgets(sessionpids, 30, fich_session);
		
			sprintf(comparesession,"%i\n",tmppid);
		
			if (strcmp(sessionpids, comparesession) == 0) {ok = 1;}
		
		
		}
	
		pclose(fich_session);
		
		
		FILE *fich_pgid ;
	
		fich_pgid=popen (PGID, "r") ;
	
	
		while (!feof(fich_pgid) && ok == 0) {
		
			fgets(pgidpids, 30, fich_pgid);
		
			sprintf(comparepgid,"%i\n",tmppid);
		
			if (strcmp(pgidpids, comparepgid) == 0) {ok = 1;}
		
		
		}
	
		pclose(fich_pgid);
		
	}
	
	
	if ( ok == 0 ) {
		
		int faked ;
		int statuscmd ;
		char cmd[100] ;
		
		faked = isfaked(tmppid) ;
		
		
		if ( faked == 0 ) {

			struct stat buffer;
			
			printf ("Found HIDDEN PID: %i\n", tmppid) ;
	
		
			sprintf(cmd,"/proc/%i/cmdline",tmppid);
		
			statuscmd = stat(cmd, &buffer);
		
			if (statuscmd == 0) {
			
				FILE *cmdfile ;
				char cmdcont[1000];
			
				cmdfile=fopen (cmd, "r") ;
			
			
				while (!feof (cmdfile)) {
				
					fgets (cmdcont, 1000, cmdfile);
					printf ("Command: %s\n\n", cmdcont);
				
				}
			}
		}	
	}		
	
}

	

void checkproc() {
	
	int procpids ;
	int statusproc;
	struct stat buffer;
	
	printf ("[*]Searching for Hidden processes through /proc scanning\n\n") ;
		
	for ( procpids = 1; procpids <= maxpid; procpids = procpids +1 ) {
		
		char directory[100] ;
		
		
		sprintf(directory,"/proc/%d",procpids);
		
		
		statusproc = stat(directory, &buffer) ;
		
		if (statusproc == 0) {
			
			checkps(procpids,0);
			
		}
		
	}
}

void checkgetpriority() {
	
	int syspids ;
	
	printf ("[*]Searching for Hidden processes through getpriority() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int which = PRIO_PROCESS;
		
		int ret;
		
		errno= 0 ;
		
		ret = getpriority(which, syspids);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}
		
void checkgetpgid() {
	
	int syspids ;
	
	
	printf ("[*]Searching for Hidden processes through getpgid() scanning\n\n") ;
	
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = getpgid(syspids);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}		
		

void checkgetsid() {
	
	int syspids ;
	
	
	printf ("[*]Searching for Hidden processes through getsid() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = getsid(syspids);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}		


void checksched_getaffinity() {
	
	int syspids;
	unsigned long mask;
	
	printf ("[*]Searching for Hidden processes through sched_getaffinity() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = sched_getaffinity(syspids, sizeof(unsigned int), &mask);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}		


void checksched_getparam() {
	
	int syspids;
	struct sched_param param;
	
	printf ("[*]Searching for Hidden processes through sched_getparam() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = sched_getparam(syspids, &param);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}		

void checksched_getscheduler() {
	
	int syspids ;
	
	
	printf ("[*]Searching for Hidden processes through sched_getscheduler() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = sched_getscheduler(syspids);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}		

void checksched_rr_get_interval() {
	
	int syspids;
	struct timespec tp;
	
	printf ("[*]Searching for Hidden processes through sched_rr_get_interval() scanning\n\n") ;
	
	
	for ( syspids = 1; syspids <= maxpid; syspids = syspids +1 ) {
		
		int ret;
		
		errno= 0 ;
		
		ret = sched_rr_get_interval(syspids, &tp);
		
		if ( errno == 0) {
			
			checkps(syspids,0);
		}
	}
}

void checksysinfo() {
	
	struct sysinfo info;
	int contador=0;
	int resultado=0;
	int ocultos=0;
	char buffer[500];

	FILE *fich_proceso ;
	
	printf ("[*]Searching for Hidden processes through sysinfo() scanning\n\n") ;
	
	fich_proceso=popen (COMMAND, "r") ;
	
	
	while (!feof(fich_proceso)) {
		
		fscanf( fich_proceso, "%s", &buffer );	
		contador++;
		
        }
	
	pclose(fich_proceso);
	
	sysinfo(&info);
	
	resultado=contador-5;
	ocultos=info.procs-resultado;
	
	if (ocultos >0) {
		
		printf("HIDDEN Processes Found:%i\n",ocultos) ;
	}

}


void brute() {
	
	int i=0;
	int vpid;
	int allpids[maxpid] ;
	int x;
	int y;
	int z;
	
	
	printf ("[*]Starting scanning using brute force against PIDS\n\n") ;
	
	for(x=0; x < 299; x++) {
		
		allpids[x] = '\0' ;
	}
	
	
	for(z=300; z < maxpid; z++) {
		
		allpids[z] = z ;
	}
	
	
	for (i=0; i < maxpid; i++) {
		
		errno= 0 ;
		
		if (vfork() == 0) { 
			
			vpid = getpid();
			
			allpids[vpid] =  '\0';
			
			exit(1);
		}
		
		waitpid(vpid);
		
	}
	
	for(y=0; y < maxpid; y++) {
		
		if (allpids[y] != '\0') {
			
			checkps(allpids[y],1) ;
		
		}
		
	}	
	
			
	
	
}




int main (int argc, char *argv[]) {
	
	
	printf ("Unhide 20080519 \n") ;
	printf ("yjesus@security-projects.com\n\n\n") ;
	
	
	if(argc != 2) {
		
		printf("usage: %s proc | sys | brute\n\n", argv[0]);
		exit (1);
		
	} 
	
	if (strcmp(argv[1], "proc") == 0) {checkproc();}
	
	else if (strcmp(argv[1], "sys") == 0) {
		checkgetpriority();
		checkgetpgid() ;
		checkgetsid();
		checksched_getaffinity();
		checksched_getparam();
		checksched_getscheduler();
		checksched_rr_get_interval();
		checksysinfo();
		
	}
	
	else if(strcmp(argv[1], "brute") == 0) {
		
		brute();
		
	}
	
	
}
