/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef UNCC_TYPES_H
#define UNCC_TYPES_H

struct _Stack;
struct _SourceLine;
struct _Function;
struct _Register;
struct _Label;
struct _Expr;
struct _FrameEl;
typedef struct _Stack Stack;
typedef struct _SourceLine SourceLine;
typedef struct _Function Function;
typedef struct _Register Register;
typedef struct _Label Label;
typedef struct _Expr Expr;
typedef struct _FrameEl FrameEl;

// STACK =========================================================

struct _Stack
{
	Expr *expr;
	struct _Stack *next;
};


// SOURCE ========================================================

#define MAX_OPCODE_LEN 10
#define MAX_PARAM_LEN 20
struct _SourceLine {
	char opcode[MAX_OPCODE_LEN];
	char parm[5][MAX_PARAM_LEN];
	int nparm;
	struct _SourceLine *next,*prev;
	Function *function;
	Label *label;
};


// REGISTERS =====================================================

struct _Register
{
	char *name;
	Expr *value;
	int must_drop;
	Function *drop_to;
	struct _Register *next;
};


// EXPRESSIONS ===================================================

enum ExpressionType
{
	EXPR_STRING,
	EXPR_INT,

	// Operations
	EXPR_OP_INC,
	EXPR_OP_SUM,
	EXPR_OP_SUB,
	EXPR_OP_AND,
	EXPR_OP_MULT,

	// Pointers
	EXPR_OP_ADDRESS,
	EXPR_OP_DEREFERENCE,

	// Assignment
	EXPR_OP_ASSIGN,

	// Conditionals
	EXPR_OP_EQUAL,
	EXPR_OP_NOT_EQUAL,
	EXPR_OP_LESS_EQUAL,

	// Commands
	EXPR_GOTO,
	EXPR_IF,
	EXPR_LABEL,

	EXPR_END
};
typedef int ExpressionType;

struct _Expr {
	union {
		char *_pchar;
		int *_pint;
	} data;
	ExpressionType type;
	struct _Expr *sx, *dx;
	int sx_fill, dx_fill;
};


// LABELS ========================================================

struct _Label
{
	char *name;
	struct _Label *next;
	SourceLine *pos;
};


// FUNCTIONS =====================================================

enum VarType {
	VAR_BYTE,
	VAR_WORD,
	VAR_DWORD,
	VAR_QUAD
};
typedef int VarType;

typedef struct _Variable
{
	char *name;
	int offset;
	VarType type;
	struct _Variable *next;
} Variable;

typedef struct _BodyLine
{
	Expr *line;
	struct _BodyLine *next;
} BodyLine;

struct _FrameEl
{
	Variable *var;
};

struct _Function {
	Label *label;
	Variable *localvars;
	Variable *arguments;

	int frame_size;

	BodyLine *body;
	BodyLine *body_last;
	Register *frame_pointer;
	int fp_displacement;
	struct _Function *next;

	int external;
};


#endif

