/* ========================================================================== */
/* === umfpack_wsolve ======================================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_wsolve
(
    const char sys [ ],
    const int Ap [ ],
    const int Ai [ ],
    const double Ax [ ],
    double X [ ],
    const double B [ ],
    void *Numeric,
    const double Control [UMFPACK_CONTROL],
    double Info [UMFPACK_INFO],
    int Wi [ ],
    double W [ ],
    double Y [ ],
    double Z [ ],
    double S [ ]
) ;

long umfpack_l_wsolve
(
    const char sys [ ],
    const long Ap [ ],
    const long Ai [ ],
    const double Ax [ ],
    double X [ ],
    const double B [ ],
    void *Numeric,
    const double Control [UMFPACK_CONTROL],
    double Info [UMFPACK_INFO],
    long Wi [ ],
    double W [ ],
    double Y [ ],
    double Z [ ],
    double S [ ]
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Numeric ;
    int status, *Ap, *Ai ;
    char *sys ;
    double *B, *X, *Ax, Info [UMFPACK_INFO], Control [UMFPACK_CONTROL] ;
    int *Wi ;
    double *W, *Y, *Z, *S ;
    status = umfpack_wsolve (sys, Ap, Ai, Ax, X, B, Numeric, Control, Info,
	Wi, W, Y, Z, S) ;

long Syntax:

    #include "umfpack.h"
    void *Numeric ;
    long status, *Ap, *Ai ;
    char *sys ;
    double *B, *X, *Ax, Info [UMFPACK_INFO], Control [UMFPACK_CONTROL] ;
    long *Wi ;
    double *W, *Y, *Z, *S ;
    status = umfpack_l_wsolve (sys, Ap, Ai, Ax, X, B, Numeric, Control, Info,
	Wi, W, Y, Z, S) ;

Purpose:

    Given LU factors computed by umfpack_numeric (PAQ=LU) and the
    right-hand-side, B, solve a linear system for the solution X.  Iterative
    refinement is optionally performed.  This routine is identical to
    umfpack_solve, except that it does not dynamically allocate any workspace.
    When you have many linear systems to solve, this routine is slightly faster
    than umfpack_solve, since the workspace (Wi, W, Y, Z, and S) needs to be
    allocated only once, prior to calling umfpack_wsolve.

Returns:

    The status code is returned.  See Info [UMFPACK_STATUS], below.

Arguments:

    char sys [ ] ;		Input argument, not modified.
    Int Ap [n+1] ;		Input argument, not modified.
    Int Ai [nz] ;		Input argument, not modified.
    double Ax [nz] ;		Input argument, not modified.
    double X [n] ;		Output argument.
    double B [n] ;		Input argument, not modified.
    void *Numeric ;		Input argument, not modified.
    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.
    double Info [UMFPACK_INFO] ;	Output argument.

	The above arguments are identical to umfpack_solve, except that the
	error code UMFPACK_ERROR_out_of_memory will not be returned in
	Info [UMFPACK_STATUS], since umfpack_wsolve does not allocate any
	memory.

    Int Wi [2*n] ;		Workspace.
    double W [n] ;		Workspace.
    double Y [n] ;		Workspace, only needed for iterative refinement.
    double Z [n] ;		Workspace, only needed for iterative refinement.
    double S [n] ;		Workspace, only needed for iterative refinement.

	The Wi, W, Y, Z, and S arguments are workspace used by umfpack_wsolve.
	Their contents are undefined on output.

*/

