/* ========================================================================== */
/* === umfpack_report_triplet =============================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_report_triplet
(
    const char name [ ],
    int n,
    int nz,
    const int Ti [ ],
    const int Tj [ ],
    const double Tx [ ],
    const double Control [UMFPACK_CONTROL]
) ;

long umfpack_l_report_triplet
(
    const char name [ ],
    long n,
    long nz,
    const long Ti [ ],
    const long Tj [ ],
    const double Tx [ ],
    const double Control [UMFPACK_CONTROL]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, nz, *Ti, *Tj, status ;
    double *Tx, Control [UMFPACK_CONTROL] ;
    status = umfpack_report_triplet ("Triplet", n, nz, Ti, Tj, Tx, Control) ;

long Syntax:

    #include "umfpack.h"
    long n, nz, *Ti, *Tj, status ;
    double *Tx, Control [UMFPACK_CONTROL] ;
    status = umfpack_l_report_triplet ("Triplet", n, nz, Ti, Tj, Tx, Control) ;

Purpose:

    Verifies and prints a matrix in triplet form.

Returns:

    UMFPACK_OK if Control [UMFPACK_PRL] <= 2 (the input is not checked).

    Otherwise:

    UMFPACK_OK if the Triplet matrix is OK.
    UMFPACK_ERROR_argument_missing if Ti and/or Tj are missing.
    UMFPACK_ERROR_n_nonpositive if n <= 0.
    UMFPACK_ERROR_nz_negative if nz < 0.
    UMFPACK_ERROR_invalid_triplet if any row or column index in Ti and/or Tj
	is not in the range 0 to n-1.

Arguments:

    char name [ ] ;	Input argument, not modified.

	The name of the matrix.  This is optional; no name is printed if
	a (char *) NULL pointer is passed.

    Int n ;		Input argument, not modified.

	A is an n-by-n matrix.

    Int nz ;		Input argument, not modified.

	The number of entries in the triplet form of the matrix.

    Int Ti [nz] ;	Input argument, not modified.
    Int Tj [nz] ;	Input argument, not modified.
    double Tx [nz] ;	Input argument, not modified.

	Ti, Tj, and Tx hold the "triplet" form of a sparse matrix.  The kth
	nonzero entry is in row i = Ti [k], column j = Tj [k], and has a
	numerical value of a_ij = Tx [k].  The row and column indices i and j
	must be in the range 0 to n-1.  Duplicate entries
	may be present; they are summed in the output matrix.  This is not an
	error condition.  The "triplets" may be in any order.  Tx is optional;
	if Tx is not present (a (double *) NULL pointer), then the numerical
	values are not printed.

    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.

	If a (double *) NULL pointer is passed, then the default control
	settings are used.  Otherwise, the settings are determined from the
	Control array.  See umfpack_defaults on how to fill the Control
	array with the default settings.  The following Control parameters
	are used:

	Control [UMFPACK_PRL]:  printing level.

	    2 or less: no output.  returns silently without checking anything.
	    3: fully check input, and print a short summary of its status
	    4: as 3, but print first few entries of the input
	    5: as 3, but print all of the input
	    Default: 1
*/
