function [out1, out2, out3, out4, out5] = umfpack (in1, in2, in3, in4, in5)
%UMFPACK
%
%   Factor or solve a sparse linear system, returning either the solution x to
%   Ax=b or A'x'=b', or the factorization LU=PAQ.  A must be square (n-by-n),
%   sparse, and non-singular, and b must be a dense n-by-1 vector.
%
%   Each of these uses of umfpack (except for "Control = umfpack") is stand-
%   alone.  That is, no call to umfpack is required for any subsequent call.
%
%   Usage:
%
%   [x, Info] = umfpack (A, '\', b) ;
%   [x, Info] = umfpack (A, '\', b, Control) ;
%   [x, Info] = umfpack (A, Qinit, '\', b, Control) ;
%   [x, Info] = umfpack (A, Qinit, '\', b) ;
%
%	Solves Ax=b (or x = A\b in Matlab).
%
%   [x, Info] = umfpack (b, '/', A) ;
%   [x, Info] = umfpack (b, '/', A, Control) ;
%   [x, Info] = umfpack (b, '/', A, Qinit) ;
%   [x, Info] = umfpack (b, '/', A, Qinit, Control) ;
%
%	Solves A'x'=b' (or x = b/A in Matlab).
%
%   [L, U, P, Q, Info] = umfpack (A) ;
%   [L, U, P, Q, Info] = umfpack (A, Control) ;
%   [L, U, P, Q, Info] = umfpack (A, Qinit) ;
%   [L, U, P, Q, Info] = umfpack (A, Qinit, Control) ;
%
%	Returns the LU factorization of A.  P and Q are returned as permutation
%	vectors, so L is lower triangular, U is upper triangular and L*U is
%	equal to A (P,Q).  You can convert P and Q to permutation matrices with:
%	    n = size (A,1) ; I = speye (n) ; P = I (P,:) ; Q = I (:,Q) ;
%	Now L*U is equal to P*A*Q.
%
%   [Qtree, Fr, Ch, Info] = umfpack (A, 'symbolic') ;
%   [Qtree, Fr, Ch, Info] = umfpack (A, 'symbolic', Control) ;
%   [Qtree, Fr, Ch, Info] = umfpack (A, Qinit, 'symbolic') ;
%   [Qtree, Fr, Ch, Info] = umfpack (A, Qinit, 'symbolic', Control) ;
%
%	Performs only the fill-reducing column pre-ordering (including the
%	column elimination tree post-ordering) and symbolic factorization.
%	Qtree is the initial column permutation (either from colamd or
%	Qinit), followed by a column elimination tree post-ordering.
%
%	Fr is a nfr-by-2 array containing information about each frontal
%	matrix, where nfr <= n is the number of frontal matrices.  Fr (:,1) is
%	the number of pivots in each front, and Fr (:,2) is the parent of
%	each front in the supercolumn elimination tree.  Ch is a
%	(nchains+1)-by-3 array containing information about each "chain"
%	(unifrontal sequence) of frontal matrices, and where nchains <= nfr
%	is the number of chains.  The ith chain consists of frontal matrices.
%	Chain (i,1) to Chain (i+1,1)-1, and the largest front in chain i is
%	Chain (i,2)-by-Chain (i,3).
%
%	This use of umfpack is not required to factor or solve a linear system
%	in Matlab.  It analyzes the matrix A and provides information only.
%	The Matlab statement "treeplot (Fr (:,2)')" plots the column elimination
%	tree.
%
%   Control = umfpack ;
%
%	Returns a 20-by-1 vector of default parameter settings for umfpack.
%
%   umfpack_report (Control, Info) ;
%
%	Prints the current Control settings, and Info
%
%   If present, Qinit is a user-supplied 1-by-n permutation vector.  It is an
%   initial fill-reducing column pre-ordering for A; if not present, then colamd
%   is used instead.  If present, Control is a user-supplied 20-by-1 array.
%   Control and Info are optional; if Control is not present, defaults are used.
%
%   UMFPACK Version 3.2, Jan. 1, 2002.  Copyright (c) 2002 by Timothy A.
%   Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.
%
% UMFPACK License:
%
%   Your use or distribution of UMFPACK or any derivative code implies that
%   you agree to this License.
%
%   THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY
%   EXPRESSED OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
%
%   Permission is hereby granted to use or copy this program, provided
%   that the Copyright, this License, and the Availability of the original
%   version is retained on all copies.  User documentation of any code that
%   uses this code or any derivative code must cite the Copyright, this
%   License, the Availability note, and "Used by permission."  If this
%   code or any derivative code is accessible from within MATLAB, then
%   typing "help umfpack" must cite the Copyright, and "type umfpack"
%   must also cite this License and the Availability note.  Permission to
%   modify the code and to distribute modified code is granted, provided
%   the Copyright, this License, and the Availability note are retained,
%   and a notice that the code was modified is included.  This software
%   was developed with support from the National Science Foundation, and
%   is provided to you free of charge.
%
% Availability:
%
%   http://www.cise.ufl.edu/research/sparse.
%
% See also umfpack, umfpack_make, umfpack_report,
%    umfpack_demo, and umfpack_simple.

help umfpack_details

