#! /bin/sh

# Converts uptime.records from older ud versions
# Andreas Muck <andi@koala.rhein-neckar.de>

if [ $# -ne 1 ]; then
  echo "Usage: $0 <file>"
  exit 1
fi

if [ -f $1.old ]; then
  echo "$1.old exists. Move it out of the way and restart $0"
  exit 1
fi
echo 0.7.1 > $1.new

if [ "`head -1 $1`" = "0.7" ]; then
 echo "Updating from 0.7 to 0.7.1"
 head -n 3 $1 | tail -n 2 >> $1.new  
 head -n 6 $1 | tail -n 2 >> $1.new  
 head -n 9 $1 | tail -n 2 >> $1.new  
elif [ "`head -1 $1`" = "0.6" ]; then
 echo "Updating from 0.6 to 0.7"
 head -n 3 $1 | tail -n 2 >> $1.new
 head -n 6 $1 | tail -n 2 >> $1.new
 head -n 9 $1 | tail -n 2 >> $1.new
elif [ "`head -1 $1`" = "0.7.1" ]; then
 echo "Already updated (0.7.1)!"
 exit
else
 echo "Updating from < 0.6 to 0.7.1"
 head -n 1 $1 >> $1.new
 echo "Unknown kernel" >> $1.new
 head -n 3 $1 | tail -n 1 >> $1.new
 echo "Unknown kernel" >> $1.new
 head -n 5 $1 | tail -n 1 >> $1.new
 echo "Unknown kernel" >> $1.new
fi

mv $1 $1.old
mv $1.new $1
