/* ==================================================== ======== ======= *
 *
 *  dbricks.cc  [demo
 *  Ubit Project [Elc::99]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit System: A Visual+Textual Environment for Building GUIs.
 *
 *  (C) 1999 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */


#include <ubit/ubit.hpp>
#include "dmisc.hh"
#include "dbricks.hh"

BrickDialog::BrickDialog() {
    UButton *b = null;
    UHbox &sdate =
      uhbox( ubox( UBorder::shadowIn   + " Fri " )
	     + ubox( UBorder::shadowIn + " Jul  " )
	     + ubox( UBorder::shadowIn + " 30  " )
	     + ubox( UBorder::shadowIn + " 1999  " )
	     );
    
    UTextbox &sharedt =
      utextbox(uedit() + shared->bgcolor	  // shared bgcolor
	       + UColor::orange + "aaa"  + ubutton("bbb") + UColor::navy + "ccc");
    

    // adds children to "this" object
    addlist
      (
       utitle("Basic Bricks")
       + utop()
       + uhbox( UFont::large + UFont::bold + UColor::red + uhcenter()
		+ " Basic Brick Combinations")

       // PushButtons
       + uhbox( UBorder::etchedOut + uhcenter()
		 
		// Pixmpap Button
		+ ubutton( UColor::navy
			   + UBgcolor::white
			   + UOn::enter/UBgcolor::wheat
			   + UOn::arm/UBgcolor::red
			   + ubit_pix + UFont::large + "Ubit"
			   )

		// Shared Text
		+ uvbox(UBorder::etchedOut
			+ UFont::italic + "Shared text"
			+ sharedt
			+ sharedt)
		
		// Strange Button
		+ ubutton( UOrient::vertical + UBorder::etchedOut
			   + uhcenter()
			   + uhbox(bricks_pix + bricks_pix
				   + bricks_pix + bricks_pix)
			   + UColor::red   + UFont::italic
			   + " Click Me!"
			   + UFont::bold + UColor::blue
			   + " I am Ready! "
			   + uhbox (USymbol::down + USymbol::down
				    + USymbol::down+ USymbol::down
				    + USymbol::down)
			   )

		+ uvbox( uvspacing(3) + uhmargin(2)
			 + ubutton(UBorder::none + UFont::bold 
				   + UPix::ray + " Button 1 " + UPix::ray)

			 + ubutton(
				   USymbol::up
				   + UColor::red + UFont::italic
				   +  ubox( UBorder::shadowIn  +" Button 2 ")
				   + USymbol::down
				   )

			 + ubutton(UBorder::etchedIn
				   + USymbol::square
				   + " Button 3 "
				   + USymbol::square)
			 )
		)
       
       + " " //spacing

       //+ uvflex()
       // Warped text containg other gadgets
       + utextbox(UFlowView::style + uedit()
		  + shared->bgcolor	// shared bgcolor
		  + USymbol::square + " This is " 
		  + UPix::colors
		  + UColor::red + UFont::bold + " multi-color " 
		  + UColor::black 
		  + UFont::italic + " multi-font " + UFont::_italic
		  + UFont::_bold
		  + "warped text that contains a " 
		  + UFont::bold + ucheckbox("Checkbox" + manual_pix)
		  + " and a " + ulinkbutton("pseudo hyperlink") + UPix::ray
	       )

       + ubottom()
       + " "//spacing
	// A button that contains a text field
       + ubutton
       (
	USymbol::right
	+ uhflex()
	+ uvbox(UBorder::etchedOut
		+ (b = &ubutton
		   (manual_pix
		     + ugroup(UFont::bold + "A Button ")
		     + bricks_pix
		     + UFont::italic + " that contains "
		     + uhflex()
		     + shared->shtext // shared textfield
		     ))
		)
	+ uleft() + USymbol::left
	)
       + ""

       + uhbox( uhflex() + sharedt + sharedt
		+ uright() + shared->optbutton) // shared object

       + uhbox( UBorder::etchedIn 
		+uvbox(
		       uhbox(uhflex()
			     + ubutton( UPix::edit + "Edit")
			     + utextbox("More" + USymbol::down)
			     + ubox(UBorder::etchedOut + UFont::bold + "Ubit")
			     )
		       + uhbox(UBorder::etchedIn
				+ "This is " + UColor::red + "multi-color"
			       + UColor::blue + "text")
		       )
		+ " "
		// shared gain with a large font + uhbox(UFont::large + sharedt)
		+ uright()
		+ uvbox(ubutton( UBorder::none + uhcenter()
				 +  USymbol::up + "Another" + USymbol::left
				 + "Push"  + USymbol::right + "Button")
			+ sdate)
		)
       
       + uhbox( uhcenter()
		// closes the dialog box when OK or Cancel are clicked
		+ ubutton( UPix::ray + "OK" + ucloseWin())
		+ ubutton("Cancel" + ucloseWin())
		+ ubutton( UPix::question + "Help")
		)
       );
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:99] ======= */
