/* ==================================================== ======== ======= *
 *
 *  uuevent.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuevent.cpp	   ubit:03.05.05"
#include <X11/Xlib.h>
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ubox.hpp>
#include <ustr.hpp>
#include <uevent.hpp>
#include <ucontext.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <ucolor.hpp>
#include <ugraph.hpp>
#include <uappli.hpp>
#include <uflow.hpp>
#include <umsproto.hpp>
#include <unatdisp.hpp>  // a deplacer
#include <X11/Xatom.h>   // a deplacer
using namespace std;

#define ANY_BUTTON (Button1Mask|Button2Mask|Button3Mask|Button4Mask|Button5Mask)
#define ANY_MOD (ShiftMask|LockMask|ControlMask|Mod1Mask|Mod2Mask|Mod3Mask|Mod4Mask|Mod5Mask)

const u_id UEvent::UbitEventFlow = UMSprotocol::UBIT_EVENT_FLOW;

// cette valeur est choisie pour eviter des interferences avec les Button*Mask
// et les Modifier*Mask. elle est < 1<<15 car cette valeur est definie par X
// et car les Event.xxx.state sont des unsigned int.
// const u_id UEvent::UbitEventFlow = 1<<14;  UProtocol::UBIT_EVENT_FLOW

const u_id 
 UEvent::MButton1 = Button1Mask, 
 UEvent::MButton2 = Button2Mask, 
 UEvent::MButton3 = Button3Mask, 
 UEvent::MButton4 = Button4Mask, 
 UEvent::MButton5 = Button5Mask;

const u_id 
 UEvent::MShift   = ShiftMask, 
 UEvent::MLock    = LockMask, 
 UEvent::MControl = ControlMask,
 UEvent::MOption  = Mod1Mask;          // A VERIFIER suivant config
/*
 UEvent::MAlt     = Mod1Mask,
 UEvent::MNumLock = Mod2Mask,
 UEvent::MAltGr   = Mod3Mask;
*/
/*
  XK_Return, 
  XK_Delete XK_KP_Delete
  XK_Escape
  XK_BackSpace
  XK_Tab  XK_KP_Tab
  XK_Return
  XK_Insert XK_KP_Insert
  XK_Undo
  XK_Redo
  XK_Menu
  XK_Help
  XK_Break
  XK_space  XK_KP_Space
  XK_Home XK_KP_Home
  XK_Up XK_KP_Up 
  XK_Down XK_KP_Down
  XK_Left XK_KP_Left
  XK_Right  XK_KP_Right
  XK_Prior XK_KP_Prior
  XK_Next XK_KP_Next
  XK_End XK_KP_End
  XK_Begin XK_KP_Begin
  XK_Page_Up XK_KP_Page_Up
  XK_Page_Down XK_KP_Page_Down
  XK_F1 XK_KP_F1
  XK_F2 XK_KP_F2
  XK_F3 XK_KP_F3
  XK_F4 XK_KP_F4
  XK_F5	
  XK_F6	
  XK_F7	
  XK_F8	
  XK_F9	
  XK_F10
  XK_F11
  XK_F12
*/

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// effectue l'intersection de *this avec clip2
// *this est mis a jour (contient l'intersection), clip2 ne change pas
// renvoie:
// * false si pas d'intersection (region inchangee)
// * true sinon si region est incluse dans clip (ie. clipping inutile)

// OLD: renvoie:
// OLD: * 0 si pas d'intersection
// OLD: * 2 si region est incluse dans clip (ie. clipping inutile)
//  OLD:* 1 sinon (il il a une intersection ou clip inclus dans region)

bool URegion::setInter(const URegion &clip2) {
  //OLD int stat = 0;
  bool stat = false;

  // *** en x

  if (clip2.x < x) {
    if (clip2.x + clip2.width < x) {
      width = height = 0;	// securite !
      return false;// no inter
    }

    // fait: width = UMIN(x + width, clip2.x + clip2.width) - x;

    else if (x + width <= clip2.x + clip2.width) {
      //x = x;
      //width = x + width -x;
      //OLD!!! stat = 2; //region incluse horizontalement dans clip (clip inutile)
      stat = true;
    }
    else {
      //x = x;
      width = clip2.x + clip2.width -x;
      //OLD stat = 1;			// inter simple
      stat = true;
    }
  }

  else {    // (x <= clip2.x)
    if (x + width <= clip2.x) {
      width = height = 0;	// securite !
      return false;
    }

    // width = UMIN(x + width, clip2.x + clip2.width) - clip2.x;

    else if (x + width <= clip2.x + clip2.width) {
      width = x + width - clip2.x;
      x = clip2.x;		// !att a l'ordre!
      //OLDstat = 1;	
      stat = true;
    }
    else {
      width = clip2.width; 
      x = clip2.x;
      //OLD stat = 1;	  // clip inclus dans region (renvoie 1: clip necessaire)
      stat = true;
    }
  }

  // *** en y

  if (clip2.y < y) {
    if (clip2.y + clip2.height < y) {
      width = height = 0;	// securite !
      return false;// no inter
    }

    // fait: height = UMIN(y + height, clip2.y + clip2.height) - y;

    else if (y + height <= clip2.y + clip2.height) {
      //y = y;
      //height = y + height -y;
      // region incluse horizontalement
      // *ET* verticalement dans clip (clip inutile)
      //OLD stat = (stat == 2) ? 2 : 1;
      stat = true;
    }
    else {
      //y = y;
      height = clip2.y + clip2.height -y;
      //OLD stat = 1;			// inter simple
      stat = true;
    }
  }

  else {    // (y <= clip2.y)
    if (y + height <= clip2.y) {
      width = height = 0;	// securite !
      return false;// no inter
    }

    // height = UMIN(y + height, clip2.y + clip2.height) - clip2.y;
    else if (y + height <= clip2.y + clip2.height) {
      height = y + height - clip2.y;
      y = clip2.y;		// !att a l'ordre!
      //OLD stat = 1;
      stat = true;
    }
    else {
      height = clip2.height; 
      y = clip2.y;
      //OLD stat = 1;	  // clip inclus dans region (renvoie 1: clip necessaire)
      stat = true;
    }
  }

  //ajout 29 dec: renvoyer false si vide!
  // ceci exclut les "regions ponctuelles" sans epaisseur
  if (width <= 0 || height <= 0) return false;
  else return stat;
}

bool URegion::setInter(const URegion *clip2) {
  return setInter(*clip2);
}
bool URegion::setInter(u_pos xx, u_pos yy, u_dim w, u_dim h) {
  URegion r(xx,yy,w,h);
  return setInter(r);
}

// les regions vides ne sont pas prises en compte !
void URegion::setClosure(const URegion &clip2) {
  if (width <= 0 || height <= 0) {
    *this = clip2;
  }
  else if (clip2.width <= 0 || clip2.height <= 0) {
    /*nop*/;
  }
  else {
    if (x > clip2.x) x = clip2.x;
    if (y > clip2.y) y = clip2.y;

    if (x + width < clip2.x + clip2.width) 
      width = clip2.x + clip2.width - x;
    if (y + height < clip2.y + clip2.height) 
      height = clip2.y + clip2.height - y;
  }
}

void URegion::setClosure(const URegion *clip2) {
  return setClosure(*clip2);
}
void URegion::setClosure(u_pos xx, u_pos yy, u_dim w, u_dim h) {
  URegion r(xx,yy,w,h);
  return setClosure(r);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void USourceProps::reset(UView* win_view) {
  enabled      = true;
  inMenu       = false;
  autoCloseMenu= false;
  redrawStatus = false; 
  if (win_view) redrawClip = *win_view; else redrawClip.set(0,0,0,0);
  opaqueView   = null;
  layoutView   = null;
  incrustView  = null;
  cursor       = null;
  browsingGroup= null;
  parentBrowsingGroup = win_view ? win_view->getBox()->getBrowsingGroup() : null;
  parentContext = null;
}

/* ==================================================== ======== ======= */

void USourceProps::set(UView* view, UGroup* grp, const UContext& curp) {
  if (!grp->isEnabled()) enabled = false;
  
  if (curp.local.alpha == 1. && !curp.bgcolor->equals(UBgcolor::none))
    opaqueView = view;
  
  if (grp->isDef(0, UMode::FLOATING)
      || view->allVmodes(UView::FIXED_WIDTH | UView::FIXED_HEIGHT))
    layoutView = view;

  if (grp->isCmode(UMode::MENU))
    inMenu = true;
  else if (grp->isCmode(UMode::SOFTWIN | UMode::HARDWIN))
    inMenu = false;
  
  if (grp->isCmode(UMode::INCRUST))
    incrustView = view;

  if (grp->isCmode(UMode::HAS_CLOSE_MENU_MODE))
    autoCloseMenu = grp->isCmode(UMode::CLOSE_MENU_MODE);

  // cursor herite mais ecrase si defini au niveau local
  if (curp.cursor) cursor = curp.cursor;

  // parentBrowsingGroup herite mais dominant : ecrase le niveau local
  parentBrowsingGroup = browsingGroup;
  if (parentBrowsingGroup)  browsingGroup = parentBrowsingGroup;
  else if (grp->isBrowsingGroup())  browsingGroup = grp->getBrowsingGroup();
  else browsingGroup = null;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
//!Note: 'win_view' must be a valid window view or 'null'

UEvent::UEvent(int _id, UFlow* _eflow, UView* hardwin_view, UX_Event ev)
  : sp(hardwin_view)   // SourceProps init by its constructor
{
  eflow      = _eflow,
  id         = _id;
  xev        = ev;
  cond       = null;
  time       = 0;
  hardWinView= hardwin_view;
  sourceView = null;
  source     = null;
  aux        = null;
  xmouse = ymouse = 0;
  xdrag_ref = ydrag_ref = 0;
  detail    = 0;
  flagdefs  = null;
  flagdefCount = 0;
  preChildEventNotify = postChildEventNotify = false;
  resendEvent = false;
}

/* ==================================================== ======== ======= */

UEvent::~UEvent() {
  // flags vectors are shared by all stacked Contexts
  // where they are refererenced through pointers named respectively
  // pflags and pexts
  // thus, they must be freed by ~UEvent (if not null) and only there
  if (flagdefs) free(flagdefs);
  flagdefs = null;
  flagdefCount = 0;

  // if (parentContext) delete parentContext;
  // parentContext = null;

  // note: les flags des 2 contexts sont partages
  // mais comme c'est bien fait (parentContext est un UWinContext
  // qui detruit ces champs alors que sourceContext est un UContext
  // qui ne les detruits pas) il n'y a (normalement) pas de probleme

  // if (sourceContext) delete sourceContext;
  // sourceContext = null;
}

/* ==================================================== ======== ======= */
// RECOPIE de tout le contenu AINSI que celui des champs pointes

void UEvent::copy(const UEvent& e2) {
  if (flagdefs) free(flagdefs);
  flagdefs = null;
  flagdefCount = 0;

  // if (parentContext) delete parentContext;
  // parentContext = null;

  // recopie globale des champs
  *this = e2;

  // ALLOUER e recopier le CONTENU des champs pointes vu qu'ils seront
  // automatiquement detruits par le destructeur de UWinContext

  // if (e2.parentContext) {
  //  parentContext = new UWinContext();
  // // this method recopies the internal flags and exts arrays
  //  parentContext->copy(*e2.parentContext);
  //}

  if (e2.flagdefs) {
    flagdefs = (const UFlagdef**) malloc(flagdefCount * sizeof(UFlagdef*));
    for (int k = 0; k < flagdefCount; k++) flagdefs[k] = e2.flagdefs[k];
  }
}

/* ==================================================== ======== ======= */

void UEvent::addFlagdef(const UFlagdef* _flagdef) {
  if (flagdefs)
    flagdefs = (const UFlagdef**) realloc(flagdefs,
                                    (flagdefCount+1) * sizeof(UFlagdef*));
  else 
    flagdefs = (const UFlagdef**) malloc(sizeof(UFlagdef*));

  flagdefs[flagdefCount] = _flagdef;
  flagdefCount++;
}

const class UFlagdef* UEvent::getFlagdef(const UFlag &_flag) const {
  if (!flagdefs) return null;

  for (int k = 0; k < flagdefCount; k++)
    if ((flagdefs)[k]->getFlag() == &_flag) return (flagdefs)[k];

  return null;  // not found
}


const class UPropdef* UEvent::getPropdef(const UFlag& _flag) const {
  if (!flagdefs) return null;

  const UPropdef* last_pdef = null;
  //att: comme il peut y avoir plusieurs propdef empilees il faut
  //toujours prendre la derniere

  for (int k = 0; k < flagdefCount; k++) {
    const UPropdef* pdef = null;
    if ((flagdefs)[k]->getFlag() == &_flag
        && (pdef = dynamic_cast<const UPropdef*>((flagdefs)[k]))
        ) {
      last_pdef = pdef;
    }
  }

  return last_pdef;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UEvent::setID(int _id) {id = _id;}

void UEvent::setSource(UView *v) {
  sourceView = v;
  source = (v ? v->getBox() : null);
}

void UEvent::setSource(UGroup *grp) {
  sourceView = null;
  source = grp;
}

void UEvent::setAux(UBrick* b)        {aux = b;}
void UEvent::setCond(const UCond *cd) {cond = cd;}

UGroup* UEvent::getSource() const
{return source;}

UBox* UEvent::getBoxSource() const {
  return (source ? source->boxCast() : null);
}

UGroup* UEvent::getTarget() const {
  return (aux ? aux->groupCast() : null);
}

UBox* UEvent::getBoxTarget() const {
  return (aux ? aux->boxCast() : null);
}

UBrick* UEvent::getBrickTarget() const {
  return aux;
}

UProp* UEvent::getChangedProp() const {
  return (aux ? aux->propCast() : null);
}

UElem* UEvent::getChangedElem() const {
  return (aux ? aux->elemCast() : null);
}

UStr*  UEvent::getChangedStr() const {
  return (aux ? aux->strCast() : null);
}

bool UEvent::getMessage(UStr& s) const {
  s = (char*)null;
  
  if (id != umessage || !xev) {
    return false;
  }
  
  else if (xev->type == ClientMessage) {
    xev->xclient.data.b[sizeof(xev->xclient.data.b) - 1] = 0;
    s = xev->xclient.data.b;
    return true;
  }
  
  else if (xev->type == PropertyNotify) {
    UDisp* d = getDisp();
    if (!d) return false;
    
    long req_offset = 0;
    long req_length = XMaxRequestSize(xev->xproperty.display);
    Atom type;
    int format;
    unsigned long nitems = 0, bytes_after = 1;
    unsigned char *prop;

    Bool req_stat =
      XGetWindowProperty(xev->xproperty.display,
                         xev->xproperty.window,
                         d->getNatDisp()->atoms.UBIT_MESSAGE,
                         req_offset, req_length,
                         True,         // delete property
                         XA_STRING,    // req_type
                         &type, &format, &nitems, &bytes_after,
                         &prop);
    if (req_stat == Success && nitems > 0 && prop != null
        && type == XA_STRING && format == 8) {
      s = (char*)prop;
      XFree(prop);
      return true;
    }
    else return false;
  }
  else return false;
}

UView* UEvent::getHardWinView() const
{return hardWinView;}

UWin* UEvent::getHardWin() const
{return (hardWinView ? hardWinView->getHardwin() : null);}

int UEvent::getFlowID() const
{return eflow ? eflow->getID() : 0;}    // DEFAULT FLOWID !

UAppli* UEvent::getAppli() const
{return eflow ? &(eflow->getAppli()) : null;}

UDisp* UEvent::getDisp() const
{return eflow ? &(eflow->getDisp()) : null;}

int UEvent::getDispID() const
{return eflow ? eflow->getDisp().getID() : 0;}

u_time UEvent::getTime() const {return time;} 

//NB: getClickCount et getKeyChar utilisent le meme champ!
//-- initialise dans disarmBehavior()
int UEvent::getClickCount() const {return (int)detail;} 

//-- initialise dans typeBehavior()
int UEvent::getKeyChar() const {return detail;}
void UEvent::setKeyChar(int ch)  {detail = ch;}

// return the location of the mouse relatively to the source VIEW
//NOTES: dans le cas des drags, xmouse, xmouse est relatif a la hardwin
//sur laquelle la souris se trouve actuellement et non celle qui a initie le Drag.
// ==> le calcul est fait en absolu sur les screen coords, *drag_ref etant les
//screen coords de la vue sur laquelle on a fait le Press 
  
void UEvent::setMouse(u_pos xm, u_pos ym) {
  xmouse = xm; ymouse = ym;
}

void UEvent::goThrough(UBox* obj) {
  resendEvent = true;
  aux = obj;
}

u_pos UEvent::getX() const {
  if (id == mdrag) return xev->xbutton.x_root - xdrag_ref;
  return sourceView ? xmouse - sourceView->x : -1;
}
u_pos UEvent::getY() const {
  if (id == mdrag) return xev->xbutton.y_root - ydrag_ref;
  return sourceView ? ymouse - sourceView->y : -1;
}

// (available for mouse and key events)
// !!!ATT: normalement le nom du champ varie suivant type d'event
// (en pratique c'est tjrs le meme champ)

u_pos UEvent::getXscreen() const {
  return xev->xbutton.x_root;
}

u_pos UEvent::getYscreen() const {
  return xev->xbutton.y_root;
}

// returns the ID of the button that was pressed or released.
u_id UEvent::getButtons() const {
  if (!xev) 
    return 0;
  else if (xev->type == MotionNotify) {
    //std::cerr << "btn= " << (xev->xbutton.state & ANY_BUTTON) << std::endl;
    return (xev->xbutton.state & ANY_BUTTON);
  }
  // att: au Press, xev->xbutton.state ne contient pas encore
  // le ButtonMask correspondant
  else if (xev->type == ButtonPress || xev->type == ButtonRelease) {
    switch (xev->xbutton.button) {
      case 1: return MButton1;
      case 2: return MButton2;
      case 3: return MButton3;
      case 4: return MButton4;
      case 5: return MButton5;
    }
  }
  // default
  return 0;
}

// returns a combination of key and mouse button modifiers
//u_id UEvent::getState() const {
//  return xev ? xev->xbutton.state : 0;
//}

u_id UEvent::getMods() const {
  return xev ? (xev->xkey.state & ANY_MOD) : 0;
}

// returns the X KeySym (but without taking modifiers into account)
// --- can be used in all Key callbacks
u_id UEvent::getKeySym() const {
  if (xev && (xev->type == KeyPress || xev->type == KeyRelease))
    // inde=0 -> considere la table standard sans tenir compte des SHIFT
    return XKeycodeToKeysym(xev->xany.display, xev->xkey.keycode, 0);
  else return 0;
}

/***
// Button Number when the mouse is dragged
// Note: returns 0 if the mouse is moved without pressing any button
int UEvent::draggedButton() {
  uint stm = xev->xmotion.state & ANY_BUTTON;
  if (stm == 0) return 0;
  if (stm & Button1Mask) return 1;
  if (stm & Button2Mask) return 2;
  if (stm & Button3Mask) return 3;
  return 0;
}
void UEvent::queryMouse() {
  Display *display;
  Window w;
  Window *root_return, *child_return;
  int *root_x_return, *root_y_return;
  int *win_x_return, *win_y_return;
  unsigned int mask_return;
  // ca suffit pas: faut trouver la UWin
  Bool XQueryPointer(display, w, root_return, child_return,
		     root_x_return, root_y_return,
		     win_x_return, win_y_return,
  e(UEvent::QueryMouse, winview, x_in_win, y_in_win, null);
}
***/


/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// returns UView if found and null otherwise

UView *UEvent::locateSource(u_pos x_in_win, u_pos y_in_win) {
  if (!hardWinView) {
    UError::error("warning@UEvent::locateSource",
		  UError::Cant_locate_source);
    return null;
  }
  xmouse = x_in_win;
  ymouse = y_in_win;

  UWinContext winContext(hardWinView);
  USourceProps vl(hardWinView);

  sourceView = hardWinView->locateSource(winContext, vl.redrawClip, 
					 *this, null, vl);

  if (sp.incrustView) {
    // !!new 17june03: les events ne sont pas detectes par
    // les incrusts (mais par les dialogs, frames, menus)
    // => il faut corriger hardWinView
    hardWinView = sp.incrustView;
    /* deja pris en compte dans UView
    xmouse -= sp.incrustView->getXwin();
    ymouse -= sp.incrustView->getYwin();
    sp.redrawClip.x -= sp.incrustView->getXwin();
    sp.redrawClip.y -= sp.incrustView->getYwin();
    */
  }
  
  source = (sourceView ? sourceView->getBox() : null);

  //if (through != null) {
  if (source && resendEvent) {
    vl.reset(hardWinView);
    sourceView = hardWinView->locateSource(winContext, vl.redrawClip, 
					   *this, null, vl);
    source = (sourceView ? sourceView->getBox() : null);
  }

  return sourceView;
}

/* ==================================================== ======== ======= */

UView *UEvent::locateSource(UView* searched_view) {
  if (!hardWinView) {
    UError::error("warning@UEvent::locateSource",UError::Cant_locate_source);
    return null;
  }

  UWinContext winContext(hardWinView);
  USourceProps vl(hardWinView);
  sourceView = hardWinView->locateSource(winContext, vl.redrawClip, 
					 *this, searched_view, vl);
  source = (sourceView ? sourceView->getBox() : null);

  //if (through != null) {
  if (source && resendEvent) {
    vl.reset(hardWinView);
    sourceView = hardWinView->locateSource(winContext, vl.redrawClip, 
					   *this, searched_view, vl);
    source = (sourceView ? sourceView->getBox() : null);
  }

  return sourceView;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// NB: cette fct initialise entre-autres:
//     - elemLink : elem clique
//     - region   : zone se trouve l'elem
//     - props    : props associees a cet elem

UElem* UEvent::searchElem(UElemProps &itd, const UElem *searched_elem,
			  int strpos1, int strpos2) {
  if (!sourceView) return null;
  UView* searched_view = sourceView;

  UViewUpdate vup(searched_elem ? UViewUpdate::LOCATE_ELEM_PTR
		  : UViewUpdate::LOCATE_ELEM_POS);
  vup.e = this;
  vup.elem_props = &itd;
  itd.elemLink = null;
  itd.elem     = (UElem*)searched_elem;
  itd.strpos   = strpos1;
  itd.strpos2  = strpos2;

  // NB: winContext et elemContext sont asocies a ElemProps
  // et cree et detruits par cette classe

  if (itd.winContext)  delete itd.winContext;
  if (itd.elemContext) delete itd.elemContext;
  itd.winContext = new UWinContext(hardWinView);
  itd.elemContext = null;

  // parentContext (temporaire) = permet de recuperer le context de la view 
  // qui contient l'item via locateSource()
  // NB: on le recopie de winContext pour init les champs pour eviter
  // d'eventuelles catastrophes
  UContext parentContext(*itd.winContext);

  USourceProps vl(hardWinView);
  vl.parentContext = &parentContext;  // !!

  sourceView = hardWinView->locateSource(*itd.winContext, vl.redrawClip, 
					 *this, searched_view, vl);
  source = (sourceView ? sourceView->getBox() : null);

  //if (through != null) {
  if (source && resendEvent) {
    vl.reset(hardWinView);
    vl.parentContext = &parentContext;  // !!
    sourceView = hardWinView->locateSource(*itd.winContext, vl.redrawClip, 
					   *this, searched_view, vl);
    source = (sourceView ? sourceView->getBox() : null);
  }
 
  if (!sourceView) {
    //cerr << "sourceview not found" << endl;
    return null;
  }

  URegion clip(*sourceView);
  // !att: ici il faut partir de parentContext et non de winContext !
  sourceView->doUpdate(parentContext, clip, clip, vup);

  if (itd.elemLink) return itd.elem;
  else return null;
}

/* ==================================================== ======== ======= */
// return the LOCAL coordinates of the origine of the Elem
// (location is relative to the origin of the SOURCE View)

u_pos UElemProps::getX(class UEvent *e) {
  return e->getView()->XwinToX(region.x);
}

u_pos UElemProps::getY(class UEvent *e) {
  return e->getView()->YwinToY(region.y);
}

// return the width and the height of the Elem
u_dim UElemProps::getWidth()  {return region.width;}
u_dim UElemProps::getHeight() {return region.height;}


UElemProps::UElemProps() {
  elem     = null;
  elemLink = null;
  strpos   = -1;
  strpos2  = -1;       // !must be se to -1 if unused
  region.set(0,0,0,0); // !important pour set/union
  winContext  = null;  // !important pour ~UItemData
  elemContext = null;  // !important pour ~UItemData
  exactMatch  = false;
}

UElemProps::~UElemProps() {
  if (winContext)  delete winContext;
  if (elemContext) delete elemContext;
}

// -- exact_match   = true  : Elem is exactly located under the Mouse
//                    false : Elem is the last Elem before the Mouse position
// -- merge_regions = true  : region 'r' is merged with the previous 'region'
//                    false : region 'r' replaces the previous value of 'region'
//
void UElemProps::set(UContext &ctx, UElem *_elem, ULink *_link,
		    const URegion &r, int _strpos, bool exact_match) {
  elem     = _elem;
  elemLink = _link;
  strpos   = _strpos;
  //don't change strpos2!
  if (!elemContext) elemContext  = new UContext(ctx);
  exactMatch = exact_match;
  region = r;
}

void UElemProps::merge(UContext &ctx, UElem *_elem, ULink *_link, 
		      const URegion &r, bool exact_match) {
  elem     = _elem;
  elemLink = _link;
  //don't change strpos and strpos2!
  if (!elemContext) elemContext  = new UContext(ctx);
  exactMatch = exact_match;
  region.setClosure(r);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// Returns the UElem child that was clicked in this box (if any)
// Notes:
// - can return null
// - argument UElemProps is filled with information that is related 
//   to the selected elem

UElem* UEvent::getElem() {
  UElemProps itd;
  return searchElem(itd, null, 0);
}

UElem* UEvent::getElem(UElemProps &itd) {
  return searchElem(itd, null, 0);
}

// same as getElem() but discards UElems that are not Strings
UStr* UEvent::getStr() {
  UElemProps itd;
  UElem *elem = getElem(itd);
  return (elem ? elem->strCast() : null);
}

UStr* UEvent::getStr(UElemProps &itd) {
  UElem *elem = getElem(itd);
  return (elem ? elem->strCast() : null);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// Cette fct recupere les props heritees via le graphe d'instanciation
// ATTENTION:
// -1- les props de cette UBox ne sont pas prises en compte
//     (ie. l'heritage s'arrete au PARENT de cette UBox)
// -2- cette fct n'a de sens et ne doit etre utilisee QUE SI l'objet 
//     est VISIBLE (car elle fait appel a getSource)
/*
UContext* UBox::getProps(UView *view) {

  if (!view->getWinView()) return null;
  UEvent e(UEvent::search, view->getWinView(), view);

  if (e.sourceView != view) return null;
  else if (!e.sourceProps) return null;
  else {
    UContext*p = new UContext();
    *p = *(e.sourceProps);
    return p;
  }
}
*/

/* ==================================================== ======== ======= */
/*
UContext* UEvent::getParentContext() {
  if (!parentContext)
    uerror("UEvent::getParentContext", UError::Cant_retreive_context);
  return parentContext;
}

UContext* UEvent::getSourceContext(int pos) {
  if (!parentContext || !source || !sourceView) {
    uerror("UEvent::getSourceContext", UError::Cant_retreive_context);
    return null;
  }

  if (!sourceContext) {
    sourceContext = new UContext(source, sourceView, *parentContext);
    int count = 0;

    for (ULink *ch = source->getChildLinks(); ch; ch = ch->next()) {
      if (count == pos) break;
      count++;
      if (ch->verifies(sourceContext, source)) {
	UBrick *b = ch->brick();
	UProp *prop;
	if ((prop = b->propCast())) prop->putProp(sourceContext, source);
      }
    }
  }
  return sourceContext;
}

// RECOPIE du context (pas un simple set!)
// att: usage special, l'EVENT REFERANT DOIT ETRE LE MEME!!! 
// fonction utilisee indirectement via locateSource

void UEvent::dumpParentContext(const UContext &ctx) {
  if (parentContext)  *((UContext*)parentContext) = ctx;
  //if (parentContext)  *(getParentContext()) = ctx;
  else uerror("UEvent::dumpParentContext", UError::Cant_retreive_context);
}
*/
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
