/* ==================================================== ======== ======= *
 *
 *  uudisp.cpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uudisp.cpp	ubit:03.06.04"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <uwin.hpp>
#include <uboxImpl.hpp>
#include <uconf.hpp>
#include <unatdisp.hpp>
#include <uflow.hpp>
#include <uscrollbar.hpp>
using namespace std;

/* ==================================================== ======== ======= */

UDisp::UDisp(int disp_id, class UAppli& a, const UStr& _display_name) :
  id(disp_id),
  appli(a),
  conf(a.conf),
  display_name(_display_name)
{
  // if :screen not found add :0 (SAUF si display_name est vide)
  if (!display_name.empty() && display_name.rfind(':') < 0) 
    display_name &= ":0";

  natdisp = new UNatDisp(*this);   // depend de display_name
}

/* ==================================================== ======== ======= */

UDisp::UDisp(int disp_id, class UAppli& a, class UConf& _conf) :
  id(disp_id),
  appli(a),
  conf(_conf),
  display_name(_conf.disp_name)
{
  // if :screen not found add :0 (SAUF si display_name est vide)
  if (!display_name.empty() && display_name.rfind(':') < 0) 
    display_name &= ":0";

  // configuration
#ifdef WITH_GL
  conf.graphics_engine = UConf::OGL;
  conf.softwins = true;   // OGL implies softwins mode
#else
  conf.graphics_engine = UConf::X11;
  // softwins mode can either be false or true
#endif
  conf.app_xyscale = UScale::getXScale(conf.app_lscale);  // !!

  if (conf.transp_scrollbars) conf.scrollpane_mode = UScrollbar::TRANSP;
  else conf.scrollpane_mode = 0;

  natdisp = new UNatDisp(*this); // depend de display_name
}

/* ==================================================== ======== ======= */

UDisp::~UDisp() {
  UAppli::deleteNotifyAll(this);
}

int UDisp::getStatus() const {
  return natdisp->getStatus();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

const UStr& UDisp::getDisplayName() const {
  return display_name;
}

void UDisp::realize() {
  // true colors is the default (this is necessary for transparency, etc.)
  // deplace dans UNatDisp::UNatDisp
  // if (conf.truecolor_depth > 0) setTrueColors(conf.truecolor_depth);
  natdisp->realize();
}

bool UDisp::isRealized() const {
  return natdisp->isRealized();
}

int UDisp::getDepth() const {
  return natdisp->getDepth();
}

int UDisp::getScreenWidth() const {
  return natdisp->getScreenWidth();
}

int UDisp::getScreenHeight() const {
  return natdisp->getScreenHeight();
}

int UDisp::getScreenDefaultDepth() const {
  return natdisp->getScreenDefaultDepth();
}

int UDisp::getScreenNumber() const {
  return natdisp->getScreenNumber();
}
int UDisp::getScreenCount() const {
  return natdisp->getScreenCount();
}

int UDisp::setTrueColors(int depth_hint) {
  return natdisp->setVisual(TrueColor, depth_hint, 
			    conf.linear_gamma, /*cmap*/None);
}

int UDisp::setPseudoColors(int depth_hint) {
  return natdisp->setVisual(PseudoColor, depth_hint, 
			    conf.linear_gamma, /*cmap*/None);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UDisp::add(UWin& win) {
  if (!isRealized()) realize();

  if (conf.double_buffering) 
    win.setCmodes(UMode::DOUBLE_BUFFER, true);

  winlist.add(win);   // add to the window list

  // !!ATT: marche pas si meme win ajoutee plusieurs fois !!
  UBoxLink* link = (UBoxLink*)win.getParentList().first()->link();   // par construction; 
  win._initView(link, null, this);

  // ne pas afficher de fenetre avant lancement de la mainloop
  if (appli.main_status == appli.LOOP_RUN && win.isShowable()) win.show(true);
}

void UDisp::add(UWin* win) {
  if (!win) UError::error("UDisp::add", UError::Null_argument);
  else add(*win);
}

/* ==================================================== ======== ======= */

void UDisp::remove(UWin& win, int remove_mode) {
  win.show(false);
  winlist.remove(win, remove_mode);
}

void UDisp::remove(UWin* win, int remove_mode) {
  if (!win) UError::error("UDisp::remove", UError::Null_argument);
  else remove(*win, remove_mode);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UFlow* UDisp::openFlow(int _id) {
  UFlow* fl = getFlow(_id);
  if (!fl) {
    fl = new UFlow(_id, appli, *this);
    flowlist.push_back(fl);
  }
  return fl;
}

void UDisp::closeFlow(UFlow* f) {
  if (f) {
    // va tout decaler si on enleve de la liste !
    //flowlist.erase(std::remove(flowlist.begin(), flowlist.end(), fl), 
    //               flowlist.end());
    int f_id = f->getID();
    delete f;
    flowlist[f_id] = null;    // probablement faux  
  }
}
   
//UFlow& UDisp::getDefaultFlow() const {return *flowlist[0];}

UFlow* UDisp::getFlow(int _id) {
  for (unsigned int k = 0; k < flowlist.size(); k++) {
    if (flowlist[k]->getID() == _id) return flowlist[k];
  }

  return null;
}

unsigned int UDisp::getFlowCount() const {
  return flowlist.size();
}

/* ==================================================== ======== ======= */

void UDisp::deleteNotify(UView* deleted_view) {
  for (unsigned int f = 0; f < flowlist.size(); f++){
    if (flowlist[f]) flowlist[f]->deleteNotify(deleted_view);
  }
}

void UDisp::deleteNotify(UGroup* deleted_group) {
  for (unsigned int f = 0; f < flowlist.size(); f++)
    if (flowlist[f]) flowlist[f]->deleteNotify(deleted_group);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

bool UDisp::realizeFont(const UFont& f) {
  return natdisp->realizeFont(f);
}

bool UDisp::realizeColor(UColor& c) {
  // la valeur de ix est automatiquement initialisee si elle est == 0
  // (et si l'allocation reussit)
  return natdisp->realizeColor(c);
}

bool UDisp::realizeCursor(UCursor& c) {
  // la valeur de ix est automatiquement initialisee si elle est == 0
  // (et si l'allocation reussit)
  return natdisp->realizeCursor(c);
}

void UDisp::addHardwin(class UWin* win) {
  // ne pas ajouter 2 fois
  if (!hardwin_list.search(win))  hardwin_list.add(win->makeLink());
}

void UDisp::removeHardwin(class UWin* win) {
  ULink *l = hardwin_list.search(win);
  if (l) hardwin_list.remove(l);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
