/* ==================================================== ======== ======= *
*
*  uucond.cpp
*  Ubit Project [Elc][2003]
*  Author: Eric Lecolinet
*
*  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
*
*  (C) 1999-2003 Eric Lecolinet @ ENST Paris
*  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
*
* ***********************************************************************
* COPYRIGHT NOTICE :
* THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE
* IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
* YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU
* GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION;
* EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
* SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
* ***********************************************************************
*
* ==================================================== [Elc:03] ======= *
* ==================================================== ======== ======= */

//pragma ident	"@(#)uucond.cpp	ubit:03.05.06"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <ucond.hpp>
#include <uctrl.hpp>
#include <ugroup.hpp>
#include <ucontext.hpp>
#include <uevent.hpp>
#include <ustr.hpp>
using namespace std;

UOn UOn::umessage(ANY,   UMode::UMESSAGE_CB, 0);
UOn UOn::notifyEvent(ANY,UMode::NOTIFY_EVENT_CB,0);
UOn UOn::rawEvent(ANY,   UMode::RAW_EVENT_CB,0);

UOn UOn::add(ANY,   UMode::CONTAINER_CB,0);
UOn UOn::remove(ANY,UMode::CONTAINER_CB,0);
UOn UOn::close(ANY,      UMode::CONTAINER_CB,0);
UOn UOn::destruct(ANY,   UMode::DESTRUCT_CB,0);

UOn UOn::viewPaint(ANY,  UMode::VIEW_PAINT_CB,0);
UOn UOn::viewResize(ANY, UMode::VIEW_CHANGE_CB,0);
UOn UOn::viewMove(ANY,   UMode::VIEW_CHANGE_CB,0);
//UOn UOn::viewShow(ANY,   UMode::VIEW_CHANGE_CB,0);
//UOn UOn::viewHide(ANY,   UMode::VIEW_CHANGE_CB,0);

//ATT: le mode SELECTED pose probleme car ce n'est pas un mode
//qu'il faut affecter au parent mais juste un referent pour le UOn
//(pour l'instant c'est regle en ne rajoutant pas ces modes et
// en testant directement l'egalite des UOn dans fire() et match()

UOn UOn::select(ANY,        0, UMode::CAN_SELECT | UMode::CAN_ARM);
UOn UOn::unselect(ANY,      0, UMode::CAN_SELECT | UMode::CAN_ARM);
// c'est select qui joue ce role
//UOn UOn::childSelect(ANY,   0, UMode::CHILD_SELECT_CB);
//UOn UOn::childUnselect(ANY, 0, UMode::CHILD_SELECT_CB);

UOn UOn::change(ANY,     UMode::CHANGE_CB, 0);
UOn UOn::propChange(ANY, UMode::CHILD_CHANGE_CB, 0);
UOn UOn::elemChange(ANY, UMode::CHILD_CHANGE_CB, 0);
UOn UOn::strChange(ANY,  UMode::CHILD_CHANGE_CB, 0);
//UOn UOn::caretChange(ANY,  UMode::CHILD_CHANGE_CB, 0);

UOn UOn::ktype(ANY,      UMode::KEY_CB, 0);
UOn UOn::kpress(ANY,     UMode::KEY_CB, 0);
UOn UOn::krelease(ANY,   UMode::KEY_CB, 0);

UOn UOn::mpress(ANY,     UMode::MOUSE_CB, 0);
//UOn UOn::mpress1(ANY,     UMode::MOUSE_CB, 0, UEvent::MButton1);
//UOn UOn::mpress2(ANY,     UMode::MOUSE_CB, 0, UEvent::MButton2);
//UOn UOn::mpress3(ANY,     UMode::MOUSE_CB, 0, UEvent::MButton3);
//UOn UOn::mlongpress(ANY, UMode::MOUSE_CB, 0);

UOn UOn::mrelease(ANY,   UMode::MOUSE_CB, 0);
//UOn UOn::mrelease1(ANY,   UMode::MOUSE_CB, 0, UEvent::MButton1);
//UOn UOn::mrelease2(ANY,   UMode::MOUSE_CB, 0, UEvent::MButton2);
//UOn UOn::mrelease3(ANY,   UMode::MOUSE_CB, 0, UEvent::MButton3);

UOn UOn::mrelax(ANY,     UMode::MOUSE_CB, 0);

// mouse click, double click, etc.
UOn UOn::mclick(ANY,     UMode::MOUSE_CB | UMode::MOUSE_CLICK_CB, 0);
UOn UOn::mbiclick(ANY,   UMode::MOUSE_CB | UMode::MOUSE_CLICK_CB, 0);
UOn UOn::mtriclick(ANY,  UMode::MOUSE_CB | UMode::MOUSE_CLICK_CB, 0);
UOn UOn::mquadclick(ANY, UMode::MOUSE_CB | UMode::MOUSE_CLICK_CB, 0);

UOn UOn::mdrag(ANY,    UMode::MOUSE_DRAG_CB, 0);
UOn UOn::mmove(ANY,    UMode::MOUSE_MOVE_CB, 0);

UOn UOn::enter(ENTERED,UMode::MOUSE_CROSS_CB, 0);
UOn UOn::leave(ANY,    UMode::MOUSE_CROSS_CB, 0);

// NB: action n'entraine pas necessairement CAN_ARM :
// ce n'est vrai que si on n'est pas en CAN_EDIT_TEXT
UOn UOn::action(IDLE,  0, 0/*UMode::CAN_ACTION*/);
UOn UOn::arm(ARMED,    0, UMode::CAN_ARM);
UOn UOn::disarm(ANY,   0, UMode::CAN_ARM);

//NB: idle is mainly used for conditional flags
UOn UOn::idle(IDLE,    0, 0);

UOn UOn::dragStart(ANY, 0, UMode::CAN_DRAG2);
UOn UOn::dragDone(ANY,  0, UMode::CAN_DRAG2);
UOn UOn::dropEnter(ANY, 0, UMode::CAN_DROP);
UOn UOn::dropLeave(ANY, 0, UMode::CAN_DROP);
UOn UOn::dropDone(ANY,  0, UMode::CAN_DROP);

UOn UOn::preChildEvent(ANY,  UMode::PRE_CHILD_EVENT_CB,0);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// NB: on_modes are added in order to make the UGroup & UBox parents
// sensitive to the action that is specified as the first argument

UOn::UOn(u_state state, u_modes b_modes, u_modes c_modes) : UCond() {
  istate = state;
  bmodes = b_modes;
  cmodes = c_modes;
}

// NB: programme' pour faire un OU entre modes et action
//
bool UOn::verifies(const UContext*, const class UCtrl *ctrl) const {
  /*
   TOUT CE QUI CONCEERNE LES MODES EST VIRE A PART SELECTION !
   if (mask & SELECTED) {
     bool b = ( (ctrl->modes & mask) == modes );
     b = b && ( (ctrl->mask & mask) == mask );
     // on est en mode OU => return true si une des conditions est validee
     if (b) return true;
   }
   */
  // A REVOIR!!
  if (this == &UOn::select) {
    return ctrl->isSelected();
  }
  else  if (this == &UOn::unselect) {
    return ! ctrl->isSelected();
  }

  //!!!PBM: pas le meme test que pour les callbacks!!
  if (istate != UOn::ANY)
    return (ctrl->istate == istate);
  else return false;
}

/* ==================================================== ======== ======= */
//NOTE: this function does not copy modes that are specific to its
//UMode argument (such as UCONST, UREF, etc.)
// !!!ATTENTION: PROBLEME
// setModes() pose probleme avec select/unselect car ce n'est pas un mode
// qu'il faut propager au parent mais juste un referent pour le UOn
// (pour l'instant c'est regle en ne rajoutant pas ces modes et
// en testant directement l'egalite des UOn dans fire() et match()

void UOn::setParentModes(UCtrl *p/*parent*/) const {
  // B modes
  // ATTENTION: certains modes (UMode::CANT_DEL etc...) sont propres
  // a l'objet 'm' et ne doivent surtout PAS ETRE PROPAGES au Uctrl !!!
  p->bmodes = p->bmodes | (bmodes & ~UMode::DONT_PROPAGATE);
  // C modes
  p->cmodes = p->cmodes | cmodes;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UNotCond::UNotCond(const UCond& _cond) : cond(_cond) {}

bool UNotCond::verifies(const UContext *ctx, const class UCtrl* ctrl) const {
  return !cond.verifies(ctx, ctrl);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

const UFlag UFlag::none;

UFlag::UFlag(const char* _name) :
name(_name ? CStr::strdup(_name) : null),
not_cond(null) {
}

bool UFlag::verifies(const UContext *ctx, const class UCtrl*) const {
  return (ctx->getFlagdef(this) != null);
}

UCond& UFlag::operator!() const {
  if (!not_cond) not_cond = new UNotCond(*this);
  return *not_cond;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

USrange::USrange(int smin, int smax) {
  scale_min = smin, scale_max = smax;
}

USrange& usrange(int scale_min, int scale_max) {
  return *new USrange(scale_min, scale_max);
}

bool USrange::verifies(const UContext *ctx, const class UCtrl*) const {
  //NB: lscale = LOGICAL scale
  return (ctx->lscale >= scale_min && ctx->lscale <= scale_max);
};

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

