/* ==================================================== ======== ======= *
 *
 *  ufilebox.hh
 *  Ubit Project  [Elc][2003]
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ufilebox_hh
#define	_ufilebox_hh
#include <ubit/uchoice.hpp>
//pragma ident	"@(#)ufilebox.hh	ubit:03.03.00"


/* File chooser.
 * This object is a subclass of UBox.
 * You can include it into a UDialog or a UMenu to create a File Dialog Choser:
 * 
	* examples: 
	* <pre>
	*   UDialog& filedial = udialog(ufilebox())
	*   UMenu&   filemenu = umenu(ufilebox())
	* </pre>
 */
class UFilebox : public UBox {
public:
  UFilebox(const UArgs& a = UArgs::none);
  ///< constructor.

  friend UFilebox& ufilebox(const UArgs& a = UArgs::none);
  ///< creator shortcut: equivalent to: *new UFilebox().

  virtual ~UFilebox();

  virtual void showHiddenFiles(bool);
		virtual void showDirOnly(bool);
		virtual void showList(bool);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  virtual const UStr& getDir() const;
  ///< returns the directory of the file (without the file name).

  virtual const UStr& getName() const;
  ///< returns the name of the file (without the directory).

  virtual const UStr& getPath() const;
  ///< returns the full pathname: getDir()/getName().

  virtual const UStr& getFilter() const;
  ///< returns the extension filter.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  virtual void setDir(const UStr&);
  ///< note that setDir and setFilter reload the directory.

  virtual void setName(const UStr&);

  virtual void setFilter(const UStr&);
  ///< syntax: "C++ Files (*.cpp; *.hpp)" or "*.cc; *.hh" or "*.*" 

  virtual void changeDir(UStr* dirpath);
  /**< sets the directory in a relative way.
   * notes:
   * - goes to the parent directory if arg is ".."
   * - goes to subdirectory "xxx" if arg is "xxx" 
			*/

  virtual void rescan();
  ///< rescans the directory and updates the display.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  virtual void cancelBehavior(class UEvent&);
  virtual void okBehavior(class UEvent&, const UStr&);
  virtual void selectBehavior(class UEvent&, const UStr&);
  /**< these functions implement the behavior of the File box and can be redefined.
   * conditions: these fcts. are called when:
   * - selectBehavior : an item is selected (= simple clicked) 
   * - okBehavior : an item is double clicked or the OK button is clicked
   * - cancelBehavior : the Cancel button is clicked
   *
   * actions:
   * - selected, and cancelBehavior close the window.
   * - then okBehavior() fires the 'UOn::action' callbacks that are 
   *   attached to the FileDialog
   * - and selectBehavior fires the 'UOn::childSelect' callbacks
   * examples:
   *  -  ufilebox( UOn::action / ucall(this, &MyClass::memberfun, arg) )
   *  -  ufilebox( UOn::action / ucall(globfun, arg))
   */

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		// Impl.

protected:
  UStr fname, fdir, ffilter;
  mutable UStr fdir2, fpath;
  class UScrollpane *scrollpane;
  class UBox *viewport;
  class UButton *show_list, *show_hidden_files, *show_dirs_only;
  URadioSelect new_sel;
};

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
#endif

