#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// should be in header file

class Demo : public UFrame {
public:
	Demo();

private:
	ULabel label;
	UButton b1, b2, b3;
	UColor   color;		             // foreground color property
	UBgcolor bgcolor;		           // background color property

	virtual void doIt(UEvent&);   // callback function
};

// end of header - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int main(int argc, char* argv[]) {
	UAppli appli(&argc, argv);

	Demo frame;
	appli.add(frame);
	frame.show(true);

	return appli.mainLoop();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Demo::Demo() {
	
	// here we initialize the bgcolor and color instance variables
	// UColor::yellow, etc. are predefined constants (see class UColor)
	bgcolor = UColor::yellow;
	color   = UColor::red;
	
	addlist
	(
		UOrient::horizontal 		// predef constant that specifies an horizontal layout

		+ b1.addlist( UBgcolor::wheat + "Button 1" + ucall(this, &Demo::doIt) )
		+ b2.addlist( UFont::italic   + "Button 2" + ucall(this, &Demo::doIt) )
	 + b3.addlist( UFont::bold     + "Button 3" + ucall(this, &Demo::doIt) )
		
		// color and bgcolor specify the foreground and background colors of this
		// widget. As the child list is evaluated in the left-to-right order they
		// MUST be inserted BEFORE the string
		+ label.addlist( color + bgcolor + "Hello World!" )
		);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void Demo::doIt(UEvent& e) {
	UGroup* which_button = e.getSource();

	if (which_button == &b1) {
		// swap the foreground and background colors of the label
		UColor tmp = color;
		color = bgcolor;
		bgcolor = tmp;
	}

	else if (which_button == &b2)
		// change the sensibility of the last button
		b3.setEnabled(! b3.isEnabled());

	else if (which_button == &b3)
		// quit the application
  UAppli::quit(0);
}


