/* ==================================================== ======== ======= *
 *
 *  uutable.cc
 *  Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uutable.cc	ubit:001.11.5"
#include <udefs.hh>
#include <ubrick.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ucontext.hh>
#include <ubox.hh>
#include <uborder.hh>
#include <uview.hh>
#include <uviewImpl.hh>
#include <ucolor.hh>
#include <uevent.hh>
#include <uwin.hh>
#include <uappli.hh>
#include <ugraph.hh>
#include <utable.hh>
#include <ustyle.hh>
#include <math.h>

#define TAB_QUANTUM 15

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

const UClass UTable::uclass("UTable");
UStyle *UTable::style = null;

const UStyle* UTable::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->viewStyle      = &UTableView::style;
    style->local.orient   = UOrient::vertical.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::top.get();
    style->local.hspacing = 0; //EX 1;
    style->local.vspacing = 1;
    style->local.padding.set(1, 1); //!!EX: 0,0
  }
  return style;
}

UTable::UTable(UArgs a): UBox(a) {}
UTable& utable(UArgs l) {return *(new UTable(l));}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

const UClass UTrow::uclass("UTrow");
UStyle *UTrow::style = null;

const UStyle* UTrow::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    //style->local.valign   = UValign::top.get(); //EX!!
    style->local.valign   = UValign::flex.get();
    style->local.hspacing = 1;
    style->local.vspacing = 0;  //EX 1
    style->local.padding.set(0, 0);
  }
  return style;
}

UTrow::UTrow(UArgs a): UBox(a) {}
UTrow& utrow(UArgs l) {return *(new UTrow(l));}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

const UClass UTcell::uclass("UTcell");
UStyle *UTcell::style = null;

const UStyle* UTcell::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->viewStyle      = &UFlowView::style;
    style->local.orient   = UOrient::horizontal.get();  ///????
    style->local.halign   = UHalign::flex.get();
    style->local.valign   = UValign::flex.get();
    style->local.hspacing = 0;  //!!EX 1;
    style->local.vspacing = 0;  //!!EX 1;
    //style->local.padding.set(1,1);
    style->local.padding.set(0,0); //EX: 1,1
  }
  return style;
}

UTcell& utcell(UArgs a) {
  return *(new UTcell(a));
}
UTcell& utcell(short colspan, UArgs a) {
  return *(new UTcell(colspan, a));
}
UTcell& utcell(short colspan, short rowspan, UArgs a) {
  return *(new UTcell(colspan, rowspan, a));
}

UTcell::UTcell(UArgs a): UFlowbox(a) {
  colspan = 1;
  rowspan = 1;
}
UTcell::UTcell(short _colspan, UArgs a) : UFlowbox(a) {
  colspan = _colspan;
  rowspan = 1;
}
UTcell::UTcell(short _colspan, short _rowspan, UArgs a) : UFlowbox(a) {
  colspan = _colspan;
  rowspan = _rowspan;
}

void UTcell::setColspan(short _colspan) {
  colspan = _colspan;
  update(UUpdate::layout);
}

void UTcell::setRowspan(short _rowspan) {
  rowspan = _rowspan;
  update(UUpdate::layout);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UViewStyle UTableView::style(&UTableView::makeView, UMode::UCONST);

UTableView::UTableView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) 
  : UView(box_link, par_view, wgraph) {}

// "static" constructor used by UViewStyle to make a new view
//
UView* UTableView::makeView(UBoxLink*bl, UView* parview, 
			    UWinGraph *wgraph){
  return new UTableView(bl, parview, wgraph);
}

UTableView::~UTableView() {}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

struct ViewCell {
  u_dim min_dim, max_dim, spec_dim;
  static ViewCell* augment(ViewCell *tab, u_card &count, int span = 1);
};

ViewCell* ViewCell::augment(ViewCell *tab, u_card &count, int span) {
  int quantum = U_MAX(span, TAB_QUANTUM);
  if (!tab) {
    count = quantum;
    tab = (ViewCell*)malloc(sizeof(ViewCell) * count);
  }
  else {
    count += quantum;
    tab = (ViewCell*)realloc(tab, sizeof(ViewCell) * count);
  }
  if (!tab) uerror("ViewCell::augment", "Not enough memory to display the table");
  else for (int k = count - quantum; k < count; k++) {
    tab[k].min_dim = tab[k].max_dim = tab[k].spec_dim = 0;
    //tab[k].mode = UViewLayout::COMP_BY_CHILD;
  }
  return tab;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

struct UTableLayoutData : public ULayoutData {
  ViewCell *cols, *lines;
  u_card ccur, ccount, cmax, lcount, lmax; 

  UTableLayoutData(UView *v) : ULayoutData(v) {
    cmax = lmax = 0;
    cols  = ViewCell::augment(null, cmax);
    lines = ViewCell::augment(null, lmax);
    ccur = ccount = lcount = 0;
  }
};

/* ==================================================== ======== ======= */

static void tableDoLayout(UTableLayoutData &vd, UContext &curp, 
			  UGroup *grp, UViewLayout &vl);

u_bool UTableView::doLayout(UContext &parp, UViewLayout &vl) {
  UBox *box = getBox();
  UTableLayoutData vd(this);

  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;

  // !!PREMIER ROUND!!
  vl.strategy = UViewLayout::GET_HINTS;
  //tableDoLayout2(this, box, parp, vd, vl);

  UContext curp(box, this, parp);
  tableDoLayout(vd, curp, box, vl);

  // vl.spec_w >=0 means: "table width was explicitely specified"
  // vl.spec_w < 0 means: "table uses as many space as needed"
  //
  if (vl.spec_w < 0) {
    //favoriteWidth = vl.cmax_w;
    //if (!vl.keepSize) width = favoriteWidth;
    //nb: sinon si (keepSize) valeur precedente de width conservee

    for (int c = 0; c < vd.ccount; c++)  {
      vd.cols[c].spec_dim = vd.cols[c].max_dim;
    }
  }

  else {  // (vl.spec_w >= 0)   la width de la table est specifiee
    //REGLES: cell.uwidth est un 'hint':
    // - cell.w est tjrs >= cell.wmin qqsoit specif. cell.uwidth
    // - cell.w est < cell.uwidth si table.uwidth pas assez grande

    //@@vl.wmode = UViewLayout::FIXED_BY_CHILD;

    // spec. table.uwidth > max computed witdh ==> agrandir les cells
    if (vl.spec_w >= vl.cmax_w) {

      // 'fill_prop' = coefficient pour fill proportionnel =
      // (fill_w = used - reste_) / reste

      if (vl.cmax_w <= 0) vl.cmax_w = 1; //securite
      float fill_prop = (vl.spec_w - vl.cmax_w) / (float)vl.cmax_w;

      //favoriteWidth = vl.cmax_w = vl.spec_w; //?? ou le cmax_w ?
      //if (!vl.keepSize) width = favoriteWidth;

      // favorite doit etre le MAX de la taille desiree et de la taille
      // requise par les enfants (sinon le scroll ne marchera pas dans
      // le 1e cas et le 'flex' ne marchera pas dans le second)
      //favoriteWidth = UMAX(vl.spec_w, vl.cmax_w);
      //width = vl.spec_w;

      for (int c = 0; c < vd.ccount; c++)  {
	// l'agrandissement est proportionnel au contenu de la cell
	vd.cols[c].spec_dim = 
	  vd.cols[c].max_dim + (u_dim)(vd.cols[c].max_dim * fill_prop);
      }
    }

    // spec. table.uwidth > min computed witdh ==> reduire les cells
    else if (vl.spec_w >= vl.cmin_w) {

      // 'fill_prop' = coefficient pour fill proportionnel =
      // (fill_w = used - reste_) / reste
      if (vl.cmax_w <= 0) vl.cmax_w = 1; //securite

      // !!! A REVOIR: FAIRE PROPORTION PAR RAPPORT AU MAX PAS AU MIN !!!
      // et tenir compte des SPECS
      float fill_prop = (vl.spec_w - vl.cmin_w) / (float)vl.cmin_w;

      //favoriteWidth = UMAX(vl.spec_w, vl.cmax_w);
      //width = vl.spec_w;

      for (int c = 0; c < vd.ccount; c++)  {
	// taille min + proportion liee a la taille du max
	//??imposer(vd.cols[c].min_dim + ?? vd.cols[c].max_dim * fill_prop);
	vd.cols[c].spec_dim =
	  vd.cols[c].min_dim + (u_dim)(vd.cols[c].min_dim * fill_prop);
      }
    }

    // spec. table.uwidth < min computed witdh ==> imposer cell.wmin
    else /*(vl.spec_w < vl.wmin)*/ {

      // !ATTENTION: diffs importantes avec hbox/vbox:
      // -- table.w est toujours >= somme{cells.wmin} qqsoit table.uwidth
      //    (==> les enfants ne sont jamais caches par les tables)
      // -- cell.finalw est tjrs >= cell.wmin qqsoit cell.uwidth
      // -- cell.finalw est < cell.uwidth si table.uwidth trop petite
      //
      //favoriteWidth = vl.wmin;
      //if (!vl.keepSize) width = favoriteWidth;

      for (int c = 0; c < vd.ccount; c++)  {
	 vd.cols[c].spec_dim = vd.cols[c].min_dim;
      }
    }

    // ENSUITE faudra voir les pourcentages des cells......!!!!
  }

  //else {
    // la table a une width proportionnelle....!!!
  // ........
  //}

  //printf("UTableView::doLayout:  fin part1: vd.ccount = %d -- vd.lcount = %d \n",
  //	 vd.ccount, vd.lcount);

  vd.mustLayoutAgain = false;
  //inutile vd.view = this;

  //FAUX:  vd.cmax = vd.lmax = 0;
  //FAUX:vd.cols  = ViewCell::augment(null, vd.cmax);
  //FAUX:d.lines = ViewCell::augment(null, vd.lmax);

  int k;
  for (k = 0; k < vd.ccount; k++)
    vd.cols[k].min_dim = vd.cols[k].max_dim = 0;  //!PAS tab[k].spec_dim = 0;

  for (k = 0; k < vd.lcount; k++)
    vd.lines[k].min_dim = vd.lines[k].max_dim = 0; //!PAS tab[k].spec_dim = 0;

  vd.ccur = vd.ccount = vd.lcount = 0; //APRES!

  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;


  // !!DEUXIEME ROUND!!
  vl.strategy = UViewLayout::IMPOSE_WSIZE;
  //tableDoLayout2(this, box, parp, vd, vl);

  UContext curp2(box, this, parp);
  tableDoLayout(vd, curp2, box, vl);

#if KKKK
printf("BEFORE>>>>vl.spec_w %d, vl.cmax_w %d\n", vl.spec_w, vl.cmax_w);

  // value >=0 means: "fixed width"
  if (vl.spec_w >= UWidth::keepSize) { 
    // vl.wmode = UViewLayout::FIXED_BY_CHILD;

    if (/*!curp.boxIsHFlex ||*/ width <=0) {   // w <=0 : initialization
      // favorite doit etre le MAX de la taille desiree et de la taille
      // requise par les enfants (sinon le scroll ne marchera pas dans
      // le 1e cas et le 'flex' ne marchera pas dans le second)

      printf("INSIDE>>>>vl.spec_w %d, vl.cmax_w %d \n", vl.spec_w, vl.cmax_w);
      favoriteWidth = U_MAX(vl.spec_w, vl.cmax_w);
      //width = vl.spec_w;
      //...fixedSizes = FIXED_WIDTH;

      // HTML agrandit la taille spec si necessaire pour que tous les enfants
      // soient visibles (meme s'ils sont reduits)
      width = favoriteWidth;
    }
  }
  else {
    favoriteWidth = vl.cmax_w;
    if (!vl.keepSize) width = favoriteWidth;
    //else if(keepSize) valeur precedente de width conservee
 }
#endif
  // FAIT CHIER!
  favoriteWidth = width = U_MAX(vl.spec_w, vl.cmax_w);

  if (vl.spec_h >= UHeight::keepSize) { 
    // vl.hmode = UViewLayout::FIXED_BY_CHILD;
    if (/*!curp.boxIsVFlex ||*/ height <=0) {  // w <=0 : initialization
      // voir note pour favorite_w ci-dessus.
      favoriteHeight = U_MAX(vl.spec_h, vl.cmax_h);
      
      //if (fixedSizes == FIXED_WIDTH) fixedSizes = FIXED_SIZE;
      //else fixedSizes = FIXED_HEIGHT;
      setVmodes(UView::FIXED_HEIGHT, true);

      if (vl.spec_h == UHeight::keepSize)
	height = favoriteHeight; //init to favorite
      else 
	height = vl.spec_h;// init to spec.
    }
  }
  else {
    favoriteHeight = vl.cmax_h;
    ////obs: if (!vl.keepSize) height = favoriteHeight;
    height = favoriteHeight;
  }  

  //... afficher les padding

  //printf("UTableView::doLayout:  fin part2: vd.ccount = %d -- vd.lcount = %d \n\n",
  //	 vd.ccount, vd.lcount);

  if (vd.cols) free(vd.cols);
  if (vd.lines) free(vd.lines);

  ///shown = false;
  //  printf("////width = %d\n\n", width);

  // IMPORTANT:  Height depend de Width pour les UFlowView
  // ceci impose de refaire une seconde fois le layout du parent
  // (sauf dans le cas ou Width est fixe a priori auquel cas Height
  // (peut directement etre determine des la premier passe)
  //  return vd.mustLayoutAgain;
  return false;
};

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

static void rowDoLayout2(UView *row_view, UGroup *grp, UContext &parp, 
			 UTableLayoutData &vd, UViewLayout &vl);

static void tableDoLayout(UTableLayoutData &vd, UContext &curp, 
			  UGroup *grp, UViewLayout &vl) {

  //ULink *ch = vd.view->doPrelude(grp, curp);
  UMultiList mlist(curp, grp);

  /* mis a la fin
     if (grp->boxCast()) {
     whint = curp.local.width;
     hhint = curp.local.height;
  */

  if (curp.local.content) {
    // pas de curp, meme vd
    UGroup *content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    tableDoLayout(vd, curp, content, vl);
  }

  //for ( ; ch != null; ch = ch->next())
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->brick();
      UView *chboxview = null;
      UGroup *chgrp = null; //!att reinit!
      UViewLayout chvl;  //att: reset by constr.

      if (b->propCast())  
	  b->propCast()->putProp(&curp, grp);

      //else if ((chgrp = b->groupNotBoxCast())) { 
      else if ((chgrp = dynamic_cast<UGroup*>(b))
	       && chgrp->isDef(0, UMode::GROUP)
	       ) {
	if (chgrp->isShowable()) {
	  //tableDoLayout2(table_view, chgrp, curp, vd, vl);
	  // own curp, same vd
	  UContext chcurp(chgrp, vd.view, curp);
	  tableDoLayout(vd, chcurp, chgrp, vl);
	}
      }

      else if (b->itemCast()) {
	/* normalement y'en a pas
	   b->itemCast()->getSize(&curp, &chw, &chh);
	   vd.children_w += chw;
	   if (ch->next()) vd.children_w += curp.local.hspacing;// FAUX!!!
	   if (chh > vd.children_h) vd.children_h = chh;  // =MAX()
	*/
      }
      
      else if ( //(chgrp = b->boxCast())
	        chgrp
		&& chgrp->isShowable()
		&& chgrp->isDef(0, UMode::BOX)
		//&& (chboxview = ((UBoxLink*)ch)->getView(table_view))
		&& (chboxview = ((UBoxLink*)ch)->getView(vd.view))
		) { 

	if (chgrp->isDef(0, UMode::FLOATING) || ch->floatingCast()) {
	  //chvl.wmode = UViewLayout::COMP_BY_CHILD;
	  //chvl.hmode = UViewLayout::COMP_BY_CHILD;
	  chvl.strategy = vl.strategy;
	  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	}

	// cas (normal) des UTrow (Table Rows)
  	else if ((dynamic_cast<UTrow*>(b)) != null) {

	  // agrandir lines;
  	  if (vd.lcount >= vd.lmax) 
  	    vd.lines = ViewCell::augment(vd.lines, vd.lmax);
	  
	  //POUR prem STEP !!!!
	  //a voir: chvl.wmode =vd.cols[c].wmode
	  //@@chvl.wmode = UViewLayout::COMP_BY_CHILD;
	  //@@chvl.hmode = UViewLayout::COMP_BY_CHILD;

	  // fonction specifique pour TableRows
	  chvl.strategy = vl.strategy; //!!
  	  rowDoLayout2(chboxview, b->boxCast(), curp, vd, chvl);
  	  vd.lcount++;
  	}

  	// Autres cas
  	else {
  	  uwarning("tableDoLayout", 
  		  "Wrong object type: UTable(s) can only contain UTRow(s)");
  	}
      }
    }

  // la suite ne concerne pas les UGroup
  if (grp->boxCast()) {

    // a la ligne final
    // Les UTable COMMENCENT et se TERMINENT par un alaligne! A COMPTER!!
    //alaligne(vl, curp);

    // NOTE That: value >=0 means: "fixed width"
    vl.spec_w = curp.local.width;
    vl.spec_h = curp.local.height;
    // whint et hhint seront negatifs si indefinis
    // ==> ne PAS y toucher, meme si definis et < valeurs min
 
    // rajouters  borders et marges
    UMargin magin(0, 0, 0, 0);
    if (curp.local.border) {
      //curp.local.border->getSize(vd.view,  &curp, &magin);
      curp.local.border->doLayout(vd.view, curp, magin);
    }

    vl.cmax_w = vl.cmin_w =
      magin.left + magin.right	// borders
      + curp.local.padding.left + curp.local.padding.right
      + curp.local.hspacing * (vd.ccount - 1); // total spacing between colums 

    // NB: (un column-spacing de moins que le nbre de cols)
    // retrancher le spacing compte en trop (si au moins un element)
    //if (vl.cmax_w > 0) vl.cmax_w -= curp.local.hspacing; 
    //if (vl.cmax_h > 0) vl.cmax_h -= curp.local.vspacing; 

    vl.cmax_h = vl.cmin_h =
      magin.top + magin.bottom	// borders
      + curp.local.padding.top + curp.local.padding.bottom
      + curp.local.vspacing * (vd.lcount - 1);

    for (int c = 0; c < vd.ccount; c++)  {
      vl.cmin_w += vd.cols[c].min_dim;
      vl.cmax_w += vd.cols[c].max_dim;
    }

    for (int l = 0; l < vd.lcount; l++)  {
      vl.cmin_h += vd.lines[l].min_dim;
      vl.cmax_h += vd.lines[l].max_dim;
      //printf("tableDoLayout add h: h=%d  total=%d \n",
      //	     vd.lines[l].max_dim,vl.cmax_h);
    }
  } 
} 

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

static int setHintSizes(UView *chboxview, UContext &curp, int colspan, 
			UTableLayoutData &vd, UViewLayout &chvl) {
  chvl.strategy = UViewLayout::GET_HINTS;
  ((UFlowView*)chboxview)->getHints(curp, chvl);

  int cmin_w = (int)rint((double)chvl.cmin_w / colspan);
  int cmax_w = (int)rint((double)chvl.cmax_w / colspan);
  int spec_w = (int)rint((double)chvl.spec_w / colspan);

  for (int colk = vd.ccur; colk < vd.ccur+colspan; colk++) {
    // col width
    vd.cols[colk].min_dim  = U_MAX(vd.cols[colk].min_dim, cmin_w);
    vd.cols[colk].max_dim  = U_MAX(vd.cols[colk].max_dim, cmax_w);
    vd.cols[colk].spec_dim = U_MAX(vd.cols[colk].spec_dim, spec_w);
    //vd.cols[vd.ccur].mode = chvl.wmode;
  }

  // line height
  vd.lines[vd.lcount].min_dim = 
    U_MAX(vd.lines[vd.lcount].min_dim, chvl.cmin_h);
	      
  vd.lines[vd.lcount].max_dim = 
    U_MAX(vd.lines[vd.lcount].max_dim, chvl.cmax_h);
  
  vd.lines[vd.lcount].spec_dim = 
    U_MAX(vd.lines[vd.lcount].spec_dim, chvl.spec_h);
  
  //vd.lines[vd.lcount].mode = chvl.hmode;

  //inutile dans le cas GET_HINT?
  return chvl.cmax_w;
}

/* ==================================================== ======== ======= */

static int setImposedSizes(UView *chboxview, UContext &curp, int colspan, 
			   UTableLayoutData &vd, UViewLayout &chvl) {
  chvl.spec_w = 0;
  for (int colk = vd.ccur; colk < vd.ccur+colspan; colk++) {
    chvl.spec_w += vd.cols[colk].spec_dim;
  }

  chvl.strategy = UViewLayout::IMPOSE_WSIZE;
  chboxview->doLayout(curp, chvl);

  int cmax_w = (int)rint((double)chvl.cmax_w / colspan);

  for (int colk = vd.ccur; colk < vd.ccur+colspan; colk++) {
    //!att: min pas calcule, max = taille trouvee
    // et !!calcul different du cmax_w dans le UFlowbox
    vd.cols[colk].max_dim = U_MAX(vd.cols[colk].max_dim, cmax_w);
  }

  vd.lines[vd.lcount].max_dim = 
      U_MAX(vd.lines[vd.lcount].max_dim, chvl.cmax_h);

  return chvl.cmax_w;
}

/* ==================================================== ======== ======= */

//!! curp pas parp!
static void rowDoLayout2(UView *row_view, UGroup *grp, UContext &parp, 
			 UTableLayoutData &vd, UViewLayout &vl) {

  UContext curp(grp, row_view, parp);
  //ULink *ch = row_view->doPrelude(grp, curp);
  UMultiList mlist(curp, grp);

  if (grp->boxCast()) {
    vd.ccur = 0; //que pour les URow !!!
    vl.line_w = 0;
  }

  //for ( ; ch != null; ch = ch->next())
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
	
      UBrick *b = ch->brick();
      UView *chboxview = null;
      UGroup *chgrp = null; //!att reinit!
      UViewLayout chvl; //att: reinit by constr.

      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);

      else if ((chgrp = dynamic_cast<UGroup*>(b))
	       && chgrp->isDef(0, UMode::GROUP)
	       ) {
	if (chgrp->isShowable())
	  rowDoLayout2(row_view, chgrp, curp, vd, vl);
      }
      
      else if (b->itemCast()) {
	/* normalement interdits
	   b->itemCast()->getSize(&curp, &chw, &chh);
	   vd.children_w += chw;
	   if (ch->next()) vd.children_w += curp.local.hspacing; //FAUX!
	   if (chh > vd.children_h) vd.children_h = chh;  //=MAX()
	*/
	uwarning("UTrow::doLayout", 
		 "Wrong object type: %s:\nTable Rows should contain UTcell, UBox or UGroup objects (and subclasses)", b->cname());
      }
      
      else if (chgrp
	       && chgrp->isShowable()
	       && chgrp->isDef(0, UMode::BOX)
	       && (chboxview = ((UBoxLink*)ch)->getView(row_view))
	       ) { 
	
	if (chgrp->isDef(0, UMode::FLOATING) || ch->floatingCast()) {
	  //chvl.wmode = UViewLayout::COMP_BY_CHILD;
	  //chvl.hmode = UViewLayout::COMP_BY_CHILD;
	  chvl.strategy = vl.strategy;
	  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	}
	
	else {	// cas normal
	  int colspan = 1;  //default
	  
	  //cas des UTcell: peuvent avoir un colspan et un rowspan
	  UTcell *cell = dynamic_cast<UTcell*>(b);
	  if (cell) {
	    colspan = cell->getColspan();
	    //rowspan = ... A FINIR!
	  }

	  // agrandir cols;
	  if (vd.ccur + (colspan-1) >= vd.cmax) 
	    vd.cols = ViewCell::augment(vd.cols, vd.cmax, colspan);
	  
	  //pour prem step
	  //a voir: chvl.wmode =vd.cols[c].wmode
	  //chvl.wmode = UViewLayout::COMP_BY_CHILD;
	  //chvl.hmode = UViewLayout::COMP_BY_CHILD;
	  
	  if (vl.strategy == UViewLayout::GET_HINTS) {
	    // obtenir taille souhaitee
	    vl.line_w += setHintSizes(chboxview, curp, colspan, vd, chvl);
	  }
	  
	  else if (vl.strategy == UViewLayout::IMPOSE_WSIZE) {
	    // imposer taille
	    vl.line_w += setImposedSizes(chboxview, curp, colspan, vd, chvl);
	  }

	  else uwarning("UTrow::doLayout","Internal error: wrong ViewLayout mode");
	  
	  // passer a la Nieme colonne suivante
	  vd.ccur += colspan;

	} //endfor(cas normal)	
      }
    }
  
  //ccount = MAX de c pour chaque ligne
  vd.ccount = U_MAX(vd.ccount, vd.ccur);

  if (grp->boxCast() && vl.strategy == UViewLayout::IMPOSE_WSIZE) {
    row_view->width = vl.line_w;
    // faudrait egalement regarder les SPEC !!
    row_view->height = vd.lines[vd.lcount].max_dim;

    //printf("rowDoLayout2 %d: setSize: w=%d  h=%d \n",
    //	   row_view, row_view->width, row_view->height);
  }
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */

