/* ==================================================== ======== ======= *
 *
 *  uscroll.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uscroll_hh
#define	_uscroll_hh
//pragma ident "@(#)uscroll.hh	ubit:b1.11.7"
#include <uview.hh>
#include <ugadgets.hh>

// Shortcuts:
// Note: 'orientation' is one of:  UScrollbar::horizontal 
// or UScrollbar::vertical (see notes below for details)

class UScrollbar& uscrollbar(const UOrient&, UArgs = UArgs::none);
class UScrollbar& uhscrollbar(UArgs = UArgs::none);
class UScrollbar& uvscrollbar(UArgs = UArgs::none);

// creates a ScrollPane with two scrollbars
class UScrollPane& uscrollPane(UArgs = UArgs::none);
class UScrollPane& uscrollpane(UArgs = UArgs::none);

// creates a UScrollPane with 0, 1 or 2 scrollbars:
class UScrollPane& uscrollPane(int vertical_scrollbar_mode,
			       int horizontal_scrollbar_mode,
			       UArgs = UArgs::none);
class UScrollPane& uscrollpane(int vertical_scrollbar_mode,
			       int horizontal_scrollbar_mode,
			       UArgs = UArgs::none);

class UPane& upane(UArgs = UArgs::none);

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

class UScrollbarStyle {
public:
  UStyle *scrollbar, *slider, *lessScroller, *moreScroller;

  UScrollbarStyle(const UScrollbarStyle *model);
  void set(const UScrollbarStyle *model);  //copies the model
};

class UScrollbar: public UBox {
  friend class UScrollbarView;
protected:
  float val;
  short incr, orient;
  UPos pos;
  class UButton *slider, *moreScroller, *lessScroller;
  class UPane* pane; //the pane that is controlled by the scrollbar
  class UScrollbarView* activeView; //the view where intearction takes place
public:
  static const UClass uclass;
  // horizontal and vertical Scrollbar styles
  static UScrollbarStyle *horizontalStyle, *verticalStyle;

  /* = = = = = = = = = = = = = = = = = = = = = = = = = = */

  class Slider: public UButton {
  public:
    virtual const UStyle* getStyle(const UBox *parent);
    Slider(UArgs = UArgs::none);
  };

  class LessScroller: public UButton {
  public:
    virtual const UStyle* getStyle(const UBox *parent);
    LessScroller(UArgs = UArgs::none);
  };

  class MoreScroller: public UButton {
  public:
    virtual const UStyle* getStyle(const UBox *parent);
    MoreScroller(UArgs = UArgs::none);
  };

  /* = = = = = = = = = = = = = = = = = = = = = = = = = = */

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  virtual const UScrollbarStyle* getScrollbarStyle(const UBox *parent);
  virtual UButton *makeSlider(UArgs = UArgs::none);
  virtual UButton *makeLessScroller(UArgs = UArgs::none);
  virtual UButton *makeMoreScroller(UArgs = UArgs::none);

  static const UOrient &horizontal, &vertical;
  static const int never, always; //as_needed : not yet available)

  // 'orientation' must be:  UScrollbar::horizontal or UScrollbar::vertical
  UScrollbar(const UOrient &orientation, UArgs = UArgs::none);
  ~UScrollbar();

  // value : float between 0.0 and 100.0
  void  setValue(float percent);
  float getValue()     {return val;}
  void  setIncr(int i) {incr = i;}
  int   getIncr()      {return incr;}

  //attach the scrollbar to a UPane or a ScrollPane
  void setPane(class UPane*);

protected:
  void pressSlider(UEvent*e);
  void dragSlider(UEvent*e);
  void releaseSlider(UEvent*e);
  void pressScroller(UEvent*e, int dir);
  void pressBackground(UEvent*e);
};

/* ==================================================== [Elc:98] ======= */
/* ==================================================== ======== ======= */

class UPane: public UBox {
  friend class UPaneView;
  friend class UScrollbar;
protected:
  UBoxLink *viewportLink;
  UScrollbar *hscrollbar, *vscrollbar;
  float xscroll, yscroll;
public:
  static const UClass  uclass;
  static UStyle *style;

  UPane(UArgs = UArgs::none);
  virtual ~UPane();

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  // returns the current Viewport (ie. the scrolled box in the center area)
  // if any (null otherwise)
  UBox *getViewport();

  // returns the Viewport View corresponding to a given Pane View
  UView *getViewportView(UView *pane_view);

  // the scroll values are between 0.0 and 100.0
  float getXScroll() {return xscroll;}
  float getYScroll() {return yscroll;}

  void  scroll(float xscroll, float yscroll, u_bool update_scrollbars = true);
  void  setXScroll(float _xscroll) {scroll(_xscroll, -1);}
  void  setYScroll(float _yscroll) {scroll(-1, _yscroll);}

  // return the Vertical and Horizontal Scrollbars (if any: null otherwise)
  UScrollbar* getVScrollbar();
  UScrollbar* getHScrollbar();

  // Set the Vertical and Horizontal Scrollbars
  // Notes:
  // - if 'add_to_pane' is true (default case), the scrollbar is added to
  //   the Pane child list and it will appear inside the Pane.
  // - otherwise, the scrollbar is NOT added to the Pane and MUST be added
  //   as a child of another box. This makes it possible to CONTROL a Pane
  //   by a scrollbar that is NOT included in this Pane.

  void setVScrollbar(UScrollbar*, u_bool add_to_pane = true);
  void setHScrollbar(UScrollbar*, u_bool add_to_pane = true);

  //package_private: ====[internal implementation]=================
  void _setViewportLink(UBoxLink*);
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// UScrollPane = UPane with scrollbars

class UScrollPane: public UPane {
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  // creates a UScrollPane with 2 scrollbars
  UScrollPane(UArgs = UArgs::none);

  // creates a UScrollPane with 0, 1 or 2 scrollbars:
  // - policy must be: UScrollbar::never or UScrollbar::always
  // - (NB: policy UScrollbar::as_needed is not yet available)

  UScrollPane(int horizontal_scrollbar_policy,
	      int vertical_scrollbar_policy,
	      UArgs = UArgs::none);

  //inherited from UPane:
  // - getVScrollbar, getHScrollbar
  // - setVScrollbar, setHScrollbar
};

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UScrollbarView : public UView {
protected:
  int lastmouse, scrollmin, scrollmax;
public: 
  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}

  UScrollbarView(UBoxLink*, UView* parview, UWinGraph*);

  //package_private: ====[internal implementation: do not use]===============

  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);
  virtual u_bool doLayout(UContext&, class UViewLayout&);
  virtual void doUpdate(UContext&, URegion r, URegion clip, class UViewUpdate&);

  virtual void setScroll(float percent);
  int getScrollMin() {return scrollmin;}
  int getScrollMax() {return scrollmax;}
  int getLastMouse() {return lastmouse;}
  void setLastMouse(int m) {lastmouse = m;}
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UPaneView: public UView {
  friend class UPane;
  friend class UScrollbar;
public:
  UMargin margin, frame;
  u_dim xscroll, yscroll;

  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}

  UPaneView(UBoxLink*, UView* parview, UWinGraph*);
  virtual ~UPaneView() {}

  UPane *getPane(); // same as getBox() with an UPane cast
  u_dim  getXScroll() {return xscroll;}
  u_dim  getYScroll() {return yscroll;}

  // Note that using the following functions is not a good idea if this pane
  // is already controlled by scrollbars
  virtual void setXScroll(u_dim scr) {xscroll = scr;}
  virtual void setYScroll(u_dim scr) {yscroll = scr;}

  //package_private: ====[internal implementation: do not use]===============

  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);

  virtual u_bool doLayout(UContext&, class UViewLayout&);
  virtual void doUpdate(UContext&, URegion r, URegion clip, class UViewUpdate&);
  virtual UView* locateSource(UEvent *e, UContext* parctx, URegion clip,
			      UView *sv);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

