/* ==================================================== ======== ======= *
 *
 *  uuwin.cc
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuwin.cc	ubit:b1.11.6"
#include <ubrick.hh>
#include <uconfig.hh>
#include <ucall.hh>
#include <uprop.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ubox.hh>
#include <uwin.hh>
#include <uwinImpl.hh>
#include <uview.hh>
#include <uviewImpl.hh>
#include <uevent.hh>
#include <ustyle.hh>
#include <ucolor.hh>
#include <uborder.hh>
#include <ugraph.hh>
#include <unat.hh>
#include <uappli.hh>
#include <uobs.hh>

const UClass UWin::uclass("UWin");
const UClass UDialog::uclass("UDialog");
const UClass UFrame::uclass("UFrame");

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UDialog::UDialog(UArgs l) : UWin(l) {
  open_call = null;
}

UDialog& udialog(UArgs l) {return *(new UDialog(l));}

UStyle *UDialog::style = null;

const UStyle* UDialog::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::vertical.get();
    style->local.halign   = UHalign::flex.get();
    style->local.valign   = UValign::top.get();
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    style->local.padding.set(0, 0);
    style->font     = &UFont::standard;
    style->fgcolors = UStyle::makeColors(&UColor::black,&UColor::white); 
    style->bgcolors = UStyle::makeColors(&UBgcolor::grey, &UBgcolor::black);
  }
  return style;
}

u_bool UDialog::realize() {
  if (is_hardwin) return realizeHardwin(&UNatWin::realizeDialog);
  else {
    error("realize", UError::CANT_REALIZE_SOFTWIN);
    return false;
  }
}

void UDialog::addingTo(ULink *selflink, UGroup *parent) {
  UWin::addingTo(selflink, parent);

  // ajouter Handler pour ouvrir auto le Dialog
  // a specialiser selon parent et bouton de la souris... A REVOIR !!

  //if (openingMode != 0) {
  if (isDef(0, UMode::AUTOOPEN_BHV)) {
    if (!open_call) {
      open_call = 
	//&ucall((UWin*)this, &UWin::showImpl, (u_bool)true, UOn::action);
	&ucall((UGroup*)this, &UGroup::show, true, UOn::action);
    }
    //!!ATT: risque de pas marcher si le parent est un UGroup !!
    // mais c'est un bug a corriger ailleurs ...
    parent->add(open_call);
  }
}

//NB: removingFrom() requires a destructor to be defined
void UDialog::removingFrom(ULink *prevlink, UGroup *parent) {
  // don't delete the ucall as it is shared
  if (open_call) {
    parent->remove(open_call, false);
  }
  UWin::removingFrom(prevlink, parent);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// The FIRST Frame added to the UAppli will be the "MainFrame"
// This Window (and ONLY this one) will be automatically opened

UFrame::UFrame(UArgs l) : UDialog(l) {
  is_main_frame = false;  // defaut: NOT a main_frame
  // les frame, c'est toujours des HARDWIN !!!
  is_hardwin = true;
}

UFrame& uframe(UArgs l) { return *(new UFrame(l));}

u_bool UFrame::realize() {
  if (is_hardwin) {
    if (is_main_frame) 
      return realizeHardwin(&UNatWin::realizeMainFrame);
    else
      return realizeHardwin(&UNatWin::realizeFrame);
  }
  else {
    error("realize", UError::CANT_REALIZE_SOFTWIN);
    return false;
  }
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

const UClass UIncrust::uclass("UIncrust");

UIncrust& uincrust(UArgs args) {
  return *new UIncrust(args);
}

UIncrust::UIncrust(UArgs l) : UWin(l) {
  // Contrairement aux autres UWin, les UIncrust sont affichees par defaut
  // et sont en mode BOX (= tiled)
  setCmodes(UMode::CAN_SHOW|UMode::BOX|UMode::HARDWIN|UMode::SUB_HARDWIN, true);
  is_hardwin      = true;  // les Incrust c'est toujours des HARDWIN !!!
  is_external_win = false;
  xwin = None;
}

void UIncrust::setExternalXWin(unsigned long external_xwin) {
  is_external_win = true;
  //if xwin ==> xdestroy(xwin) etc...
  xwin = external_xwin;
}

UIncrust::~UIncrust() {}

u_bool UIncrust::realize() {
  if (is_hardwin) return realizeHardwin(&UNatWin::realizeIncrust);
  else {
    error("realize", UError::CANT_REALIZE_SOFTWIN);
    return false;
  }  
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UWin::UWin(UArgs l) : UBox(l) {
  // par defaut les fenetres ne sont pas affichees (sauf Frame)
  setCmodes(UMode::CAN_SHOW | UMode::BOX, false);
  setCmodes(UMode::AUTOOPEN_BHV, true);

  is_hardwin = true;      //!!HARD_WIN par defaut
  winview = null;
  impl.initialized = null;  //impl NOT initialized
}

USoftwinImpl::USoftwinImpl(UWin *win) {
  //NOTE: SOFTWIN => FLOATING
  // (c'est fait implicitement via l'ajout d'un UPos aux softwins)
  pos.set(200, 100);              /////!!!A_REVOIR dans cache!!!
  pos.autodel(false);
  win->add(pos, 0);               /////!!!A_REVOIR dans cache!!!
}

UHardwinImpl::UHardwinImpl(UWin *win) {
  wingraph = new UWinGraph(win);
  sub_softwins = null;
}

/* ==================================================== ======== ======= */
//! ATTENTION: les appels aux fcts vituelles ne marchent pas normalement
//! dans les constructeurs et les DESTRUCTEURS (l'appel est fait avec
//! la classe du destructeur, pas la classe effective)
//! ==> toute redefinition de 'removingFrom' necessite un DESTRUCTEUR !!

UWin::~UWin() {
  //NB: removeFromParents et removeAll fait par ~UBox
  if (winview) {
    //! IMPORTANT: the SHARED VIEWS of the UWINdows are NOT destroyed
    //! by UBox::deleteRelatedViews (as other views are) but by ~UWin
    //! (voir cette fct. et le field 'UView::WIN_SHARED')
    delete winview;
    winview = null;
  }

  if (impl.initialized) {
    if (is_hardwin) delete impl.hard;
    else delete impl.soft;
    impl.initialized = null;
  }
}

/* ==================================================== ======== ======= */

USoftwinImpl::~USoftwinImpl() {
  //pos = null;   pos n'est plus un ptr mais un objet
}

UHardwinImpl::~UHardwinImpl() {
  if (wingraph) {
    //enlever cette window de la liste des win managees par le isp
    if (wingraph->getDisp())
      wingraph->getDisp()->removeHardwin(wingraph->getHardwin());

    //OLD: question: pourquoi ~WinGraph ne detruit pas natwin ?
    //NEW: eh bien c'est ce qui est fait maintenant
    delete wingraph;
    wingraph = null;	//securite (theoriquement inutile)
  }

  if (sub_softwins) {
    //NB: softwins est detruit implicitement (car rajoute a la childlist) ???
    sub_softwins = null;  //securite
  }
}

/* ==================================================== ======== ======= */
//ATT: cette fct doit etre appelee a la creation de la UWin

UWin& UWin::setSoftwinMode(u_bool state) {
  if (impl.initialized) {
    error("setSoftwinMode", "this method must be called before the object is realized \n(i.e. before adding it to a realized parent) ");
    return *this;
  }
  if (state) {
    is_hardwin = false;
    setCmodes(UMode::HARDWIN, false);
    setCmodes(UMode::SOFTWIN, true);
  }
  else {
    is_hardwin = true;
    setCmodes(UMode::HARDWIN, true);
    setCmodes(UMode::SOFTWIN, false);
  }
  return *this;
}

u_bool UWin::isSoftwinMode() const  {
  return !is_hardwin;
}

UWinGraph* UWin::getWinGraph() const {
  return (winview ? winview->getWinGraph() : null);
}
UNatWin* UWin::getNatWin() const {
  return (winview ? winview->getWinGraph()->getNatWin() : null);
}
UDisp* UWin::getDisp() const {
  return (winview ? winview->getWinGraph()->getDisp() : null);
}
UAppli* UWin::getAppli() const {
  return (winview ? winview->getWinGraph()->getAppli() : null);
}
ULink *UWin::getSubSoftwinLinks() {
  if (is_hardwin) return impl.hard ? impl.hard->sub_softwins : null;
  else return null;
}
UGroup* UWin::getSubSoftwins() {
  ULink *link = getSubSoftwinLinks();
  return link ? (UGroup*)link->brick() : null;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// ATT: voir aussi + voir cas Displays separes!!
//!! POUR L'instant winview UNIQUE!!!
// NOTE: les Windows sont creees une seule fois mais ouvertes par tous 
// leurs parents

void UWin::init(ULink *selflink, ULink *parlink, UView *parview) {
  init(selflink, parlink, parview, parview->getDisp());
  if (isShowable()) show(true);
}

// optimization: les vues des enfants de la UWIn seront crees ulterieurement,
// au premier show() de la UWin, via la fonction realizeChildren()
//att: parview n'est pas la view du parent mais du 1er parent de type UBox!

void UWin::init(ULink *selflink, ULink *parlink, UView *parview, UDisp *disp){
  // par construction
  UBoxLink *wlink = dynamic_cast<UBoxLink*>(selflink);
  if (!wlink) {
    error("init", "Internal error: incorrect link type");
    return;
  }

  // Il n'y a qu'une seule winview par Window
  // ==> ne creer et n'initialiser les descendants que la premiere fois
  if (!winview) {
    UWinGraph *wingraph = null;

    if (is_hardwin) {
      setCmodes(UMode::HARDWIN, true);
      setCmodes(UMode::SOFTWIN, false);
      impl.hard = new UHardwinImpl(this); 
      wingraph = impl.hard->wingraph;

      // ajouter a la liste des hardwins de UDisp
      disp->addHardwin(this);
    }
    else {			// softwin
      setCmodes(UMode::HARDWIN, false);
      setCmodes(UMode::SOFTWIN, true);
      impl.soft = new USoftwinImpl(this); 

      // dans le cas des softwin il faut un parview, et il faut de plus
      // reinitialser la vue partagee a chaque apparition !!!!
      if (!parview) {
	//NB: parview necessaire dans ce cas pour: parview->getWinGraph(); 
	//    (et aussi optionnellement pour getStyle(closest_parent)
	error("init", "No parent view!");
	return;
      }
      wingraph = parview->getWinGraph();
    }

    if (!wingraph) {
      error("init", UError::CANT_REALIZE_WINDOW);
      return;
    }
    
    const UViewStyle *render;
    if (isDef(0,UMode::HAS_RENDERER)) {
      // si renderer defini dynamiquement dans la childlist
      render = (UViewStyle*) getChild(&UViewStyle::uclass);
    }
    else {  // default:p rendre le renderer defini par le style de la Win
      //NB: closest_parent: ne sert en fait pas a grand chose (sauf dans des
      //cas de styles contextuels ou le renderer changerait suivant parent)
      UBox *closest_parent = parview ? parview->getBox() : null;
      render = getStyle(closest_parent)->viewStyle;
    }

    // !note: winview est desormais une var. d'instance!
    if (render)
      winview = (render->makeView)(wlink, null, wingraph);
    else {
      warning("init", "missing ViewStyle Spec., taking default");
      winview = new UView(wlink, null, wingraph);
    }

    // initialize le WinGraph (mais ne cree pas la X Window: ce sera fait
    // ulterieurement par UWin::realize() qunad la fenetre apparaitra
    // la 1ere fois (NB: a partir de ce moment, UGraph::isWinRealized()
    // renverra true (mais pas avant)
    if (is_hardwin) wingraph->init(disp, winview);

  } //endif(!winview)

  // !!!DANS TOUS LES CAS: 
  // faire pointer BoxLink->views vers la View associee 

  if (wlink->viewCount == 0)   // UN seul link
    wlink->views = (UView**)malloc(sizeof(UView*));
  else if (wlink->viewCount > 1)
    warning("init","Internal error: Wrong view count: %d",wlink->viewCount);
  if (!wlink->views) {
    wlink->viewCount = 0;
    error("!init",UError::NO_MEMORY);
    return;
  }

  wlink->viewCount = 1;
  //!!WinView PARTAGEE!! (important pour UBoxLink::deleteRelatedViews)
  winview->setVmodes(UView::WIN_SHARED, true);
  wlink->views[0] = winview;

  // Propager aux children :
  // optimization: les vues des enfants de la UWIn sont crees plus tard
  // au premier show() de la UWin, via la fonction realizeChildren()
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

u_bool UWin::realizeHardwin(u_bool (*xrealize)(UNatDisp*, UNatWin*, UWin*)){
  UHardwinImpl *hard = impl.hard;
  
  if (hard->wingraph->isWinRealized())   // deja realize'
    return true;
  else if ((*xrealize)(hard->wingraph->getNatDisp(), 
		       hard->wingraph->getNatWin(), this)) {
    realizeChildren();    // create the children views of the UWin

    // initialiser disposition spatiale avant affichage
    /**27nov01: plus necessaire grace a  WIN_MAPPED (voir UNatWin::configure)
    UUpdate upd(UUpdate::LAYOUT);
    upd.evenIfHidden();
    update(upd);
    */
    return true;
  }
  else return false;
}

u_bool UWin::realizeSoftwin() {
  UWin *hardwin;
  if (!winview || !(hardwin = winview->getHardwin())) {
    error("realizeSoftwin", UError::UNREALIZED_WINDOW);
    return false;
  }
  UGroup *softwins = null;
  if (hardwin->impl.hard->sub_softwins)
    softwins = (UGroup*)hardwin->impl.hard->sub_softwins->brick();

  // recuperer ou creer la softlist de la hardwin
  if (!softwins) {
    softwins = new UGroup();
    if (!softwins) {
      error("realizeSoftwin", UError::NO_MEMORY);
      return false;
    }
    //ce mode permettra de detecter les softwins au lieu adequat
    //dans uuview.cc et consorts
    softwins->setCmodes(UMode::SOFTWIN_LIST, true);
    softwins->setCmodes(UMode::CAN_SHOW, true);
    
    //initialiser sub_softwins  
    ULink *link = softwins->makeLink();
    hardwin->impl.hard->sub_softwins = link;
  }

  //NB: faudrait enlever this des autres softwins si c'est le cas

  //est-ce que this est deja dans la softlist ?
  ULink *prevlink = null;
  u_bool already_in_softwins = softwins->getChildImpl(this, &prevlink);

  if (!already_in_softwins) {
    // NB: modifier CAN_SHOW pour eviter recursion infinie car add()
    // appelle show() qui appelle cette fonction si CAN-SHOW is true
    softwins->add(this);
    softwins->getChildImpl(this, &prevlink);
  }

  ULink *l = prevlink ? prevlink->next() : softwins->children.first();
  UView *parview = hardwin->winview;

  //initialiser les tableaux de Views
  //!att: l'autre version de init() appelle show ce qui provoque
  //une boucle infinie!
  init(l, null, parview, parview->getDisp());

  // le parent de la vue doit etre mis a jour
  winview->_setParentView(parview); //!!
  realizeChildren();  //risque de doublons si refait a chaque fois
 
  // initialiser disposition spatiale avant affichage
  /*surtout pas: boucle infinie
  UUpdate upd(UUpdate::LAYOUT);
  upd.evenIfHidden();
  updateSoftwin(upd);
  */
  return true;
}

// !ATT: l'initialisation des descendant NE DOIT SE FAIRE qu'une seule
// fois, c'est a dire pour la seule WinView effectivement creee
// (sinon on irait creer des Views inutiles dans les descendants)

void UWin::realizeChildren() {
  //NB: only one screen !
  UBoxLink *winlink = null;

  if (!winview || !(winlink = winview->getBoxLink()))
    error("realizeChildren", UError::UNREALIZED_WINDOW);
  else				// Propager aux children
    UGroup::init(winlink, null, winview); // winview pas parview!!
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

u_bool UWin::isShown() const {
  if (!isShowable() || !winview) return false;

  //if (!is_hardwin) return UBox::isShown(); // isShown normal
  //else return impl.wingraph->isRealized();

  //NB: dans le cas des softwin, isShown est cense etre independant
  //de la visibilite des parents
  return winview->getWinGraph()->isWinRealized();
}

void UWin::update(UUpdate upmode) {
  if (!winview) {
    //pas de message: la fenetre peut tout simplement ne pas etre
    //encore initialisee
    return;
  }
  if (is_hardwin) impl.hard->update(this, upmode);
  else impl.soft->update(this, upmode);
}

void UWin::update() {
  update(UUpdate::layout);
}

/* ==================================================== ======== ======= */
// CAS SOFTWIN

void USoftwinImpl::update(UWin *win, const UUpdate &upmode) {
  //erreur: UGroup *softwins = getSubSoftwins();
  UWin *hardwin;
  if (!win->winview || !(hardwin = win->winview->getHardwin())) {
    uerror("USoftwinImpl::update", UError::UNREALIZED_WINDOW);
    return;
  }
  UGroup *softwins = null;
  if (hardwin->impl.hard->sub_softwins)
    softwins = (UGroup*)hardwin->impl.hard->sub_softwins->brick();

  switch (upmode.ix) {
  case UUpdate::TITLE:
    printf("update title\n");                   //A_REVOIR!!!!
    break;

  case UUpdate::HIDE:
    // recuperer  la softlist de la hardwin
    //si dans la liste => l'enlever (sans message d'erreur!)
    if (softwins) {
      ULink *prevlink = null;
      if (softwins->getChildImpl(win, &prevlink))
	  softwins->removeImpl(win, prevlink, false);
    }
    win->setCmodes(UMode::CAN_SHOW, false);
    break;
  
  case UUpdate::SHOW:                 /*|| upmode.ix == UUpdate::WIN*/
    // mettre ou remettre 'this' en LAST position dans la softwin list
    // si deja dans la liste => l'enlever (sans message d'erreur!)

    // EN FAIT LE MIEUX CE SERAIT JUSTE D'INVERSER LES POSITIONS
    // DANS LA LISTE SANS RIEN RECONSTRUIRE !!!!!!  
    if (softwins) {
      ULink *prevlink = null;
      if (softwins->getChildImpl(win, &prevlink))
	softwins->removeImpl(win, prevlink, false);
    }
    win->realizeSoftwin();
    win->setCmodes(UMode::CAN_SHOW, true);
    break;

  case UUpdate::LAYOUT:
    if (win->isShowable() || upmode.always) {
      //if (..???...!wingraph->isRealized())
      {
	//on realize si pas deja fait
	if (!win->realizeSoftwin()) return;
      }
    }
    break;
  }

  //dans tous les cas
  win->UBox::update(upmode);
}

/* ==================================================== ======== ======= */
// CAS HARDWIN

void UHardwinImpl::update(UWin *win, const UUpdate &upmode) {
  //UWinGraph *wingraph = impl.hard->wingraph;

  switch (upmode.ix) {
  case UUpdate::TITLE:
    if (!wingraph->isWinRealized()) return;
    const UStr *s;
    if (!upmode.item || !(s = dynamic_cast<const UStr*>(upmode.item)))
      return;
    wingraph->getNatWin()->setTitle(wingraph->getNatDisp(), s->chars());
    break;

  case UUpdate::HIDE:
    win->setCmodes(UMode::CAN_SHOW, false);
    // NB: dans le cas state==true, le champ view.show est mis a true 
    // dans doUpdate(). 
    // Par contre, dans le cas state==false il doit par contre etre mis 
    // a false ici (car on ne passera pas dans doUpdate)
    ///winview->shown = false; supprime
    //fire(&e, UOn::hide); supprime car pas recursif: faire autrement
    wingraph->getNatWin()->show(wingraph->getNatDisp(), false);	
    break;

  case UUpdate::SHOW:{               /*||upmode.ix == UUpdate::WIN*/
    win->setCmodes(UMode::CAN_SHOW, true);
    //fire(&e, UOn::show);   supprime car pas recursif: faire autrement
    if (!wingraph->isWinRealized()) {
      if (!win->realize()) return;  //realize the Xt Widget AND the X-Window
    }
    updateLayout(win->winview, false, 0, 0);
    //set title if applicable
    UTitle *title = win->getTypedChild<UTitle>();
    if (title)
      wingraph->getNatWin()->setTitle(wingraph->getNatDisp(),title->chars());
    //pop up and raise
    wingraph->getNatWin()->show(wingraph->getNatDisp(), true);
    }break;
 
  case UUpdate::PAINT: 
    if (win->isShowable() || upmode.always) 
      win->UBox::update(upmode);
    break;

  default:    //LAYOUT, etc.
    if (win->isShowable() || upmode.always) {
      //on realize si pas deja fait
      if (!wingraph->isWinRealized()) {
	if (!win->realize()) return;  //realize the Xt Widget AND the X-Window
      } 
      //preserver la taille courante
      //!!NOTE:  bug dans le cas des menus ou on add/remove des objs:  !!!
      //         ne changent pas de taille!                 !! A REVOIR !!
      u_dim ww, hh;
      win->winview->getSize(ww, hh);
      if (ww > 0 && hh >0) updateLayout(win->winview, true, ww, hh);
      else updateLayout(win->winview, false, 0, 0);
    }
    break;
  }
}

/* ==================================================== ======== ======= */
//NB:impose une taille donnee en mode 'resize=true' (si les valeurs sont >0)

void UHardwinImpl::updateLayout(UView* winview,
				u_bool impose_size, u_dim w, u_dim h) {
  if (w <= 0 || h <= 0) impose_size = false;

  UBox::updateLayout(winview, winview, impose_size, w, h);

  // securite: une taille <= 0 fait planter X !
  if (winview->getWidth()  <= 0)  winview->setWidth(1);
  if (winview->getHeight() <= 0)  winview->setHeight(1);

  //NB1: qq part il faudrait la notion de stack/level pour les softwins
  //NB2: bug classique UBox:softwin : ne reaffiche pas la zone decourverte
  // qunad on retaille pour une nouvelle taille plus petite
  // UWinGraph *wingraph = win->impl.hard->wingraph;

  //???devrait faire resize que si mode 'resize' ??
  wingraph->getNatWin()->resize(wingraph->getNatDisp(),
				winview->getWidth(), winview->getHeight());
}

/***ex: merge avec version UBox
void UHardwinImpl::updateLayout(UView *winview, u_bool resize, u_dim w, u_dim h) {
  UViewLayout vl;
  UWinContext winctx1(winview);           
  u_bool mustLayoutAgain = winview->doLayout(winctx1, vl);

 AGAIN:
  // forcer valeurs de w et h, indep de ce que veut layout()
  if (resize) {
    if (w > 0 && h >0) winview->resize(w, h);
  }

  if (!mustLayoutAgain) {
    winview->updateWinPaint(winview,false, null, true);
  }
  else {
    winview->updateWinData(winview);
    if (resize) winview->resize(w, h);

    UWinContext winctx2(winview);
    winview->doLayout(winctx2, vl);
    mustLayoutAgain = false;
    goto AGAIN;
  }
  // securite: une taille <= 0 fait planter X !
  if (winview->getWidth()  <= 0)  winview->setWidth(1);
  if (winview->getHeight() <= 0)  winview->setHeight(1);

  //NB1: qq part il faudrait la notion de stack/level pour les softwins
  //NB2: bug classique UBox:softwin : ne reaffiche pas la zone decourverte
  // qunad on retaille pour une nouvelle taille plus petite
  // UWinGraph *wingraph = win->impl.hard->wingraph;

  //???devrait faire resize que si mode 'resize' ??
  wingraph->getNatWin()->resize(wingraph->getNatDisp(),
				winview->getWidth(), winview->getHeight());
}
***/
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
//ATT: contrairement a update(), resize() impose une taille donnee
// (si les valeurs sont >0)

u_bool UWin::resize(u_dim w, u_dim h) {
  if (!winview) {
    warning("resize", UError::UNREALIZED_WINDOW);
    return false;
  }
  else {
    winview->resize(w, h);
    if (isShowable()) {
      if (is_hardwin) impl.hard->updateLayout(winview, true, w, h);
      else UBox::update(UUpdate::layout);  //layout ou data ???
    }
    return true;
  }
}

u_bool UWin::getSize(u_dim &w, u_dim &h) const {
  if (!winview) {
    warning("getSize", UError::UNREALIZED_WINDOW);
    w = -1; h = -1;
    return false;
  }
  else {
    winview->getSize(w, h);
    return true;
  }
}

u_dim UWin::getWidth() const {
  u_dim w, h;
  if (getSize(w, h)) return w;
  else return -1;
}
u_dim UWin::getHeight() const {
  u_dim w, h;
  if (getSize(w, h)) return h;
  else return -1;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

u_bool UWin::whereOnScreen(u_pos &x, u_pos &y) const {
  UNatWin *natwin;
  if (!winview || !(natwin = winview->getWinGraph()->getNatWin())) {
    x = -1; y = -1;
    warning("whereOnScreen", UError::UNREALIZED_WINDOW);
    return false;
  }
  else {
    //natwin->where(impl.wingraph->getNatDisp(), x, y);
    natwin->where(winview->getWinGraph()->getNatDisp(), x, y);
    // x += winview->x; y += winview->y;
    // OU BIEN:
    if (!is_hardwin) {
      x += impl.soft->pos.getX();
      y += impl.soft->pos.getY();
    }
    return true;
  }
}

u_bool UWin::where(UWin *win, u_pos &x, u_pos &y) const {
  u_pos x2, y2;
  if (win && whereOnScreen(x, y) && win->whereOnScreen(x2, y2)) {
    x -= x2; y -= y2;
    return true;
  }
  else {
    x = -1; y = -1;
    return false;
  }
}

u_bool UWin::where(UView *view, u_pos &x, u_pos &y) const {
  u_pos x2, y2;
  if (view && whereOnScreen(x, y) && view->whereOnScreen(x2, y2)) {
    x -= x2; y -= y2;
    return true;
  }
  else {
    x = -1; y = -1;
    return false;
  }
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

u_bool UWin::moveAndCenter() {
  u_dim width, height;
  UAppli *a;

  if ((a = getAppli()) && getSize(width, height)) {
      u_dim 
	scr_width  = a->getScreenWidth(),
	scr_height = a->getScreenHeight();

      if (moveOnScreen((scr_width - width) / 2, (scr_height - height) / 2))
	return true;
  }
  return false;
}

u_bool UWin::moveOnScreen(u_pos x, u_pos y) {
  if (!impl.initialized) {
    warning("moveOnScreen", UError::UNREALIZED_WINDOW);
    return false;
  }

  if (is_hardwin) {
    UNatWin *natwin = impl.hard->wingraph->getNatWin();
    if (!natwin) {
      warning("moveOnScreen", UError::UNREALIZED_WINDOW);
      return false;
    }
    else {
      // c'est le moment de creer la win si pas deja fait :
      // sinon le move sera ineffectif et au prochain show le menu
      // apparaitra n'importe ou
      if (!natwin->isRealized())
	realize();

      natwin->move(impl.hard->wingraph->getNatDisp(), x, y);
      return true;
    }
  }

  else { // softwin
    error("moveOnScreen", "Softwins not yet implemented");   //!!!COMPLETER
    return false;
  }
}


u_bool UWin::move(UWin *win, u_pos x, u_pos y) {
  if (is_hardwin) {
    u_pos screen_x, screen_y;
    return (win->whereOnScreen(screen_x, screen_y)
	    && moveOnScreen(screen_x + x, screen_y + y));
  }

  else {  //SOFTWIN
    UWinGraph *new_wingraph;  // sert a recuperer la hardwin de win
    if (!winview || !win || !(new_wingraph = win->winview->getWinGraph())) {
      warning("move", UError::UNREALIZED_WINDOW);
      return false;
    }

    /* !!! INCOMPLET:
     * il faudrait
     * -- changer de wingraph:
     *    winview->wingraph = new_wingraph;
     * -- mettre a jour les softwin_list de l'ancien et du nouveau wingraph
     *    ....;
     * ATT: Bugs avec les UIncrust:
     * -a- winview->wingraph = new_wingraph; peut poser pbm dans ce cas
     *     car la fenetre UIncrust recouvre la fenetre Frame
     * -b- d'autant plus que les Events sont errones dans ce cas car les
     *     UIncrust loupent tous les events (et c'est Frame qui le recupere) 
     */

    UWin* current_hardwin = winview->getWinGraph()->getHardwin();
    // c'est un pis aller : normalement il faudrait changer le wingraph
    // de this. le probleme c'est que cette win doit rester dans
    // la sub-hardwin (UIncrust) sinon elle ne s'affichera pas
    if (current_hardwin && current_hardwin->isDef(0, UMode::SUB_HARDWIN)) {
      impl.soft->pos.set(x - current_hardwin->winview->x, 
			 y - current_hardwin->winview->y);
    }
    else impl.soft->pos.set(x - win->winview->x, y - win->winview->y);
    return true;
  }
}

u_bool UWin::move(UView *view, u_pos x, u_pos y) {
  UWin *hardwin = view->getHardwin();  //returns hardwin!!!
  if (hardwin) {
    x += view->x; y += view->y;  
    return move(hardwin, x, y);
  }
  else {
    warning("move", UError::UNREALIZED_WINDOW);
    return false;
  }
}

u_bool UWin::move(UEvent *e, u_pos x, u_pos y) {
  /*
    u_pos screen_x, screen_y;
    return (e->whereOnScreen(screen_x, screen_y)
	    && moveOnScreen(screen_x + x, screen_y + y));
  */

  // !ATT: la win renvoyee est tjrs une hardwin externe (typiquement
  // un Dialog ou un Frame) jamais une harwin incrustee (comme UIncrust)
  UWin *win = e->getWin();
  if (win) return move(win, e->getXwin() + x, e->getYwin() + y);
  else return false;
}

/* ==================================================== ======== ======= */
// updates object layout to get correct size when necessay
static void checkUpdate(UWin *obj) {
  u_dim w, h;
  obj->getSize(w, h);

  // if <= 0 must update layout to get correct sizes
  if (w <= 0 || h <= 0) {
    // 2nd arg = true ==> will update even if NOT shown
    UUpdate upd(UUpdate::LAYOUT);
    upd.evenIfHidden(true);
    obj->update(upd);
  }
}

//positionner par rapport a view
u_bool UWin::move(UView *view, UPlacement &pl) {
  u_pos _x = 0, _y = 0;  //nom a changer
  ///view->whereOnScreen(screen_x, screen_y);

  if (pl.halign) {
    if (pl.halign->get() == UHalign::left.get()) {
      if (pl.hoppositeBorder) {	  // a gauche de view
	// updates layout to get correct size when necessay
	checkUpdate(this);
	_x -= this->getWidth() + pl.hdist;
      }
      else _x += pl.hdist;  //alignes a dist pres
    }

    else if (pl.halign->get() == UHalign::right.get()) {
      if (pl.hoppositeBorder)	  // a droite de view
	_x += view->getWidth() + pl.hdist;
      else {
	checkUpdate(this);
	_x += view->getWidth() - this->getWidth() - pl.hdist;
      }
    }

    //else nop: aligne' avec view (a gauche)
    // flex devrait s'adapter en largeur (qunad plus petit que view)
  }

  if (pl.valign) {
    if (pl.valign->get() == UValign::top.get()) {
      if (pl.voppositeBorder) {	      // au dessus de view
	checkUpdate(this);
	_y -= this->getHeight() + pl.vdist;
      }
      else _y += pl.vdist;  //alignes a dist pres
    }
    
    else if (pl.valign->get() == UValign::bottom.get()) {
      if (pl.voppositeBorder)	          // en dessous de view
	_y += view->getHeight() + pl.vdist;
      else {
	checkUpdate(this);
	_y += view->getHeight() - this->getHeight() - pl.vdist;
      }
    }

    //else nop: aligne' avec view (en haut)
    // flex devrait s'dapter en hauteur(qunad plus petit que view)
  }

  //move(screen_x, screen_y);
  return move(view, _x, _y);
}

UPlacement::UPlacement() {
  halign = null;
  valign = null;
  hoppositeBorder = voppositeBorder = false;
  hdist = vdist = 0;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */


