/* ==================================================== ======== ======= *
 *
 *  uuint.cc
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uulint.cc	ubit:b1.11.7"
#include <ctype.h>
#include <udefs.hh>
#include <ubrick.hh>
#include <uconfig.hh>
#include <uctrl.hh>
#include <ustr.hh>
#include <uint.hh>
#include <uevent.hh>

const UClass ULint::uclass("ULint");


ULint& ulint(long ii) {return *(new ULint(ii));}
ULint& ulint(const ULint& ii) {return *(new ULint(ii));}


ULint::ULint(long ii, u_modes m) : UEditable(m) {
  val = ii;
}

ULint::ULint(const ULint& ii) : UEditable(0) {
  val = ii.val;
}

/* ==================================================== ======== ======= */

void ULint::set(long ii) {
  if (equals(ii)) return;
  val = ii;
  changed();
}

void ULint::set(const ULint& ii) {
  if (equals(ii)) return;
  val = ii.val;
  changed();
}

void ULint::set(const ULint* ii) {
  if (!ii) {uerror("set","null argument"); return;}
  set(*ii);
}

void ULint::set(const UStr &str) {
  const char*_s = str.chars();
  if (!_s) {uerror("set","UStr argument has null value"); return;}
  val = atol(_s);  
  changed();
}

void ULint::set(const UStr *str) {
  if (!str) {uerror("set","null argument"); return;}
  set(*str); 
}

/* ==================================================== ======== ======= */

u_bool ULint::equals(long ii) const {
  return (val == ii);
}

u_bool ULint::equals(const ULint& ii) const {
  return (val == ii.val);
}

u_bool ULint::equals(const ULint* ii) const {
  if (!ii) {uerror("equals","null argument"); return false;}
  return (val == ii->val);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */


void ULint::changed() {
  if (cache) {
    UEvent e(UEvent::change, null, NULL);
    //e.setItemSource(this);
    fire(e, UOn::change);
  }
}

u_bool ULint::checkFormat(int pos, char _c) {
  return true;
  /***************
  if (isdigit(_c))
    return true;
  else if ((pos == 0 || (pos<0 && len==0)) && (_c == '-' || _c == '+')) 
    return true;
  else return false;
  **************/
}

u_bool ULint::checkFormat(int pos, const char *_s) {   //a completer!!!
  return (_s != null);
}


/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
