/* ==================================================== ======== ======= *
 *
 *  uugadgets.cc
 *  Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uugadgets.cc	ubit00.15.3"
#include <udefs.hh>
#include <ubrick.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ubox.hh>
#include <uwin.hh>
#include <umenu.hh>
#include <ugadgets.hh>
#include <usymbol.hh>
#include <ustyle.hh>
#include <uborder.hh>
#include <ucolor.hh>
#include <ucursor.hh>
#include <upix.hh>

const UClass ULabel::uclass("ULabel");
const UClass UButton::uclass("UButton");
const UClass UTbutton::uclass("UTbutton");
const UClass UCheckbox::uclass("UCheckbox");
const UClass UTcheckbox::uclass("UTcheckbox");
const UClass UHref::uclass("UHref");
const UClass UTextbox::uclass("UTextbox");
const UClass ULine::uclass("ULine");

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UStyle *ULabel::style = null;

const UStyle *ULabel::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::center.get();
    style->local.padding.set(1, 1);
    style->local.hspacing = 1;
    style->local.vspacing = 1;
  }
  return style;
}

ULabel::ULabel(UArgs l) : UBox(l) {}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

static void MakeButtonColors(const UColor***bgcolors, 
			     const UColor***fgcolors, u_bool transp) {

  *fgcolors = UStyle::makeColors(&UColor::inherit,&UColor::inherit); 
  if (transp)
    *bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::none);
  else
    *bgcolors = UStyle::makeColors(&UBgcolor::grey, &UBgcolor::grey);

  UStyle::setColor(*fgcolors, UOn::DISABLED,	&UColor::disabled);
  UStyle::setColor(*bgcolors, UOn::ENTERED, 	&UColor::lightgrey);
  UStyle::setColor(*bgcolors, UOn::ARMED, 	&UBgcolor::darkgrey);

  //UStyle::setColor(*fgcolors, UOn::ACTIONED,	&UBgcolor::white);
  //UStyle::setColor(*bgcolors, UOn::ACTIONED,	&UBgcolor::navy);

  UStyle::setColor(*bgcolors, UOn::DROPPED,     &UBgcolor::lightgrey);
  UStyle::setColor(*bgcolors, UOn::HIGHLIGHTED, &UBgcolor::red);
}

static void MakeMenuButtonColors(const UColor***bgcolors, 
				 const UColor***fgcolors) {

  *fgcolors = UStyle::makeColors(&UColor::inherit,&UColor::inherit); 
  *bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::none);

  UStyle::setColor(*fgcolors, UOn::DISABLED,	&UColor::disabled);

  UStyle::setColor(*fgcolors, UOn::ENTERED, 	&UColor::white);
  UStyle::setColor(*bgcolors, UOn::ENTERED, 	&UColor::navy);

  UStyle::setColor(*fgcolors, UOn::ARMED, 	&UColor::white);
  UStyle::setColor(*bgcolors, UOn::ARMED, 	&UBgcolor::navy);

  //UStyle::setColor(*fgcolors, UOn::ACTIONED,	&UBgcolor::white);
  //UStyle::setColor(*bgcolors, UOn::ACTIONED,	&UBgcolor::navy);

  UStyle::setColor(*bgcolors, UOn::DROPPED,     &UBgcolor::lightgrey);
  UStyle::setColor(*bgcolors, UOn::HIGHLIGHTED, &UBgcolor::red);
}

/* ==================================================== ======== ======= */

UStyle *UButton::style, *UButton::menuStyle, *UButton::barStyle;

// !!ATT: Style Variable suivant Context

const UStyle *UButton::getStyle(const UBox *parent) {
  const UColor **bgcolors = null, **fgcolors = null;
  const UColor **menu_bgcolors = null, **menu_fgcolors = null;

  if (parent) {
    // style for menus and menubar
    if (dynamic_cast<const UMenu*>(parent) 
	|| dynamic_cast<const UMenubar*>(parent)) {
      
      if (!menuStyle) {
	menuStyle = new UStyle(null);
	menuStyle->local.orient   = UOrient::horizontal.get();
	menuStyle->local.halign   = UHalign::left.get();
	menuStyle->local.valign   = UValign::center.get();
	menuStyle->local.border   = null;
	menuStyle->local.hspacing = 2;
	menuStyle->local.vspacing = 2;
	menuStyle->local.padding.set(2, 2);
	if (!menu_bgcolors) 
	  MakeMenuButtonColors(&menu_bgcolors, &menu_fgcolors);
	menuStyle->bgcolors       = menu_bgcolors;
	menuStyle->fgcolors       = menu_fgcolors;
      }
      return menuStyle;
    }

    // style for bars
    else if (dynamic_cast<const UBar*>(parent)) {
      if (!barStyle) {
	barStyle = new UStyle(null);
	barStyle->local.orient   = UOrient::vertical.get();
	barStyle->local.halign   = UHalign::center.get();
	barStyle->local.valign   = UValign::top.get();
	barStyle->local.hspacing = 2;
	barStyle->local.vspacing = 2;
	barStyle->local.padding.set(1, 1);
	if (!menu_bgcolors) 
	  MakeMenuButtonColors(&menu_bgcolors, &menu_fgcolors);
	barStyle->bgcolors       = menu_bgcolors;
	barStyle->fgcolors       = menu_fgcolors;
      }
      return barStyle;
    }
  } //endif (parent) 

  // tous les autres cas : standard style
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::center.get();
    style->local.hspacing = 2;
    style->local.vspacing = 2;
    style->local.padding.set(1, 1);
    style->local.border   = &UBorder::activeShadowOut;
    if (!bgcolors)
      MakeButtonColors(&bgcolors, &fgcolors, false);
    style->bgcolors       = bgcolors;
    style->fgcolors       = fgcolors;
  }
  return style;
}

UButton::UButton(UArgs l) : UBox(l) {
  setCmodes(UMode::CAN_ARM | UMode::ENTER_HIGHLIGHT, true);
}

/* ==================================================== ======== ======= */

UStyle *UTbutton::style;

// !!ATT: Style Variable suivant Context

const UStyle *UTbutton::getStyle(const UBox *parent) {
  const UColor **bgcolors = null, **fgcolors = null;

  if (parent) {
    // style for menus and menubar
    if (dynamic_cast<const UMenu*>(parent) 
	|| dynamic_cast<const UMenubar*>(parent)) {
      if (!UButton::menuStyle) UButton::getStyle(parent);
      return UButton::menuStyle;
    }

    // style for bars
    else if (dynamic_cast<const UBar*>(parent)) {
      if (!UButton::barStyle)  UButton::getStyle(parent);
      return UButton::barStyle;
    }
  } //endif (parent) 

  // tous les autres cas : standard+transparent button
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::center.get();
    style->local.hspacing = 2;
    style->local.vspacing = 2;
    style->local.padding.set(1, 1);
    style->local.border   = &UBorder::activeShadowOut;
    if (!bgcolors)
      MakeButtonColors(&bgcolors, &fgcolors, true);
    style->bgcolors       = bgcolors;
    style->fgcolors       = fgcolors;
  }
  return style;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UStyle *UCheckbox::style, *UCheckbox::barStyle, *UCheckbox::menuStyle;

const UStyle* UCheckbox::getStyle(const UBox *parent) {

  if (parent) {

    if (dynamic_cast<const UMenu*>(parent)
	|| dynamic_cast<const UMenubar*>(parent)) {  
      if (!menuStyle) {
	menuStyle = new UStyle(UButton::getStyle(parent));
	// add the check symbol
	menuStyle->local.content = &ugroup(USymbol::check);
      }
      return menuStyle;
    }

    else if (dynamic_cast<const UBar*>(parent)) {
      if (!barStyle) {
	barStyle = new UStyle(UButton::getStyle(parent));
	barStyle->local.orient  = UOrient::horizontal.get();
	barStyle->local.content = &ugroup(USymbol::check);
      }
      return barStyle;
    }
  } //endif (parent) 

  // tous les autres cas : standard style
  if (!style) {
    style = new UStyle(UButton::getStyle(parent));
    // add the check symbol
    style->local.content = &ugroup(USymbol::check);    
  }
  return style;
}

UCheckbox::UCheckbox(UArgs l) : UButton(l) {
  setCmodes(UMode::CAN_ARM | UMode::CAN_SELECT, true);
} 

/* ==================================================== ======== ======= */

UStyle *UTcheckbox::style;

// !!ATT: Style Variable suivant Context

const UStyle *UTcheckbox::getStyle(const UBox *parent) {
  const UColor **bgcolors = null, **fgcolors = null;

  if (parent) {
    // style for menus and menubar
    if (dynamic_cast<const UMenu*>(parent) 
	|| dynamic_cast<const UMenubar*>(parent)) {
      if (!UCheckbox::menuStyle) UCheckbox::getStyle(parent);
      return UCheckbox::menuStyle;
    }

    // style for bars
    else if (dynamic_cast<const UBar*>(parent)) {
      if (!UCheckbox::barStyle)  UCheckbox::getStyle(parent);
      return UCheckbox::barStyle;
    }
  } //endif (parent) 

  // tous les autres cas : standard style
  if (!style) {
    style = new UStyle(UCheckbox::getStyle(parent));
    MakeButtonColors(&bgcolors, &fgcolors, true);
    style->bgcolors       = bgcolors;
    style->fgcolors       = fgcolors;
  }
  return style;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UStyle* UHref::style = null;

const UStyle* UHref::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::center.get();
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    style->local.padding.set(1, 1);

    // NB bleu sur fond blanc:
    style->fgcolors = UStyle::makeColors(&UColor::blue, &UColor::navy);
    style->bgcolors = UStyle::makeColors(&UBgcolor::inherit, &UBgcolor::inherit);

    UStyle::setColor(style->fgcolors, UOn::DISABLED, &UColor::disabled);
    UStyle::setColor(style->bgcolors, UOn::ENTERED,  &UBgcolor::wheat);
    UStyle::setColor(style->fgcolors, UOn::ARMED,    &UColor::red);
    UStyle::setColor(style->fgcolors, UOn::ACTIONED, &UColor::red);
    UStyle::setColor(style->fgcolors, UOn::DROPPED,  &UColor::red);
    UStyle::setColor(style->bgcolors, UOn::HIGHLIGHTED, &UBgcolor::red);

    style->cursor = &UCursor::hand;
  }
  return style;
}

UHref::UHref(UArgs l) : UButton(l) {
  //fprintf(stderr, ">new UHRef %d\n", this);
  setCmodes(UMode::CAN_ARM 
	    | UMode::ENTER_HIGHLIGHT 
	    | UMode::HAS_CURSOR,
	    true);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UTextbox::UTextbox(UArgs l) : UBox(l) {
  setCmodes( UMode::CAN_SELECT_TEXT // also added by uedit
	     | UMode::HAS_CURSOR, 
	    true);
  //setCmodes(UMode::CAN_CLOSE_MENU, false); // also added by uedit
  setCmodes(UMode::HAS_AUTOCLOSE_BHV, true);
  setCmodes(UMode::AUTOCLOSE_BHV, false);
}

UStyle *UTextbox::style = null;

const UStyle* UTextbox::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);

    style->fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::white);
    style->bgcolors = UStyle::makeColors(&UBgcolor::white, &UBgcolor::black);
    UStyle::setColor(style->fgcolors, UOn::DISABLED,    &UColor::disabled);
    UStyle::setColor(style->bgcolors, UOn::HIGHLIGHTED, &UBgcolor::red);
    UStyle::setColor(style->bgcolors, UOn::ENTERED,     &UBgcolor::wheat);

    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::center.get();
    style->local.hspacing = 0;
    style->local.vspacing = 3;
    style->local.padding.set(1, 1);
    style->local.border   = &UBorder::shadowIn;
    style->cursor         = &UCursor::text;

    // fixed size: wont' change (except if the box is also flexible)
    style->local.width = 100;
    // will take initial size and won't change
    style->local.height = UHeight::keepSize;
  }
  return style; 
}


/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */
// ULine: horizontal, adaptative size, white background, not ghost, 
//        no border, margins, focus, no input, no arm

UStyle *ULine::style = null;

const UStyle* ULine::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);

    style->fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::white);
    style->bgcolors = UStyle::makeColors(&UBgcolor::white, &UBgcolor::black);
    UStyle::setColor(style->fgcolors, UOn::DISABLED,    &UColor::disabled);
    UStyle::setColor(style->bgcolors, UOn::HIGHLIGHTED, &UBgcolor::red);
    UStyle::setColor(style->bgcolors, UOn::ENTERED,     &UBgcolor::wheat);

    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::flex.get();
    style->local.hspacing = 2;
    style->local.hspacing = 2;
    style->local.padding.set(1, 1);
  }
  return style;
}

ULine::ULine(UArgs a): UBox(a) {
  setCmodes(UMode::ENTER_HIGHLIGHT, true);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

