/* ==================================================== ======== ======= *
 *
 *  uint.hh
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uint_hh
#define	_uint_hh
//pragma ident	"@(#)uint.hh	ubit:b.11.1"

class ULint& ulint(long ii);
class ULint& ulint(const ULint& ii);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UEditable: public UBrick {
public:
  UEditable(u_modes b_modes): UBrick(b_modes) {};

  virtual u_bool checkFormat(int pos, char) = 0;
  virtual u_bool checkFormat(int pos, const char*) = 0;
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class ULint: public UEditable {
protected:
  long val;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  //Ubit Long Integer
  ULint(const ULint&);
  ULint(long = 0, u_modes bmodes = 0);

  void set(long);
  void set(const ULint&);
  void set(const ULint*);
  //argument must contains a string that represents a valid number
  void set(const UStr&);
  void set(const UStr*);
  ULint& operator=(const ULint& _i) {set(_i); return *this;}
  ULint& operator=(const long _i)   {set(_i); return *this;}

  long getValue() const {return val;}

  u_bool equals(const long) const;
  u_bool equals(const ULint&) const;
  u_bool equals(const ULint*) const;

  //==== Ubit Intrinsics

  virtual void changed();
  virtual u_bool checkFormat(int pos, char);
  virtual u_bool checkFormat(int pos, const char*);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
