/* ==================================================== ======== ======= *
 *
 *  ucursor.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucursor_hh
#define	_ucursor_hh
//pragma ident	"@(#)ucursor.hh	ubit:b1.10.1"
#include <uprop.hh>


class UCursor : public UProp {
  friend class UNatDisp;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  // standard predefined cursors
  static UCursor crosshair, xcross, arrow, plus, text, hand, wait, question,
    kill, sizing;
  // alternate cursors (may not be defined on a particular platform)
  static UCursor pencil, spray, finger, spider, umbrella, pirate, gumby, heart;

  // Creates a new UCursor that is a copy of a pre-existing UCursor
  UCursor(const UCursor&, u_modes = 0);
  ~UCursor() {clean();}

  // Creates a Cursor from a X-Window shape number
  UCursor(const char *name, int shape_index, u_modes bmodes);

  void set(const UCursor&);
  void set(const UCursor*);

  u_bool equals(const UCursor&) const;

  const char* getName() const {return name;}
  int getShapeIndex() const {return shape;}

  // update parents' graphics
  virtual void update();

  //package_private: ===[internal implementation]=========================
  virtual void addingTo(ULink *selflink, UGroup *parent);
  virtual void removingFrom(ULink *selflink, UGroup *parent);
  u_bool realize(class UDisp*);
  virtual void putProp(class UContext*, class UCtrl*);

protected:
  int shape;
  const char *name;
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
