// NOTE: GPL in the license field means "GPL version 2 or above"

var noun_type_debian_release = new CmdUtils.NounType("release",
        ["any", "experimental", "stable",
        "testing", "unstable", "oldstable",
        "sid", "lenny", "etch", "squeeze"]);

var noun_type_texttile = new CmdUtils.NounType("text or title", ["Title", "Text"]);

var bugno_re = new RegExp("^#([0-9]+)");

// http://github.com/garyhodgson/ubiquity-rtm-api/blob/7299e60eab828fa89d76ce3c927faa1ad4064a23/ubiquity-rtm-api.js
function isParser2() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
    var branch = prefs.getBranch("extensions.ubiquity.");

    return (branch.getPrefType("parserVersion") != 0) ? branch.getIntPref("parserVersion") == 2 : false;
}

// XXX role location first suggestion is near, tweak so it displays "in"
if (isParser2()) {

CmdUtils.CreateCommand({
    names: ["debian-pts-search", "pts", "pkgtrack", "debtrack"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'package'}],
    help: "Searches Debian package tracking system.",
    description: "Searches the Debian package tracking system at packages.qa.debian.org",
    preview: function (pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        var data = {package: args.object.text};
        pblock.innerHTML = _("Search Debian package tracking system for: <b>${package}</b>", data);
    },
    execute: function (args) {
        var data = {package: args.object.text};
        var url = CmdUtils.renderTemplate("http://packages.qa.debian.org/${package}", data);
        Utils.openUrlInBrowser(url);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-pkg-search", "pkg", "debpackage", "debpkg"],
    author: {name: "Jonathan E. Magen"},
    homepage: "http://yonkeltron.com",
    contributors: ["Filippo Giunchedi - http://people.debian.org/~filippo"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'package'},
                {role: 'location', nountype: noun_type_debian_release, label: 'release'}],
    help: "Searches Debian package repositories for a package and, optionally, ",
    description: "Searches the Debian package repositories at packages.debian.org",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        var msg = "Search Debian package tracking system for: <b>${package}</b>";
        var values = {package: args.object.text};
        if (args.location && args.location.text.length > 0) {
            msg += " in <b>${release}</b>";
            values.release = args.location.text;
        }
        pblock.innerHTML = _(msg, values);
    },
    execute: function(args) {
        var url = "http://packages.debian.org/search?keywords=${package}&suite=${release}";
        var values = {package: args.object.text, release: "all"};
        if (args.location && args.location.text.length > 0) {
            values.release = args.location.text;
        }
        var urlString = CmdUtils.renderTemplate(url, values);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-bts-search", "bts", "debbug"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'query'}],
    help: "Searches Debian bug tracking system.",
    description: "Searches the Debian bug tracking system at bugs.debian.org",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = _("Search Debian bug tracking system for: <b>${query}</b>", {query: args.object.text});
    },
    execute: function(args) {
        var url = "http://bugs.debian.org/${query}";
        var values = {query: args.object.text};
        var match = args.object.text.match(bugno_re);
        if (match) {
            values.query = match[1];
        }
        var urlString = CmdUtils.renderTemplate(url, values);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-message-id", "msgid"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'msgid'}],
    help: "Searches Debian mailing list archives for a given message-id",
    description: "Searches the Debian mailing list archives at lists.debian.org for messages corresponding to a message-id",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = _("Search Debian mailing lists for message-id <b>${msgid}</b>", {msgid: args.object.text});
    },
    execute: function(args) {
        var url = "http://lists.debian.org/msgid-search/${query}";
        var urlString = CmdUtils.renderTemplate(url, {query: args.object.text});
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-buildd", "buildd"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'package'}],
    help: "Shows the buildd status for a given package",
    description: "Shows the buildd status for a given package as listed on buildd.debian.org",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = _("See buildd status for: <b>${pkg}</b>", {pkg: args.object.text});
    },
    execute: function(args) {
        var url="http://buildd.debian.org/${query}";
        var urlString = CmdUtils.renderTemplate(url, {query: args.object.text});
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-debtags", "debtags"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'query'}],
    help: "Edits the Debtags of a given package",
    description: "Edits the Debtags for a given package registered on debtags.alioth.debian.org",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = _("Edit DebTags for: <b>${query}</b>", {query: args.object.text});
    },
    execute: function(args) {
        var url = "http://debtags.alioth.debian.org/edit.html?pkg=${query}";
        var urlString = CmdUtils.renderTemplate(url, {query: args.object.text});
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-ddpo", "ddpo"],
    author: {name: "Filippo Giunchedi", email: "filippo@debian.org"},
    homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html",
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'query'}],
    help: "Show the Debian Developer's Packages Overview corresponding to the provided login or email address",
    description: "Shows the Debian Developer Packages Overview for a given developer identified by their login or email address",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = _("See the Debian Developer's Packages Overview for: <b>${query}</b>", {query: args.object.text});
    },
    execute: function(args) {
        var url = "http://qa.debian.org/developer.php?login=${query}";
        var urlString = CmdUtils.renderTemplate(url, {query: args.object.text});
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    names: ["debian-wiki-search", "debwiki", "dwiki"],
    author: {name: "Jonathan E. Magen"},
    homepage: "http://yonkeltron.com",
    contributors: ["Filippo Giunchedi - http://esaurito.net"],
    icon: "http://wiki.debian.org/favicon.ico",
    license: "GPL",
    arguments: [{role: 'object', nountype: noun_arb_text, label: 'query'},
                {role: 'location', nountype: noun_type_texttile, label: 'where'}],
    help: "Search the Debian wiki at wiki.debian.org",
    description: "Searches wiki.debian.org",
    preview: function(pblock, args) {
        if (!args.object || args.object.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        var msg = "Search the Debian wiki for: <b>${query}</b>";
        var values = {query: args.object.text};
        if (args.location && args.location.text.length > 0) {
            msg += " in <b>${where}</b>";
            values.where = args.location.text;
        }
        pblock.innerHTML = _(msg, values);

    },
    execute: function(args) {
        var url = "http://wiki.debian.org/?action=fullsearch&context=180&fullsearch=${where}&value=${query}";
        var values = {query: args.object.text, where: "Title"};
        if (args.location && args.location.text.length > 0) {
            values.where = args.location.text;
        }
        var urlString = CmdUtils.renderTemplate(url, values);
        Utils.openUrlInBrowser(urlString);
    }
});

} else { // old ubiquity version

CmdUtils.CreateCommand({
    name: "debian-pts-search",
    synonyms: ["pts", "pkgtrack", "debtrack"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"the package name": noun_arb_text},
    modifiers: {},
    help: "Searches Debian package tracking system.",
    description: "Searches the Debian package tracking system at packages.qa.debian.org",
    preview: function(pblock, pkgname) {
        if (!pkgname || pkgname.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "Search debian package tracking system for: <b>" + pkgname.text + "</b>";
    },
    execute: function(pkgname) {
        var url = "http://packages.qa.debian.org/{QUERY}";
        var urlString = url.replace("{QUERY}", pkgname.text);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-pkg-search",
    synonyms: ["pkg", "debpackage", "debpkg"],
    author: {name: "Jonathan E. Magen", homepage: "http://yonkeltron.com"},
    contributors: ["Filippo Giunchedi - http://people.debian.org/~filippo"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"the package name": noun_arb_text},
    modifiers: {"in": noun_type_debian_release},
    help: "Searches Debian package repositories for a package and, optionally, ",
    description: "Searches the Debian package repositories at packages.debian.org",
    preview: function(pblock, pkgname, mods) {
        if (!pkgname || pkgname.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        var msg = "Search debian package tracking system for: <b>${package}</b>";
        var values = {package: pkgname.text};
        if (mods["in"] && mods["in"].text.length > 0) {
            msg += " in <b>${release}</b>";
            values.release = mods["in"].text;
        }
        pblock.innerHTML = CmdUtils.renderTemplate(msg, values);
    },
    execute: function(pkgname, mods) {
        var url = "http://packages.debian.org/search?keywords=${package}&suite=${release}";
        var values = {package: pkgname.text};
        if (mods["in"] && mods["in"].text.length > 0) {
            values.release = mods["in"].text;
        } else {
            values.release = "all";
        }
        var urlString = CmdUtils.renderTemplate(url, values);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-bts-search",
    synonyms: ["bts", "debbug"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"the package name": noun_arb_text},
    modifiers: {},
    help: "Searches Debian bug tracking system.",
    description: "Searches the Debian bug tracking system at bugs.debian.org",
    preview: function(pblock, pkgname) {
        if (!pkgname || pkgname.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "Search debian bug tracking system for: <b>" + pkgname.text + "</b>";
    },
    execute: function(pkgname) {
        var url = "http://bugs.debian.org/{QUERY}";
        var match = pkgname.text.match(bugno_re);
        if (match) {
            var urlString = url.replace("{QUERY}", match[1]);
        } else {
            var urlString = url.replace("{QUERY}", pkgname.text);
        }
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-message-id",
    synonyms: ["msgid"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"message-id": noun_arb_text},
    modifiers: {},
    help: "Searches Debian mailing list archives for a given message-id",
    description: "Searches the Debian mailing list archives at lists.debian.org for messages corresponding to a message-id",
    preview: function(pblock, msgid) {
        if (!msgid || msgid.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "Search debian mailing lists for message-id <b>" + msgid.text + "</b>";
    },
    execute: function(msgid) {
        var url = "http://lists.debian.org/msgid-search/{QUERY}";
        var urlString = url.replace("{QUERY}", msgid.text);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-buildd",
    synonyms: ["buildd"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"the package name": noun_arb_text},
    modifiers: {},
    help: "Shows the buildd status for a given package",
    description: "Shows the buildd status for a given package as listed on buildd.debian.org",
    preview: function(pblock, pkgname) {
        if (!pkgname || pkgname.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "See buildd status for: <b>" + pkgname.text + "</b>";
    },
    execute: function(pkgname) {
        var url="http://buildd.debian.org/{QUERY}";
        var urlString = url.replace("{QUERY}", pkgname.text);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-debtags",
    synonyms: ["debtags"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"the package name": noun_arb_text},
    modifiers: {},
    help: "Edits the DebTags of a given package",
    description: "Edits the DebTags for a given package registered on debtags.alioth.debian.org",
    preview: function(pblock, pkgname) {
        if (!pkgname || pkgname.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "Edit DebTags for: <b>" + pkgname.text + "</b>";
    },
    execute: function(pkgname) {
        var url = "http://debtags.alioth.debian.org/edit.html?pkg={QUERY}";
        var urlString = url.replace("{QUERY}", pkgname.text);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-ddpo",
    synonyms: ["ddpo"],
    author: {name: "Filippo Giunchedi", homepage: "http://people.debian.org/~filippo/ubiquity-commands/ubiquity-commands.html"},
    contributors: ["Jonathan E. Magen - http://yonkeltron.com"],
    icon: "http://debian.org/favicon.ico",
    license: "GPL",
    takes: {"login / email address": noun_arb_text},
    modifiers: {},
    help: "Show the Debian Developer's Packages Overview corresponding to the provided login or email address",
    description: "Shows the Debian Developer Packages Overview for a given developer identified by their login or email address",
    preview: function(pblock, login) {
        if (!login || login.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        pblock.innerHTML = "See the Debian Developer's Packages Overview for: <b>" + login.text + "</b>";
    },
    execute: function(login) {
        var url = "http://qa.debian.org/developer.php?login={QUERY}";
        var urlString = url.replace("{QUERY}", login.text);
        Utils.openUrlInBrowser(urlString);
    }
});

CmdUtils.CreateCommand({
    name: "debian-wiki-search",
    synonyms: ["debwiki", "dwiki"],
    author: {name: "Jonathan E. Magen", homepage: "http://yonkeltron.com"},
    contributors: ["Filippo Giunchedi - http://esaurito.net"],
    icon: "http://wiki.debian.org/favicon.ico",
    license: "GPL",
    takes: {"search term": noun_arb_text},
    modifiers: {"in": noun_type_texttile},
    help: "Search the Debian wiki at wiki.debian.org",
    description: "Searches wiki.debian.org",
    preview: function(pblock, searchTerm, mods) {
        if (!searchTerm || searchTerm.text.length < 1) {
            pblock.innerHTML = this.help;
            return;
        }
        var msg = "Search the Debian wiki for: <b>${query}</b>";
        var values = {query: searchTerm.text};
        if (mods["in"] && mods["in"].text.length > 0) {
            msg += " in <b>${where}</b>";
            values.where = mods["in"].text;
        }
        pblock.innerHTML = CmdUtils.renderTemplate(msg, values);

    },
    execute: function(searchTerm, mods) {
        var url = "http://wiki.debian.org/?action=fullsearch&context=180&fullsearch=${where}&value=${query}";
        var values = {query: searchTerm.text};
        if (mods["in"] && mods["in"].text.length > 0) {
            values.where = mods["in"].text;
        } else {
            values.where = "Title";
        }
        var urlString = CmdUtils.renderTemplate(url, values);
        Utils.openUrlInBrowser(urlString);
    }
});

} // if (isparser2())

// this hasn't changed between parser1 and parser2
CmdUtils.makeSearchCommand({
	name: "debian-manual-page",
	author: {name: "Stefano Zacchiroli", homepage: "http://upsilon.cc/~zack"},
	synonyms: ["man", "debman"],
	url: "http://man.cx/?page={QUERY}",
	icon: "http://man.cx/favicon.ico",
	description: "Searches Debian manual page on man.cx"
});

// vim:et:ts=4
