/*
 * Copyright (C) 2005-2006 by Texas Instruments
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef __MUSB_OMAP243X_H__
#define __MUSB_OMAP243X_H__

#ifndef __UBOOT__
#include <plat/usb.h>
#else
#undef RESETDONE
#endif

/*
 * OMAP2430-specific definitions
 */

#define OTG_REVISION		0x400

#define OTG_SYSCONFIG		0x404
#	define	MIDLEMODE	12	/* bit position */
#	define	FORCESTDBY		(0 << MIDLEMODE)
#	define	NOSTDBY			(1 << MIDLEMODE)
#	define	SMARTSTDBY		(2 << MIDLEMODE)

#	define	SIDLEMODE		3	/* bit position */
#	define	FORCEIDLE		(0 << SIDLEMODE)
#	define	NOIDLE			(1 << SIDLEMODE)
#	define	SMARTIDLE		(2 << SIDLEMODE)

#	define	ENABLEWAKEUP		(1 << 2)
#	define	SOFTRST			(1 << 1)
#	define	AUTOIDLE		(1 << 0)

#define OTG_SYSSTATUS		0x408
#	define	RESETDONE		(1 << 0)

#define OTG_INTERFSEL		0x40c
#	define	EXTCP			(1 << 2)
#	define	PHYSEL			0	/* bit position */
#	define	UTMI_8BIT		(0 << PHYSEL)
#	define	ULPI_12PIN		(1 << PHYSEL)
#	define	ULPI_8PIN		(2 << PHYSEL)

#define OTG_SIMENABLE		0x410
#	define	TM1			(1 << 0)

#define OTG_FORCESTDBY		0x414
#	define	ENABLEFORCE		(1 << 0)

/*
 * OMAP4-specific definitions
 */

#define USBOTGHS_CONTROL_AVALID		(1 << 0)
#define USBOTGHS_CONTROL_VBUSVALID	(1 << 2)
#define USBOTGHS_CONTROL_IDDIG		(1 << 4)

#endif	/* __MUSB_OMAP243X_H__ */
