/*
 * Copyright 2008-2010 Analog Devices Inc.
 *
 * Licensed under the GPL-2 or later
 */

#ifndef _MACH_PORTMUX_H_
#define _MACH_PORTMUX_H_

#define MAX_RESOURCES	MAX_BLACKFIN_GPIOS

/* PPI Port Mux */
#define P_PPI0_D0	(P_DEFINED | P_IDENT(GPIO_PF15) | P_FUNCT(2))
#define P_PPI0_D1	(P_DEFINED | P_IDENT(GPIO_PF14) | P_FUNCT(2))
#define P_PPI0_D2	(P_DEFINED | P_IDENT(GPIO_PF13) | P_FUNCT(2))
#define P_PPI0_D3	(P_DEFINED | P_IDENT(GPIO_PF12) | P_FUNCT(2))
#define P_PPI0_D4	(P_DEFINED | P_IDENT(GPIO_PF11) | P_FUNCT(2))
#define P_PPI0_D5	(P_DEFINED | P_IDENT(GPIO_PF10) | P_FUNCT(2))
#define P_PPI0_D6	(P_DEFINED | P_IDENT(GPIO_PF9) | P_FUNCT(2))
#define P_PPI0_D7	(P_DEFINED | P_IDENT(GPIO_PF8) | P_FUNCT(2))
#define P_PPI0_D8	(P_DEFINED | P_IDENT(GPIO_PF2) | P_FUNCT(2))
#define P_PPI0_D9	(P_DEFINED | P_IDENT(GPIO_PF3) | P_FUNCT(2))
#define P_PPI0_D10	(P_DEFINED | P_IDENT(GPIO_PF4) | P_FUNCT(2))
#define P_PPI0_D11	(P_DEFINED | P_IDENT(GPIO_PF5) | P_FUNCT(2))
#define P_PPI0_D12	(P_DEFINED | P_IDENT(GPIO_PF6) | P_FUNCT(2))
#define P_PPI0_D13	(P_DEFINED | P_IDENT(GPIO_PF7) | P_FUNCT(2))
#define P_PPI0_D14	(P_DEFINED | P_IDENT(GPIO_PG13) | P_FUNCT(2))
#define P_PPI0_D15	(P_DEFINED | P_IDENT(GPIO_PG12) | P_FUNCT(2))

#define P_PPI0_CLK	(P_DEFINED | P_IDENT(GPIO_PG0) | P_FUNCT(1))
#define P_PPI0_FS1	(P_DEFINED | P_IDENT(GPIO_PG14) | P_FUNCT(2))
#define P_PPI0_FS2	(P_DEFINED | P_IDENT(GPIO_PG15) | P_FUNCT(2))
#define P_PPI0_FS3	(P_DEFINED | P_IDENT(GPIO_PG1) | P_FUNCT(1))

/* SPI Port Mux */
#define P_SPI0_SCK	(P_DEFINED | P_IDENT(GPIO_PF10) | P_FUNCT(0))
#define P_SPI0_MISO	(P_DEFINED | P_IDENT(GPIO_PF11) | P_FUNCT(0))
#define P_SPI0_MOSI	(P_DEFINED | P_IDENT(GPIO_PF12) | P_FUNCT(0))

#define P_SPI0_SSEL1	(P_DEFINED | P_IDENT(GPIO_PF13) | P_FUNCT(0))
#define P_SPI0_SSEL2	(P_DEFINED | P_IDENT(GPIO_PF14) | P_FUNCT(0))
#define P_SPI0_SSEL3	(P_DEFINED | P_IDENT(GPIO_PF15) | P_FUNCT(0))

#define P_SPI1_SCK	(P_DEFINED | P_IDENT(GPIO_PG3) | P_FUNCT(0))
#define P_SPI1_MISO	(P_DEFINED | P_IDENT(GPIO_PG5) | P_FUNCT(0))
#define P_SPI1_MOSI	(P_DEFINED | P_IDENT(GPIO_PG4) | P_FUNCT(0))

#define P_SPI1_SSEL1	(P_DEFINED | P_IDENT(GPIO_PG2) | P_FUNCT(0))
#define P_SPI1_SSEL2	(P_DEFINED | P_IDENT(GPIO_PG1) | P_FUNCT(0))
#define P_SPI1_SSEL3	(P_DEFINED | P_IDENT(GPIO_PG0) | P_FUNCT(0))

#define GPIO_DEFAULT_BOOT_SPI_CS GPIO_PF13
#define P_DEFAULT_BOOT_SPI_CS P_SPI0_SSEL1

/* SPORT Port Mux */
#define P_SPORT0_DRPRI	(P_DEFINED | P_IDENT(GPIO_PF5) | P_FUNCT(0))
#define P_SPORT0_RSCLK	(P_DEFINED | P_IDENT(GPIO_PF1) | P_FUNCT(0))
#define P_SPORT0_RFS	(P_DEFINED | P_IDENT(GPIO_PF4) | P_FUNCT(0))
#define P_SPORT0_TFS	(P_DEFINED | P_IDENT(GPIO_PF3) | P_FUNCT(0))
#define P_SPORT0_DTPRI	(P_DEFINED | P_IDENT(GPIO_PF2) | P_FUNCT(0))
#define P_SPORT0_TSCLK	(P_DEFINED | P_IDENT(GPIO_PF0) | P_FUNCT(0))
#define P_SPORT0_DTSEC	(P_DEFINED | P_IDENT(GPIO_PF8) | P_FUNCT(1))
#define P_SPORT0_DRSEC	(P_DEFINED | P_IDENT(GPIO_PF9) | P_FUNCT(1))

#define P_SPORT1_DRPRI	(P_DEFINED | P_IDENT(GPIO_PG9) | P_FUNCT(0))
#define P_SPORT1_RFS	(P_DEFINED | P_IDENT(GPIO_PG10) | P_FUNCT(0))
#define P_SPORT1_RSCLK	(P_DEFINED | P_IDENT(GPIO_PG11) | P_FUNCT(0))
#define P_SPORT1_DTPRI	(P_DEFINED | P_IDENT(GPIO_PH0) | P_FUNCT(1))
#define P_SPORT1_TFS	(P_DEFINED | P_IDENT(GPIO_PH1) | P_FUNCT(1))
#define P_SPORT1_TSCLK	(P_DEFINED | P_IDENT(GPIO_PH2) | P_FUNCT(1))
#define P_SPORT1_DTSEC	(P_DEFINED | P_IDENT(GPIO_PG3) | P_FUNCT(1))
#define P_SPORT1_DRSEC	(P_DEFINED | P_IDENT(GPIO_PG8) | P_FUNCT(0))

/* UART Port Mux */
#ifdef CONFIG_BF506_UART0_PORTF
#define P_UART0_TX	(P_DEFINED | P_IDENT(GPIO_PF1) | P_FUNCT(1))
#define P_UART0_RX	(P_DEFINED | P_IDENT(GPIO_PF0) | P_FUNCT(1))
#else
#define P_UART0_TX	(P_DEFINED | P_IDENT(GPIO_PG13) | P_FUNCT(0))
#define P_UART0_RX	(P_DEFINED | P_IDENT(GPIO_PG12) | P_FUNCT(0))
#endif
#define P_UART0_RTS	(P_DEFINED | P_IDENT(GPIO_PG14) | P_FUNCT(0))
#define P_UART0_CTS	(P_DEFINED | P_IDENT(GPIO_PG15) | P_FUNCT(0))

#ifdef CONFIG_BF506_UART1_PORTG
#define P_UART1_TX	(P_DEFINED | P_IDENT(GPIO_PG3) | P_FUNCT(0))
#define P_UART1_RX	(P_DEFINED | P_IDENT(GPIO_PG0) | P_FUNCT(0))
#else
#define P_UART1_TX	(P_DEFINED | P_IDENT(GPIO_PF6) | P_FUNCT(0))
#define P_UART1_RX	(P_DEFINED | P_IDENT(GPIO_PF7) | P_FUNCT(0))
#endif
#define P_UART1_RTS	(P_DEFINED | P_IDENT(GPIO_PF8) | P_FUNCT(0))
#define P_UART1_CTS	(P_DEFINED | P_IDENT(GPIO_PF9) | P_FUNCT(0))

/* Timer */
#define P_TMRCLK	(P_DEFINED | P_IDENT(GPIO_PG0) | P_FUNCT(1))
#define P_TMR0		(P_DEFINED | P_IDENT(GPIO_PG14) | P_FUNCT(2))
#define P_TMR1		(P_DEFINED | P_IDENT(GPIO_PG15) | P_FUNCT(2))
#define P_TMR2		(P_DEFINED | P_IDENT(GPIO_PF10) | P_FUNCT(1))
#define P_TMR3		(P_DEFINED | P_IDENT(GPIO_PF13) | P_FUNCT(1))
#define P_TMR4		(P_DEFINED | P_IDENT(GPIO_PG2) | P_FUNCT(1))
#define P_TMR5		(P_DEFINED | P_IDENT(GPIO_PF1) | P_FUNCT(2))
#define P_TMR6		(P_DEFINED | P_IDENT(GPIO_PF0) | P_FUNCT(2))
#define P_TMR7		(P_DEFINED | P_IDENT(GPIO_PG5) | P_FUNCT(1))

/* CAN */
#define P_CAN_TX	(P_DEFINED | P_IDENT(GPIO_PG2) | P_FUNCT(2))
#define P_CAN_RX	(P_DEFINED | P_IDENT(GPIO_PG1) | P_FUNCT(2))

/* PWM */
#define P_PWM0_AH	(P_DEFINED | P_IDENT(GPIO_PF14) | P_FUNCT(1))
#define P_PWM0_AL	(P_DEFINED | P_IDENT(GPIO_PF15) | P_FUNCT(1))
#define P_PWM0_BH	(P_DEFINED | P_IDENT(GPIO_PF2) | P_FUNCT(1))
#define P_PWM0_BL	(P_DEFINED | P_IDENT(GPIO_PF3) | P_FUNCT(1))
#define P_PWM0_CH	(P_DEFINED | P_IDENT(GPIO_PF4) | P_FUNCT(1))
#define P_PWM0_CL	(P_DEFINED | P_IDENT(GPIO_PF5) | P_FUNCT(1))
#define P_PWM0_SYNC	(P_DEFINED | P_IDENT(GPIO_PF7) | P_FUNCT(1))
#define P_PWM0_TRIP	(P_DEFINED | P_IDENT(GPIO_PF6) | P_FUNCT(1))

#define P_PWM1_AH	(P_DEFINED | P_IDENT(GPIO_PG6) | P_FUNCT(2))
#define P_PWM1_AL	(P_DEFINED | P_IDENT(GPIO_PG7) | P_FUNCT(2))
#define P_PWM1_BH	(P_DEFINED | P_IDENT(GPIO_PG8) | P_FUNCT(2))
#define P_PWM1_BL	(P_DEFINED | P_IDENT(GPIO_PG9) | P_FUNCT(2))
#define P_PWM1_CH	(P_DEFINED | P_IDENT(GPIO_PG10) | P_FUNCT(2))
#define P_PWM1_CL	(P_DEFINED | P_IDENT(GPIO_PG11) | P_FUNCT(2))
#define P_PWM1_SYNC	(P_DEFINED | P_IDENT(GPIO_PG4) | P_FUNCT(2))
#define P_PWM1_TRIP	(P_DEFINED | P_IDENT(GPIO_PG5) | P_FUNCT(2))

/* RSI */
#define P_RSI_DATA0	(P_DEFINED | P_IDENT(GPIO_PG9) | P_FUNCT(1))
#define P_RSI_DATA1	(P_DEFINED | P_IDENT(GPIO_PG8) | P_FUNCT(1))
#define P_RSI_DATA2	(P_DEFINED | P_IDENT(GPIO_PG7) | P_FUNCT(1))
#define P_RSI_DATA3	(P_DEFINED | P_IDENT(GPIO_PG6) | P_FUNCT(1))
#define P_RSI_DATA4	(P_DEFINED | P_IDENT(GPIO_PG12) | P_FUNCT(1))
#define P_RSI_DATA5	(P_DEFINED | P_IDENT(GPIO_PG13) | P_FUNCT(1))
#define P_RSI_DATA6	(P_DEFINED | P_IDENT(GPIO_PG14) | P_FUNCT(1))
#define P_RSI_DATA7	(P_DEFINED | P_IDENT(GPIO_PG15) | P_FUNCT(1))
#define P_RSI_CMD	(P_DEFINED | P_IDENT(GPIO_PG10) | P_FUNCT(1))
#define P_RSI_CLK	(P_DEFINED | P_IDENT(GPIO_PG11) | P_FUNCT(1))

/* ACM */
#define P_ACM_SE_DIFF	(P_DEFINED | P_IDENT(GPIO_PG6) | P_FUNCT(0))
#define P_ACM_RANGE	(P_DEFINED | P_IDENT(GPIO_PG7) | P_FUNCT(0))
#define P_ACM_A0	(P_DEFINED | P_IDENT(GPIO_PH2) | P_FUNCT(0))
#define P_ACM_A1	(P_DEFINED | P_IDENT(GPIO_PH1) | P_FUNCT(0))
#define P_ACM_A2	(P_DEFINED | P_IDENT(GPIO_PH0) | P_FUNCT(0))

#endif				/* _MACH_PORTMUX_H_ */
